% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdweave_to.R
\name{mdweave_to_pdf}
\alias{mdweave_to_pdf}
\alias{mdweave_to_tex}
\alias{mdweave_to_html}
\title{Run the code in a markdown file and generate a new document}
\usage{
mdweave_to_pdf(
  fn,
  ofn = file_subs_ext(basename(fn), ".pdf", FALSE),
  extra_arguments2 = "--self-contained",
  run_in_temp = TRUE,
  cmd2 = "pandoc \%3$s -s \\"\%1$s\\" -t latex -o \\"\%2$s\\"",
  ...
)

mdweave_to_tex(
  fn,
  ofn = file_subs_ext(basename(fn), ".tex", FALSE),
  extra_arguments2 = "--self-contained",
  run_in_temp = TRUE,
  cmd2 = "pandoc \%3$s -s \\"\%1$s\\" -t latex -o \\"\%2$s\\"",
  ...
)

mdweave_to_html(
  fn,
  ofn = file_subs_ext(basename(fn), ".html", FALSE),
  extra_arguments2 = "--self-contained",
  run_in_temp = TRUE,
  cmd2 = "pandoc \%3$s -s \\"\%1$s\\" -t html -o \\"\%2$s\\"",
  ...
)
}
\arguments{
\item{fn}{filename of the markdown file (should use pandoc markdown).}

\item{ofn}{name of the resulting file.}

\item{extra_arguments2}{extra arguments passed on to pandoc. Should be a length 1
character vector.}

\item{run_in_temp}{When TRUE the intermediary markdown file and generated figures (when
not using custom paths) are created in a temporary directory. Otherwise these will be
generated in the same directory as the output file.}

\item{cmd2}{command used to run pandoc. See details.}

\item{...}{additional arguments are passed on to \code{\link{mdweave}}.}
}
\value{
Returns the name of the resulting outout file.
}
\description{
Run the code in a markdown file and generate a new document
}
\details{
These functions first call \code{\link{mdweave}} to run the code in the original
file and convert the original markdown file to a new markdown file. This second
markdown file is then converted to the desired output format using a second run
of \code{pandoc}.

In case of converting to pdf the file is required to have the extension
\code{.pdf}. In case of converting to LaTeX, the file cannot have the extension
\code{.pdf}. That is because in both cases the file is first converted to
LaTeX. In case of a file with the extension \code{.pdf} the file is than
further converted to PDF.
}
