% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_labels.R
\name{var_rename}
\alias{var_rename}
\alias{rename_variables}
\alias{rename_columns}
\title{Rename variables}
\usage{
var_rename(x, ..., verbose = TRUE)

rename_variables(x, ..., verbose = TRUE)

rename_columns(x, ..., verbose = TRUE)
}
\arguments{
\item{x}{A data frame.}

\item{...}{A named vector, or pairs of named vectors, where the name (lhs)
equals the column name that should be renamed, and the value (rhs) is
the new column name.}

\item{verbose}{Logical, if \code{TRUE}, a warning is displayed when variable
names do not exist in \code{x}.}
}
\value{
\code{x}, with new column names for those variables specified in \code{...}.
}
\description{
This function renames variables in a data frame, i.e. it
   renames the columns of the data frame.
}
\examples{
dummy <- data.frame(
  a = sample(1:4, 10, replace = TRUE),
  b = sample(1:4, 10, replace = TRUE),
  c = sample(1:4, 10, replace = TRUE)
)

rename_variables(dummy, a = "first.col", c = "3rd.col")

# using quasi-quotation
library(rlang)
v1 <- "first.col"
v2 <- "3rd.col"
rename_variables(dummy, a = !!v1, c = !!v2)

x1 <- "a"
x2 <- "b"
rename_variables(dummy, !!x1 := !!v1, !!x2 := !!v2)

# using a named vector
new_names <- c(a = "first.col", c = "3rd.col")
rename_variables(dummy, new_names)
}
