% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hop.R
\name{hop}
\alias{hop}
\alias{hop_vec}
\title{Hop}
\usage{
hop(.x, .starts, .stops, .f, ...)

hop_vec(.x, .starts, .stops, .f, ..., .ptype = NULL)
}
\arguments{
\item{.x}{\verb{[vector]}

The vector to iterate over and apply \code{.f} to.}

\item{.starts, .stops}{\verb{[integer]}

Vectors of boundary locations that make up the windows to bucket \code{.x} with.
Both \code{.starts} and \code{.stops} will be recycled to their common size, and
that common size will be the size of the result. Both vectors should be
integer locations along \code{.x}, but out-of-bounds values are allowed.}

\item{.f}{\verb{[function / formula]}

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.}

\item{...}{Additional arguments passed on to the mapped function.}

\item{.ptype}{\verb{[vector(0) / NULL]}

A prototype corresponding to the type of the output.

If \code{NULL}, the default, the output type is determined by computing the
common type across the results of the calls to \code{.f}.

If supplied, the result of each call to \code{.f} will be cast to that type,
and the final output will have that type.

If \code{getOption("vctrs.no_guessing")} is \code{TRUE}, the \code{.ptype} must be
supplied. This is a way to make production code demand fixed types.}
}
\value{
A vector fulfilling the following invariants:

\subsection{\code{hop()}}{
\itemize{
\item \code{vec_size(hop(.x, .starts, .stops)) == vec_size_common(.starts, .stops)}
\item \code{vec_ptype(hop(.x, .starts, .stops)) == list()}
}

}

\subsection{\code{hop_vec()}}{
\itemize{
\item \code{vec_size(hop_vec(.x, .starts, .stops)) == vec_size_common(.starts, .stops)}
\item \code{vec_size(hop_vec(.x, .starts, .stops)[[1]]) == 1L}
\item \code{vec_ptype(hop_vec(.x, .starts, .stops, .ptype = ptype)) == ptype}
}

}
}
\description{
\code{hop()} is the lower level engine that powers \code{\link[=slide]{slide()}} (at least in theory).
It has slightly different invariants than \code{slide()}, and is useful
when you either need to hand craft boundary locations, or want to compute a
result with a size that is different from \code{.x}.
}
\details{
\code{hop()} is very close to being a faster version of:\preformatted{map2(
  .starts,
  .stops,
  function(start, stop) \{
    x_slice <- vec_slice(.x, start:stop)
    .f(x_slice, ...)
  \}
)
}

Because of this, \code{\link[=hop_index]{hop_index()}} is often the more useful function. \code{hop()}
mainly exists for API completeness.

The main difference is that the start and stop values make up ranges of
\emph{possible} locations along \code{.x}, and it is not enforced that these locations
actually exist along \code{.x}. As an example, with \code{hop()} you can do the
following, which would be an error with \code{vec_slice()} because \code{0L} is
out of bounds.\preformatted{hop(c("a", "b"), .starts = 0L, .stops = 1L, ~.x)
#> [[1]]
#> [1] "a"
}

\code{hop()} allows these out of bounds values to be fully compatible with
\code{slide()}. It is always possible to construct a \code{hop()} call from a \code{slide()}
call. For example, the following are equivalent:\preformatted{slide(1:2, ~.x, .before = 1)

hop(1:2, .starts = c(0, 1), .stops = c(1, 2), ~.x)

#> [[1]]
#> [1] 1
#>
#> [[2]]
#> [1] 1 2
}
}
\examples{
# `hop()` let's you manually specify locations to apply `.f` at.
hop(1:3, .starts = c(1, 3), .stops = 3, ~.x)

# `hop()`'s start/stop locations are allowed to be out of bounds relative
# to the size of `.x`.
hop(
  mtcars,
  .starts = c(-1, 3),
  .stops  = c(2, 6),
  ~.x
)

}
\seealso{
\code{\link[=hop2]{hop2()}}, \code{\link[=hop_index]{hop_index()}}, \code{\link[=slide]{slide()}}
}
