% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arithmetic.R
\name{index-arithmetic}
\alias{index-arithmetic}
\alias{slider_plus}
\alias{slider_minus}
\title{Index arithmetic}
\usage{
slider_plus(x, y)

slider_minus(x, y)
}
\arguments{
\item{x, y}{\verb{[vector]}

Two vectors to add or subtract.

\code{x} will always be the index, \code{.i}.

For \code{slider_plus()}, \code{y} will be \code{.after}.

For \code{slider_minus()}, \code{y} will be \code{.before}.}
}
\value{
\itemize{
\item For \code{slider_plus()}, \code{x} after adding \code{y}.
\item For \code{slider_minus()}, \code{x} after subtracting \code{y}.
}

The result should always be the same type and size as \code{x}.
}
\description{
\code{slider_plus()} and \code{slider_minus()} are developer functions used to register
special double dispatch methods to control how \code{.before} and \code{.after} are
subtracted from and added to \code{.i}. These allow developers to overcome some of
the restrictions around \code{+} and \code{-} when custom S3 types are involved. These
should only be used by package authors creating new index types.
\itemize{
\item \code{slider_plus()} allows you to override the default behavior of
\code{.i + .after}. When writing the S3 method, \code{x} will be \code{.i}, and \code{y} will
be \code{.after}.
\item \code{slider_minus()} allows you to override the default behavior of
\code{.i - .before}. When writing the S3 method, \code{x} will be \code{.i}, and \code{y} will
be \code{.before}.
}

These generics are a bit special. They work similarly to
\code{\link[vctrs:vec_ptype2]{vctrs::vec_ptype2()}} in that they are \emph{double dispatch} methods that
dispatch off the types of both \code{x} and \code{y}. To write an S3 method for these
generics, write and export an S3 method of the form:

\if{html}{\out{<div class="sourceCode">}}\preformatted{slider_plus.x_class.y_class <- function(x, y) \{
  # My method
\}
}\if{html}{\out{</div>}}

Inheritance is not considered in the method lookup, and you cannot use
\code{NextMethod()} from within your method.
}
\examples{
slider_plus(1, 2)
slider_minus(1, 2)
}
\keyword{internal}
