\name{plot.studpermutest}
\alias{plot.studpermutest}
\title{
  Plot a Studentised Permutation Test
}
\description{
  Plot the result of the studentised permutation test.
}
\usage{
  \method{plot}{studpermutest}(x, fmla, \dots,
          lty = NULL, col = NULL, lwd = NULL,
          lty.theo = NULL, col.theo = NULL, lwd.theo = NULL,
          lwd.mean = if (meanonly) 1 else NULL,
          lty.mean = lty, col.mean = col,
          separately = FALSE, meanonly = FALSE,
          main = if (meanonly) "group means" else NULL,
          xlim = NULL, ylim = NULL, ylab = NULL,
          legend = !add, legendpos = "topleft", lbox = FALSE, add = FALSE)
}
\arguments{
  \item{x}{
    An object of class \code{"studpermutest"} generated by
    \code{\link{studpermu.test}} and representing the result of a
    studentised permutation test for spatial point pattern data.
  }
  \item{fmla}{
    Plot formula used in \code{\link{plot.fv}}.
  }
  \item{\dots}{
    Additional graphical arguments passed to \code{\link{plot.fv}}.
  }
  \item{lty,col,lwd}{
    Line type, colour, and line width of the curves plotting the
    summary function for each point pattern in the original data.
    Either a single value or a
    vector of length equal to the number of point patterns.
  }
  \item{lty.theo,col.theo,lwd.theo}{
    Line type, colour, and line width of the curve representing the
    theoretical value of the summary function. 
  }
  \item{lty.mean,col.mean,lwd.mean}{
    Line type, colour, and line width (as a multiple of \code{lwd})
    of the curve representing the group mean of the summary function.
  }
  \item{separately}{
    Logical value indicating whether to plot each group of data
    in a separate panel.
  }
  \item{meanonly}{
    Logical value indicating whether to plot only the group means
    of the summary function.
  }
  \item{main}{
    Character string giving a main title for the plot.
  }
  \item{xlim,ylim}{
    Numeric vectors of length 2 giving the limits for the \eqn{x} and
    \eqn{y} coordinates of the plot or plots.
  }
  \item{ylab}{
    Character string or expression to be used for the label on the
    \eqn{y} axis.
  }
  \item{legend}{
    Logical value indicating whether to plot a legend
    explaining the meaning of each curve.
  }
  \item{legendpos}{
    Position of legend. See \code{\link{plot.fv}}.
  }
  \item{lbox}{
    Logical value indicating whether to plot a box around the plot.
  }
  \item{add}{
    Logical value indicating whether the plot should be added to
    the existing plot (\code{add=TRUE}) or whether a new frame should be
    created (\code{add=FALSE}, the default).
  }
}
\details{
  This is the \code{plot} method for objects of class
  \code{"studpermutest"} which represent the result of a studentised
  permutation test applied to several point patterns. The test is
  performed by \code{\link{studpermu.test}}.

  The plot shows the summary functions for each point pattern,
  coloured according to group.
  Optionally it can show the different groups
  in separate plot panels, or show only the group means in a single panel.
}
\value{
Null.
}
\author{
  Ute Hahn.

  Modified for \code{spatstat} by
  \spatstatAuthors.
}
\seealso{
  \code{\link{studpermu.test}}
}
\examples{
  np <- if(interactive()) 99 else 19
  testpyramidal <- studpermu.test(pyramidal, Neurons ~ group, nperm=np)
  plot(testpyramidal)
  plot(testpyramidal, meanonly=TRUE)
  plot(testpyramidal, col.theo=8, lwd.theo=4, lty.theo=1)
  plot(testpyramidal, . ~ pi * r^2)
  op <- par(mfrow=c(1,3))
  plot(testpyramidal, separately=TRUE)
  plot(testpyramidal, separately=TRUE, col=2, lty=1, lwd.mean=2, col.mean=4)
  par(op)
}
\keyword{hplot}
\keyword{htest}
