% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histo.R
\name{histo}
\alias{histo}
\title{Alternative Histograms}
\usage{
histo(x, breaks, ...)
}
\arguments{
\item{x}{numeric. A vector.}

\item{breaks}{numeric. A vector of breakpoints to build the histogram, 
possibly given by \code{\link[statip]{find_breaks}()}.}

\item{...}{Additional parameters (currently not used).}
}
\value{
An object of class \code{"histogram"}, which can be plotted 
by \code{\link[graphics]{plot.histogram}} from package \pkg{graphics}.
This object is a list with components:
\itemize{
  \item \code{breaks}: the \code{n+1} cell boundaries;
  \item \code{counts}: \code{n} integers giving the number of \code{x} 
  inside each cell;
  \item \code{xname}: a string with the actual \code{x} argument name.
}
}
\description{
A simplified version of 
\code{\link[graphics]{hist}()} from package \pkg{graphics}.
}
\seealso{
\code{\link[statip]{find_breaks}()} in this package; 
\code{\link[MASS]{truehist}()} from package \pkg{MASS};
\code{\link[graphics]{hist}()} from package \pkg{graphics}.
}
