% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system_fonts.R
\name{reset_font_cache}
\alias{reset_font_cache}
\title{Reset the system font cache}
\usage{
reset_font_cache()
}
\description{
Building the list of system fonts is time consuming and is therefore cached.
This, in turn, means that changes to the system fonts (i.e. installing new
fonts), will not propagate to systemfonts. The solution is to reset the
cache, which will result in the next call to e.g. \code{\link[=match_font]{match_font()}} will trigger
a rebuild of the cache.
}
\examples{
all_fonts <- system_fonts()

##-- Install a new font on the system --##

all_fonts_new <- system_fonts()

## all_fonts_new will be equal to all_fonts

reset_font_cache()

all_fonts_new <- system_fonts()

## all_fonts_new will now contain the new font

}
