% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eol_search.R
\name{eol_search}
\alias{eol_search}
\title{Search for terms in EOL database.}
\usage{
eol_search(
  sci,
  page = 1,
  exact = NULL,
  filter_tid = NULL,
  filter_heid = NULL,
  filter_by_string = NULL,
  cache_ttl = NULL,
  terms = NULL,
  ...
)
}
\arguments{
\item{sci}{(character) scientific name}

\item{page}{A maximum of 30 results are returned per page. This parameter
allows you to fetch more pages of results if there are more than
30 matches (Default 1)}

\item{exact}{Will find taxon pages if the preferred name or any synonym
or common name exactly matches the search term.}

\item{filter_tid}{Given an EOL page ID, search results will be limited
to members of that taxonomic group}

\item{filter_heid}{Given a Hierarchy Entry ID, search results will be
limited to members of that taxonomic group}

\item{filter_by_string}{Given a search term, an exact search will be made
and that matching page will be used as the taxonomic group against which
to filter search results}

\item{cache_ttl}{The number of seconds you wish to have the response cached.}

\item{terms}{Deprecated, see \code{sci}}

\item{...}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
A data frame with four columns:
\itemize{
\item pageid: pageid, this is the same as the eolid you can get from
\code{\link[=get_eolid]{get_eolid()}}
\item name: taxonomic name, may or may not contain the taxonomic authority
\item link: URL for the taxon in question
\item content: a string of semi-colon separated names. it's not clear
to us what these represent exactly, but figured why not give it to users
in case some may find it useful
}
}
\description{
Search for terms in EOL database.
}
\details{
It's possible to return JSON or XML with the EOL API. However,
this function only returns JSON for now.
}
\examples{
\dontrun{
eol_search(sci='Homo')
eol_search(sci='Salix', verbose = TRUE)
eol_search(sci='Ursus americanus')
eol_search('Pinus contorta')
}
}
