% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iucn_id.R
\name{iucn_id}
\alias{iucn_id}
\title{Get an ID for a IUCN listed taxon}
\usage{
iucn_id(sciname, key = NULL, ...)
}
\arguments{
\item{sciname}{character; Scientific name. Should be cleand and in the
format \verb{*<Genus> <Species>*}. One or more.}

\item{key}{(character) required. you IUCN Redlist API key. See
\link[rredlist:rredlist-package]{rredlist::rredlist-package} for help on authenticating with
IUCN Redlist}

\item{...}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
A named list (names are input taxa names) of one or more IUCN IDs.
Taxa that aren't found are silently dropped.
}
\description{
Get an ID for a IUCN listed taxon
}
\examples{
\dontrun{
iucn_id("Branta canadensis")
iucn_id("Branta bernicla")
iucn_id("Panthera uncia")
iucn_id("Lynx lynx")

# many names
iucn_id(c("Panthera uncia", "Lynx lynx"))

# many names, some not found
iucn_id(c("Panthera uncia", "Lynx lynx", "foo bar", "hello world"))

# a name not found
iucn_id("Foo bar")
}
}
\author{
Scott Chamberlain,
}
