% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_row}
\alias{add_row}
\alias{add_case}
\title{Add rows to a data frame}
\usage{
add_row(.data, ..., .before = NULL, .after = NULL)
}
\arguments{
\item{.data}{Data frame to append to.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}>
Name-value pairs, passed on to \code{\link[=tibble]{tibble()}}. Values can be defined
only for columns that already exist in \code{.data} and unset columns will get an
\code{NA} value.}

\item{.before, .after}{One-based row index where to add the new rows,
default: after last row.}
}
\description{
This is a convenient way to add one or more rows of data to an existing data
frame. See \code{\link[=tribble]{tribble()}} for an easy way to create an complete
data frame row-by-row. Use \code{\link[=tibble_row]{tibble_row()}} to ensure that the new data
has only one row.

\code{add_case()} is an alias of \code{add_row()}.
}
\examples{
# add_row ---------------------------------
df <- tibble(x = 1:3, y = 3:1)

df \%>\% add_row(x = 4, y = 0)

# You can specify where to add the new rows
df \%>\% add_row(x = 4, y = 0, .before = 2)

# You can supply vectors, to add multiple rows (this isn't
# recommended because it's a bit hard to read)
df \%>\% add_row(x = 4:5, y = 0:-1)

# Use tibble_row() to add one row only
df \%>\% add_row(tibble_row(x = 4, y = 0))
try(df \%>\% add_row(tibble_row(x = 4:5, y = 0:-1)))

# Absent variables get missing values
df \%>\% add_row(x = 4)

# You can't create new variables
try(df \%>\% add_row(z = 10))
}
\seealso{
Other addition: 
\code{\link{add_column}()}
}
\concept{addition}
