% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-misc.R
\name{everything}
\alias{everything}
\alias{last_col}
\title{Select all variables or the last variable}
\usage{
everything(vars = NULL)

last_col(offset = 0L, vars = NULL)
}
\arguments{
\item{vars}{A character vector of variable names. If not supplied,
the variables are taken from the current selection context (as
established by functions like \code{select()} or \code{pivot_longer()}).}

\item{offset}{Set it to \code{n} to select the nth var from the end.}
}
\description{
These functions are \link[=language]{selection helpers}.
\itemize{
\item \code{\link[=everything]{everything()}} selects all variable. It is also useful in
combination with other tidyselect operators.
\item \code{\link[=last_col]{last_col()}} selects the last variable.
}
}
\section{Examples}{


Selection helpers can be used in functions like \code{dplyr::select()}
or \code{tidyr::pivot_longer()}. Let's first attach the tidyverse:\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(tidyverse)

# For better printing
iris <- as_tibble(iris)
mtcars <- as_tibble(mtcars)
}\if{html}{\out{</div>}}

Use \code{everything()} to select all variables:\if{html}{\out{<div class="sourceCode r">}}\preformatted{iris \%>\% select(everything())
#> # A tibble: 150 x 5
#>   Sepal.Length Sepal.Width Petal.Length Petal.Width Species
#>          <dbl>       <dbl>        <dbl>       <dbl> <fct>  
#> 1          5.1         3.5          1.4         0.2 setosa 
#> 2          4.9         3            1.4         0.2 setosa 
#> 3          4.7         3.2          1.3         0.2 setosa 
#> 4          4.6         3.1          1.5         0.2 setosa 
#> # ... with 146 more rows

mtcars \%>\% pivot_longer(everything())
#> # A tibble: 352 x 2
#>   name  value
#>   <chr> <dbl>
#> 1 mpg      21
#> 2 cyl       6
#> 3 disp    160
#> 4 hp      110
#> # ... with 348 more rows
}\if{html}{\out{</div>}}

Use \code{last_col()} to select the last variable:\if{html}{\out{<div class="sourceCode r">}}\preformatted{iris \%>\% select(last_col())
#> # A tibble: 150 x 1
#>   Species
#>   <fct>  
#> 1 setosa 
#> 2 setosa 
#> 3 setosa 
#> 4 setosa 
#> # ... with 146 more rows

mtcars \%>\% pivot_longer(last_col())
#> # A tibble: 32 x 12
#>     mpg   cyl  disp    hp  drat    wt  qsec    vs    am  gear name  value
#>   <dbl> <dbl> <dbl> <dbl> <dbl> <dbl> <dbl> <dbl> <dbl> <dbl> <chr> <dbl>
#> 1  21       6   160   110  3.9   2.62  16.5     0     1     4 carb      4
#> 2  21       6   160   110  3.9   2.88  17.0     0     1     4 carb      4
#> 3  22.8     4   108    93  3.85  2.32  18.6     1     1     4 carb      1
#> 4  21.4     6   258   110  3.08  3.22  19.4     1     0     3 carb      1
#> # ... with 28 more rows
}\if{html}{\out{</div>}}

Supply an offset \code{n} to select a variable located \code{n} positions
from the end:\if{html}{\out{<div class="sourceCode r">}}\preformatted{mtcars \%>\% select(1:last_col(5))
#> # A tibble: 32 x 6
#>     mpg   cyl  disp    hp  drat    wt
#>   <dbl> <dbl> <dbl> <dbl> <dbl> <dbl>
#> 1  21       6   160   110  3.9   2.62
#> 2  21       6   160   110  3.9   2.88
#> 3  22.8     4   108    93  3.85  2.32
#> 4  21.4     6   258   110  3.08  3.22
#> # ... with 28 more rows
}\if{html}{\out{</div>}}
}

\seealso{
The \link[=language]{selection language} page, which includes links to other selection helpers.
}
