% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faq.R
\name{faq-external-vector}
\alias{faq-external-vector}
\title{FAQ - Note: Using an external vector in selections is ambiguous}
\description{
\subsection{Ambiguity between columns and external variables}{

With selecting functions like \code{dplyr::select()} or
\code{tidyr::pivot_longer()}, you can refer to variables by name:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{mtcars \%>\% select(cyl, am, vs)
#> # A tibble: 32 x 3
#>     cyl    am    vs
#>   <dbl> <dbl> <dbl>
#> 1     6     1     0
#> 2     6     1     0
#> 3     4     1     1
#> 4     6     0     1
#> # ... with 28 more rows

mtcars \%>\% select(mpg:disp)
#> # A tibble: 32 x 3
#>     mpg   cyl  disp
#>   <dbl> <dbl> <dbl>
#> 1  21       6   160
#> 2  21       6   160
#> 3  22.8     4   108
#> 4  21.4     6   258
#> # ... with 28 more rows
}\if{html}{\out{</div>}}

For historical reasons, it is also possible to refer an external vector
of variable names. You get the correct result, but with a note informing
you that selecting with an external variable is ambiguous because it is
not clear whether you want a data frame column or an external object.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vars <- c("cyl", "am", "vs")
result <- mtcars \%>\% select(vars)
#> Warning: Using an external vector in selections was deprecated in
#> tidyselect 1.1.0.
#> i Please use `all_of()` or `any_of()` instead.
#>   # Was:
#>   data \%>\% select(vars)
#> 
#>   # Now:
#>   data \%>\% select(all_of(vars))
#> 
#> See
#> <https://tidyselect.r-lib.org/reference/faq-external-vector.html>.
}\if{html}{\out{</div>}}

This note will become a warning in the future, and then an error. We
have decided to deprecate this particular approach to using external
vectors because they introduce ambiguity. Imagine that the data frame
contains a column with the same name as your external variable.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{some_df <- mtcars[1:4, ]
some_df$vars <- 1:nrow(some_df)
}\if{html}{\out{</div>}}

These are very different objects but it isn’t a problem if the context
forces you to be specific about where to find \code{vars}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vars
#> [1] "cyl" "am"  "vs"

some_df$vars
#> [1] 1 2 3 4
}\if{html}{\out{</div>}}

In a selection context however, the column wins:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{some_df \%>\% select(vars)
#> # A tibble: 4 x 1
#>    vars
#>   <int>
#> 1     1
#> 2     2
#> 3     3
#> 4     4
}\if{html}{\out{</div>}}
}

\subsection{Fixing the ambiguity}{

To make your selection code more robust and silence the message, use
\code{all_of()} to force the external vector:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{some_df \%>\% select(all_of(vars))
#> # A tibble: 4 x 3
#>     cyl    am    vs
#>   <dbl> <dbl> <dbl>
#> 1     6     1     0
#> 2     6     1     0
#> 3     4     1     1
#> 4     6     0     1
}\if{html}{\out{</div>}}

For more information or if you have comments about this, please see the
\href{https://github.com/r-lib/tidyselect/issues/76}{Github issue} tracking
the deprecation process.
}
}
