% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{linearMrca}
\alias{linearMrca}
\title{Linear MRCA function}
\usage{
linearMrca(tree, k = 0)
}
\arguments{
\item{tree}{an object of the class \code{phylo} which should be rooted.}

\item{k}{(optional) number of tips in tree, for faster computation}
}
\description{
Function to make the most recent common ancestor (MRCA) matrix of a tree, where entry (i,j) gives the MRCA of tips i and j.
The function is linear, exploiting the fact that the tree is rooted.
}
\examples{

## generate a random tree
x <- rtree(6)

## create matrix of MRCAs: entry (i,j) is the node number of the MRCA of tips i and j
linearMrca(x,6)


}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
