% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCollapsedTree.R
\name{makeCollapsedTree}
\alias{makeCollapsedTree}
\title{Collapse a tree into a single tip per category}
\usage{
makeCollapsedTree(tree, df, warnings = TRUE)
}
\arguments{
\item{tree}{an object of the class \code{phylo}: the tree to collapse.}

\item{df}{a two-column data frame linking tip labels (column 2) with their corresponding categories (column 1).}

\item{warnings}{a logical determining whether a warning should be given if there are paraphyletic categories (default TRUE)}
}
\value{
A tree (class \code{phylo}) whose tip labels are exactly the set of unique categories from \code{df}.
}
\description{
Reduce a tree with many tips into a tree with a single tip per category. 
Where a category's tips form a monophyletic clade, the clade is replaced by a single tip labelled by that category.
Where a category's tips are paraphyletic, the largest clade for that category is treated as above, and all other tips pruned.
}
\examples{
 
# simulate a tree which is monophyletic per category
tree <- simulateIndTree(rtree(5), permuteTips=FALSE)

df <- cbind(sort(rep(rtree(5)$tip.label,5)),sort(tree$tip.label))
palette <- c("red","blue","black","green","purple")#' 
tipCols <- palette[as.factor(sapply(tree$tip.label, function(l) df[which(df[,2]==l),1]))]
plot(tree, tip.color=tipCols)
collapsedTree <- makeCollapsedTree(tree,df)
plot(collapsedTree, tip.color=palette[as.factor(collapsedTree$tip.label)])

# simulate a tree which is paraphyletic per category
tree <- simulateIndTree(rtree(5), tipPercent=20)
tipCols <- palette[as.factor(sapply(tree$tip.label, function(l) df[which(df[,2]==l),1]))]
plot(tree, tip.color=tipCols)
collapsedTree <- makeCollapsedTree(tree,df)
plot(collapsedTree, tip.color=palette[as.factor(collapsedTree$tip.label)])

}
\seealso{
\code{\link{treeConcordance}} \code{\link{simulateIndTree}}
}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
