% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tween_fill.R
\name{tween_fill}
\alias{tween_fill}
\title{Fill out missing values by interpolation}
\usage{
tween_fill(data, ease)
}
\arguments{
\item{data}{A data.frame or vector.}

\item{ease}{A character vector giving valid easing functions. Recycled to
match the ncol of \code{data}}
}
\value{
If \code{data} is a data.frame then a data.frame with the same
columns. If \code{data} is a vector then a vector.
}
\description{
This tween fills out \code{NA} elements (or \code{NULL} elements if \code{data} is a list)
by interpolating between the prior and next non-missing values.
}
\examples{
# Single vector
tween_fill(c(1, NA, NA, NA, NA, NA, 2, 6, NA, NA, NA, -2), 'cubic-in-out')

# Data frame
tween_fill(mtcars[c(1, NA, NA, NA, NA, 4, NA, NA, NA, 10), ], 'cubic-in')

}
