% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uwot.R
\name{load_uwot}
\alias{load_uwot}
\title{Save or Load a Model}
\usage{
load_uwot(file)
}
\arguments{
\item{file}{name of the file where the model is to be saved or read from.}
}
\description{
Functions to write a UMAP model to a file, and to restore.
}
\examples{
# create model
model <- umap(iris[1:100, ], ret_model = TRUE)

# save
model_file <- tempfile("iris_umap")
save_uwot(model, file = model_file)

# restore
model2 <- load_uwot(file = model_file)

identical(model, model2)

unlink(model_file)
}
