% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response_class.R
\name{VcrResponse}
\alias{VcrResponse}
\title{The response of an HTTPInteraction}
\description{
Custom vcr http response object
}
\examples{
\dontrun{
vcr_configure(dir = tempdir())

# basic example of VcrResponse use
url <- "https://google.com"
(cli <- crul::HttpClient$new(url = url))
(res <- cli$get("get", query = list(q = "stuff")))
(x <- VcrResponse$new(res$status_http(), res$response_headers,
   res$parse("UTF-8"), res$response_headers$status))
x$body
x$status
x$headers
x$http_version
x$to_hash()
x$from_hash(x$to_hash())

# update content length header
## example 1
### content-length header present, but no change
url <- "https://fishbase.ropensci.org"
cli <- crul::HttpClient$new(url = url, headers = list(`Accept-Encoding` = '*'))
res <- cli$get("species/34")
x <- VcrResponse$new(res$status_http(), res$response_headers,
   res$parse("UTF-8"), res$response_headers$status)
x$headers$`content-length`
x$update_content_length_header()
x$headers$`content-length`

## example 2
### no content-length header b/c a transfer-encoding header is included
### and no content-length header allowed if transfer-encoding header
### used (via rfc7230)
url <- "https://google.com"
cli <- crul::HttpClient$new(url = url)
res <- cli$get()
x <- VcrResponse$new(res$status_http(), res$response_headers,
   rawToChar(res$content), res$response_headers$status)
x$headers$`content-length` # = NULL
x$update_content_length_header() # no change, b/c header doesn't exist
x$headers$`content-length` # = NULL

## example 3
### content-length header present, and does change
body <- " Hello World "
x <- VcrResponse$new(200, list('content-length'=nchar(body)),
  body, "HTTP/2")
x$headers$`content-length` # = 13
x$body <- gsub("^\\\\s|\\\\s$", "", x$body)
x$headers$`content-length` # = 13
x$update_content_length_header()
x$headers$`content-length` # = 11

# check if body is compressed
url <- "https://fishbase.ropensci.org"
(cli <- crul::HttpClient$new(url = url))
(res <- cli$get("species/3"))
res$response_headers
(x <- VcrResponse$new(res$status_http(), res$response_headers,
   res$parse("UTF-8"), res$response_headers$status))
x$content_encoding()
x$is_compressed()

# with disk
url <- "https://google.com"
(cli <- crul::HttpClient$new(url = url))
f <- tempfile()
(res <- cli$get("get", query = list(q = "stuff"), disk = f))
(x <- VcrResponse$new(res$status_http(), res$response_headers,
   f, res$response_headers$status, disk = TRUE))
}
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{status}}{the status of the response}

\item{\code{headers}}{the response headers}

\item{\code{body}}{the response body}

\item{\code{http_version}}{the HTTP version}

\item{\code{opts}}{a list}

\item{\code{adapter_metadata}}{Additional metadata used by a specific VCR adapter}

\item{\code{hash}}{a list}

\item{\code{disk}}{a boolean}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-VcrResponse-new}{\code{VcrResponse$new()}}
\item \href{#method-VcrResponse-print}{\code{VcrResponse$print()}}
\item \href{#method-VcrResponse-to_hash}{\code{VcrResponse$to_hash()}}
\item \href{#method-VcrResponse-from_hash}{\code{VcrResponse$from_hash()}}
\item \href{#method-VcrResponse-update_content_length_header}{\code{VcrResponse$update_content_length_header()}}
\item \href{#method-VcrResponse-get_header}{\code{VcrResponse$get_header()}}
\item \href{#method-VcrResponse-edit_header}{\code{VcrResponse$edit_header()}}
\item \href{#method-VcrResponse-delete_header}{\code{VcrResponse$delete_header()}}
\item \href{#method-VcrResponse-content_encoding}{\code{VcrResponse$content_encoding()}}
\item \href{#method-VcrResponse-is_compressed}{\code{VcrResponse$is_compressed()}}
\item \href{#method-VcrResponse-clone}{\code{VcrResponse$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VcrResponse-new"></a>}}
\if{latex}{\out{\hypertarget{method-VcrResponse-new}{}}}
\subsection{Method \code{new()}}{
Create a new VcrResponse object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VcrResponse$new(
  status,
  headers,
  body,
  http_version,
  opts,
  adapter_metadata = NULL,
  disk
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{the status of the response}

\item{\code{headers}}{the response headers}

\item{\code{body}}{the response body}

\item{\code{http_version}}{the HTTP version}

\item{\code{opts}}{a list}

\item{\code{adapter_metadata}}{Additional metadata used by a specific VCR adapter}

\item{\code{disk}}{boolean, is body a file on disk}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{VcrResponse} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VcrResponse-print"></a>}}
\if{latex}{\out{\hypertarget{method-VcrResponse-print}{}}}
\subsection{Method \code{print()}}{
print method for the \code{VcrResponse} class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VcrResponse$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VcrResponse-to_hash"></a>}}
\if{latex}{\out{\hypertarget{method-VcrResponse-to_hash}{}}}
\subsection{Method \code{to_hash()}}{
Create a hash
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VcrResponse$to_hash()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VcrResponse-from_hash"></a>}}
\if{latex}{\out{\hypertarget{method-VcrResponse-from_hash}{}}}
\subsection{Method \code{from_hash()}}{
Get a hash back to an R list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VcrResponse$from_hash(hash)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hash}}{a list}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an \code{VcrResponse} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VcrResponse-update_content_length_header"></a>}}
\if{latex}{\out{\hypertarget{method-VcrResponse-update_content_length_header}{}}}
\subsection{Method \code{update_content_length_header()}}{
Updates the Content-Length response header so that
it is accurate for the response body
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VcrResponse$update_content_length_header()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
no return; modifies the content length header
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VcrResponse-get_header"></a>}}
\if{latex}{\out{\hypertarget{method-VcrResponse-get_header}{}}}
\subsection{Method \code{get_header()}}{
Get a header by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VcrResponse$get_header(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{(character) header name to get}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the header value (if it exists)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VcrResponse-edit_header"></a>}}
\if{latex}{\out{\hypertarget{method-VcrResponse-edit_header}{}}}
\subsection{Method \code{edit_header()}}{
Edit a header
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VcrResponse$edit_header(key, value = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{(character) header name to edit}

\item{\code{value}}{(character) new value to assign}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
no return; modifies the header in place
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VcrResponse-delete_header"></a>}}
\if{latex}{\out{\hypertarget{method-VcrResponse-delete_header}{}}}
\subsection{Method \code{delete_header()}}{
Delete a header
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VcrResponse$delete_header(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{(character) header name to delete}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
no return; the header is deleted if it exists
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VcrResponse-content_encoding"></a>}}
\if{latex}{\out{\hypertarget{method-VcrResponse-content_encoding}{}}}
\subsection{Method \code{content_encoding()}}{
Get the content-encoding header value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VcrResponse$content_encoding()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(character) the content-encoding value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VcrResponse-is_compressed"></a>}}
\if{latex}{\out{\hypertarget{method-VcrResponse-is_compressed}{}}}
\subsection{Method \code{is_compressed()}}{
Checks if the encoding is one of "gzip" or "deflate"
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VcrResponse$is_compressed()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VcrResponse-clone"></a>}}
\if{latex}{\out{\hypertarget{method-VcrResponse-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VcrResponse$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
