% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git-app.R
\name{git_app}
\alias{git_app}
\title{Web app that acts as a git http server}
\usage{
git_app(
  git_root,
  git_cmd = "git",
  git_timeout = as.difftime(1, units = "mins"),
  filter = TRUE,
  cleanup = TRUE
)
}
\arguments{
\item{git_root}{Path to the root of the directory tree to be served.}

\item{git_cmd}{Command to call, by default it is \code{"git"}. It may also
be a full path to git.}

\item{git_timeout}{A \code{difftime} object, time limit for the git
command.}

\item{filter}{Whether to support the \code{filter} capability in the server.}

\item{cleanup}{Whether to clean up \code{git_root} when the app is
garbage collected.}
}
\description{
It is useful for tests that need an HTTP git server.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dir.create(tmp <- tempfile())
setwd(tmp)
system("git clone --bare https://github.com/cran/crayon")
system("git clone --bare https://github.com/cran/glue")
app <- git_app(tmp)
git <- new_app_process(app)
system(paste("git ls-remote", git$url("/crayon")))
\dontshow{\}) # examplesIf}
}
