% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_http.R
\name{parse_http}
\alias{parse_http}
\title{Parse http request}
\usage{
parse_http(body, content_type, ...)
}
\arguments{
\item{body}{request body of the http request}

\item{content_type}{content-type http request header as specified by the client}

\item{...}{additional arguments passed to parser function}
}
\description{
Parse the body of a http request, based on the \code{Content-Type} request
header. Currently supports the three most important content types:
\code{application/x-www-form-urlencoded} with \code{\link[=parse_query]{parse_query()}},
\code{multipart/form-data} with \code{\link[=parse_multipart]{parse_multipart()}}, and \code{application/json}
with \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}}.
}
\examples{
# Parse json encoded payload:
parse_http('{"foo":123, "bar":true}', 'application/json')

# Parse url-encoded payload
parse_http("foo=1\%2B1\%3D2&bar=yin\%26yang", "application/x-www-form-urlencoded")

\dontrun{use demo app to parse multipart/form-data payload
demo_rhttpd()
}
}
