% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{addPanel}
\alias{addPanel}
\title{Add a panel to an existing xts plot}
\usage{
addPanel(
  FUN,
  main = "",
  on = NA,
  type = "l",
  col = NULL,
  lty = 1,
  lwd = 1,
  pch = 1,
  ...
)
}
\arguments{
\item{FUN}{An xts object to plot.}

\item{main}{Main title for a new panel if drawn.}

\item{on}{Panel number to draw on. A new panel will be drawn if \code{on = NA}.}

\item{type}{The type of plot to be drawn, same as in \code{\link[=plot]{plot()}}.}

\item{col}{Color palette to use, set by default to rational choices.}

\item{lty}{Set the line type, same as in \code{\link[=par]{par()}}.}

\item{lwd}{Set the line width, same as in \code{\link[=par]{par()}}.}

\item{pch}{The type of plot to be drawn, same as in \code{\link[=par]{par()}}.}

\item{\dots}{Additional named arguments passed through to \code{FUN} and any
other graphical passthrough parameters.}
}
\description{
Apply a function to the data of an existing xts plot object and plot the
result on an existing or new panel. \code{FUN} should have arguments \code{x} or \code{R}
for the data of the existing xts plot object to be passed to. All other
additional arguments for \code{FUN} are passed through \dots.
}
\examples{

library(xts)
data(sample_matrix)
sample.xts <- as.xts(sample_matrix)

calcReturns <- function(price, method = c("discrete", "log")){
  px <- try.xts(price)
  method <- match.arg(method)[1L]
  returns <- switch(method,
    simple = ,
    discrete = px / lag(px) - 1,
    compound = ,
    log = diff(log(px)))
  reclass(returns, px)
}

# plot the Close
plot(sample.xts[,"Close"])
# calculate returns 
addPanel(calcReturns, method = "discrete", type = "h")
# Add simple moving average to panel 1
addPanel(rollmean, k = 20, on = 1)
addPanel(rollmean, k = 40, col = "blue", on = 1)

}
\seealso{
\code{\link[=plot.xts]{plot.xts()}}, \code{\link[=addSeries]{addSeries()}}
}
\author{
Ross Bennett
}
