% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.environment.xts.R
\name{as.environment.xts}
\alias{as.environment.xts}
\title{Coerce an xts Object to an Environment by Column}
\usage{
\method{as.environment}{xts}(x)
}
\arguments{
\item{x}{An xts object.}
}
\value{
An environment containing \code{ncol(x)} vectors extracted by
column from \code{x}.
}
\description{
Method to automatically convert an xts object to an environment containing
vectors representing each column of the original xts object. The name of
each object in the resulting environment corresponds to the name of the
column of the xts object.
}
\note{
Environments do not preserve (or have knowledge) of column order and
cannot be subset by an integer index.
}
\examples{

x <- xts(1:10, Sys.Date()+1:10)
colnames(x) <- "X"
y <- xts(1:10, Sys.Date()+1:10)
colnames(x) <- "Y"
xy <- cbind(x,y)
colnames(xy)
e <- as.environment(xy)    # currently using xts-style positive k 
ls(xy)
ls.str(xy)

}
\author{
Jeffrey A. Ryan
}
\keyword{manip}
