# Announce: Rakudo Perl 6 compiler, Development Release #82 ("Helsinki")

On behalf of the Rakudo development team, I'm happy to announce the
November 2014 release of Rakudo Perl 6 #82 "Helsinki". Rakudo is an
implementation of Perl 6 on the Moar Virtual Machine[^1], the Java Virtual
Machine and the Parrot Virtual Machine. The tarball for this release
is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it's announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The Rakudo Perl compiler follows a monthly release cycle, with each
release named after a Perl Mongers group. This release is named after
Helsinki, in honour of the organizers of the Nordic Perl Workshop.

Some of the changes in this release are outlined below:

- Method 'for' as an alias for 'map'. Map will stop flattening the list eventually, 'for' remains as it is now.
- Method 'unique' as a successor for 'uniq'
- Introduce IO::Handle.slurp-rest for slurping rest from handle
- Using a constant negative subscript now dies at compile time
- Better wording for runtime negative index failure
- Force calling method for <.foo> even if sub foo exists
- Fix tie-breaking issues with longest literal matching
- Various performance improvements and bugfixes

These are only some of the changes in this release. For a more
detailed list, see "docs/ChangeLog".

A note for OS X users: when running a spectest with a high number of parallel
tests (e.g. with TEST_JOBS=8), it is likely you will see any number between
0 and 10 test-files with failures, usually because they abort midway through
testing.  Running these test-files then by themselves, shows no errors
whatsoever.  Current theory is that something in the MoarVM build on OS X is
introducing random memory corruption.  Any thoughts / suggestions / fixes will
be deeply appreciated.

The development team thanks all of our contributors and sponsors for
making Rakudo Perl possible, as well as those people who worked on
Parrot, the Perl 6 test suite, MoarVM and the specification.

The following people contributed to this release:

Elizabeth Mattijsen, Tobias Leich, Larry Wall, Jonathan Scott Duff,
Timo Paulssen, Alexander Moquin, Moritz Lenz, Steve Mynott,
Christian Bartolomäus, Carl Mäsak, Pepe Schwarz, Rob Hoelz, Reini Urban,
Geoff Broadwell, [Coke]

If you would like to contribute, see <http://rakudo.org/how-to-help>,
ask on the <perl6-compiler@perl.org> mailing list, or ask on IRC
\#perl6 on freenode.

The next release of Rakudo (#83), is scheduled for 18 December 2014.
A list of the other planned release dates and code names for future
releases is available in the "docs/release_guide.pod" file. A Rakudo
development release typically occurs a few days (often two) after the
third Tuesday of each month.

The development team appreciates feedback! If you're using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list of IRC channel. Enjoy!

[^1]: See <http://moarvm.org/>

[^2]: What's the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Nothing else.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the "Using Perl 6" book, and other software that can
be used with the Rakudo compiler to enhance its utility.  Rakudo Star
is meant for early adopters who wish to explore what's possible with
Rakudo Perl 6 and provide feedback on what works, what doesn't, and
what else they would like to see included in the distribution.
