# Announce: Rakudo Perl 6 compiler, Release #121 (2018.03)

On behalf of the Rakudo development team, I’m very happy to announce the
March 2018 release of Rakudo Perl 6 #121. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo.

Upcoming releases in 2018 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] — it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2018.03:
  + SPECIAL NOTES:
    + Str.comb(Regex) was fixed to return a Seq instead of a List,
      making Str.comb always return a Seq. Code relying on the
      specifics of the previous behavior might require some tweaks.
  + Fixes:
    + Fixed various sleep() issues [e3c4db73]
    + Fixed <0/0> to be False [748d1a57]
    + Improved Test.pm6's like/unlike [7c1a6cac]
    + Fixed failure to sink last statements of `for` loops [4c5b81fe]
    + Removed unneeded candidates in &say and &note [3a0d53ce]
    + Made Str.comb(Regex) return a Seq [1da07530]
    + Fixed &say and &note to not auto-thread [b62e0eb7][355b2eb5]
    + Differentiated precomp NC sub setup markers [b27c548f][ec5edcae]
    + Moved chrs() logic to List.chrs and made chrs() the gateway [1894eace]
    + Moved ords() logic to Str.ords [61176475]
    + Fixed bug on ops with subclasses of Range [440fceac]
    + Fixed wrong assumption of Junction execution order [207313be]
        [89f33bbe][e9cff795]
    + Fixed cases of mis-scoped QAST::Block of regexes [fb882d49]
    + Fixed .grep(Regex) on Hyper/Race Seqs [5e462e12]
    + Fixed &dd to not mark Failures as handled [7773c3d5][65874b15]
    + Enabled native-int candidates in bitshift operators [29fdb75a][3d735975]
    + Made Int:D (elem) Range:D be independent of size of Range [de30c162]
    + Straightened up `$/` handling in Str.subst[-mutate] [874fcdda]
    + Fixed Metamodel shortname assignments [ce08683f]
    + Fixed Pair.clone [5031dab3]
    + Improved Pod::To::Text to indent tables [57af8b84][dffbd68a]
    + Fixed precomp files of NativeCall users having absolute paths [51c4d4d8]
    + Made sure `samewith`-using routines aren't inlined [e12e305a]
    + Made sure MERGESORT-* don't leak low-level types [511bec0a]
    + Fixed code generation bug affecting private methods calls in roles
      where the target private method used a role parameter [21997b62]
    + Various improvements to produced messages [a4f9090e][235d3f1c]
        [3b350739][5ae1bbe1][52176c3c]
  + Additions:
    + Implemented IO::CatHandle.handles [d5baa036][eb064922][639c6da0]
    + Made signal handlers cancellable [db010b84][a31579c7]
    + “datagram”-oriented API for UDP sockets [67f36e36][b406b320][dd2c9019]
    + Added support for replacement and strict setting in Buf.decode [0d796fb0]
    + Added support to Encoding::Decoder to use replacements [ea92f550]
  + Removals:
    + Removed no longer used DELETEKEY helper sub [6f2cbcf7]
    + Removed Range.clone-with-op [440fceac]
  + Efficiency:
    + Optimized Uni.list to reify 15x faster (on 10000-char str) [8b7385d8]
    + Made Str.perl 43x faster for some chars [ba6b84bd]
    + Optimized Str.perl by making uniprop(Int, Str) 2.7x faster [6ac56cc0]
    + Made Rational.Str 28% faster [008b9279]
    + Made internal RETURN-LIST sub faster for common case [3a4056bf]
    + Made Num.Bool 9x faster [2a42cdbb]
    + Nano-optimized supervisor thread sleep [4617976d][85ad0eba]
    + Added special cases for 2-tuple infix:<,> that are 10% faster [b6e5d7fc]
        [48c46fa7][90079357][ddf00078][d5a148c0]
    + Made Channel.receive/receive-nil-on-close 2.5% faster [4054ca68]
    + Reduced the number of DYNAMIC calls when hypering [598832cc]
    + Made Channel.poll 2x fast [eff92f94]
    + Made HyperIteratorBatcher.produce-batch 3.6x faster [8026cef8]
    + Many HyperToIterator speedups [0194ef46][6232d29e][34889beb]
  + Internal:
    + Turned many subs into multis [16b57af5][55bc053c][182b7ea5][63775474]
        [c2d0d3ac][cdb45fa5][4f473867][bf5e3357][5210d702][b704a175][4c67498f]
        [7d72387b][838782b7][abfbd1ab][6d6a69fd][c1d2a5bc][4da2418a][62fc3118]
        [d3f50dba][b9f40fea][dfef8283][9a0a7bdd][32b08035][51fccdfe][474c512c]
        [4f04698f][423e7cc0][ae4204c5][8cba0846][1b94ff6f][5490bacd][e1b711ae]
        [a23684f3][804c009a][f5b23a55][4513c279]
    + Marked many subs as “only” [1be26afb][25bedf88]
    + Marked set ops as “pure” on their proto only [af353894]
    + Made Unicode operators aliases of corresponding ASCII subs [254f477e]
        [aadd3c12][bc52fefa][a2100ec7][2e7a0e59]
    + Added nqp::getppid [fed92e3b]
    + Many profiler improvements, it now supports multi-threaded programs
        [fed92e3b][a5a6c778][dd2c9019]
    + Made substr() just a front for Str.substr [7835652d][b688a6f3][15ccfd33]
    + Made substr-rw() just a front for Str.substr-rw [038837f8]
    + Moved substr/substr-rw catcher methods from Any to Cool [aad79f8a]
    + Remote debug support on MoarVM [ffeff74e][e32bda21]


The following people contributed to this release:

Zoffix Znet, Elizabeth Mattijsen, JJ Merelo, Will "Coke" Coleda,
Paweł Murias, Christian Bartolomäus, Tom Browder,
Aleks-Daniel Jakimenko-Aleksejev, Luca Ferrari, Timo Paulssen, cfa,
Jonathan Worthington, Itsuki Toyota, Samantha McVey, Daniel Green,
Jan-Olof Hendig, Ronald Schmidt, Nick Logan, Stefan Seifert,
Richard Hainsworth, Steve Mynott, Ben Davies, Jeremy Studer,
Juan Julián Merelo Guervós, Patrick Spek, Alex Chen, Antonio Quinonez,
Brad Gilbert, Wenzel P. P. Peppmeyer, Brian S. Julin, LLFourn, Larry Wall

as well as Bart Wiegmans

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put “Perl 6 Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#122), is tentatively scheduled for 2018-04-21.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory
documentation, and other software that can be used with the Rakudo
compiler to enhance its utility.
