// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Net.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.net {

  public class InterfaceIPv6Info : ICloneable {
    public object Clone() {
      InterfaceIPv6Info copy = new InterfaceIPv6Info();
      copy.enabled = this.enabled;
      copy.configMethod = this.configMethod;
      copy.addrsCidr = this.addrsCidr;
      copy.dhcpServerId = this.dhcpServerId;
      copy.dhcpPreferredHostname = this.dhcpPreferredHostname;
      copy.raManaged = this.raManaged;
      copy.raOtherConf = this.raOtherConf;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["enabled"] = this.enabled;
      json["configMethod"] = (int)this.configMethod;
      json["addrsCidr"] = new JsonArray(this.addrsCidr.Select(
        _value => (JsonValue)(_value.Encode())));
      json["dhcpServerId"] = this.dhcpServerId;
      json["dhcpPreferredHostname"] = this.dhcpPreferredHostname;
      json["raManaged"] = this.raManaged;
      json["raOtherConf"] = this.raOtherConf;
      return json;
    }

    public static InterfaceIPv6Info Decode(LightJson.JsonObject json, Agent agent) {
      InterfaceIPv6Info inst = new InterfaceIPv6Info();
      inst.enabled = (bool)json["enabled"];
      inst.configMethod = (Com.Raritan.Idl.net.IpConfigMethod)(int)json["configMethod"];
      inst.addrsCidr = new System.Collections.Generic.List<Com.Raritan.Idl.net.IpAddrCidr>(json["addrsCidr"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.net.IpAddrCidr.Decode(_value, agent)));
      inst.dhcpServerId = (string)json["dhcpServerId"];
      inst.dhcpPreferredHostname = (string)json["dhcpPreferredHostname"];
      inst.raManaged = (bool)json["raManaged"];
      inst.raOtherConf = (bool)json["raOtherConf"];
      return inst;
    }

    public bool enabled = false;
    public Com.Raritan.Idl.net.IpConfigMethod configMethod = Com.Raritan.Idl.net.IpConfigMethod.STATIC;
    public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.net.IpAddrCidr> addrsCidr = new System.Collections.Generic.List<Com.Raritan.Idl.net.IpAddrCidr>();
    public string dhcpServerId = "";
    public string dhcpPreferredHostname = "";
    public bool raManaged = false;
    public bool raOtherConf = false;
  }
}
