# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2024 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from BulkRequest.idl.

use strict;

package Raritan::RPC::bulkrpc::BulkRequest_1_0_2;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "bulkrpc.BulkRequest:1.0.2";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::bulkrpc::BulkRequest_1_0_2::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use Raritan::RPC::bulkrpc::Request;
use Raritan::RPC::bulkrpc::Response;

sub performRequest($$$) {
    my ($self, $requests, $responses) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'requests'} = [];
    for (my $i0 = 0; $i0 <= $#{$requests}; $i0++) {
        $args->{'requests'}->[$i0] = Raritan::RPC::bulkrpc::Request::encode($requests->[$i0]);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'performRequest', $args);
    $$responses = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'responses'}}; $i0++) {
        $$responses->[$i0] = Raritan::RPC::bulkrpc::Response::decode($agent, $rsp->{'responses'}->[$i0]);
    }
}

use Raritan::RPC::bulkrpc::BulkRequest_1_0_2::Request;
use Raritan::RPC::bulkrpc::BulkRequest_1_0_2::Response;

sub performBulk($$$) {
    my ($self, $requests, $responses) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'requests'} = [];
    for (my $i0 = 0; $i0 <= $#{$requests}; $i0++) {
        $args->{'requests'}->[$i0] = Raritan::RPC::bulkrpc::BulkRequest_1_0_2::Request::encode($requests->[$i0]);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'performBulk', $args);
    $$responses = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'responses'}}; $i0++) {
        $$responses->[$i0] = Raritan::RPC::bulkrpc::BulkRequest_1_0_2::Response::decode($agent, $rsp->{'responses'}->[$i0]);
    }
}

use Raritan::RPC::bulkrpc::BulkRequest_1_0_2::Request;
use Raritan::RPC::bulkrpc::BulkRequest_1_0_2::Response;

sub performBulkTimeout($$$$) {
    my ($self, $requests, $responses, $timeoutMs) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'requests'} = [];
    for (my $i0 = 0; $i0 <= $#{$requests}; $i0++) {
        $args->{'requests'}->[$i0] = Raritan::RPC::bulkrpc::BulkRequest_1_0_2::Request::encode($requests->[$i0]);
    }
    $args->{'timeoutMs'} = 1 * $timeoutMs;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'performBulkTimeout', $args);
    $$responses = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'responses'}}; $i0++) {
        $$responses->[$i0] = Raritan::RPC::bulkrpc::BulkRequest_1_0_2::Response::decode($agent, $rsp->{'responses'}->[$i0]);
    }
}

Raritan::RPC::Registry::registerProxyClass('bulkrpc.BulkRequest', 1, 0, 2, 'Raritan::RPC::bulkrpc::BulkRequest_1_0_2');
1;
