# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2024 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "DisplayControl.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.display

import raritan.rpc.event


# interface
class DisplayControl(Interface):
    idlType = "display.DisplayControl:2.0.0"

    SUCCESS = 0

    ERR_INVALID_VALUE = 1

    # structure
    class Info(Structure):
        idlType = "display.DisplayControl_2_0_0.Info:1.0.0"
        elements = ["fwAppVersion", "fwBootVersion", "orientation", "width", "height", "versionAvailable"]

        def __init__(self, fwAppVersion=0, fwBootVersion=0, orientation=0, width=0, height=0, versionAvailable=False):
            typecheck.is_int(fwAppVersion, AssertionError)
            typecheck.is_int(fwBootVersion, AssertionError)
            typecheck.is_int(orientation, AssertionError)
            typecheck.is_int(width, AssertionError)
            typecheck.is_int(height, AssertionError)
            typecheck.is_bool(versionAvailable, AssertionError)

            self.fwAppVersion = fwAppVersion
            self.fwBootVersion = fwBootVersion
            self.orientation = orientation
            self.width = width
            self.height = height
            self.versionAvailable = versionAvailable

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                fwAppVersion = json['fwAppVersion'] if 'fwAppVersion' in json or not useDefaults else 0,
                fwBootVersion = json['fwBootVersion'] if 'fwBootVersion' in json or not useDefaults else 0,
                orientation = json['orientation'] if 'orientation' in json or not useDefaults else 0,
                width = json['width'] if 'width' in json or not useDefaults else 0,
                height = json['height'] if 'height' in json or not useDefaults else 0,
                versionAvailable = json['versionAvailable'] if 'versionAvailable' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['fwAppVersion'] = self.fwAppVersion
            json['fwBootVersion'] = self.fwBootVersion
            json['orientation'] = self.orientation
            json['width'] = self.width
            json['height'] = self.height
            json['versionAvailable'] = self.versionAvailable
            return json

    # structure
    class DefaultViewItem(Structure):
        idlType = "display.DisplayControl_2_0_0.DefaultViewItem:1.0.0"
        elements = ["id", "description"]

        def __init__(self, id="", description=""):
            typecheck.is_string(id, AssertionError)
            typecheck.is_string(description, AssertionError)

            self.id = id
            self.description = description

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = json['id'] if 'id' in json or not useDefaults else "",
                description = json['description'] if 'description' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = self.id
            json['description'] = self.description
            return json

    # structure
    class Settings(Structure):
        idlType = "display.DisplayControl_2_0_0.Settings:1.0.0"
        elements = ["defaultView", "backlightTimeout"]

        def __init__(self, defaultView="", backlightTimeout=0):
            typecheck.is_string(defaultView, AssertionError)
            typecheck.is_int(backlightTimeout, AssertionError)

            self.defaultView = defaultView
            self.backlightTimeout = backlightTimeout

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                defaultView = json['defaultView'] if 'defaultView' in json or not useDefaults else "",
                backlightTimeout = json['backlightTimeout'] if 'backlightTimeout' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['defaultView'] = self.defaultView
            json['backlightTimeout'] = self.backlightTimeout
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "display.DisplayControl_2_0_0.SettingsChangedEvent:1.0.0"

        def __init__(self, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.display.DisplayControl.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if newSettings is None:
                newSettings = raritan.rpc.display.DisplayControl.Settings()
            typecheck.is_struct(newSettings, raritan.rpc.display.DisplayControl.Settings, AssertionError)

            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.display.DisplayControl.SettingsChangedEvent, self).encode()
            json['newSettings'] = raritan.rpc.display.DisplayControl.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                newSettings = raritan.rpc.display.DisplayControl.Settings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.display.DisplayControl.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["newSettings"]
            elements = elements + super(raritan.rpc.display.DisplayControl.SettingsChangedEvent, self).listElements()
            return elements

    class _getAvailableDefaultViews(Interface.Method):
        name = 'getAvailableDefaultViews'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.display.DisplayControl.DefaultViewItem.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.display.DisplayControl.DefaultViewItem, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.display.DisplayControl.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.display.DisplayControl.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.display.DisplayControl.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.display.DisplayControl.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.display.DisplayControl.Info.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.display.DisplayControl.Info, DecodeException)
            return _ret_

    class _showSmiley(Interface.Method):
        name = 'showSmiley'

        @staticmethod
        def encode(on, happy, msg):
            typecheck.is_bool(on, AssertionError)
            typecheck.is_bool(happy, AssertionError)
            typecheck.is_string(msg, AssertionError)
            args = {}
            args['on'] = on
            args['happy'] = happy
            args['msg'] = msg
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None
    def __init__(self, target, agent):
        super(DisplayControl, self).__init__(target, agent)
        self.getAvailableDefaultViews = DisplayControl._getAvailableDefaultViews(self)
        self.getSettings = DisplayControl._getSettings(self)
        self.setSettings = DisplayControl._setSettings(self)
        self.getInfo = DisplayControl._getInfo(self)
        self.showSmiley = DisplayControl._showSmiley(self)
