// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Sx.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.sx {
  public class Sx : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("sx.Sx:1.0.0", null);

    public Sx(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Sx(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Sx StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Sx(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class ClientInfo : ICloneable {
      public object Clone() {
        ClientInfo copy = new ClientInfo();
        copy.portId = this.portId;
        copy.portName = this.portName;
        copy.userName = this.userName;
        copy.userIp = this.userIp;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["portId"] = this.portId;
        json["portName"] = this.portName;
        json["userName"] = this.userName;
        json["userIp"] = this.userIp;
        return json;
      }

      public static ClientInfo Decode(LightJson.JsonObject json, Agent agent) {
        ClientInfo inst = new ClientInfo();
        inst.portId = (string)json["portId"];
        inst.portName = (string)json["portName"];
        inst.userName = (string)json["userName"];
        inst.userIp = (string)json["userIp"];
        return inst;
      }

      public string portId = "";
      public string portName = "";
      public string userName = "";
      public string userIp = "";
    }

    public class ClientConnectionStatusEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("sx.Sx.ClientConnectionStatusEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.sx.Sx.ClientInfo clientInfo = new Com.Raritan.Idl.sx.Sx.ClientInfo();
      public bool status = false;
      public int clientCnt = 0;
    }

  }
}
