% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{getRcppVersion}
\alias{getRcppVersion}
\title{Export the Rcpp (API) Package Version}
\usage{
getRcppVersion(devel = FALSE)
}
\arguments{
\item{devel}{An logical value indicating if the development or
release version number should be returned, default is release.}
}
\value{
A \code{package_version} object with either the release
or development version.
}
\description{
Helper function to report the package version of the R installation.
}
\details{
While \code{packageVersion(Rcpp)} exports the version registers in
{DESCRIPTION}, this version does get incremented more easily
during development and can therefore be higher than the released
version.  The actual \code{#define} long used at the C++ level
corresponds more to an \sQuote{API Version} which is now provided
by this function, and use for example in the package skeleton
generator.
}
\examples{
getRcppVersion()
}
\seealso{
\code{\link{packageVersion}},
\code{\link{Rcpp.package.skeleton}}
}
\author{
Dirk Eddelbuettel
}
