--
-- PostgreSQL database dump
--

\connect - sysdba

SET search_path = public, pg_catalog;

--
-- TOC entry 2 (OID 169224)
-- Name: atomic_data; Type: TABLE; Schema: public; Owner: sysdba
--

CREATE TABLE atomic_data (
    num integer,
    name character varying(2),
    config character varying(26),
    esup double precision,
    esdown double precision,
    epup double precision,
    epdown double precision,
    edup double precision,
    eddown double precision,
    efup double precision,
    efdown double precision,
    des double precision,
    dep double precision,
    ded double precision,
    def double precision,
    atomic_rad double precision,
    cov_rad double precision,
    slater_atomic_rad double precision,
    a_r_electroneg double precision,
    pauling_electroneg double precision,
    atomic_mass double precision,
    first_ip double precision,
    electron_affinity double precision,
    pearson_electroneg double precision,
    pearson_hardness double precision,
    polarizability double precision,
    mendeleev_number integer,
    miedema_phi double precision,
    miedema_n double precision,
    miedema_v double precision,
    metaltype integer,
    m_b_electroneg double precision,
    pp_core_radii_sum double precision,
    dh298 integer,
    mp integer,
    bp integer,
    density double precision,
    r_metallic double precision
);


--
-- TOC entry 3 (OID 169318)
-- Name: lsd_data; Type: TABLE; Schema: public; Owner: sysdba
--

CREATE TABLE lsd_data (
    num integer,
    name character varying(2),
    config character varying(26),
    esup double precision,
    esdown double precision,
    epup double precision,
    epdown double precision,
    edup double precision,
    eddown double precision,
    efup double precision,
    efdown double precision,
    des double precision,
    dep double precision,
    ded double precision,
    def double precision
);


--
-- TOC entry 4 (OID 169458)
-- Name: source_notes; Type: TABLE; Schema: public; Owner: sysdba
--

CREATE TABLE source_notes (
    property character varying(18),
    notes character varying(99),
    units character varying(13),
    source character varying(73)
);


--
-- Data for TOC entry 5 (OID 169224)
-- Name: atomic_data; Type: TABLE DATA; Schema: public; Owner: sysdba
--

COPY atomic_data (num, name, config, esup, esdown, epup, epdown, edup, eddown, efup, efdown, des, dep, ded, def, atomic_rad, cov_rad, slater_atomic_rad, a_r_electroneg, pauling_electroneg, atomic_mass, first_ip, electron_affinity, pearson_electroneg, pearson_hardness, polarizability, mendeleev_number, miedema_phi, miedema_n, miedema_v, metaltype, m_b_electroneg, pp_core_radii_sum, dh298, mp, bp, density, r_metallic) FROM stdin;
1	H	1s^1	-2.72590208054	-7.31918621063	0	0	0	0	0	0	4.5932841301	0	0	0	2.07999992371	0.319999992847	0.52999997139	2.20000004768	2.20000004768	1.00794005394	13.5984401703	0.754194974899	7.1763176918	6.42212247849	0.666792988777	1	5.19999980927	1.5	1.41999995708	0	2.09999990463	1.25	1318	-259	-253	0.070000000298	0.370000004768
2	He	1s^2	-15.5220632553	-15.5220632553	0	0	0	0	0	0	0	0	0	0	0	0.930000007153	0	0	0	4.00260210037	24.5874099731	0	0	0	0.204955995083	103	0	0	0	0	0	0	2379	-270	-269	0.15000000596	0
3	Li	[He] 2s^1	-2.09133195877	-3.16482210159	0	0	0	0	0	0	1.07349002361	0	0	0	1.54999995232	1.23000001907	1.45000004768	0.97000002861	0.980000019073	6.94099998474	5.39171981812	0.617999970913	3.00485992432	2.3868598938	24.2999992371	12	2.84999990463	0.980000019073	5.53000020981	1	0.899999976158	1.61000001431	526	180	1330	0.52999997139	1.51999998093
4	Be	[He] 2s^2	-5.59858179092	-5.59858179092	0	0	0	0	0	0	0	0	0	0	1.12000000477	0.899999976158	1.04999995232	1.47000002861	1.57000005245	9.01218223572	9.32269954681	0	0	0	5.59999990463	77	5.05000019073	1.66999995708	2.88000011444	1	1.45000004768	1.08000004292	906	1280	2480	1.85000002384	1.12000000477
5	B	[He] 2s^2 2p^1	-8.67020511627	-9.8081035614	-3.07989501953	-4.10492086411	0	0	0	0	1.13789904118	1.02502596378	0	0	0.980000019073	0.819999992847	0.850000023842	2.00999999046	2.03999996185	10.8109998703	8.2980298996	0.277000010014	4.28751516342	4.01051521301	3.02999997139	85	5.30000019073	1.75	2.79999995232	0	1.89999997616	0.795000016689	807	2030	3900	2.33999991417	0.790000021458
6	C	[He] 2s^2 2p^2	-11.8387546539	-14.4567642212	-3.79013991356	-6.19214487076	0	0	0	0	2.61800909042	2.4020049572	0	0	0.910000026226	0.769999980927	0.699999988079	2.5	2.54999995232	12.0109996796	11.2602996826	1.26289999485	6.26160001755	4.99870014191	1.75999999046	95	6.23999977112	1.76999998093	2.20000004768	0	2.36999988556	0.639999985695	1093	3730	4830	2.25999999046	0.709999978542
7	N	[He] 2s^2 2p^3	-15.2752275467	-19.6128883362	-4.37300777435	-8.40418624878	0	0	0	0	4.33765983582	4.03117799759	0	0	0.920000016689	0.75	0.649999976158	3.06999993324	3.03999996185	14.0067396164	14.5341396332	0	0	0	1.10000002384	100	6.86000013351	7.65000009537	2.55999994278	0	2.84999990463	0.540000021458	1407	-210	-196	0.810000002384	0.730000019073
8	O	[He] 2s^2 2p^4	-21.8136920929	-24.9135055542	-7.41099786758	-10.3711633682	0	0	0	0	3.09981393814	2.9601650238	0	0	0.649999976158	0.730000019073	0.600000023842	3.5	3.44000005722	15.9994001389	13.618060112	1.46111035347	7.53958511353	6.07847499847	0.801999986172	101	0	0	0	0	3.31999993324	0.465000003576	1320	-219	-183	1.14999997616	0.740000009537
9	F	[He] 2s^2 2p^5	-28.684135437	-30.3153495789	-10.4478435516	-12.0315752029	0	0	0	0	1.63121497631	1.58373105526	0	0	0.569999992847	0.72000002861	0.5	4.09999990463	3.98000001907	18.9983997345	17.4228191376	3.4011900425	10.4120054245	7.01081514359	0.556999981403	102	0	0	0	0	3.77999997139	0.405000001192	1687	-220	-188	1.50999999046	0.709999978542
10	Ne	[He] 2s^2 2p^6	-35.9954833984	-35.9954833984	-13.5522022247	-13.5522022247	0	0	0	0	0	0	0	0	0.509999990463	0.709999978542	0	0	0	20.1797008514	21.5645999908	0	0	0	0.395599991083	2	0	0	0	0	0	0	2087	-249	-246	1.20000004768	0
11	Na	[Ne] 3s^1	-2.21879005432	-3.0804669857	0	0	0	0	0	0	0.861675977707	0	0	0	1.89999997616	1.53999996185	1.79999995232	1.00999999046	0.930000007153	22.9897708893	5.13908004761	0.547926008701	2.84350299835	2.29557704926	24.0799999237	11	2.70000004768	0.819999992847	8.27000045776	1	0.889999985695	2.65000009537	502	98	892	0.97000002861	1.86000001431
12	Mg	[Ne] 3s^2	-4.77361392975	-4.77361392975	0	0	0	0	0	0	0	0	0	0	1.60000002384	1.36000001431	1.5	1.23000001907	1.30999994278	24.3050003052	7.64624023438	0	0	0	10.6000003815	73	3.45000004768	1.16999995708	5.80999994278	1	1.30999994278	2.02999997139	744	650	1110	1.74000000954	1.60000002384
13	Al	[Ne] 3s^2 3p^1	-7.39970493317	-8.06213855743	-2.41754198074	-3.02718710899	0	0	0	0	0.662433981895	0.609643995762	0	0	1.42999994755	1.17999994755	2.15000009537	1.47000002861	1.61000001431	26.9815406799	5.98577022552	0.441000014544	3.21338510513	2.77238488197	6.80000019073	80	4.19999980927	1.38999998569	4.63999986649	2	1.63999998569	1.67499995232	584	660	2450	2.70000004768	1.42999994755
14	Si	[Ne] 3s^2 3p^2	-9.83958816528	-11.3410043716	-3.29029393196	-4.63184309006	0	0	0	0	1.50141596794	1.34154903889	0	0	1.32000005245	1.11000001431	1.15999996662	1.74000000954	1.89999997616	28.0855007172	8.15168952942	1.38499999046	4.76834487915	3.38334488869	5.38000011444	85	4.69999980927	1.5	4.19999980927	0	1.98000001907	1.41999995708	793	1410	2680	2.32999992371	1.17999994755
15	P	[Ne] 3s^2 3p^3	-12.2498102188	-14.7022380829	-4.12233686447	-6.2961192131	0	0	0	0	2.4524269104	2.17378306389	0	0	1.27999997139	1.05999994278	1	2.05999994278	2.19000005722	30.9737606049	10.4866895676	0.746500015259	5.61659479141	4.87009477615	3.63000011444	90	5.55000019073	1.64999997616	4.15000009537	0	2.31999993324	1.24000000954	1018	44	280	1.82000005245	1.10000002384
16	S	[Ne] 3s^2 3p^4	-16.1379108429	-17.8551940918	-6.21195411682	-7.73644590378	0	0	0	0	1.71728396416	1.52449095249	0	0	1.26999998093	1.01999998093	1	2.44000005722	2.57999992371	32.0660018921	10.3600101471	2.07710409164	6.21855688095	4.14145278931	2.90000009537	94	0	0	0	0	2.65000009537	1.10000002384	1006	113	445	2.06999993324	1.01999998093
17	Cl	[Ne] 3s^2 3p^5	-20.0472106934	-20.9383296967	-8.28943634033	-9.08311080933	0	0	0	0	0.891119003296	0.793675005436	0	0	0.97000002861	0.990000009537	1	2.82999992371	3.16000008583	35.4527015686	12.9676399231	3.61268997192	8.29016494751	4.67747497559	2.18000006676	99	0	0	0	0	2.98000001907	1.00999999046	1257	-101	-35	1.55999994278	0.990000009537
18	Ar	[Ne] 3s^2 3p^6	-24.0381145477	-24.0381145477	-10.4037351608	-10.4037351608	0	0	0	0	0	0	0	0	0.879999995232	0.980000019073	0	3.20000004768	0	39.0983009338	15.7596197128	0	0	0	1.64110004902	3	0	0	0	0	0	0	1527	-189	-186	1.39999997616	0
19	K	[Ar] 4s^1	-2.02398395538	-2.61776399612	0	0	0	0	0	0	0.593779981136	0	0	0	2.34999990463	2.02999997139	2.20000004768	0.910000026226	0.819999992847	39.9480018616	4.34066009521	0.501470029354	2.42106509209	1.91959500313	43.4000015259	10	2.25	0.649999976158	12.7700004578	1	0.800000011921	3.69000005722	425	64	760	0.860000014305	2.26999998093
20	Ca	[Ar] 4s^2	-3.84799098969	-3.84799098969	0	0	0	0	0	0	0	0	0	0	1.97000002861	1.74000000954	1.79999995232	1.03999996185	1	40.077999115	6.11316013336	0.0245500002056	3.06885504723	3.04430508614	22.7999992371	16	2.54999995232	0.910000026226	8.81999969482	1	1.16999995708	3	596	838	1490	1.54999995232	1.97000002861
21	Sc	[Ar] 3d^1 4s^2	-4.1057100296	-4.38000106812	0	0	-3.19108104706	-3.84053492546	0	0	0.274291008711	0	0.649453997612	0	1.62000000477	1.44000005722	1.60000002384	1.20000004768	1.36000001431	44.955909729	6.56150007248	0.187999993563	3.37474989891	3.18674993515	17.7999992371	19	3.25	1.26999998093	6.09000015259	3	1.5	2.75	637	1540	2730	3	1.61000001431
22	Ti	[Ar] 3d^2 4s^2	-4.26193094254	-4.75584506989	0	0	-3.74589395523	-5.17106389999	0	0	0.493914008141	0	1.42516994476	0	1.45000004768	1.32000005245	1.39999997616	1.32000005245	1.53999996185	47.8800010681	6.82810020447	0.0790000036359	3.45355010033	3.37455010414	14.6000003815	51	3.79999995232	1.51999998093	4.82000017166	3	1.86000001431	2.57999992371	664	1670	3260	4.5	1.45000004768
23	V	[Ar] 3d^3 4s^2	-4.3844370842	-5.06894016266	0	0	-4.09229516983	-6.38003921509	0	0	0.684503018856	0	2.28774404526	0	1.34000003338	1.22000002861	1.35000002384	1.45000004768	1.62999999523	50.9415016174	6.74630022049	0.524999976158	3.63564991951	3.11065006256	12.3999996185	54	4.25	1.63999998569	4.11999988556	3	2.22000002861	2.43000006676	656	1900	3450	5.80000019073	1.30999994278
24	Cr	[Ar] 3d^5 4s^1	-2.56189894676	-4.53230381012	0	0	-0.307924002409	-3.98274207115	0	0	1.97040498257	0	3.67481803894	0	1.29999995232	1.17999994755	1.39999997616	1.55999994278	1.65999996662	51.9961013794	6.76649999619	0.666000008583	3.71624994278	3.05025005341	11.6000003815	57	4.65000009537	1.73000001907	3.74000000954	3	2	2.44000005722	659	1900	2642	7.78999996185	1.25
25	Mn	[Ar] 3d^5 4s^2	-4.5876789093	-5.60451412201	0	0	-4.3716468811	-8.58021736145	0	0	1.01683604717	0	4.20857000351	0	1.35000002384	1.16999995708	1.39999997616	1.60000002384	1.54999995232	54.9380493164	7.43402004242	0	0	0	9.39999961853	60	4.44999980927	1.66999995708	3.77999997139	3	2.03999996185	2.22000002861	724	1250	2110	7.42999982834	1.37000000477
26	Fe	[Ar] 3d^6 4s^2	-4.96915483475	-5.71406698227	0	0	-5.82084512711	-9.35538768768	0	0	0.744912028313	0	3.53454303741	0	1.25999999046	1.16999995708	1.39999997616	1.63999998569	1.83000004292	55.8470001221	7.90240001678	0.150999993086	4.02670001984	3.87569999695	8.39999961853	61	4.92999982834	1.76999998093	3.69000005722	3	1.66999995708	2.1099998951	766	1540	3000	7.86000013351	1.24000000954
27	Co	[Ar] 3d^7 4s^2	-5.28586912155	-5.80631399155	0	0	-7.16838121414	-9.92454242706	0	0	0.520444989204	0	2.7561609745	0	1.25	1.15999996662	1.35000002384	1.70000004768	1.87999999523	58.6934013367	7.88100004196	0.662000000477	4.27150011063	3.60949993134	7.5	64	5.09999990463	1.75	3.54999995232	3	1.72000002861	2.01999998093	764	1490	2900	8.89999961853	1.25
28	Ni	[Ar] 3d^8 4s^2	-5.56535720825	-5.89268302917	0	0	-8.44614601135	-10.3455018997	0	0	0.327325999737	0	1.89935600758	0	1.24000000954	1.14999997616	1.35000002384	1.75	1.90999996662	58.9332008362	7.63980007172	1.15600001812	4.39790010452	3.24189996719	6.80000019073	67	5.19999980927	1.70000004768	3.51999998093	3	1.75999999046	2.18000006676	743	1450	2730	8.89999961853	1.25
29	Cu	[Ar] 3d^10 4s^1	-4.18797111511	-5.00725078583	0	0	-5.36361217499	-5.50960111618	0	0	0.819280982018	0	0.145989000797	0	1.27999997139	1.16999995708	1.35000002384	1.75	1.89999997616	63.5460014343	7.72637987137	1.23500001431	4.48069000244	3.24569010735	6.09999990463	72	4.44999980927	1.47000002861	3.70000004768	3	1.08000004292	2.03999996185	752	1083	2600	8.96000003815	1.27999997139
30	Zn	[Ar] 3d^10 4s^2	-6.06065893173	-6.06065893173	0	0	-10.8558254242	-10.8558254242	0	0	0	0	0	0	1.37999999523	1.25	1.35000002384	1.65999996662	1.64999997616	65.3899993896	9.39420032501	0	0	0	7.09999990463	76	4.09999990463	1.32000005245	4.38000011444	3	1.39999997616	1.87999999523	913	419	906	7.13999986649	1.33000004292
31	Ga	[Ar] 3d^10 4s^2 4p^1	-8.56250190735	-9.1530714035	-2.4025220871	-2.99869608879	-19.9347457886	-20.0011959076	0	0	0.590569019318	0.596175014973	0.0664499998093	0	1.40999996662	1.25999999046	1.29999995232	1.82000005245	1.80999994278	69.7229995728	5.99930000305	0.300000011921	3.14965009689	2.84964990616	8.11999988556	81	4.09999990463	1.30999994278	5.19000005722	2	1.70000004768	1.69500005245	585	30	2400	5.90999984741	1.22000002861
32	Ge	[Ar] 3d^10 4s^2 4p^2	-10.7624616623	-12.0428676605	-3.27875590324	-4.50936412811	-30.1303119659	-30.2976341248	0	0	1.28040504456	1.23060798645	0.167322993279	0	1.37000000477	1.22000002861	1.25	2.01999998093	2.00999999046	72.6100006104	7.89940023422	1.23300004005	4.56619977951	3.33319997787	6.07000017166	84	4.55000019073	1.37000000477	4.59999990463	2	1.99000000954	1.55999994278	768	937	2830	5.32000017166	1.23000001907
33	As	[Ar] 3d^10 4s^2 4p^3	-12.8657951355	-14.8904323578	-4.09041786194	-5.99551486969	-41.4961891174	-41.7899093628	0	0	2.02463698387	1.90509700775	0.293720006943	0	1.38999998569	1.20000004768	1.14999997616	2.20000004768	2.18000006676	74.9215927124	9.78859996796	0.810000002384	5.29930019379	4.48929977417	4.30999994278	89	4.80000019073	1.44000005722	5.19999980927	0	2.26999998093	1.41499996185	953	817	613	5.71999979019	1.25
34	Se	[Ar] 3d^10 4s^2 4p^4	-16.0815029144	-17.4628334045	-5.92803096771	-7.21396017075	-54.5032081604	-54.7263145447	0	0	1.38133203983	1.28592896461	0.223105996847	0	1.39999997616	1.15999996662	1.14999997616	2.48000001907	2.54999995232	78.9599990845	9.75238037109	2.02066993713	5.88652515411	3.86585497856	3.76999998093	93	0	0	0	0	2.53999996185	1.28499996662	947	217	685	4.80000019073	1.15999996662
35	Br	[Ar] 3d^10 4s^2 4p^5	-19.2149219513	-19.9169483185	-7.68743801117	-8.33602237701	-68.5435562134	-68.6673126221	0	0	0.702027022839	0.648584008217	0.123756997287	0	1.12000000477	1.13999998569	1.14999997616	2.74000000954	2.96000003815	79.9039993286	11.8138103485	3.36359000206	7.58869981766	4.22511005402	3.04999995232	98	0	0	0	0	2.82999992371	1.20000004768	1146	-7	58	3.11999988556	1.13999998569
36	Kr	[Ar] 3d^10 4s^2 4p^6	-22.3289661407	-22.3289661407	-9.42439556122	-9.42439556122	-83.6508102417	-83.6508102417	0	0	0	0	0	0	1.02999997139	1.88999998569	0	2.94000005722	0	83.8000030518	13.9996099472	0	0	0	2.48440003395	4	0	0	0	0	0	0	1357	-157	-152	2.16000008583	0
37	Rb	[Kr] 5s^1	-1.98371100426	-2.5068230629	0	0	0	0	0	0	0.523111999035	0	0	0	2.48000001907	2.16000008583	2.34999990463	0.889999985695	0.819999992847	85.4677963257	4.17713022232	0.485920011997	2.33152508736	1.84560501575	47.2999992371	9	2.09999990463	0.600000023842	14.6499996185	1	0.800000011921	4.09999990463	409	39	688	1.52999997139	2.48000001907
38	Sr	[Kr] 5s^2	-3.58627200127	-3.58627200127	0	0	0	0	0	0	0	0	0	0	2.15000009537	1.90999996662	2	0.990000009537	0.949999988079	87.6200027466	5.69490003586	0.0480000004172	2.87144994736	2.8234500885	27.6000003815	15	2.40000009537	0.839999973774	10.4799995422	1	1.12999999523	3.21000003815	556	770	1380	2.59999990463	2.15000009537
39	Y	[Kr] 4d^1 5s^2	-3.92363905907	-4.24293804169	0	0	-2.67733001709	-3.17170596123	0	0	0.319299012423	0	0.494376987219	0	1.77999997139	1.62000000477	1.79999995232	1.11000001431	1.22000002861	88.9058532715	6.21710014343	0.307000011206	3.26204991341	2.95504999161	22.7000007629	25	3.20000004768	1.21000003815	7.34000015259	3	1.40999996662	2.94000005722	622	1500	2930	4.5	1.77999997139
40	Zr	[Kr] 4d^2 5s^2	-4.08859395981	-4.66182994843	0	0	-3.4683380127	-4.53088903427	0	0	0.573234975338	0	1.06255102158	0	1.60000002384	1.45000004768	1.35000002384	1.22000002861	1.33000004292	91.2239990234	6.63390016556	0.425999999046	3.52994990349	3.10395002365	17.8999996185	49	3.45000004768	1.40999996662	5.80999994278	3	1.70000004768	2.82500004768	666	1850	3580	6.48999977112	1.59000003338
41	Nb	[Kr] 4d^4 5s^1	-2.66176509857	-4.37703514099	0	0	-1.69880795479	-4.02105617523	0	0	1.71527099609	0	2.32224798203	0	1.46000003815	1.34000003338	1.42999994755	1.23000001907	1.60000002384	92.9063796997	6.75885009766	0.893000006676	3.82592511177	2.93292498589	15.6999998093	53	4.05000019073	1.63999998569	4.88999986649	3	2.02999997139	2.75999999046	670	2420	4900	8.55000019073	1.42999994755
42	Mo	[Kr] 4d^5 5s^1	-2.60554599762	-4.50549983978	0	0	-1.99671804905	-4.9208278656	0	0	1.89995396137	0	2.92410993576	0	1.38999998569	1.29999995232	1.45000004768	1.29999995232	2.16000008583	95.9400024414	7.09243011475	0.748000025749	3.92021489143	3.17221498489	12.8000001907	56	4.65000009537	1.76999998093	4.44999980927	3	1.94000005722	2.72000002861	691	2610	5560	10.1999998093	1.36000001431
43	Tc	[Kr] 4d^5 5s^2	-4.33649015427	-5.45591306686	0	0	-5.44298696518	-8.43869113922	0	0	1.11942303181	0	2.99570298195	0	1.36000001431	1.26999998093	1.35000002384	1.36000001431	1.89999997616	98	7.28000020981	0.550000011921	3.91499996185	3.36500000954	11.3999996185	59	5.30000019073	1.80999994278	4.21000003815	3	2.18000006676	2.65000009537	708	2140	4600	11.5	1.35000002384
44	Ru	[Kr] 4d^7 5s^1	-3.3640089035	-4.5916519165	0	0	-4.5087928772	-6.40809392929	0	0	1.22764205933	0	1.89930105209	0	1.34000003338	1.25	1.29999995232	1.41999995708	2.20000004768	101.069999695	7.36049985886	1.04999995232	4.20524978638	3.15525007248	9.60000038147	62	5.40000009537	1.83000004292	4.05999994278	3	1.97000002861	2.60500001907	717	2300	3900	12.1999998093	1.33000004292
45	Rh	[Kr] 4d^8 5s^1	-3.57614898682	-4.58533906937	0	0	-5.68563222885	-7.03055477142	0	0	1.00918900967	0	1.34492301941	0	1.34000003338	1.25	1.35000002384	1.42999994755	2.27999997139	102.905502319	7.45889997482	1.13699996471	4.29794979095	3.16094994545	8.60000038147	65	5.40000009537	1.75999999046	4.09999990463	3	1.99000000954	2.51999998093	726	1970	3730	12.3999996185	1.34000003338
46	Pd	[Kr] 4d^10	0	0	0	0	-4.37480401993	-4.37480401993	0	0	0	0	0	0	1.37000000477	1.27999997139	1.39999997616	1.35000002384	2.20000004768	106.419998169	8.33689975739	0.561999976635	4.44945001602	3.88744997978	4.80000019073	69	5.44999980927	1.66999995708	4.28999996185	3	2.07999992371	2.45000004768	811	1550	3125	12	1.37999999523
47	Ag	[Kr] 4d^10 5s^1	-3.88622307777	-4.55423593521	0	0	-8.00028800964	-8.16238594055	0	0	0.668012976646	0	0.162098005414	0	1.44000005722	1.34000003338	1.60000002384	1.41999995708	1.92999994755	107.868202209	7.5763001442	1.30200004578	4.43914985657	3.13715004921	7.19999980927	71	4.34999990463	1.36000001431	4.71999979019	3	1.07000005245	2.375	737	961	2210	10.5	1.44000005722
48	Cd	[Kr] 4d^10 5s^2	-5.55733013153	-5.55733013153	0	0	-12.8037796021	-12.8037796021	0	0	0	0	0	0	1.71000003815	1.40999996662	1.54999995232	1.46000003815	1.69000005722	112.411003113	8.99380016327	0	0	0	7.19999980927	75	4.05000019073	1.24000000954	5.53000020981	3	1.39999997616	2.21499991417	874	321	765	8.64999961853	1.49000000954
49	In	[Kr] 4d^10 5s^2 5p^1	-7.60653877258	-8.10170459747	-2.45993804932	-2.97785210609	-19.7949333191	-19.8675327301	0	0	0.495166003704	0.517915010452	0.0725999996066	0	1.65999996662	1.44000005722	1.54999995232	1.49000000954	1.77999997139	114.819999695	5.78635978699	0.300000011921	3.04317998886	2.74318003654	10.1999998093	79	3.90000009537	1.16999995708	6.28000020981	2	1.62999999523	2.04999995232	565	156	2000	7.30999994278	1.36000001431
50	Sn	[Kr] 4d^10 5s^2 5p^2	-9.38151073456	-10.4190816879	-3.26955890656	-4.30750989914	-27.1271266937	-27.2984752655	0	0	1.03757095337	1.03795194626	0.171350002289	0	1.62000000477	1.40999996662	1.45000004768	1.72000002861	1.96000003815	118.709999084	7.3439002037	1.11199998856	4.22795009613	3.11595010757	7.69999980927	83	4.15000009537	1.24000000954	6.42999982834	2	1.87999999523	1.87999999523	715	232	2270	7.30000019073	1.50999999046
51	Sb	[Kr] 4d^10 5s^2 5p^3	-11.0514202118	-12.6570825577	-4.01308298111	-5.58538484573	-34.9233016968	-35.2113609314	0	0	1.60566294193	1.57230198383	0.28806000948	0	1.59000003338	1.39999997616	1.45000004768	1.82000005245	2.04999995232	121.757003784	8.60840034485	1.04600000381	4.82719993591	3.7811999321	6.59999990463	88	4.40000009537	1.25999999046	6.59999990463	2	2.1400001049	1.76499998569	840	631	1380	6.67999982834	1.45000004768
52	Te	[Kr] 4d^10 5s^2 5p^4	-13.5409374237	-14.6196241379	-5.55460882187	-6.59849214554	-43.579246521	-43.7895622253	0	0	1.07868695259	1.04388403893	0.210317000747	0	1.41999995708	1.36000001431	1.39999997616	2.00999999046	2.09999990463	126.904502869	9.00959968567	1.97080004215	5.49020004272	3.51939988136	5.5	92	0	0	0	0	2.38000011444	1.66999995708	876	450	1390	6.23999977112	1.42999994755
53	I	[Kr] 4d^10 5s^2 5p^5	-15.9358386993	-16.4778900146	-7.0117521286	-7.53108119965	-52.6669044495	-52.7800750732	0	0	0.542051017284	0.519330024719	0.113172002137	0	1.32000005245	1.33000004292	1.13999998569	2.21000003815	2.66000008583	127.599998474	10.451259613	3.05903792381	6.75514888763	3.69611096382	5.34999990463	97	0	0	0	0	2.75999999046	1.58500003815	1015	114	183	4.94000005722	1.33000004292
54	Xe	[Kr] 4d^10 5s^2 5p^6	-18.28840065	-18.28840065	-8.43104362488	-8.43104362488	-62.2233848572	-62.2233848572	0	0	0	0	0	0	1.24000000954	1.30999994278	0	2.40000009537	0	131.289993286	12.1297998428	0	0	0	4.04400014877	5	0	0	0	0	0	0	1177	-112	-108	3.5	0
55	Cs	[Xe] 6s^1	-1.85930097103	-2.30085992813	0	0	0	0	0	0	0.441558986902	0	0	0	2.67000007629	2.34999990463	2.59999990463	0.860000014305	0.790000021458	132.905395508	3.8938999176	0.471626013517	2.18276309967	1.71113705635	59.5999984741	8	1.95000004768	0.550000011921	16.8600006104	1	0.769999980927	4.30999994278	382	29	690	1.87000000477	2.65000009537
56	Ba	[Xe] 6s^2	-3.23725891113	-3.23725891113	0	0	0	0	0	0	0	0	0	0	2.22000002861	1.98000001907	2.15000009537	0.97000002861	0.889999985695	137.32699585	5.21169996262	0.15000000596	2.68085002899	2.53084993362	39.7000007629	14	2.31999993324	0.810000002384	11.3199996948	1	1.08000004292	3.40199995041	509	714	1640	3.5	2.17000007629
57	La	[Xe] 5d^1 6s^2	-3.46216106415	-3.71408390999	0	0	-3.59655809402	-4.04013109207	0	0	0.251922994852	0	0.443572998047	0	1.37999999523	1.25	1.95000004768	1.08000004292	1.10000002384	138.905502319	5.57700014114	0.5	3.03850007057	2.53850007057	31.1000003815	33	3.17000007629	1.17999994755	7.98000001907	4	1.35000002384	3.07999992371	544	920	3470	6.17000007629	1.87000000477
58	Ce	[Xe] 4f^1 5d^1 6s^2	-3.48648810387	-3.77544593811	0	0	-3.50232505798	-4.07721996307	-8.71951198578	-9.52858924866	0.288958013058	0	0.5748950243	0.80907702446	1.80999994278	1.64999997616	1.85000002384	1.08000004292	1.12000000477	140.115005493	5.53870010376	0	0	0	29.6000003815	32	3.18000006676	1.19000005722	7.76000022888	4	1.10000002384	4.5	534	795	3470	6.78000020981	1.83000004292
59	Pr	[Xe] 4f^3 6s^2	-3.32542395592	-3.43592905998	0	0	0	0	-3.07741904259	-4.93767213821	0.110504999757	0	0	1.86025297642	1.82000005245	1.64999997616	1.85000002384	1.07000005245	1.12999999523	140.907699585	5.46400022507	0	0	0	28.2000007629	31	3.19000005722	1.20000004768	7.55999994278	4	1.10000002384	4.48000001907	529	935	3130	6.76999998093	1.32000005245
60	Nd	[Xe] 4f^4 6s^2	-3.3477640152	-3.48243308067	0	0	0	0	-3.26256489754	-5.8286819458	0.134669005871	0	0	2.56611704826	1.82000005245	1.63999998569	1.85000002384	1.07000005245	1.13999998569	144.240005493	5.52500009537	0	0	0	31.3999996185	30	3.19000005722	1.20000004768	7.51000022888	4	1.20000004768	3.99000000954	536	1020	3030	7	1.80999994278
61	Pm	[Xe] 4f^5 6s^2	-3.36942410469	-3.52591705322	0	0	0	0	-3.31339597702	-6.61204385757	0.156492993236	0	0	3.29864811897	0	1.62999999523	1.83000004292	1.07000005245	1.12999999523	145	5.57999992371	0	0	0	30.1000003815	29	3.19000005722	1.21000003815	7.42999982834	4	1.14999997616	3.99000000954	542	1030	2730	0	0
62	Sm	[Xe] 4f^6 6s^2	-3.39062190056	-3.56727790833	0	0	0	0	-3.25206208229	-7.30571699142	0.176655992866	0	0	4.05365514755	1.80999994278	1.62000000477	1.85000002384	1.07000005245	1.16999995708	150.36000061	5.64359998703	0	0	0	28.7999992371	28	3.20000004768	1.21000003815	7.36999988556	4	1.20000004768	4.13999986649	549	1070	1900	7.53999996185	1.78999996185
63	Eu	[Xe] 4f^7 6s^2	-3.41143894196	-3.60700702667	0	0	0	0	-3.09404492378	-7.92224502563	0.19556799531	0	0	4.82819986343	1.99000000954	1.85000002384	1.85000002384	1.00999999046	1.20000004768	151.964996338	5.67040014267	0	0	0	27.7000007629	18	3.20000004768	1.21000003815	7.36000013351	4	1.14999997616	3.94000005722	553	826	1440	5.26000022888	1.99000000954
64	Gd	[Xe] 4f^7 5d^1 6s^2	-3.63538908958	-4.09602308273	0	0	-2.77934503555	-3.90807390213	-9.71781730652	-15.1763153076	0.460635006428	0	1.12872898579	5.4584980011	1.79999995232	1.61000001431	1.79999995232	1.11000001431	1.20000004768	157.25	6.15010023117	0	0	0	23.5	27	3.20000004768	1.21000003815	7.34000015259	4	1.10000002384	3.91000008583	598	1310	3000	7.88999986649	1.78999996185
65	Tb	[Xe] 4f^9 6s^2	-3.51995801926	-3.64001488686	0	0	0	0	-4.81720685959	-8.42584705353	0.12005700171	0	0	3.60863995552	1.79999995232	1.59000003338	1.75	1.10000002384	1.20000004768	158.925292969	5.86380004883	0	0	0	25.5	26	3.21000003815	1.22000002861	7.19999980927	4	1.20000004768	3.8900001049	570	1360	2800	8.27000045776	1.75999999046
66	Dy	[Xe] 4f^10 6s^2	-3.56613588333	-3.65664100647	0	0	0	0	-5.53866291046	-8.47798442841	0.0905049964786	0	0	2.93932104111	1.79999995232	1.59000003338	1.75	1.10000002384	1.22000002861	162.5	5.9388999939	0	0	0	24.5	24	3.21000003815	1.22000002861	7.11999988556	4	1.14999997616	3.67000007629	578	1410	2600	8.53999996185	1.75
67	Ho	[Xe] 4f^11 6s^2	-3.60931992531	-3.67370200157	0	0	0	0	-6.18828105927	-8.42840480804	0.0643820017576	0	0	2.2401239872	1.78999996185	1.58000004292	1.75	1.10000002384	1.23000001907	164.930297852	6.02150011063	0	0	0	23.6000003815	23	3.22000002861	1.22000002861	7.05999994278	4	1.20000004768	3.65000009537	586	1460	2600	8.80000019073	1.74000000954
68	Er	[Xe] 4f^12 6s^2	-3.65030002594	-3.69122600555	0	0	0	0	-6.77591085434	-8.29123210907	0.0409259982407	0	0	1.51532101631	1.77999997139	1.57000005245	1.75	1.11000001431	1.24000000954	167.259994507	6.10769987106	0	0	0	22.7000007629	22	3.22000002861	1.23000001907	6.98000001907	4	1.20000004768	3.63000011444	595	1500	2900	9.05000019073	1.73000001907
69	Tm	[Xe] 4f^13 6s^2	-3.68964791298	-3.70921301842	0	0	0	0	-7.30903577805	-8.07688808441	0.0195649992675	0	0	0.767850995064	1.76999998093	1.55999994278	1.75	1.11000001431	1.25	168.934204102	6.18430995941	0	0	0	21.7999992371	21	3.22000002861	1.23000001907	6.90000009537	4	1.20000004768	3.59999990463	601	1550	1730	9.32999992371	0
70	Yb	[Xe] 4f^14 6s^2	-3.72766208649	-3.72766208649	0	0	0	0	-7.7935628891	-7.7935628891	0	0	0	0	1.94000005722	1.70000004768	1.75999999046	1.05999994278	1.10000002384	173.039993286	6.25415992737	0	0	0	21	17	3.22000002861	1.23000001907	6.86000013351	4	1.10000002384	3.58999991417	610	824	1430	6.98000001907	1.94000005722
71	Lu	[Xe] 4f^14 5d^1 6s^2	-4.03341007233	-4.36987876892	0	0	-2.55044293404	-3.02909088135	-15.3839378357	-15.4542789459	0.336468994617	0	0.478648990393	0.0703409984708	1.75	1.55999994278	1.75	1.13999998569	1.26999998093	174.966995239	5.42589998245	0	0	0	21.8999996185	20	3.22000002861	1.24000000954	6.80999994278	4	1.20000004768	3.36999988556	530	1650	3330	9.84000015259	1.72000002861
72	Hf	[Xe] 4f^14 5d^2 6s^2	-4.17926311493	-4.78686618805	0	0	-3.31554603577	-4.32511615753	-23.5275211334	-23.6885585785	0.607603013515	0	1.00957000256	0.161036998034	1.66999995708	1.44000005722	1.54999995232	1.23000001907	1.29999995232	178.490005493	6.82506990433	0	3.41253495216	3.41253495216	16.2000007629	50	3.59999990463	1.45000004768	5.65000009537	3	1.73000001907	2.91000008583	680	2000	5400	13.1000003815	1.55999994278
73	Ta	[Xe] 4f^14 5d^3 6s^2	-4.26908779144	-5.10151195526	0	0	-4.01330089569	-5.57896280289	-32.3138923645	-32.5788192749	0.832423985004	0	1.56566202641	0.264930009842	1.49000000954	1.34000003338	1.45000004768	1.33000004292	1.5	180.947906494	7.54960012436	0.321999996901	3.93580007553	3.61380004883	13.1000003815	52	4.05000019073	1.62999999523	4.88999986649	3	1.94000005722	2.78999996185	767	3000	5430	16.6000003815	1.42999994755
74	W	[Xe] 4f^14 5d^4 6s^2	-4.33205509186	-5.35569286346	0	0	-4.67736816406	-6.81583023071	-41.7318115234	-42.1114082336	1.02363801003	0	2.13846206665	0.379599004984	1.40999996662	1.29999995232	1.35000002384	1.39999997616	2.3599998951	183.850006104	7.8639998436	0.814999997616	4.33949995041	3.52449989319	11.1000003815	55	4.80000019073	1.80999994278	4.5	3	1.78999996185	2.7349998951	776	3410	5930	19.2999992371	1.37000000477
75	Re	[Xe] 4f^14 5d^5 6s^2	-4.38000106812	-5.56968402863	0	0	-5.32244110107	-8.04720020294	-51.7570610046	-52.2610168457	1.18968200684	0	2.72475910187	0.503955006599	1.37000000477	1.27999997139	1.35000002384	1.46000003815	1.89999997616	186.207000732	7.83349990845	0.15000000596	3.99175000191	3.84174990654	9.69999980927	58	5.19999980927	1.85000002384	4.28000020981	3	2.05999994278	2.68000006676	766	3180	5630	21	1.37000000477
76	Os	[Xe] 4f^14 5d^6 6s^2	-4.72256612778	-5.59518098831	0	0	-6.78372001648	-8.97532653809	-62.7424125671	-63.1699867249	0.872614979744	0	2.19160604477	0.427572995424	1.35000002384	1.25999999046	1.29999995232	1.51999998093	2.20000004768	190.199996948	8.43819999695	1.10000002384	4.76910018921	3.66910004616	8.5	63	5.40000009537	1.85000002384	4.15000009537	3	1.85000002384	2.65000009537	850	3000	5500	22.3999996185	1.34000003338
77	Ir	[Xe] 4f^14 5d^7 6s^2	-4.99451589584	-5.6008682251	0	0	-8.1960735321	-9.84783267975	-74.2423553467	-74.5795898438	0.606351971626	0	1.65175902843	0.337231010199	1.36000001431	1.26999998093	1.35000002384	1.54999995232	2.20000004768	192.220001221	8.96700000763	1.5637999773	5.26539993286	3.70160007477	7.59999990463	66	5.55000019073	1.83000004292	4.17000007629	3	1.87000000477	2.62800002098	880	2450	4500	22.5	1.36000001431
78	Pt	[Xe] 4f^14 5d^9 6s^1	-3.91449594498	-4.7045249939	0	0	-7.01651382446	-7.72537088394	-82.539932251	-82.6585998535	0.790028989315	0	0.708856999874	0.118669003248	1.38999998569	1.29999995232	1.35000002384	1.44000005722	2.27999997139	195.080001831	8.95870018005	2.12800002098	5.54335021973	3.41534996033	6.5	68	5.65000009537	1.77999997139	4.36000013351	3	1.90999996662	2.70000004768	870	1770	3825	21.3999996185	1.38999998569
79	Au	[Xe] 4f^14 5d^10 6s^1	-4.05803585052	-4.67195177078	0	0	-8.16703891754	-8.34225273132	-94.8371200562	-94.8449249268	0.613915979862	0	0.175213992596	0.00780999986455	1.46000003815	1.34000003338	1.35000002384	1.41999995708	2.53999996185	196.966506958	9.22550010681	2.30862998962	5.76706504822	3.45843505859	5.80000019073	70	5.15000009537	1.57000005245	4.69999980927	3	1.19000005722	2.66000008583	896	1063	2970	19.2999992371	1.44000005722
80	Hg	[Xe] 4f^14 5d^10 6s^2	-5.58206510544	-5.58206510544	0	0	-12.314573288	-12.314573288	-111.84677124	-111.84677124	0	0	0	0	1.60000002384	1.49000000954	1.5	1.44000005722	2	200.589996338	10.4375	0	0	0	5.69999980927	74	4.19999980927	1.24000000954	5.82999992371	3	1.49000000954	2.41000008583	1013	-39	357	13.529999733	1.5
81	Tl	[Xe] 4f^14 5d^10 6s^2 6p^1	-7.48411512375	-7.93865394592	-2.47234606743	-2.96057295799	-18.2774353027	-18.3540897369	-131.542770386	-131.550552368	0.454539000988	0.488227009773	0.0766550004482	0.007782000117	1.71000003815	1.48000001907	1.89999997616	1.44000005722	2.03999996185	204.383300781	6.10820007324	0.20000000298	3.15409994125	2.95409989357	7.59999990463	78	3.90000009537	1.12000000477	6.67000007629	2	1.69000005722	2.2349998951	596	303	1460	11.8500003815	1.70000004768
82	Pb	[Xe] 4f^14 5d^10 6s^2 6p^2	-9.11970996857	-10.0580949783	-3.25124502182	-4.21439313889	-24.3539848328	-24.5292263031	-152.050445557	-152.074005127	0.938385009766	0.963147997856	0.1752409935	0.0235649999231	1.75	1.47000002861	1.79999995232	1.54999995232	2.32999992371	207.199996948	7.416659832	0.363999992609	3.89033007622	3.5263299942	6.80000019073	82	4.09999990463	1.14999997616	6.94000005722	2	1.91999995708	2.08999991417	722	327	1740	11.3999996185	1.75
83	Bi	[Xe] 4f^14 5d^10 6s^2 6p^3	-10.642950058	-12.0797119141	-3.96042895317	-5.40200710297	-30.6616420746	-30.9494838715	-173.45123291	-173.497817993	1.43676197529	1.44157803059	0.287842005491	0.0465859994292	1.70000004768	1.46000003815	1.60000002384	1.66999995708	2.01999998093	208.980392456	7.28560018539	0.945999979973	4.11579990387	3.16980004311	7.40000009537	87	4.15000009537	1.15999996662	7.19999980927	2	2.1400001049	1.99699997902	710	271	1560	9.80000019073	1.54999995232
84	Po	[Xe] 4f^14 5d^10 6s^2 6p^4	-12.8676176071	-13.8249969482	-5.3762922287	-6.3245549202	-37.5555152893	-37.7610702515	-196.00668335	-196.045181274	0.957378983498	0.948262989521	0.205555006862	0.0385040007532	1.66999995708	1.52999997139	1.89999997616	1.75999999046	2	209	8.4167098999	1.89999997616	5.15835523605	3.25835490227	6.80000019073	91	0	0	0	2	2.40000009537	1.89999997616	818	254	962	9.39999961853	1.66999995708
85	At	[Xe] 4f^14 5d^10 6s^2 6p^5	-14.9871959686	-15.4649734497	-6.70107889175	-7.16884279251	-44.6603012085	-44.7689285278	-219.392044067	-219.414794922	0.477777987719	0.467763990164	0.108627997339	0.0227489992976	1.45000004768	1.47000002861	0	1.89999997616	2.20000004768	210	0	2.79999995232	0	0	6	96	0	0	0	0	2.6400001049	1.83000004292	0	302	335	0	0
86	Rn	[Xe] 4f^14 5d^10 6s^2 6p^6	-17.0498466492	-17.0498466492	-7.9778380394	-7.9778380394	-52.0099372864	-52.0099372864	-243.632324219	-243.632324219	0	0	0	0	1.34000003338	0	0	2.05999994278	0	213.035903931	10.7484998703	0	0	0	5.30000019073	6	0	0	0	0	0	0	1043	-71	-62	4.40000009537	0
87	Fr	[Rn] 7s^1	-1.81412994862	-2.22246408463	0	0	0	0	0	0	0.408333986998	0	0	0	2.70000004768	0	0	0.860000014305	0.699999988079	222	4.07270002365	0.460000008345	2.2663500309	1.80634999275	48.7000007629	7	0	0	0	1	0.699999988079	4.36999988556	0	27	680	0	0
88	Ra	[Rn] 7s^2	-3.09480690956	-3.09480690956	0	0	0	0	0	0	0	0	0	0	2.32999992371	0	2.15000009537	0.97000002861	0.899999976158	223	5.27839994431	0	0	0	38.2999992371	13	0	0	0	1	0.899999976158	3.52999997139	516	700	1530	5	0
89	Ac	[Rn] 6d^1 7s^2	-3.31301498413	-3.55508804321	0	0	-3.52910089493	-3.93370699883	0	0	0.242072999477	0	0.40460601449	0	1.87999999523	0	1.92999994755	1	1.10000002384	226.025405884	5.17000007629	0	0	0	32.0999984741	48	0	0	0	5	1.10000002384	3.11999988556	670	1050	3200	0	0
90	Th	[Rn] 6d^2 7s^2	-3.44999694824	-3.8928360939	0	0	-4.23401212692	-5.06126594543	0	0	0.442838013172	0	0.827253997326	0	1.79999995232	1.64999997616	1.79999995232	1.11000001431	1.29999995232	227	6.30670022964	0	0	0	32.0999984741	47	3.29999995232	1.27999997139	7.32000017166	5	1.29999995232	4.98000001907	0	1700	4200	11.6999998093	1.79999995232
91	Pa	[Rn] 5f^2 6d^1 7s^2	-3.3474919796	-3.67013788223	0	0	-3.47367095947	-4.18247413635	-7.91644906998	-9.13347911835	0.322645992041	0	0.708802998066	1.21703004837	1.61000001431	0	1.79999995232	1.13999998569	1.5	232.038101196	5.88999986649	0	0	0	25.3999996185	46	0	0	0	5	1.5	4.96000003815	0	1230	0	15.3999996185	1.61000001431
92	U	[Rn] 5f^3 6d^1 7s^2	-3.36341094971	-3.71634292603	0	0	-3.41660904884	-4.24772691727	-8.92389678955	-10.7035226822	0.352932006121	0	0.831117987633	1.77962601185	1.37999999523	1.41999995708	1.75	1.22000002861	1.37999999523	238.028900146	6.19404983521	0	0	0	24.8999996185	45	3.90000009537	1.50999999046	5.57000017166	5	1.70000004768	4.71999979019	0	1130	3820	18.8999996185	1.38999998569
\.


--
-- Data for TOC entry 6 (OID 169318)
-- Name: lsd_data; Type: TABLE DATA; Schema: public; Owner: sysdba
--

COPY lsd_data (num, name, config, esup, esdown, epup, epdown, edup, eddown, efup, efdown, des, dep, ded, def) FROM stdin;
1	H	1s^1	-2.72590208054	-7.31918621063	0	0	0	0	0	0	4.5932841301	0	0	0
2	He	1s^2	-15.5220632553	-15.5220632553	0	0	0	0	0	0	0	0	0	0
3	Li	[He] 2s^1	-2.09133195877	-3.16482210159	0	0	0	0	0	0	1.07349002361	0	0	0
4	Be	[He] 2s^2	-5.59858179092	-5.59858179092	0	0	0	0	0	0	0	0	0	0
5	B	[He] 2s^2 2p^1	-8.67020511627	-9.8081035614	-3.07989501953	-4.10492086411	0	0	0	0	1.13789904118	1.02502596378	0	0
6	C	[He] 2s^2 2p^2	-11.8387546539	-14.4567642212	-3.79013991356	-6.19214487076	0	0	0	0	2.61800909042	2.4020049572	0	0
7	N	[He] 2s^2 2p^3	-15.2752275467	-19.6128883362	-4.37300777435	-8.40418624878	0	0	0	0	4.33765983582	4.03117799759	0	0
8	O	[He] 2s^2 2p^4	-21.8136920929	-24.9135055542	-7.41099786758	-10.3711633682	0	0	0	0	3.09981393814	2.9601650238	0	0
9	F	[He] 2s^2 2p^5	-28.684135437	-30.3153495789	-10.4478435516	-12.0315752029	0	0	0	0	1.63121497631	1.58373105526	0	0
10	Ne	[He] 2s^2 2p^6	-35.9954833984	-35.9954833984	-13.5522022247	-13.5522022247	0	0	0	0	0	0	0	0
11	Na	[Ne] 3s^1	-2.21879005432	-3.0804669857	0	0	0	0	0	0	0.861675977707	0	0	0
12	Mg	[Ne] 3s^2	-4.77361392975	-4.77361392975	0	0	0	0	0	0	0	0	0	0
13	Al	[Ne] 3s^2 3p^1	-7.39970493317	-8.06213855743	-2.41754198074	-3.02718710899	0	0	0	0	0.662433981895	0.609643995762	0	0
14	Si	[Ne] 3s^2 3p^2	-9.83958816528	-11.3410043716	-3.29029393196	-4.63184309006	0	0	0	0	1.50141596794	1.34154903889	0	0
15	P	[Ne] 3s^2 3p^3	-12.2498102188	-14.7022380829	-4.12233686447	-6.2961192131	0	0	0	0	2.4524269104	2.17378306389	0	0
16	S	[Ne] 3s^2 3p^4	-16.1379108429	-17.8551940918	-6.21195411682	-7.73644590378	0	0	0	0	1.71728396416	1.52449095249	0	0
17	Cl	[Ne] 3s^2 3p^5	-20.0472106934	-20.9383296967	-8.28943634033	-9.08311080933	0	0	0	0	0.891119003296	0.793675005436	0	0
18	Ar	[Ne] 3s^2 3p^6	-24.0381145477	-24.0381145477	-10.4037351608	-10.4037351608	0	0	0	0	0	0	0	0
19	K	[Ar] 4s^1	-2.02398395538	-2.61776399612	0	0	0	0	0	0	0.593779981136	0	0	0
20	Ca	[Ar] 4s^2	-3.84799098969	-3.84799098969	0	0	0	0	0	0	0	0	0	0
21	Sc	[Ar] 3d^1 4s^2	-4.1057100296	-4.38000106812	0	0	-3.19108104706	-3.84053492546	0	0	0.274291008711	0	0.649453997612	0
22	Ti	[Ar] 3d^2 4s^2	-4.26193094254	-4.75584506989	0	0	-3.74589395523	-5.17106389999	0	0	0.493914008141	0	1.42516994476	0
23	V	[Ar] 3d^3 4s^2	-4.3844370842	-5.06894016266	0	0	-4.09229516983	-6.38003921509	0	0	0.684503018856	0	2.28774404526	0
24	Cr	[Ar] 3d^5 4s^1	-2.56189894676	-4.53230381012	0	0	-0.307924002409	-3.98274207115	0	0	1.97040498257	0	3.67481803894	0
25	Mn	[Ar] 3d^5 4s^2	-4.5876789093	-5.60451412201	0	0	-4.3716468811	-8.58021736145	0	0	1.01683604717	0	4.20857000351	0
26	Fe	[Ar] 3d^6 4s^2	-4.96915483475	-5.71406698227	0	0	-5.82084512711	-9.35538768768	0	0	0.744912028313	0	3.53454303741	0
27	Co	[Ar] 3d^7 4s^2	-5.28586912155	-5.80631399155	0	0	-7.16838121414	-9.92454242706	0	0	0.520444989204	0	2.7561609745	0
28	Ni	[Ar] 3d^8 4s^2	-5.56535720825	-5.89268302917	0	0	-8.44614601135	-10.3455018997	0	0	0.327325999737	0	1.89935600758	0
29	Cu	[Ar] 3d^10 4s^1	-4.18797111511	-5.00725078583	0	0	-5.36361217499	-5.50960111618	0	0	0.819280982018	0	0.145989000797	0
30	Zn	[Ar] 3d^10 4s^2	-6.06065893173	-6.06065893173	0	0	-10.8558254242	-10.8558254242	0	0	0	0	0	0
31	Ga	[Ar] 3d^10 4s^2 4p^1	-8.56250190735	-9.1530714035	-2.4025220871	-2.99869608879	-19.9347457886	-20.0011959076	0	0	0.590569019318	0.596175014973	0.0664499998093	0
32	Ge	[Ar] 3d^10 4s^2 4p^2	-10.7624616623	-12.0428676605	-3.27875590324	-4.50936412811	-30.1303119659	-30.2976341248	0	0	1.28040504456	1.23060798645	0.167322993279	0
33	As	[Ar] 3d^10 4s^2 4p^3	-12.8657951355	-14.8904323578	-4.09041786194	-5.99551486969	-41.4961891174	-41.7899093628	0	0	2.02463698387	1.90509700775	0.293720006943	0
34	Se	[Ar] 3d^10 4s^2 4p^4	-16.0815029144	-17.4628334045	-5.92803096771	-7.21396017075	-54.5032081604	-54.7263145447	0	0	1.38133203983	1.28592896461	0.223105996847	0
35	Br	[Ar] 3d^10 4s^2 4p^5	-19.2149219513	-19.9169483185	-7.68743801117	-8.33602237701	-68.5435562134	-68.6673126221	0	0	0.702027022839	0.648584008217	0.123756997287	0
36	Kr	[Ar] 3d^10 4s^2 4p^6	-22.3289661407	-22.3289661407	-9.42439556122	-9.42439556122	-83.6508102417	-83.6508102417	0	0	0	0	0	0
37	Rb	[Kr] 5s^1	-1.98371100426	-2.5068230629	0	0	0	0	0	0	0.523111999035	0	0	0
38	Sr	[Kr] 5s^2	-3.58627200127	-3.58627200127	0	0	0	0	0	0	0	0	0	0
39	Y	[Kr] 4d^1 5s^2	-3.92363905907	-4.24293804169	0	0	-2.67733001709	-3.17170596123	0	0	0.319299012423	0	0.494376987219	0
40	Zr	[Kr] 4d^2 5s^2	-4.08859395981	-4.66182994843	0	0	-3.4683380127	-4.53088903427	0	0	0.573234975338	0	1.06255102158	0
41	Nb	[Kr] 4d^4 5s^1	-2.66176509857	-4.37703514099	0	0	-1.69880795479	-4.02105617523	0	0	1.71527099609	0	2.32224798203	0
42	Mo	[Kr] 4d^5 5s^1	-2.60554599762	-4.50549983978	0	0	-1.99671804905	-4.9208278656	0	0	1.89995396137	0	2.92410993576	0
43	Tc	[Kr] 4d^5 5s^2	-4.33649015427	-5.45591306686	0	0	-5.44298696518	-8.43869113922	0	0	1.11942303181	0	2.99570298195	0
44	Ru	[Kr] 4d^7 5s^1	-3.3640089035	-4.5916519165	0	0	-4.5087928772	-6.40809392929	0	0	1.22764205933	0	1.89930105209	0
45	Rh	[Kr] 4d^8 5s^1	-3.57614898682	-4.58533906937	0	0	-5.68563222885	-7.03055477142	0	0	1.00918900967	0	1.34492301941	0
46	Pd	[Kr] 4d^10	0	0	0	0	-4.37480401993	-4.37480401993	0	0	0	0	0	0
47	Ag	[Kr] 4d^10 5s^1	-3.88622307777	-4.55423593521	0	0	-8.00028800964	-8.16238594055	0	0	0.668012976646	0	0.162098005414	0
48	Cd	[Kr] 4d^10 5s^2	-5.55733013153	-5.55733013153	0	0	-12.8037796021	-12.8037796021	0	0	0	0	0	0
49	In	[Kr] 4d^10 5s^2 5p^1	-7.60653877258	-8.10170459747	-2.45993804932	-2.97785210609	-19.7949333191	-19.8675327301	0	0	0.495166003704	0.517915010452	0.0725999996066	0
50	Sn	[Kr] 4d^10 5s^2 5p^2	-9.38151073456	-10.4190816879	-3.26955890656	-4.30750989914	-27.1271266937	-27.2984752655	0	0	1.03757095337	1.03795194626	0.171350002289	0
51	Sb	[Kr] 4d^10 5s^2 5p^3	-11.0514202118	-12.6570825577	-4.01308298111	-5.58538484573	-34.9233016968	-35.2113609314	0	0	1.60566294193	1.57230198383	0.28806000948	0
52	Te	[Kr] 4d^10 5s^2 5p^4	-13.5409374237	-14.6196241379	-5.55460882187	-6.59849214554	-43.579246521	-43.7895622253	0	0	1.07868695259	1.04388403893	0.210317000747	0
53	I	[Kr] 4d^10 5s^2 5p^5	-15.9358386993	-16.4778900146	-7.0117521286	-7.53108119965	-52.6669044495	-52.7800750732	0	0	0.542051017284	0.519330024719	0.113172002137	0
54	Xe	[Kr] 4d^10 5s^2 5p^6	-18.28840065	-18.28840065	-8.43104362488	-8.43104362488	-62.2233848572	-62.2233848572	0	0	0	0	0	0
55	Cs	[Xe] 6s^1	-1.85930097103	-2.30085992813	0	0	0	0	0	0	0.441558986902	0	0	0
56	Ba	[Xe] 6s^2	-3.23725891113	-3.23725891113	0	0	0	0	0	0	0	0	0	0
57	La	[Xe] 5d^1 6s^2	-3.46216106415	-3.71408390999	0	0	-3.59655809402	-4.04013109207	0	0	0.251922994852	0	0.443572998047	0
58	Ce	[Xe] 4f^1 5d^1 6s^2	-3.48648810387	-3.77544593811	0	0	-3.50232505798	-4.07721996307	-8.71951198578	-9.52858924866	0.288958013058	0	0.5748950243	0.80907702446
59	Pr	[Xe] 4f^3 6s^2	-3.32542395592	-3.43592905998	0	0	0	0	-3.07741904259	-4.93767213821	0.110504999757	0	0	1.86025297642
60	Nd	[Xe] 4f^4 6s^2	-3.3477640152	-3.48243308067	0	0	0	0	-3.26256489754	-5.8286819458	0.134669005871	0	0	2.56611704826
61	Pm	[Xe] 4f^5 6s^2	-3.36942410469	-3.52591705322	0	0	0	0	-3.31339597702	-6.61204385757	0.156492993236	0	0	3.29864811897
62	Sm	[Xe] 4f^6 6s^2	-3.39062190056	-3.56727790833	0	0	0	0	-3.25206208229	-7.30571699142	0.176655992866	0	0	4.05365514755
63	Eu	[Xe] 4f^7 6s^2	-3.41143894196	-3.60700702667	0	0	0	0	-3.09404492378	-7.92224502563	0.19556799531	0	0	4.82819986343
64	Gd	[Xe] 4f^7 5d^1 6s^2	-3.63538908958	-4.09602308273	0	0	-2.77934503555	-3.90807390213	-9.71781730652	-15.1763153076	0.460635006428	0	1.12872898579	5.4584980011
65	Tb	[Xe] 4f^9 6s^2	-3.51995801926	-3.64001488686	0	0	0	0	-4.81720685959	-8.42584705353	0.12005700171	0	0	3.60863995552
66	Dy	[Xe] 4f^10 6s^2	-3.56613588333	-3.65664100647	0	0	0	0	-5.53866291046	-8.47798442841	0.0905049964786	0	0	2.93932104111
67	Ho	[Xe] 4f^11 6s^2	-3.60931992531	-3.67370200157	0	0	0	0	-6.18828105927	-8.42840480804	0.0643820017576	0	0	2.2401239872
68	Er	[Xe] 4f^12 6s^2	-3.65030002594	-3.69122600555	0	0	0	0	-6.77591085434	-8.29123210907	0.0409259982407	0	0	1.51532101631
69	Tm	[Xe] 4f^13 6s^2	-3.68964791298	-3.70921301842	0	0	0	0	-7.30903577805	-8.07688808441	0.0195649992675	0	0	0.767850995064
70	Yb	[Xe] 4f^14 6s^2	-3.72766208649	-3.72766208649	0	0	0	0	-7.7935628891	-7.7935628891	0	0	0	0
71	Lu	[Xe] 4f^14 5d^1 6s^2	-4.03341007233	-4.36987876892	0	0	-2.55044293404	-3.02909088135	-15.3839378357	-15.4542789459	0.336468994617	0	0.478648990393	0.0703409984708
72	Hf	[Xe] 4f^14 5d^2 6s^2	-4.17926311493	-4.78686618805	0	0	-3.31554603577	-4.32511615753	-23.5275211334	-23.6885585785	0.607603013515	0	1.00957000256	0.161036998034
73	Ta	[Xe] 4f^14 5d^3 6s^2	-4.26908779144	-5.10151195526	0	0	-4.01330089569	-5.57896280289	-32.3138923645	-32.5788192749	0.832423985004	0	1.56566202641	0.264930009842
74	W	[Xe] 4f^14 5d^4 6s^2	-4.33205509186	-5.35569286346	0	0	-4.67736816406	-6.81583023071	-41.7318115234	-42.1114082336	1.02363801003	0	2.13846206665	0.379599004984
75	Re	[Xe] 4f^14 5d^5 6s^2	-4.38000106812	-5.56968402863	0	0	-5.32244110107	-8.04720020294	-51.7570610046	-52.2610168457	1.18968200684	0	2.72475910187	0.503955006599
76	Os	[Xe] 4f^14 5d^6 6s^2	-4.72256612778	-5.59518098831	0	0	-6.78372001648	-8.97532653809	-62.7424125671	-63.1699867249	0.872614979744	0	2.19160604477	0.427572995424
77	Ir	[Xe] 4f^14 5d^7 6s^2	-4.99451589584	-5.6008682251	0	0	-8.1960735321	-9.84783267975	-74.2423553467	-74.5795898438	0.606351971626	0	1.65175902843	0.337231010199
78	Pt	[Xe] 4f^14 5d^9 6s^1	-3.91449594498	-4.7045249939	0	0	-7.01651382446	-7.72537088394	-82.539932251	-82.6585998535	0.790028989315	0	0.708856999874	0.118669003248
79	Au	[Xe] 4f^14 5d^10 6s^1	-4.05803585052	-4.67195177078	0	0	-8.16703891754	-8.34225273132	-94.8371200562	-94.8449249268	0.613915979862	0	0.175213992596	0.00780999986455
80	Hg	[Xe] 4f^14 5d^10 6s^2	-5.58206510544	-5.58206510544	0	0	-12.314573288	-12.314573288	-111.84677124	-111.84677124	0	0	0	0
81	Tl	[Xe] 4f^14 5d^10 6s^2 6p^1	-7.48411512375	-7.93865394592	-2.47234606743	-2.96057295799	-18.2774353027	-18.3540897369	-131.542770386	-131.550552368	0.454539000988	0.488227009773	0.0766550004482	0.007782000117
82	Pb	[Xe] 4f^14 5d^10 6s^2 6p^2	-9.11970996857	-10.0580949783	-3.25124502182	-4.21439313889	-24.3539848328	-24.5292263031	-152.050445557	-152.074005127	0.938385009766	0.963147997856	0.1752409935	0.0235649999231
83	Bi	[Xe] 4f^14 5d^10 6s^2 6p^3	-10.642950058	-12.0797119141	-3.96042895317	-5.40200710297	-30.6616420746	-30.9494838715	-173.45123291	-173.497817993	1.43676197529	1.44157803059	0.287842005491	0.0465859994292
84	Po	[Xe] 4f^14 5d^10 6s^2 6p^4	-12.8676176071	-13.8249969482	-5.3762922287	-6.3245549202	-37.5555152893	-37.7610702515	-196.00668335	-196.045181274	0.957378983498	0.948262989521	0.205555006862	0.0385040007532
85	At	[Xe] 4f^14 5d^10 6s^2 6p^5	-14.9871959686	-15.4649734497	-6.70107889175	-7.16884279251	-44.6603012085	-44.7689285278	-219.392044067	-219.414794922	0.477777987719	0.467763990164	0.108627997339	0.0227489992976
86	Rn	[Xe] 4f^14 5d^10 6s^2 6p^6	-17.0498466492	-17.0498466492	-7.9778380394	-7.9778380394	-52.0099372864	-52.0099372864	-243.632324219	-243.632324219	0	0	0	0
87	Fr	[Rn] 7s^1	-1.81412994862	-2.22246408463	0	0	0	0	0	0	0.408333986998	0	0	0
88	Ra	[Rn] 7s^2	-3.09480690956	-3.09480690956	0	0	0	0	0	0	0	0	0	0
89	Ac	[Rn] 6d^1 7s^2	-3.31301498413	-3.55508804321	0	0	-3.52910089493	-3.93370699883	0	0	0.242072999477	0	0.40460601449	0
90	Th	[Rn] 6d^2 7s^2	-3.44999694824	-3.8928360939	0	0	-4.23401212692	-5.06126594543	0	0	0.442838013172	0	0.827253997326	0
91	Pa	[Rn] 5f^2 6d^1 7s^2	-3.3474919796	-3.67013788223	0	0	-3.47367095947	-4.18247413635	-7.91644906998	-9.13347911835	0.322645992041	0	0.708802998066	1.21703004837
92	U	[Rn] 5f^3 6d^1 7s^2	-3.36341094971	-3.71634292603	0	0	-3.41660904884	-4.24772691727	-8.92389678955	-10.7035226822	0.352932006121	0	0.831117987633	1.77962601185
\.


--
-- Data for TOC entry 7 (OID 169458)
-- Name: source_notes; Type: TABLE DATA; Schema: public; Owner: sysdba
--

COPY source_notes (property, notes, units, source) FROM stdin;
Config	Valence electron configuration	n/a	NIST database
eXup/down	Valence orbital energies	eV	NIST database
deX	Valence orbital exchange splitting (from eXup/down)	eV	NIST database
atomic_rad	Atomic radius	A	-
covalent_rad	Covalent radius	A	-
slater_atomic_rad	Slater atomic radius	A	-
a_r_electroneg	Allred-Rochow Electronegativity	n/a	-
pauling_electroneg	Pauling electronegativity	n/a	-
atomic_mass	Average atomic mass	au	-
first_ip	First Ionization potential	eV	CRC
electron_affinity	Electron Affinity	eV	CRC
pearson_electroneg	Pearsons electronegativity	eV	Calculated from first_IP and electron_affinity
pearson_hardness	Pearsons hardness	eV	Calculated from first_IP and electron_affinity
polarizability	Atomic Polarizability	10^(-24) cm3	CRC
mendeleev_number	Mendeleev Number (alternate numbering for the Periodic Table)	\N	Sutton: "Electronic Structure of Materials"
Miedema_phi	Miedemas phi (electronegativity)	eV	Miedema: "Cohesion in Metals"
Miedema_n	Miedemas n_ws(1/3) (electron density at the edge of the atom)	density^(1/3)	Miedema: "Cohesion in Metals"
Miedema_v	Miedemas V(2/3)	cm^(2)	Miedema: "Cohesion in Metals"
Metaltype	0: nonmetal; 1: alkali/alkali earth; 3: semi-metal; 4: transition metal; 5: rare-earth; 6: actinide	\N	Periodic Table 
M_B_electroneg	Matynov-Batsanov electronegativity	eV^(1/2)	K.M. Rabe, J.C. Phillips, P. Villars, I.D. Brown PRB 45, 7650-7676 (1992)
pp_core_radii_sum	r_s + r_p	au	K.M. Rabe, J.C. Phillips, P. Villars, I.D. Brown PRB 45, 7650-7676 (1992)
DH298	Heat of Formation	kJ/mol	CamSoft Table
mp	melting point of the element	deg C	CamSoft Table
bp	boiling point of the element	deg C	CamSoft Table
density	density of the element	g cm^(-3)	CamSoft Table
r_metallic	metallic radius	A	CamSoft Table
\.


