/* refdb-client.h: header file for refdb-client.c */
/* markus@mhoenicka.de 3-7-00 */
/* $Id: refdb-client.h,v 1.15.2.2 2006/02/05 01:31:02 mhoenicka Exp $ */

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#ifndef REFDB_CLIENT_H
#define REFDB_CLIENT_H 1

#include <stdio.h> /* required for the FILE definition */

struct simplelistvals {
  int n_sockfd; /* file descriptor of the socket */
  int n_file_open; /* if 1, write to outfile */
  int n_file_append; /* if 1, append to outfile */
  int n_pipe; /* if 1, write to pipe */
  char* outbuffer; /* holds the command for the server */
  char inbuffer[OUTBUF_LEN+TERM_LEN]; /* holds the reply from the server */
  char* outfile; /* ptr to string with output filename */
  char* outpipe; /* ptr to string with pipe command */
};

int connect_to_server(int* n_sockfd, char* server_ip, char* port_address);
int init_dialog(int n_sockfd, char* passwd, char* inbuffer);
int listvalue (char* arg, char* command, char* help_string, char* err_string, int n_with_summary);
int getsimplelist(struct simplelistvals* slvals, int n_with_summary);
int send_xml_data(FILE *infp, FILE *pagerfp, FILE *errstream, int n_sockfd, size_t* ptr_byte_written);
int send_ris_data(FILE *infp, FILE *pagerfp, FILE *errstream, int n_sockfd, char** ptr_ris_set_buffer, size_t* ptr_n_setlength, int* ptr_n_setcount, char* default_ris, int n_cgi, size_t* ptr_byte_written);
void pipehandler(int sig);
void inthandler(int sig);
char* build_batchcommand(int argc, char** argv, int optind, char* s, char* the_command);
size_t read_terminated_string(struct simplelistvals* ptr_slvals, FILE* pagerfp, int* ptr_error);
#endif
void log_print(int priority, const char* string);
