/* $Id: trace.c,v 1.6 2005/12/20 15:11:24 rockyb Exp $
Copyright (C) 2004, 2005 Free Software Foundation, Inc.
Copyright (C) 2008, 2012 R. Bernstein <rocky@gnu.org>

This file is part of GNU Make.

GNU Make is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Make is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Make; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <sys/time.h>
/* Header for routines related to tracing and debugging support */

/* AIX likes this: */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "globals.h"
#include "trace.h"
#include "print.h"
#include "debug.h"
// debugger include(s)
#include "cmd.h"
#include "profile.h"

/** Pointer to top of current target call stack */
target_stack_node_t *p_stack_top;

/** Pointer to top of current target floc stack */
floc_stack_node_t *p_stack_floc_top = NULL;

/*! Push "target" to the call stack. */
extern target_stack_node_t *
trace_push_target (target_stack_node_t *p, file_t *p_target)
{
  target_stack_node_t *new_node = CALLOC(target_stack_node_t, 1);

  /* We allocate and make a copy of p_target in case we want to
     modify information, like the file location or target name
     on the fly as we process file commands or handle dependencies from
     target patterns.
   */
  new_node->p_target = CALLOC (file_t, 1);
  memcpy(new_node->p_target, p_target, sizeof(file_t));
  new_node->p_shared_target = p_target;

  new_node->p_parent = p;

  if (p_target && p_target->floc.filenm != NULL) {

    if ( db_level & DB_VERBOSE ) {
      print_file_target_prefix(p_target);
      printf("\n");
    }
  }

  if (profile_flag) {
    file_t *prev = NULL;

    if (NULL != new_node->p_parent) {
        prev = new_node->p_parent->p_target;
    }

    profile_add_dependency(new_node->p_target, prev);
  }

  return new_node;
};

/*! Pop the next target from the call stack.. */
extern void
trace_pop_target (target_stack_node_t *p)
{

  if (NULL == p) return;

  if (profile_flag) {
    profile_update_target(p->p_target);
  }

  free(p->p_target);
  free(p);
}

/*! Push "p_floc" to the floc stack. Return the new stack top.
*/
extern void
trace_push_floc (gmk_floc *p_floc)
{
  floc_stack_node_t *new_node = CALLOC (floc_stack_node_t, 1);

  /* We DO NOT allocate and make a copy of p_floc so that as we
     read the Makefile, the line number gets updated automatically.
     Slick, huh? Also it shortens and simplifies code a bit.
   */
  new_node->p_floc = p_floc;
  new_node->p_parent = p_stack_floc_top;
  p_stack_floc_top = new_node;
};

/*! Pop the next target from the floc stack. */
extern void
trace_pop_floc (void)
{
  if (NULL == p_stack_floc_top) return;
  else {
    floc_stack_node_t *p_new_top = p_stack_floc_top->p_parent;
    free(p_stack_floc_top);
    p_stack_floc_top = p_new_top;
  }
}
