### Install ResFinder 4.0 ###

# Dependencies:
# NCBIs BLAST (module load ncbi-blast/2.6.0+)
pip3 install biopython
pip3 install tabulate
pip3 install cgecore

# Install
git clone -b 4.0 https://bitbucket.org/genomicepidemiology/resfinder.git
git clone -b new_naming https://bitbucket.org/genomicepidemiology/pointfinder_db.git resfinder/db_pointfinder
git clone https://bitbucket.org/genomicepidemiology/resfinder_db.git resfinder/db_resfinder
git clone https://bitbucket.org/genomicepidemiology/kma.git resfinder/cge/kma
cd resfinder/cge/kma && make
cd ../..
mkdir db_resfinder/kma_indexing
cge/kma/kma_index -i db_resfinder/fusidicacid.fsa -o db_resfinder/kma_indexing/fusidicacid
cge/kma/kma_index -i db_resfinder/phenicol.fsa -o db_resfinder/kma_indexing/phenicol
cge/kma/kma_index -i db_resfinder/glycopeptide.fsa -o db_resfinder/kma_indexing/glycopeptide
cge/kma/kma_index -i db_resfinder/trimethoprim.fsa -o db_resfinder/kma_indexing/trimethoprim
cge/kma/kma_index -i db_resfinder/oxazolidinone.fsa -o db_resfinder/kma_indexing/oxazolidinone
cge/kma/kma_index -i db_resfinder/tetracycline.fsa -o db_resfinder/kma_indexing/tetracycline
cge/kma/kma_index -i db_resfinder/quinolone.fsa -o db_resfinder/kma_indexing/quinolone
cge/kma/kma_index -i db_resfinder/nitroimidazole.fsa -o db_resfinder/kma_indexing/nitroimidazole
cge/kma/kma_index -i db_resfinder/fosfomycin.fsa -o db_resfinder/kma_indexing/fosfomycin
cge/kma/kma_index -i db_resfinder/aminoglycoside.fsa -o db_resfinder/kma_indexing/aminoglycoside
cge/kma/kma_index -i db_resfinder/macrolide.fsa -o db_resfinder/kma_indexing/macrolide
cge/kma/kma_index -i db_resfinder/sulphonamide.fsa -o db_resfinder/kma_indexing/sulphonamide
cge/kma/kma_index -i db_resfinder/rifampicin.fsa -o db_resfinder/kma_indexing/rifampicin
cge/kma/kma_index -i db_resfinder/colistin.fsa -o db_resfinder/kma_indexing/colistin
cge/kma/kma_index -i db_resfinder/beta-lactam.fsa -o db_resfinder/kma_indexing/beta-lactam
cge/kma/kma_index -i db_pointfinder/campylobacter/*.fsa -o db_pointfinder/campylobacter/campylobacter
cge/kma/kma_index -i db_pointfinder/escherichia_coli/*.fsa -o db_pointfinder/escherichia_coli/escherichia_coli
cge/kma/kma_index -i db_pointfinder/enterococcus_faecalis/*.fsa -o db_pointfinder/enterococcus_faecalis/enterococcus_faecalis
cge/kma/kma_index -i db_pointfinder/enterococcus_faecium/*.fsa -o db_pointfinder/enterococcus_faecium/enterococcus_faecium
cge/kma/kma_index -i db_pointfinder/neisseria_gonorrhoeae/*.fsa -o db_pointfinder/neisseria_gonorrhoeae/neisseria_gonorrhoeae
cge/kma/kma_index -i db_pointfinder/salmonella/*.fsa -o db_pointfinder/salmonella/salmonella
cge/kma/kma_index -i db_pointfinder/mycobacterium_tuberculosis/*.fsa -o db_pointfinder/mycobacterium_tuberculosis/mycobacterium_tuberculosis

python3 tests/functional_test.py

