/* Ricochet - https://ricochet.im/
 * Copyright (C) 2014, John Brooks <john.brooks@dereferenced.net>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *    * Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *
 *    * Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following disclaimer
 *      in the documentation and/or other materials provided with the
 *      distribution.
 *
 *    * Neither the names of the copyright owners nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef IDENTITYMANAGER_H
#define IDENTITYMANAGER_H

#include <QObject>
#include "UserIdentity.h"

class IdentityManager : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(IdentityManager)

public:
    explicit IdentityManager(QObject *parent = 0);
    ~IdentityManager();

    const QList<UserIdentity*> &identities() const { return m_identities; }
    UserIdentity *lookupNickname(const QString &nickname) const;
    UserIdentity *lookupHostname(const QString &hostname) const;
    UserIdentity *lookupUniqueID(int uniqueID) const;

    UserIdentity *createIdentity(const QString &serviceDirectory = QString(), const QString &nickname = QString());

signals:
    void identityAdded(UserIdentity *identity);
    void contactAdded(ContactUser *user, UserIdentity *identity);
    void contactDeleted(ContactUser *user, UserIdentity *identity);
    void outgoingRequestAdded(OutgoingContactRequest *request, UserIdentity *identity);
    void incomingRequestAdded(IncomingContactRequest *request, UserIdentity *identity);
    void incomingRequestRemoved(IncomingContactRequest *request, UserIdentity *identity);

private slots:
    void onContactAdded(ContactUser *user);
    void onOutgoingRequest(OutgoingContactRequest *request);
    void onIncomingRequest(IncomingContactRequest *request);
    void onIncomingRequestRemoved(IncomingContactRequest *request);

private:
    QList<UserIdentity*> m_identities;
    int highestID;

    void loadFromSettings();
    void addIdentity(UserIdentity *identity);
};

extern IdentityManager *identityManager;

#endif // IDENTITYMANAGER_H
