/*  RipOff - Plugin based CD Ripper
 *  Copyright (C) 2006 Bobby Ryan Newberry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef RIPOFFCORE_H
#define RIPOFFCORE_H
#include "lib/RipOff.h"
#include "RipOffPreferences.h"

/* Stores the GtkWidgets who will later be needed for extraction and update purposes */
struct RipOffCore_
{	
	GtkWidget *main_window;
	GtkWidget *album, *artist, *genre, *year;
	GtkWidget *view;
	RipOffPreferences prefs;
};
typedef struct RipOffCore_ * RipOffCore;

extern GtkWidget *status_bar;

/*returns a pointer to a new RipOffCore.  The main window of RipOff is also drawn as a result.  
  Argument is an initialized RipOffPreferences object*/
RipOffCore ripoff_core_new(RipOffPreferences prefs);

/* Retrieves string currently in the album entry field.  This function is probably not needed */
gchar *ripoff_core_get_album(RipOffCore core);

/* Retrieves string currently in the year entry field.  This function is probably not needed */
gchar *ripoff_core_get_year(RipOffCore core);

/* Retrieves string currently in the genre entry field.  This function is probably not needed */
gchar *ripoff_core_get_genre(RipOffCore core);

/* Used to change value currently in album entry field. Used by CDDB lookup
   functionality */
void ripoff_core_set_album(RipOffCore core, gchar *album_string);

/* Used to change value currently in artist entry field. Used by CDDB lookup
   functionality */
void ripoff_core_set_artist(RipOffCore core, gchar *artist_string);

/* Used to change value currently in album entry field. Used by CDDB lookup
   functionality */
void ripoff_core_set_year(RipOffCore core, gchar *year_string);

/* Used to change value currently in album entry field. Used by CDDB lookup
   functionality */
void ripoff_core_set_genre(RipOffCore core, gchar *genre_string);

/*output string function*/

/*plugin object function*/

/*  Informs the GUI to update the GtkTreeModel that represents the CD.
    Called after a CD has been inserted */
void ripoff_core_update_model(RipOffCore core);

/*  Informs the GUI to clear the GtkTreeModel that represents the CD. Called after CD has been
    ejected */
void ripoff_core_clear_model(RipOffCore core);
#endif
