module Emot
  MAP = {
    :"+1"                              => [0x1F44D],
    :"-1"                              => [0x1F44E],
    :"100"                             => [0x1F4AF],
    :"-100"                            => [0x1F4AF],
    :"1234"                            => [0x1F522],
    :"-1234"                           => [0x1F522],
    :"8ball"                           => [0x1F3B1],
    :"a"                               => [0x1F170],
    :"ab"                              => [0x1F18E],
    :"abc"                             => [0x1F524],
    :"abcd"                            => [0x1F521],
    :"accept"                          => [0x1F251],
    :"aerial_tramway"                  => [0x1F6A1],
    :"airplane"                        => [0x2708, 0xFE0F],
    :"alarm_clock"                     => [0x23F0],
    :"alien"                           => [0x1F47D],
    :"ambulance"                       => [0x1F691],
    :"anchor"                          => [0x2693, 0xFE0F],
    :"angel"                           => [0x1F47C],
    :"anger"                           => [0x1F4A2],
    :"angry"                           => [0x1F620],
    :"anguished"                       => [0x1F627],
    :"ant"                             => [0x1F41C],
    :"apple"                           => [0x1F34E],
    :"aquarius"                        => [0x2652, 0xFE0F],
    :"aries"                           => [0x2648, 0xFE0F],
    :"arrow_backward"                  => [0x25C0, 0xFE0F],
    :"arrow_double_down"               => [0x23EC],
    :"arrow_double_up"                 => [0x23EB],
    :"arrow_down"                      => [0x2B07, 0xFE0F],
    :"arrow_down_small"                => [0x1F53D],
    :"arrow_forward"                   => [0x25B6, 0xFE0F],
    :"arrow_heading_down"              => [0x2935, 0xFE0F],
    :"arrow_heading_up"                => [0x2934, 0xFE0F],
    :"arrow_left"                      => [0x2B05, 0xFE0F],
    :"arrow_lower_left"                => [0x2199, 0xFE0F],
    :"arrow_lower_right"               => [0x2198, 0xFE0F],
    :"arrow_right"                     => [0x27A1, 0xFE0F],
    :"arrow_right_hook"                => [0x21AA, 0xFE0F],
    :"arrow_up"                        => [0x2B06, 0xFE0F],
    :"arrow_up_down"                   => [0x2195, 0xFE0F],
    :"arrow_up_small"                  => [0x1F53C],
    :"arrow_upper_left"                => [0x2196, 0xFE0F],
    :"arrow_upper_right"               => [0x2197, 0xFE0F],
    :"arrows_clockwise"                => [0x1F503],
    :"arrows_counterclockwise"         => [0x1F504],
    :"art"                             => [0x1F3A8],
    :"articulated_lorry"               => [0x1F69B],
    :"astonished"                      => [0x1F632],
    :"athletic_shoe"                   => [0x1F45F],
    :"atm"                             => [0x1F3E7],
    :"b"                               => [0x1F171],
    :"baby"                            => [0x1F476],
    :"baby_bottle"                     => [0x1F37C],
    :"baby_chick"                      => [0x1F424],
    :"baby_symbol"                     => [0x1F6BC],
    :"back"                            => [0x1F519],
    :"baggage_claim"                   => [0x1F6C4],
    :"balloon"                         => [0x1F388],
    :"ballot_box_with_check"           => [0x2611, 0xFE0F],
    :"bamboo"                          => [0x1F38D],
    :"banana"                          => [0x1F34C],
    :"bangbang"                        => [0x203C, 0xFE0F],
    :"bank"                            => [0x1F3E6],
    :"bar_chart"                       => [0x1F4CA],
    :"barber"                          => [0x1F488],
    :"baseball"                        => [0x26BE, 0xFE0F],
    :"basketball"                      => [0x1F3C0],
    :"bath"                            => [0x1F6C0],
    :"bathtub"                         => [0x1F6C1],
    :"battery"                         => [0x1F50B],
    :"bear"                            => [0x1F43B],
    :"bee"                             => [0x1F41D],
    :"beer"                            => [0x1F37A],
    :"beers"                           => [0x1F37B],
    :"beetle"                          => [0x1F41E],
    :"beginner"                        => [0x1F530],
    :"bell"                            => [0x1F514],
    :"bento"                           => [0x1F371],
    :"bicyclist"                       => [0x1F6B4],
    :"bike"                            => [0x1F6B2],
    :"bikini"                          => [0x1F459],
    :"bird"                            => [0x1F426],
    :"birthday"                        => [0x1F382],
    :"black_circle"                    => [0x26AB, 0xFE0F],
    :"black_joker"                     => [0x1F0CF],
    :"black_large_square"              => [0x2B1B, 0xFE0F],
    :"black_medium_small_square"       => [0x25FE, 0xFE0F],
    :"black_medium_square"             => [0x25FC, 0xFE0F],
    :"black_nib"                       => [0x2712, 0xFE0F],
    :"black_small_square"              => [0x25AA, 0xFE0F],
    :"black_square_button"             => [0x1F532],
    :"blossom"                         => [0x1F33C],
    :"blowfish"                        => [0x1F421],
    :"blue_book"                       => [0x1F4D8],
    :"blue_car"                        => [0x1F699],
    :"blue_heart"                      => [0x1F499],
    :"blush"                           => [0x1F60A],
    :"boar"                            => [0x1F417],
    :"boat"                            => [0x26F5, 0xFE0F],
    :"bomb"                            => [0x1F4A3],
    :"book"                            => [0x1F4D6],
    :"bookmark"                        => [0x1F516],
    :"bookmark_tabs"                   => [0x1F4D1],
    :"books"                           => [0x1F4DA],
    :"boom"                            => [0x1F4A5],
    :"boot"                            => [0x1F462],
    :"bouquet"                         => [0x1F490],
    :"bow"                             => [0x1F647],
    :"bowling"                         => [0x1F3B3],
    # "bowtie"                        => nil,
    :"boy"                             => [0x1F466],
    :"bread"                           => [0x1F35E],
    :"bride_with_veil"                 => [0x1F470],
    :"bridge_at_night"                 => [0x1F309],
    :"briefcase"                       => [0x1F4BC],
    :"broken_heart"                    => [0x1F494],
    :"bug"                             => [0x1F41B],
    :"bulb"                            => [0x1F4A1],
    :"bullettrain_front"               => [0x1F685],
    :"bullettrain_side"                => [0x1F684],
    :"bus"                             => [0x1F68C],
    :"busstop"                         => [0x1F68F],
    :"bust_in_silhouette"              => [0x1F464],
    :"busts_in_silhouette"             => [0x1F465],
    :"cactus"                          => [0x1F335],
    :"cake"                            => [0x1F370],
    :"calendar"                        => [0x1F4C6],
    :"calling"                         => [0x1F4F2],
    :"camel"                           => [0x1F42B],
    :"camera"                          => [0x1F4F7],
    :"cancer"                          => [0x264B, 0xFE0F],
    :"candy"                           => [0x1F36C],
    :"capital_abcd"                    => [0x1F520],
    :"capricorn"                       => [0x2651, 0xFE0F],
    :"car"                             => [0x1F697],
    :"card_index"                      => [0x1F4C7],
    :"carousel_horse"                  => [0x1F3A0],
    :"cat"                             => [0x1F431],
    :"cat2"                            => [0x1F408],
    :"cd"                              => [0x1F4BF],
    :"chart"                           => [0x1F4B9],
    :"chart_with_downwards_trend"      => [0x1F4C9],
    :"chart_with_upwards_trend"        => [0x1F4C8],
    :"checkered_flag"                  => [0x1F3C1],
    :"cherries"                        => [0x1F352],
    :"cherry_blossom"                  => [0x1F338],
    :"chestnut"                        => [0x1F330],
    :"chicken"                         => [0x1F414],
    :"children_crossing"               => [0x1F6B8],
    :"chocolate_bar"                   => [0x1F36B],
    :"christmas_tree"                  => [0x1F384],
    :"church"                          => [0x26EA, 0xFE0F],
    :"cinema"                          => [0x1F3A6],
    :"circus_tent"                     => [0x1F3AA],
    :"city_sunrise"                    => [0x1F307],
    :"city_sunset"                     => [0x1F306],
    :"cl"                              => [0x1F191],
    :"clap"                            => [0x1F44F],
    :"clapper"                         => [0x1F3AC],
    :"clipboard"                       => [0x1F4CB],
    :"clock1"                          => [0x1F550],
    :"clock10"                         => [0x1F559],
    :"clock1030"                       => [0x1F565],
    :"clock11"                         => [0x1F55A],
    :"clock1130"                       => [0x1F566],
    :"clock12"                         => [0x1F55B],
    :"clock1230"                       => [0x1F567],
    :"clock130"                        => [0x1F55C],
    :"clock2"                          => [0x1F551],
    :"clock230"                        => [0x1F55D],
    :"clock3"                          => [0x1F552],
    :"clock330"                        => [0x1F55E],
    :"clock4"                          => [0x1F553],
    :"clock430"                        => [0x1F55F],
    :"clock5"                          => [0x1F554],
    :"clock530"                        => [0x1F560],
    :"clock6"                          => [0x1F555],
    :"clock630"                        => [0x1F561],
    :"clock7"                          => [0x1F556],
    :"clock730"                        => [0x1F562],
    :"clock8"                          => [0x1F557],
    :"clock830"                        => [0x1F563],
    :"clock9"                          => [0x1F558],
    :"clock930"                        => [0x1F564],
    :"closed_book"                     => [0x1F4D5],
    :"closed_lock_with_key"            => [0x1F510],
    :"closed_umbrella"                 => [0x1F302],
    :"cloud"                           => [0x2601, 0xFE0F],
    :"clubs"                           => [0x2663, 0xFE0F],
    :"cn"                              => [0x1F1E8, 0x1F1F3],
    :"cocktail"                        => [0x1F378],
    :"coffee"                          => [0x2615, 0xFE0F],
    :"cold_sweat"                      => [0x1F630],
    :"collision"                       => [0x1F4A5],
    :"computer"                        => [0x1F4BB],
    :"confetti_ball"                   => [0x1F38A],
    :"confounded"                      => [0x1F616],
    :"confused"                        => [0x1F615],
    :"congratulations"                 => [0x3297, 0xFE0F],
    :"construction"                    => [0x1F6A7],
    :"construction_worker"             => [0x1F477],
    :"convenience_store"               => [0x1F3EA],
    :"cookie"                          => [0x1F36A],
    :"cool"                            => [0x1F192],
    :"cop"                             => [0x1F46E],
    :"copyright"                       => [0xA9],
    :"corn"                            => [0x1F33D],
    :"couple"                          => [0x1F46B],
    :"couple_with_heart"               => [0x1F491],
    :"couplekiss"                      => [0x1F48F],
    :"cow"                             => [0x1F42E],
    :"cow2"                            => [0x1F404],
    :"credit_card"                     => [0x1F4B3],
    :"crescent_moon"                   => [0x1F319],
    :"crocodile"                       => [0x1F40A],
    :"crossed_flags"                   => [0x1F38C],
    :"crown"                           => [0x1F451],
    :"cry"                             => [0x1F622],
    :"crying_cat_face"                 => [0x1F63F],
    :"crystal_ball"                    => [0x1F52E],
    :"cupid"                           => [0x1F498],
    :"curly_loop"                      => [0x27B0],
    :"currency_exchange"               => [0x1F4B1],
    :"curry"                           => [0x1F35B],
    :"custard"                         => [0x1F36E],
    :"customs"                         => [0x1F6C3],
    :"cyclone"                         => [0x1F300],
    :"dancer"                          => [0x1F483],
    :"dancers"                         => [0x1F46F],
    :"dango"                           => [0x1F361],
    :"dart"                            => [0x1F3AF],
    :"dash"                            => [0x1F4A8],
    :"date"                            => [0x1F4C5],
    :"de"                              => [0x1F1E9, 0x1F1EA],
    :"deciduous_tree"                  => [0x1F333],
    :"department_store"                => [0x1F3EC],
    :"diamond_shape_with_a_dot_inside" => [0x1F4A0],
    :"diamonds"                        => [0x2666, 0xFE0F],
    :"disappointed"                    => [0x1F61E],
    :"disappointed_relieved"           => [0x1F625],
    :"dizzy"                           => [0x1F4AB],
    :"dizzy_face"                      => [0x1F635],
    :"do_not_litter"                   => [0x1F6AF],
    :"dog"                             => [0x1F436],
    :"dog2"                            => [0x1F415],
    :"dollar"                          => [0x1F4B5],
    :"dolls"                           => [0x1F38E],
    :"dolphin"                         => [0x1F42C],
    :"door"                            => [0x1F6AA],
    :"doughnut"                        => [0x1F369],
    :"dragon"                          => [0x1F409],
    :"dragon_face"                     => [0x1F432],
    :"dress"                           => [0x1F457],
    :"dromedary_camel"                 => [0x1F42A],
    :"droplet"                         => [0x1F4A7],
    :"dvd"                             => [0x1F4C0],
    :"e-mail"                          => [0x1F4E7],
    :"ear"                             => [0x1F442],
    :"ear_of_rice"                     => [0x1F33E],
    :"earth_africa"                    => [0x1F30D],
    :"earth_americas"                  => [0x1F30E],
    :"earth_asia"                      => [0x1F30F],
    :"egg"                             => [0x1F373],
    :"eggplant"                        => [0x1F346],
    :"eight"                           => [0x38, 0xFE0F, 0x20E3],
    :"eight_pointed_black_star"        => [0x2734, 0xFE0F],
    :"eight_spoked_asterisk"           => [0x2733, 0xFE0F],
    :"electric_plug"                   => [0x1F50C],
    :"elephant"                        => [0x1F418],
    :"email"                           => [0x2709, 0xFE0F],
    :"end"                             => [0x1F51A],
    :"envelope"                        => [0x2709, 0xFE0F],
    :"envelope_with_arrow"             => [0x1F4E9],
    :"es"                              => [0x1F1EA, 0x1F1F8],
    :"euro"                            => [0x1F4B6],
    :"european_castle"                 => [0x1F3F0],
    :"european_post_office"            => [0x1F3E4],
    :"evergreen_tree"                  => [0x1F332],
    :"exclamation"                     => [0x2757, 0xFE0F],
    :"expressionless"                  => [0x1F611],
    :"eyeglasses"                      => [0x1F453],
    :"eyes"                            => [0x1F440],
    :"facepunch"                       => [0x1F44A],
    :"factory"                         => [0x1F3ED],
    :"fallen_leaf"                     => [0x1F342],
    :"family"                          => [0x1F46A],
    :"fast_forward"                    => [0x23E9],
    :"fax"                             => [0x1F4E0],
    :"fearful"                         => [0x1F628],
    # "feelsgood"                     => nil,
    :"feet"                            => [0x1F43E],
    :"ferris_wheel"                    => [0x1F3A1],
    :"file_folder"                     => [0x1F4C1],
    # "finnadie"                      => nil,
    :"fire"                            => [0x1F525],
    :"fire_engine"                     => [0x1F692],
    :"fireworks"                       => [0x1F386],
    :"first_quarter_moon"              => [0x1F313],
    :"first_quarter_moon_with_face"    => [0x1F31B],
    :"fish"                            => [0x1F41F],
    :"fish_cake"                       => [0x1F365],
    :"fishing_pole_and_fish"           => [0x1F3A3],
    :"fist"                            => [0x270A],
    :"five"                            => [0x35, 0xFE0F, 0x20E3],
    :"flags"                           => [0x1F38F],
    :"flashlight"                      => [0x1F526],
    :"flipper"                         => [0x1F42C],
    :"floppy_disk"                     => [0x1F4BE],
    :"flower_playing_cards"            => [0x1F3B4],
    :"flushed"                         => [0x1F633],
    :"foggy"                           => [0x1F301],
    :"football"                        => [0x1F3C8],
    :"footprints"                      => [0x1F463],
    :"fork_and_knife"                  => [0x1F374],
    :"fountain"                        => [0x26F2, 0xFE0F],
    :"four"                            => [0x34, 0xFE0F, 0x20E3],
    :"four_leaf_clover"                => [0x1F340],
    :"fr"                              => [0x1F1EB, 0x1F1F7],
    :"free"                            => [0x1F193],
    :"fried_shrimp"                    => [0x1F364],
    :"fries"                           => [0x1F35F],
    :"frog"                            => [0x1F438],
    :"frowning"                        => [0x1F626],
    # "fu"                            => nil,
    :"fuelpump"                        => [0x26FD, 0xFE0F],
    :"full_moon"                       => [0x1F315],
    :"full_moon_with_face"             => [0x1F31D],
    :"game_die"                        => [0x1F3B2],
    :"gb"                              => [0x1F1EC, 0x1F1E7],
    :"gem"                             => [0x1F48E],
    :"gemini"                          => [0x264A, 0xFE0F],
    :"ghost"                           => [0x1F47B],
    :"gift"                            => [0x1F381],
    :"gift_heart"                      => [0x1F49D],
    :"girl"                            => [0x1F467],
    :"globe_with_meridians"            => [0x1F310],
    :"goat"                            => [0x1F410],
    # "goberserk"                     => nil,
    # "godmode"                       => nil,
    :"golf"                            => [0x26F3, 0xFE0F],
    :"grapes"                          => [0x1F347],
    :"green_apple"                     => [0x1F34F],
    :"green_book"                      => [0x1F4D7],
    :"green_heart"                     => [0x1F49A],
    :"grey_exclamation"                => [0x2755],
    :"grey_question"                   => [0x2754],
    :"grimacing"                       => [0x1F62C],
    :"grin"                            => [0x1F601],
    :"grinning"                        => [0x1F600],
    :"guardsman"                       => [0x1F482],
    :"guitar"                          => [0x1F3B8],
    :"gun"                             => [0x1F52B],
    :"haircut"                         => [0x1F487],
    :"hamburger"                       => [0x1F354],
    :"hammer"                          => [0x1F528],
    :"hamster"                         => [0x1F439],
    :"hand"                            => [0x270B],
    :"handbag"                         => [0x1F45C],
    :"hankey"                          => [0x1F4A9],
    :"hash"                            => [0x23, 0xFE0F, 0x20E3],
    :"hatched_chick"                   => [0x1F425],
    :"hatching_chick"                  => [0x1F423],
    :"headphones"                      => [0x1F3A7],
    :"hear_no_evil"                    => [0x1F649],
    :"heart"                           => [0x2764, 0xFE0F],
    :"heart_decoration"                => [0x1F49F],
    :"heart_eyes"                      => [0x1F60D],
    :"heart_eyes_cat"                  => [0x1F63B],
    :"heartbeat"                       => [0x1F493],
    :"heartpulse"                      => [0x1F497],
    :"hearts"                          => [0x2665, 0xFE0F],
    :"heavy_check_mark"                => [0x2714, 0xFE0F],
    :"heavy_division_sign"             => [0x2797],
    :"heavy_dollar_sign"               => [0x1F4B2],
    :"heavy_exclamation_mark"          => [0x2757, 0xFE0F],
    :"heavy_minus_sign"                => [0x2796],
    :"heavy_multiplication_x"          => [0x2716, 0xFE0F],
    :"heavy_plus_sign"                 => [0x2795],
    :"helicopter"                      => [0x1F681],
    :"herb"                            => [0x1F33F],
    :"hibiscus"                        => [0x1F33A],
    :"high_brightness"                 => [0x1F506],
    :"high_heel"                       => [0x1F460],
    :"hocho"                           => [0x1F52A],
    :"honey_pot"                       => [0x1F36F],
    :"honeybee"                        => [0x1F41D],
    :"horse"                           => [0x1F434],
    :"horse_racing"                    => [0x1F3C7],
    :"hospital"                        => [0x1F3E5],
    :"hotel"                           => [0x1F3E8],
    :"hotsprings"                      => [0x2668, 0xFE0F],
    :"hourglass"                       => [0x231B, 0xFE0F],
    :"hourglass_flowing_sand"          => [0x23F3],
    :"house"                           => [0x1F3E0],
    :"house_with_garden"               => [0x1F3E1],
    # "hurtrealbad"                   => nil,
    :"hushed"                          => [0x1F62F],
    :"ice_cream"                       => [0x1F368],
    :"icecream"                        => [0x1F366],
    :"id"                              => [0x1F194],
    :"ideograph_advantage"             => [0x1F250],
    :"imp"                             => [0x1F47F],
    :"inbox_tray"                      => [0x1F4E5],
    :"incoming_envelope"               => [0x1F4E8],
    :"information_desk_person"         => [0x1F481],
    :"information_source"              => [0x2139, 0xFE0F],
    :"innocent"                        => [0x1F607],
    :"interrobang"                     => [0x2049, 0xFE0F],
    :"iphone"                          => [0x1F4F1],
    :"it"                              => [0x1F1EE, 0x1F1F9],
    :"izakaya_lantern"                 => [0x1F3EE],
    :"jack_o_lantern"                  => [0x1F383],
    :"japan"                           => [0x1F5FE],
    :"japanese_castle"                 => [0x1F3EF],
    :"japanese_goblin"                 => [0x1F47A],
    :"japanese_ogre"                   => [0x1F479],
    :"jeans"                           => [0x1F456],
    :"joy"                             => [0x1F602],
    :"joy_cat"                         => [0x1F639],
    :"jp"                              => [0x1F1EF, 0x1F1F5],
    :"key"                             => [0x1F511],
    :"keycap_ten"                      => [0x1F51F],
    :"kimono"                          => [0x1F458],
    :"kiss"                            => [0x1F48B],
    :"kissing"                         => [0x1F617],
    :"kissing_cat"                     => [0x1F63D],
    :"kissing_closed_eyes"             => [0x1F61A],
    :"kissing_heart"                   => [0x1F618],
    :"kissing_smiling_eyes"            => [0x1F619],
    :"knife"                           => [0x1F52A],
    :"koala"                           => [0x1F428],
    :"koko"                            => [0x1F201],
    :"kr"                              => [0x1F1F0, 0x1F1F7],
    :"lantern"                         => [0x1F3EE],
    :"large_blue_circle"               => [0x1F535],
    :"large_blue_diamond"              => [0x1F537],
    :"large_orange_diamond"            => [0x1F536],
    :"last_quarter_moon"               => [0x1F317],
    :"last_quarter_moon_with_face"     => [0x1F31C],
    :"laughing"                        => [0x1F606],
    :"leaves"                          => [0x1F343],
    :"ledger"                          => [0x1F4D2],
    :"left_luggage"                    => [0x1F6C5],
    :"left_right_arrow"                => [0x2194, 0xFE0F],
    :"leftwards_arrow_with_hook"       => [0x21A9, 0xFE0F],
    :"lemon"                           => [0x1F34B],
    :"leo"                             => [0x264C, 0xFE0F],
    :"leopard"                         => [0x1F406],
    :"libra"                           => [0x264E, 0xFE0F],
    :"light_rail"                      => [0x1F688],
    :"link"                            => [0x1F517],
    :"lips"                            => [0x1F444],
    :"lipstick"                        => [0x1F484],
    :"lock"                            => [0x1F512],
    :"lock_with_ink_pen"               => [0x1F50F],
    :"lollipop"                        => [0x1F36D],
    :"loop"                            => [0x27BF],
    :"loud_sound"                      => [0x1F50A],
    :"loudspeaker"                     => [0x1F4E2],
    :"love_hotel"                      => [0x1F3E9],
    :"love_letter"                     => [0x1F48C],
    :"low_brightness"                  => [0x1F505],
    :"m"                               => [0x24C2, 0xFE0F],
    :"mag"                             => [0x1F50D],
    :"mag_right"                       => [0x1F50E],
    :"mahjong"                         => [0x1F004, 0xFE0F],
    :"mailbox"                         => [0x1F4EB],
    :"mailbox_closed"                  => [0x1F4EA],
    :"mailbox_with_mail"               => [0x1F4EC],
    :"mailbox_with_no_mail"            => [0x1F4ED],
    :"man"                             => [0x1F468],
    :"man_with_gua_pi_mao"             => [0x1F472],
    :"man_with_turban"                 => [0x1F473],
    :"mans_shoe"                       => [0x1F45E],
    :"maple_leaf"                      => [0x1F341],
    :"mask"                            => [0x1F637],
    :"massage"                         => [0x1F486],
    :"meat_on_bone"                    => [0x1F356],
    :"mega"                            => [0x1F4E3],
    :"melon"                           => [0x1F348],
    :"memo"                            => [0x1F4DD],
    :"mens"                            => [0x1F6B9],
    # "metal"                         => nil,
    :"metro"                           => [0x1F687],
    :"microphone"                      => [0x1F3A4],
    :"microscope"                      => [0x1F52C],
    :"milky_way"                       => [0x1F30C],
    :"minibus"                         => [0x1F690],
    :"minidisc"                        => [0x1F4BD],
    :"mobile_phone_off"                => [0x1F4F4],
    :"money_with_wings"                => [0x1F4B8],
    :"moneybag"                        => [0x1F4B0],
    :"monkey"                          => [0x1F412],
    :"monkey_face"                     => [0x1F435],
    :"monorail"                        => [0x1F69D],
    :"moon"                            => [0x1F314],
    :"mortar_board"                    => [0x1F393],
    :"mount_fuji"                      => [0x1F5FB],
    :"mountain_bicyclist"              => [0x1F6B5],
    :"mountain_cableway"               => [0x1F6A0],
    :"mountain_railway"                => [0x1F69E],
    :"mouse"                           => [0x1F42D],
    :"mouse2"                          => [0x1F401],
    :"movie_camera"                    => [0x1F3A5],
    :"moyai"                           => [0x1F5FF],
    :"muscle"                          => [0x1F4AA],
    :"mushroom"                        => [0x1F344],
    :"musical_keyboard"                => [0x1F3B9],
    :"musical_note"                    => [0x1F3B5],
    :"musical_score"                   => [0x1F3BC],
    :"mute"                            => [0x1F507],
    :"nail_care"                       => [0x1F485],
    :"name_badge"                      => [0x1F4DB],
    # "neckbeard"                     => nil,
    :"necktie"                         => [0x1F454],
    :"negative_squared_cross_mark"     => [0x274E],
    :"neutral_face"                    => [0x1F610],
    :"new"                             => [0x1F195],
    :"new_moon"                        => [0x1F311],
    :"new_moon_with_face"              => [0x1F31A],
    :"newspaper"                       => [0x1F4F0],
    :"ng"                              => [0x1F196],
    :"night_with_stars"                => [0x1F303],
    :"nine"                            => [0x39, 0xFE0F, 0x20E3],
    :"no_bell"                         => [0x1F515],
    :"no_bicycles"                     => [0x1F6B3],
    :"no_entry"                        => [0x26D4, 0xFE0F],
    :"no_entry_sign"                   => [0x1F6AB],
    :"no_good"                         => [0x1F645],
    :"no_mobile_phones"                => [0x1F4F5],
    :"no_mouth"                        => [0x1F636],
    :"no_pedestrians"                  => [0x1F6B7],
    :"no_smoking"                      => [0x1F6AD],
    :"non-potable_water"               => [0x1F6B1],
    :"nose"                            => [0x1F443],
    :"notebook"                        => [0x1F4D3],
    :"notebook_with_decorative_cover"  => [0x1F4D4],
    :"notes"                           => [0x1F3B6],
    :"nut_and_bolt"                    => [0x1F529],
    :"o"                               => [0x2B55, 0xFE0F],
    :"o2"                              => [0x1F17E],
    :"ocean"                           => [0x1F30A],
    # "octocat"                       => nil,
    :"octopus"                         => [0x1F419],
    :"oden"                            => [0x1F362],
    :"office"                          => [0x1F3E2],
    :"ok"                              => [0x1F197],
    :"ok_hand"                         => [0x1F44C],
    :"ok_woman"                        => [0x1F646],
    :"older_man"                       => [0x1F474],
    :"older_woman"                     => [0x1F475],
    :"on"                              => [0x1F51B],
    :"oncoming_automobile"             => [0x1F698],
    :"oncoming_bus"                    => [0x1F68D],
    :"oncoming_police_car"             => [0x1F694],
    :"oncoming_taxi"                   => [0x1F696],
    :"one"                             => [0x31, 0xFE0F, 0x20E3],
    :"open_book"                       => [0x1F4D6],
    :"open_file_folder"                => [0x1F4C2],
    :"open_hands"                      => [0x1F450],
    :"open_mouth"                      => [0x1F62E],
    :"ophiuchus"                       => [0x26CE],
    :"orange_book"                     => [0x1F4D9],
    :"outbox_tray"                     => [0x1F4E4],
    :"ox"                              => [0x1F402],
    :"package"                         => [0x1F4E6],
    :"page_facing_up"                  => [0x1F4C4],
    :"page_with_curl"                  => [0x1F4C3],
    :"pager"                           => [0x1F4DF],
    :"palm_tree"                       => [0x1F334],
    :"panda_face"                      => [0x1F43C],
    :"paperclip"                       => [0x1F4CE],
    :"parking"                         => [0x1F17F, 0xFE0F],
    :"part_alternation_mark"           => [0x303D, 0xFE0F],
    :"partly_sunny"                    => [0x26C5, 0xFE0F],
    :"passport_control"                => [0x1F6C2],
    :"paw_prints"                      => [0x1F43E],
    :"peach"                           => [0x1F351],
    :"pear"                            => [0x1F350],
    :"pencil"                          => [0x1F4DD],
    :"pencil2"                         => [0x270F, 0xFE0F],
    :"penguin"                         => [0x1F427],
    :"pensive"                         => [0x1F614],
    :"performing_arts"                 => [0x1F3AD],
    :"persevere"                       => [0x1F623],
    :"person_frowning"                 => [0x1F64D],
    :"person_with_blond_hair"          => [0x1F471],
    :"person_with_pouting_face"        => [0x1F64E],
    :"phone"                           => [0x260E, 0xFE0F],
    :"pig"                             => [0x1F437],
    :"pig2"                            => [0x1F416],
    :"pig_nose"                        => [0x1F43D],
    :"pill"                            => [0x1F48A],
    :"pineapple"                       => [0x1F34D],
    :"pisces"                          => [0x2653, 0xFE0F],
    :"pizza"                           => [0x1F355],
    :"point_down"                      => [0x1F447],
    :"point_left"                      => [0x1F448],
    :"point_right"                     => [0x1F449],
    :"point_up"                        => [0x261D, 0xFE0F],
    :"point_up_2"                      => [0x1F446],
    :"police_car"                      => [0x1F693],
    :"poodle"                          => [0x1F429],
    :"poop"                            => [0x1F4A9],
    :"post_office"                     => [0x1F3E3],
    :"postal_horn"                     => [0x1F4EF],
    :"postbox"                         => [0x1F4EE],
    :"potable_water"                   => [0x1F6B0],
    :"pouch"                           => [0x1F45D],
    :"poultry_leg"                     => [0x1F357],
    :"pound"                           => [0x1F4B7],
    :"pouting_cat"                     => [0x1F63E],
    :"pray"                            => [0x1F64F],
    :"princess"                        => [0x1F478],
    :"punch"                           => [0x1F44A],
    :"purple_heart"                    => [0x1F49C],
    :"purse"                           => [0x1F45B],
    :"pushpin"                         => [0x1F4CC],
    :"put_litter_in_its_place"         => [0x1F6AE],
    :"question"                        => [0x2753],
    :"rabbit"                          => [0x1F430],
    :"rabbit2"                         => [0x1F407],
    :"racehorse"                       => [0x1F40E],
    :"radio"                           => [0x1F4FB],
    :"radio_button"                    => [0x1F518],
    :"rage"                            => [0x1F621],
    # "rage1"                         => nil,
    # "rage2"                         => nil,
    # "rage3"                         => nil,
    # "rage4"                         => nil,
    :"railway_car"                     => [0x1F683],
    :"rainbow"                         => [0x1F308],
    :"raised_hand"                     => [0x270B],
    :"raised_hands"                    => [0x1F64C],
    :"raising_hand"                    => [0x1F64B],
    :"ram"                             => [0x1F40F],
    :"ramen"                           => [0x1F35C],
    :"rat"                             => [0x1F400],
    :"recycle"                         => [0x267B, 0xFE0F],
    :"red_car"                         => [0x1F697],
    :"red_circle"                      => [0x1F534],
    :"registered"                      => [0xAE],
    :"relaxed"                         => [0x263A, 0xFE0F],
    :"relieved"                        => [0x1F60C],
    :"repeat"                          => [0x1F501],
    :"repeat_one"                      => [0x1F502],
    :"restroom"                        => [0x1F6BB],
    :"revolving_hearts"                => [0x1F49E],
    :"rewind"                          => [0x23EA],
    :"ribbon"                          => [0x1F380],
    :"rice"                            => [0x1F35A],
    :"rice_ball"                       => [0x1F359],
    :"rice_cracker"                    => [0x1F358],
    :"rice_scene"                      => [0x1F391],
    :"ring"                            => [0x1F48D],
    :"rocket"                          => [0x1F680],
    :"roller_coaster"                  => [0x1F3A2],
    :"rooster"                         => [0x1F413],
    :"rose"                            => [0x1F339],
    :"rotating_light"                  => [0x1F6A8],
    :"round_pushpin"                   => [0x1F4CD],
    :"rowboat"                         => [0x1F6A3],
    :"ru"                              => [0x1F1F7, 0x1F1FA],
    :"rugby_football"                  => [0x1F3C9],
    :"runner"                          => [0x1F3C3],
    :"running"                         => [0x1F3C3],
    :"running_shirt_with_sash"         => [0x1F3BD],
    :"sa"                              => [0x1F202],
    :"sagittarius"                     => [0x2650, 0xFE0F],
    :"sailboat"                        => [0x26F5, 0xFE0F],
    :"sake"                            => [0x1F376],
    :"sandal"                          => [0x1F461],
    :"santa"                           => [0x1F385],
    :"satellite"                       => [0x1F4E1],
    :"satisfied"                       => [0x1F606],
    :"saxophone"                       => [0x1F3B7],
    :"school"                          => [0x1F3EB],
    :"school_satchel"                  => [0x1F392],
    :"scissors"                        => [0x2702, 0xFE0F],
    :"scorpius"                        => [0x264F, 0xFE0F],
    :"scream"                          => [0x1F631],
    :"scream_cat"                      => [0x1F640],
    :"scroll"                          => [0x1F4DC],
    :"seat"                            => [0x1F4BA],
    :"secret"                          => [0x3299, 0xFE0F],
    :"see_no_evil"                     => [0x1F648],
    :"seedling"                        => [0x1F331],
    :"seven"                           => [0x37, 0xFE0F, 0x20E3],
    :"shaved_ice"                      => [0x1F367],
    :"sheep"                           => [0x1F411],
    :"shell"                           => [0x1F41A],
    :"ship"                            => [0x1F6A2],
    # "shipit"                        => nil,
    :"shirt"                           => [0x1F455],
    :"shit"                            => [0x1F4A9],
    :"shoe"                            => [0x1F45E],
    :"shower"                          => [0x1F6BF],
    :"signal_strength"                 => [0x1F4F6],
    :"six"                             => [0x36, 0xFE0F, 0x20E3],
    :"six_pointed_star"                => [0x1F52F],
    :"ski"                             => [0x1F3BF],
    :"skull"                           => [0x1F480],
    :"sleeping"                        => [0x1F634],
    :"sleepy"                          => [0x1F62A],
    :"slot_machine"                    => [0x1F3B0],
    :"small_blue_diamond"              => [0x1F539],
    :"small_orange_diamond"            => [0x1F538],
    :"small_red_triangle"              => [0x1F53A],
    :"small_red_triangle_down"         => [0x1F53B],
    :"smile"                           => [0x1F604],
    :"smile_cat"                       => [0x1F638],
    :"smiley"                          => [0x1F603],
    :"smiley_cat"                      => [0x1F63A],
    :"smiling_imp"                     => [0x1F608],
    :"smirk"                           => [0x1F60F],
    :"smirk_cat"                       => [0x1F63C],
    :"smoking"                         => [0x1F6AC],
    :"snail"                           => [0x1F40C],
    :"snake"                           => [0x1F40D],
    :"snowboarder"                     => [0x1F3C2],
    :"snowflake"                       => [0x2744, 0xFE0F],
    :"snowman"                         => [0x26C4, 0xFE0F],
    :"sob"                             => [0x1F62D],
    :"soccer"                          => [0x26BD, 0xFE0F],
    :"soon"                            => [0x1F51C],
    :"sos"                             => [0x1F198],
    :"sound"                           => [0x1F509],
    :"space_invader"                   => [0x1F47E],
    :"spades"                          => [0x2660, 0xFE0F],
    :"spaghetti"                       => [0x1F35D],
    :"sparkle"                         => [0x2747, 0xFE0F],
    :"sparkler"                        => [0x1F387],
    :"sparkles"                        => [0x2728],
    :"sparkling_heart"                 => [0x1F496],
    :"speak_no_evil"                   => [0x1F64A],
    :"speaker"                         => [0x1F508],
    :"speech_balloon"                  => [0x1F4AC],
    :"speedboat"                       => [0x1F6A4],
    # "squirrel"                      => nil,
    :"star"                            => [0x2B50, 0xFE0F],
    :"star2"                           => [0x1F31F],
    :"stars"                           => [0x1F320],
    :"station"                         => [0x1F689],
    :"statue_of_liberty"               => [0x1F5FD],
    :"steam_locomotive"                => [0x1F682],
    :"stew"                            => [0x1F372],
    :"straight_ruler"                  => [0x1F4CF],
    :"strawberry"                      => [0x1F353],
    :"stuck_out_tongue"                => [0x1F61B],
    :"stuck_out_tongue_closed_eyes"    => [0x1F61D],
    :"stuck_out_tongue_winking_eye"    => [0x1F61C],
    :"sun_with_face"                   => [0x1F31E],
    :"sunflower"                       => [0x1F33B],
    :"sunglasses"                      => [0x1F60E],
    :"sunny"                           => [0x2600, 0xFE0F],
    :"sunrise"                         => [0x1F305],
    :"sunrise_over_mountains"          => [0x1F304],
    :"surfer"                          => [0x1F3C4],
    :"sushi"                           => [0x1F363],
    # "suspect"                       => nil,
    :"suspension_railway"              => [0x1F69F],
    :"sweat"                           => [0x1F613],
    :"sweat_drops"                     => [0x1F4A6],
    :"sweat_smile"                     => [0x1F605],
    :"sweet_potato"                    => [0x1F360],
    :"swimmer"                         => [0x1F3CA],
    :"symbols"                         => [0x1F523],
    :"syringe"                         => [0x1F489],
    :"tada"                            => [0x1F389],
    :"tanabata_tree"                   => [0x1F38B],
    :"tangerine"                       => [0x1F34A],
    :"taurus"                          => [0x2649, 0xFE0F],
    :"taxi"                            => [0x1F695],
    :"tea"                             => [0x1F375],
    :"telephone"                       => [0x260E, 0xFE0F],
    :"telephone_receiver"              => [0x1F4DE],
    :"telescope"                       => [0x1F52D],
    :"tennis"                          => [0x1F3BE],
    :"tent"                            => [0x26FA, 0xFE0F],
    :"thought_balloon"                 => [0x1F4AD],
    :"three"                           => [0x33, 0xFE0F, 0x20E3],
    :"thumbsdown"                      => [0x1F44E],
    :"thumbsup"                        => [0x1F44D],
    :"ticket"                          => [0x1F3AB],
    :"tiger"                           => [0x1F42F],
    :"tiger2"                          => [0x1F405],
    :"tired_face"                      => [0x1F62B],
    :"tm"                              => [0x2122],
    :"toilet"                          => [0x1F6BD],
    :"tokyo_tower"                     => [0x1F5FC],
    :"tomato"                          => [0x1F345],
    :"tongue"                          => [0x1F445],
    :"top"                             => [0x1F51D],
    :"tophat"                          => [0x1F3A9],
    :"tractor"                         => [0x1F69C],
    :"traffic_light"                   => [0x1F6A5],
    :"train"                           => [0x1F68B],
    :"train2"                          => [0x1F686],
    :"tram"                            => [0x1F68A],
    :"triangular_flag_on_post"         => [0x1F6A9],
    :"triangular_ruler"                => [0x1F4D0],
    :"trident"                         => [0x1F531],
    :"triumph"                         => [0x1F624],
    :"trolleybus"                      => [0x1F68E],
    # "trollface"                     => nil,
    :"trophy"                          => [0x1F3C6],
    :"tropical_drink"                  => [0x1F379],
    :"tropical_fish"                   => [0x1F420],
    :"truck"                           => [0x1F69A],
    :"trumpet"                         => [0x1F3BA],
    :"tshirt"                          => [0x1F455],
    :"tulip"                           => [0x1F337],
    :"turtle"                          => [0x1F422],
    :"tv"                              => [0x1F4FA],
    :"twisted_rightwards_arrows"       => [0x1F500],
    :"two"                             => [0x32, 0xFE0F, 0x20E3],
    :"two_hearts"                      => [0x1F495],
    :"two_men_holding_hands"           => [0x1F46C],
    :"two_women_holding_hands"         => [0x1F46D],
    :"u5272"                           => [0x1F239],
    :"u5408"                           => [0x1F234],
    :"u55b6"                           => [0x1F23A],
    :"u6307"                           => [0x1F22F, 0xFE0F],
    :"u6708"                           => [0x1F237],
    :"u6709"                           => [0x1F236],
    :"u6e80"                           => [0x1F235],
    :"u7121"                           => [0x1F21A, 0xFE0F],
    :"u7533"                           => [0x1F238],
    :"u7981"                           => [0x1F232],
    :"u7a7a"                           => [0x1F233],
    :"uk"                              => [0x1F1EC, 0x1F1E7],
    :"umbrella"                        => [0x2614, 0xFE0F],
    :"unamused"                        => [0x1F612],
    :"underage"                        => [0x1F51E],
    :"unlock"                          => [0x1F513],
    :"up"                              => [0x1F199],
    :"us"                              => [0x1F1FA, 0x1F1F8],
    :"v"                               => [0x270C, 0xFE0F],
    :"vertical_traffic_light"          => [0x1F6A6],
    :"vhs"                             => [0x1F4FC],
    :"vibration_mode"                  => [0x1F4F3],
    :"video_camera"                    => [0x1F4F9],
    :"video_game"                      => [0x1F3AE],
    :"violin"                          => [0x1F3BB],
    :"virgo"                           => [0x264D, 0xFE0F],
    :"volcano"                         => [0x1F30B],
    :"vs"                              => [0x1F19A],
    :"walking"                         => [0x1F6B6],
    :"waning_crescent_moon"            => [0x1F318],
    :"waning_gibbous_moon"             => [0x1F316],
    :"warning"                         => [0x26A0, 0xFE0F],
    :"watch"                           => [0x231A, 0xFE0F],
    :"water_buffalo"                   => [0x1F403],
    :"watermelon"                      => [0x1F349],
    :"wave"                            => [0x1F44B],
    :"wavy_dash"                       => [0x3030],
    :"waxing_crescent_moon"            => [0x1F312],
    :"waxing_gibbous_moon"             => [0x1F314],
    :"wc"                              => [0x1F6BE],
    :"weary"                           => [0x1F629],
    :"wedding"                         => [0x1F492],
    :"whale"                           => [0x1F433],
    :"whale2"                          => [0x1F40B],
    :"wheelchair"                      => [0x267F, 0xFE0F],
    :"white_check_mark"                => [0x2705],
    :"white_circle"                    => [0x26AA, 0xFE0F],
    :"white_flower"                    => [0x1F4AE],
    :"white_large_square"              => [0x2B1C, 0xFE0F],
    :"white_medium_small_square"       => [0x25FD, 0xFE0F],
    :"white_medium_square"             => [0x25FB, 0xFE0F],
    :"white_small_square"              => [0x25AB, 0xFE0F],
    :"white_square_button"             => [0x1F533],
    :"wind_chime"                      => [0x1F390],
    :"wine_glass"                      => [0x1F377],
    :"wink"                            => [0x1F609],
    :"wolf"                            => [0x1F43A],
    :"woman"                           => [0x1F469],
    :"womans_clothes"                  => [0x1F45A],
    :"womans_hat"                      => [0x1F452],
    :"womens"                          => [0x1F6BA],
    :"worried"                         => [0x1F61F],
    :"wrench"                          => [0x1F527],
    :"x"                               => [0x274C],
    :"yellow_heart"                    => [0x1F49B],
    :"yen"                             => [0x1F4B4],
    :"yum"                             => [0x1F60B],
    :"zap"                             => [0x26A1, 0xFE0F],
    :"zero"                            => [0x30, 0xFE0F, 0x20E3],
    :"zzz"                             => [0x1F4A4]
  }.freeze
end
