= Font
* ((< Font drawing outline>))
* ((<SDL::TTF>))
* ((<SDL::BMFont>))
* ((<SDL::Kanji>))
* Font methods
  * ((<SDL::TTF.init>)) -- Initialize TTF APIs
  * ((<SDL::TTF.init?>)) -- Query TTF API initialization status
  * ((<SDL::TTF.open>)) -- Load font From a file
  * ((<SDL::TTF#close>)) -- Closes a font
  * ((<SDL::TTF#closed?>)) -- Returns whether a font is closed or not
  * ((<SDL::TTF#style>)) -- Get font render style
  * ((<SDL::TTF#style=>)) -- Set the rendering style.
  * ((<SDL::TTF#height>)) -- Get font max height
  * ((<SDL::TTF#ascent>)) -- Get font max ascent (y above origin)
  * ((<SDL::TTF#descent>)) -- Get font min descent (y below origin)
  * ((<SDL::TTF#line_skip>)) -- Get font recommended line spacing
  * ((<SDL::TTF#faces>)) -- Get the number of faces in a font
  * ((<SDL::TTF#fixed_width?>)) -- Get whether font is monospaced or not.
  * ((<SDL::TTF#family_name>)) -- Get current font face family name string
  * ((<SDL::TTF#style_name>)) -- Get current font face style name string
  * ((<SDL::TTF#text_size>)) -- Get size of text string as would be rendered
  * ((<SDL::TTF#render_solid_utf8>)) -- Render UTF8 text in solid mode
  * ((<SDL::TTF#render_shaded_utf8>)) -- Render UTF8 text in shaded mode
  * ((<SDL::TTF#render_blended_utf8>)) -- Render UTF8 text in blended mode
  * ((<SDL::TTF#draw_solid_utf8>)) -- Draw UTF8 text in solid mode
  * ((<SDL::TTF#draw_shaded_utf8>)) -- Draw UTF8 text in shaded mode
  * ((<SDL::TTF#draw_blended_utf8>)) -- Draw UTF8 text in blended mode
  * ((<SDL::BMFont.open>)) -- Load a bitmap font from file
  * ((<SDL::BMFont#close>)) -- Closes a font.
  * ((<SDL::BMFont#closed?>)) -- Returns whether a font is closed.
  * ((<SDL::BMFont#set_color>)) -- Change font color
  * ((<SDL::BMFont#height>)) -- Get height of the font
  * ((<SDL::BMFont#width>)) -- Get width of one character in the font
  * ((<SDL::BMFont#text_size>)) -- Get the size of surface needed
  * ((<SDL::BMFont#textout>)) -- Render the given string
  * ((<SDL::Kanji.open>)) -- Load bdf font file
  * ((<SDL::Kanji#close>)) -- Closes bdf font data
  * ((<SDL::Kanji#closed?>)) -- Returns whether bdf font is closed
  * ((<SDL::Kanji#add>)) -- Add font data into already loaded font
  * ((<SDL::Kanji#set_coding_system>)) -- Set character encoding
  * ((<SDL::Kanji#get_coding_system>)) -- Get character encoding
  * ((<SDL::Kanji#height>)) -- Get height of one character
  * ((<SDL::Kanji#textwidth>)) -- Get width of given string
  * ((<SDL::Kanji#width>)) -- Get the width of one character
  * ((<SDL::Kanji#put>)) -- Render text
  * ((<SDL::Kanji#put_tate>)) -- Render tategaki text

== Font drawing outline
Ruby/SDL has three different font drawing system.
First is True Type Font drawing by
((<SDL_ttf|URL:http://www.libsdl.org/projects/SDL_ttf/index.html>)),
second is original bitmap font/SFont drawing by
((<SGE|URL:http://www.etek.chalmers.se/~e8cal1/sge/index.html>)),
and the last is bdf font drawing by
((<SDL_kanji|URL:http://shinh.skr.jp/sdlkanji/>)).

Each system has following features. 
* SDL::TTF

  Extension name of Font file name is ttf and ttc.
  True type font has vector data, therefore you can use arbitrary font size.
  
* SDL::BMFont

  Font files are mere Windows BMP files or PNG image files.
  In original font file format, image data is regarded as 256 character
  images ordered by ASCII.
  Creating your own fonts is more easy than true type fonts.

  You can use ((<SFont|URL:http://www.linux-games.com/sfont/>))
  with this class. This format is also bitmap font, but character width
  is variable.

  You can't use kanji and other Unicode characters.

* SDL::Kanji

  Font files are BDF format. BDF is a kind of bitmap font.
  You can mix multiple font files (for example, alphabet and kanji).

== SDL::TTF
* ((<SDL::TTF.init>)) -- Initialize TTF APIs
* ((<SDL::TTF.init?>)) -- Query TTF API initialization status
* ((<SDL::TTF.open>)) -- Load font From a file
* ((<SDL::TTF#close>)) -- Closes a font
* ((<SDL::TTF#closed?>)) -- Returns whether a font is closed or not
* ((<SDL::TTF#style>)) -- Get font render style
* ((<SDL::TTF#style=>)) -- Set the rendering style.
* ((<SDL::TTF#height>)) -- Get font max height
* ((<SDL::TTF#ascent>)) -- Get font max ascent (y above origin)
* ((<SDL::TTF#descent>)) -- Get font min descent (y below origin)
* ((<SDL::TTF#line_skip>)) -- Get font recommended line spacing
* ((<SDL::TTF#faces>)) -- Get the number of faces in a font
* ((<SDL::TTF#fixed_width?>)) -- Get whether font is monospaced or not.
* ((<SDL::TTF#family_name>)) -- Get current font face family name string
* ((<SDL::TTF#style_name>)) -- Get current font face style name string
* ((<SDL::TTF#text_size>)) -- Get size of text string as would be rendered
* ((<SDL::TTF#render_solid_utf8>)) -- Render UTF8 text in solid mode
* ((<SDL::TTF#render_shaded_utf8>)) -- Render UTF8 text in shaded mode
* ((<SDL::TTF#render_blended_utf8>)) -- Render UTF8 text in blended mode
* ((<SDL::TTF#draw_solid_utf8>)) -- Draw UTF8 text in solid mode
* ((<SDL::TTF#draw_shaded_utf8>)) -- Draw UTF8 text in shaded mode
* ((<SDL::TTF#draw_blended_utf8>)) -- Draw UTF8 text in blended mode

This class represents true type font. 
((<SDL_ttf|URL:http://www.libsdl.org/projects/SDL_ttf/index.html>))
is needed to use this class. Backend of SDL_ttf is 
((<Freetype|URL:http://www.freetype.org/>)).

Note that you should pay attention to font license.

== SDL::BMFont
* ((<SDL::BMFont.open>)) -- Load a bitmap font from file
* ((<SDL::BMFont#close>)) -- Closes a font.
* ((<SDL::BMFont#closed?>)) -- Returns whether a font is closed.
* ((<SDL::BMFont#set_color>)) -- Change font color
* ((<SDL::BMFont#height>)) -- Get height of the font
* ((<SDL::BMFont#width>)) -- Get width of one character in the font
* ((<SDL::BMFont#text_size>)) -- Get the size of surface needed
* ((<SDL::BMFont#textout>)) -- Render the given string

This class represets bitmap font. 
((<SGE|URL:http://www.etek.chalmers.se/~e8cal1/sge/index.html>))
is needed.

== SDL::Kanji
* ((<SDL::Kanji.open>)) -- Load bdf font file
* ((<SDL::Kanji#close>)) -- Closes bdf font data
* ((<SDL::Kanji#closed?>)) -- Returns whether bdf font is closed
* ((<SDL::Kanji#add>)) -- Add font data into already loaded font
* ((<SDL::Kanji#set_coding_system>)) -- Set character encoding
* ((<SDL::Kanji#get_coding_system>)) -- Get character encoding
* ((<SDL::Kanji#height>)) -- Get height of one character
* ((<SDL::Kanji#textwidth>)) -- Get width of given string
* ((<SDL::Kanji#width>)) -- Get the width of one character
* ((<SDL::Kanji#put>)) -- Render text
* ((<SDL::Kanji#put_tate>)) -- Render tategaki text

This class represets bdf font. 

== Font methods

--- SDL::TTF.init

    Initialize the truetype font API. This must be called before using other methods
    of this class, excepting ((<SDL::TTF.init?>)).
    ((<SDL.init>)) does not have to be called before this call.


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF.init?>))

--- SDL::TTF.init?

    Returns true if TTF API is already initialize, otherwise returns false.


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF.init>))

--- SDL::TTF.open(filename, ptsize, index=0)

    Load ((|filename|)), face ((|index|)), for use as a font, at ((|ptsize|)) size.

    Returns new ((<SDL::TTF>)) object.

    Raises ((<SDL::Error>)) on failure

    You need SDL_ttf to use this method.

    EXAMPLE
      SDL::TTF.init
      font = SDL::TTF.open("font.ttf", 32, 0)

--- SDL::TTF#close

    Closes a font and free related resources.


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF#closed?>))

--- SDL::TTF#closed?

    Returns whether a font is closed by ((<SDL::TTF#close>))


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF#close>))

--- SDL::TTF#style

    Returns the rendering style as a bitmask composed of the follwing masks:
    * SDL::TTF::STYLE_BOLD
    * SDL::TTF::STYLE_ITALIC
    * SDL::TTF::STYLE_UNDERLINE
    If no style is set then SDL::TTF::STYLE_NORMAL is returned.


    You need SDL_ttf to use this method.

    EXAMPLE
      print "The font style is:"
      
      print " normal" if font.style == SDL::TTF::STYLE_NORMAL
      print " bold" if (font.style & SDL::TTF::STYLE_BOLD) != 0
      print " italic" if (font.style & SDL::TTF::STYLE_ITALIC) != 0
      print " italic" if (font.style & SDL::TTF::STYLE_UNDERLINE) != 0
      
      print "\n"

    * See Also
      
      ((<SDL::TTF#style=>))

--- SDL::TTF#style=(new_style)

    Set the rendering style as ((|new_style|)).
    ((|new_style|)) should be a bitmask composed of the follwing masks:
    * SDL::TTF::STYLE_BOLD
    * SDL::TTF::STYLE_ITALIC
    * SDL::TTF::STYLE_UNDERLINE
    or SDL::TTF::STYLE_NORMAL to reset style.


    You need SDL_ttf to use this method.

    EXAMPLE
      # set the loaded font's style to fake bold italics
      font.style = SDL::TTF::STYLE_ITALIC | SDL::TTF::STYLE_BOLD
      
      # render some text in fake bold italics...
      
      # set the loaded font's style back to normal
      font.style = SDL::TTF::STYLE_NORMAL

    * NOTES

      This will flush the internal cache of previously rendered glyphs, even if
      there is no change in style, so it may be best to check the current style using 
      ((<SDL::TTF.style>)) first.

    * See Also
      
      ((<SDL::TTF#style>))

--- SDL::TTF#height

    Returns the maximum pixel height of all glyphs of the font. You may use this
    height for rendering text as close together vertically as possible, though adding
    at least one pixel height to it will space it so they can't touch. Remember that
    Ruby/SDL and SDL_ttf doesn't handle multiline
    printing, so you are responsible for line
    spacing, see the ((<SDL::TTF#line_skip>)) as well.


    You need SDL_ttf to use this method.
--- SDL::TTF#ascent

    Get the maximum pixel ascent (height above baseline)
    of all glyphs of the loaded font. This can also be
    interpreted as the distance from the top of the font to the baseline. It could be
    used when drawing an individual glyph relative to a top point, by combining it
    with the glyph's maxy metric to resolve the top of the rectangle used when
    blitting the glyph on the screen.


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF#height>)), ((<SDL::TTF#descent>)), ((<SDL::TTF#line_skip>))

--- SDL::TTF#descent

    Get the maximum pixel descent (height below baseline)
    of all glyphs of the loaded font. This can also be
    interpreted as the distance from the baseline to the bottom of the font. It could
    be used when drawing an individual glyph relative to a bottom point, by combining
    it with the glyph's maxy metric to resolve the top of the rectangle used when
    blitting the glyph on the screen.


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF#height>)), ((<SDL::TTF#ascent>)), ((<SDL::TTF#line_skip>))

--- SDL::TTF#line_skip

    Get the reccomended pixel height of a rendered line of text of the loaded font.
    This is usually larger than the ((<SDL::TTF#height>)) of the font.


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF#height>)), ((<SDL::TTF#ascent>)), ((<SDL::TTF#descent>))

--- SDL::TTF#faces

    Returns the number of faces(subfonts) in a font.


    You need SDL_ttf to use this method.
--- SDL::TTF#fixed_width?

    Returns true if ((|self|)) font is monospaced, otherwise returns false.
    If font is monospaced, width of the rendered surface is
    (width)*(length of string).


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF#faces>)), ((<SDL::TTF#family_name>))

--- SDL::TTF#family_name
--- SDL::TTF#familyName

    Returns current font face family name string.
    Returns nil if that font has no name information.


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF#faces>)), ((<SDL::TTF#fixed_width?>)), ((<SDL::TTF#style_name>))

--- SDL::TTF#style_name
--- SDL::TTF#styleName

    Returns current font face style name string.
    Returns nil if the font has no name information.


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF#faces>)), ((<SDL::TTF#fixed_width?>)), ((<SDL::TTF#family_name>))

--- SDL::TTF#text_size(text)
--- SDL::TTF#textSize(text)

    Calculate the resulting surface size of the UTF8 encoded text rendered using font.
    No actual rendering is done, however correct kerning is done to get the actual
    width. The height returned in h is the same as you can get using ((<SDL::TTF#height>)).

    Returns a 2 element array as [w, h].

    Raises ((<SDL::Error>)) on failure

    You need SDL_ttf to use this method.

    EXAMPLE
      w, h = font.size_text("Hello World!")
      puts "width=#{w} height=#{h}"

    * NOTES

      If Ruby/SDL m17n support is enabled, 
      ((|text|)) will be converted to suitable encoding.

    * See Also
      
      ((<SDL::TTF#render_solid_utf8>)), ((<SDL::TTF#render_shaded_utf8>)), ((<SDL::TTF#render_blended_utf8>)), ((<SDL::TTF#draw_solid_utf8>)), ((<SDL::TTF#draw_shaded_utf8>)), ((<SDL::TTF#draw_blended_utf8>))

--- SDL::TTF#render_solid_utf8(text, r, g, b)
--- SDL::TTF#renderSolidUTF8(text, r, g, b)

    This method will render the given ((|text|)) with the given font with
    (((|r|)), [g], ((|b|)))
    color onto a new surface. The Solid mode is used and this is the fastest.
    This method returns new ((<surface|SDL::Surface>)) object.
    
    This method create an 8-bit palettized
    surface and render the given text at fast quality
    with the given font and color. The 0 pixel value is the colorkey, giving a
    transparent background, and the 1 pixel value is set to the text color. The
    colormap is set to have the desired foreground color at index 1, this allows
    you to change the color without having to render the text again. Colormap
    index 0 is of course not drawn, since it is the colorkey, and thus
    transparent, though it's actual color is 255 minus each RGB component of the
    foreground. This is the fastest rendering speed of all the rendering modes.
    This results in no box around the text, but the text is not as smooth. The
    resulting surface should blit faster than
    the ((|Blended|TTF#render_blended_utf8|)) one. Use this mode for
    FPS and other fast changing updating text displays.


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF#render_shaded_utf8>)), ((<SDL::TTF#render_blended_utf8>)), ((<SDL::TTF#draw_solid_utf8>))

--- SDL::TTF#render_shaded_utf8(text,fg_r,fg_g,fg_b,bg_r,bg_g,bg_b)
--- SDL::TTF#renderShadedUTF8(text,fg_r,fg_g,fg_b,bg_r,bg_g,bg_b)

    This method will render the given ((|text|)) with the given font with
    (((|fg_r|)), [fg_g], ((|fg_b|))) color onto a new surface
    with background color (((|bg_r|)), [bg_g], ((|bg_b|))).
    Returns new ((<surface|SDL::Surface>)) object.
    
    This method create an 8-bit palettized
    surface and render the given text at high quality
    with the given font and colors. The 0 pixel value is background, while other
    pixels have varying degrees of the foreground color from the background color.
    This results in a box of the background color around the text in the
    foreground color. The text is antialiased.
    This will render slower than ((<Solid|SDL::TTF#render_solid_utf8>)),
    but in about the same time as ((<SDL::TTF#render_blended_utf8>)).
    The resulting surface should blit
    as fast as ((<Solid|SDL::TTF#render_solid_utf8>)), once it is made.
    Use this when you need nice text, and can
    live with a box...


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF#render_solid_utf8>)), ((<SDL::TTF#render_blended_utf8>)), ((<SDL::TTF#draw_shaded_utf8>))

--- SDL::TTF#render_blended_utf8(text, r, g, b)
--- SDL::TTF#render_blended_utf8(text, r, g, b)

    This method will render the given ((|text|)) with the given font with (((|r|)), [g], ((|b|)))
    color onto a new surface with transparent background. This is
    the slowest but most beautiful.
    
    This method creates a 32-bit ARGB surface and
    render the given text at high quality, using
    alpha blending to dither the font with the given color. This results in a
    surface with alpha transparency, so you don't have a solid colored box around
    the text. The text is antialiased.
    This will render slower than ((<SDL::TTF#render_solid_utf8>)), but in
    about the same time as ((<SDL::TTF#render_shaded_utf8>)).
    The resulting surface will blit slower
    than if you had used ((<SDL::TTF#render_solid_utf8>)) and ((<SDL::TTF#render_shaded_utf8>)).
    Use this when you want high quality, and the text isn't changing too fast.


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF#render_solid_utf8>)), ((<SDL::TTF#render_shaded_utf8>)), ((<SDL::TTF#draw_blended_utf8>))

--- SDL::TTF#draw_solid_utf8(dest, text, x, y, r, g, b)
--- SDL::TTF#drawSolidUTF8(dest, text, x, y, r, g, b)

    This method will draw the given ((|text|))
    with the given font with (((|r|)), [g], ((|b|)))
    onto ((|dest|)) ((<surface|SDL::Surface>)) at (((|x|)), ((|y|)))
    in ((<solid|SDL::TTF#render_solid_utf8>)) mode.


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF#draw_shaded_utf8>)), ((<SDL::TTF#draw_blended_utf8>)), ((<SDL::TTF#render_solid_utf8>))

--- SDL::TTF#draw_shaded_utf8(dest, text, x, y, fg_r, fg_g, fg_b, bg_r, bg_g, bg_b)
--- SDL::TTF#drawShadedUTF8(dest, text, x, y, fg_r, fg_g, fg_b, bg_r, bg_g, bg_b)

    This method will draw the given ((|text|))
    with the given font with (((|fg_r|)), [fg_g], ((|fg_b|)))
    color onto onto ((|dest|)) ((<surface|SDL::Surface>)) at (((|x|)), ((|y|)))
    with background color (((|bg_r|)), [bg_g], ((|bg_b|)))
    in ((<shaded|SDL::TTF#render_shaded_utf8>)) mode.


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF#draw_solid_utf8>)), ((<SDL::TTF#draw_blended_utf8>)), ((<SDL::TTF#render_shaded_utf8>))

--- SDL::TTF#draw_blended_utf8(dest, text, x, y, r, g, b)
--- SDL::TTF#drawBlendedUTF8(dest, text, x, y, r, g, b)

    This method will draw the given ((|text|))
    with the given font with (((|r|)), [g], ((|b|)))
    onto ((|dest|)) ((<surface|SDL::Surface>)) at (((|x|)), ((|y|)))
    in ((<blended|SDL::TTF#render_blended_utf8>)) mode.


    You need SDL_ttf to use this method.
    * See Also
      
      ((<SDL::TTF#draw_solid_utf8>)), ((<SDL::TTF#draw_shaded_utf8>)), ((<SDL::TTF#render_blended_utf8>))

--- SDL::BMFont.open(filename, flags)

    Load a bitmap font from ((|filename|)) file and
    returns new ((<SDL::BMFont>)) object.
    
    ((|flags|)) is OR'd combination of following values:
    :SDL::BMFont::TRANSPARENT
      Transparent (use ((<SDL::Surface#set_color_key>)) internally, should usually be set)
    :SDL::BMFont::NOCONVERT
      Don't ((<convert font surface to display format|SDL::Surface#display_format>))
      for faster blits.
    :SDL::BMFont::SFONT
      If you enabled support for SDL_img when compiling
      SGE you can also set this flag, this enables you to
      load Karl Bartel's SFont files.
    :SDL::BMFont::PALETTE
      Converts the font surface to a palette surface
      (8bit). Don't do this on color fonts or SFonts! Blits from the
      font surface will be a bit slower but ((<SDL::BMFont#set_color>))
      will be faster (O(1) instead of O(n^2)).


    You need SGE to use this method.
--- SDL::BMFont#close

    Closes a font and release the resources.


    You need SGE to use this method.
    * See Also
      
      ((<SDL::BMFont.open>)), ((<SDL::BMFont#closed?>))

--- SDL::BMFont#closed?

    Returns whether a font is closed by ((<SDL::BMFont#close>)).


    You need SGE to use this method.
    * See Also
      
      ((<SDL::BMFont#close>))

--- SDL::BMFont#set_color(r, g, b)
--- SDL::BMFont#setColor(r, g, b)

    Changes the color of the font to (((|r|)), ((|g|)), ((|b|))). 
    Doesn't work on 'color
    fonts' or SFonts. Use ((<SDL::BMFont::PALETTE>))
    when ((<opening|SDL::BMFont.open>)) the font if
    you're going to use this function often.


    You need SGE to use this method.
--- SDL::BMFont#height

    Returns height.


    You need SGE to use this method.
    * See Also
      
      ((<SDL::BMFont#width>))

--- SDL::BMFont#width

    Returns the width of one character in ((|self|)) font.
    Doesn't work on SFonts.


    You need SGE to use this method.
    * See Also
      
      ((<SDL::BMFont#height>))

--- SDL::BMFont#text_size(string)
--- SDL::BMFont#textSize(string)

    Returns the width and height of the ((|string|)) with ((|self|)).


    You need SGE to use this method.
    * See Also
      
      ((<SDL::BMFont#textout>))

--- SDL::BMFont#textout(surface, string, x, y)

    Renders the given ((|string|)) on surface with the given font. 
    (((|x|)), ((|y|))) is the position of the left top corner. 


    You need SGE to use this method.
    * See Also
      
      ((<SDL::BMFont#text_size>))

--- SDL::Kanji.open(filename, size)

    Load bdf font data from ((|filename|)) and 
    returns new ((<SDL::Kanji>)) obejct.
    ((|size|)) is the height of one character.

    * See Also
      
      ((<SDL::Kanji#add>))

--- SDL::Kanji#close

    Closes bdf font data and release
    the resouces and memories.

    * See Also
      
      ((<SDL::Kanji.open>)), ((<SDL::Kanji#closed?>))

--- SDL::Kanji#closed?

    Returns whether bdf font is closed by ((<SDL::Kanji#close>))

    * See Also
      
      ((<SDL::Kanji#close>))

--- SDL::Kanji#add(filename)

    Add font data fromt ((|filename|)) into already loaded font ((|self|)).
    This method combines two or more font files into one.

    * See Also
      
      ((<SDL::Kanji.open>))

--- SDL::Kanji#set_coding_system(sys)
--- SDL::Kanji#setCodingSystem(sys)

    Set encoding. ((|sys|)) is one of following:
    * SDL::Kanji::SJIS
    * SDL::Kanji::EUC
    * SDL::Kanji::JIS
    Default is SDL::Kanji::JIS.

    * See Also
      
      ((<SDL::Kanji#get_coding_system>))

--- SDL::Kanji#get_coding_system
--- SDL::Kanji#getCodingSystem

    Get encoding. A return value is one of following:
    * SDL::Kanji::SJIS
    * SDL::Kanji::EUC
    * SDL::Kanji::JIS
    Default is SDL::Kanji::JIS.

    * See Also
      
      ((<SDL::Kanji#set_coding_system>))

--- SDL::Kanji#height

    Returns the height of one character as piexel.

--- SDL::Kanji#textwidth(text)

    Get width of given ((|text|)) with ((|self|)) font.

    * See Also
      
      ((<SDL::Kanji#width>))

--- SDL::Kanji#width

    Returns the width of one character.

    * See Also
      
      ((<SDL::Kanji#textwidth>))

--- SDL::Kanji#put(surface, text, x, y, r, g, b)

    Renders ((|text|)) at (((|x|)), ((|y|))) in ((|surface|))
    with (((|r|)), ((|g|)), ((|b|))) color.

    * NOTES

      If Ruby/SDL m17n support is enabled, ((|text|)) 
      will be converted to suitable encoding.

    * See Also
      
      ((<SDL::Kanji#put_tate>)), ((<SDL::Kanji#set_coding_system>))

--- SDL::Kanji#put_tate(surface, x, y, r, g, b)
--- SDL::Kanji#putTate(surface, x, y, r, g, b)

    Renders ((|text|)) as tagetaki at (((|x|)), ((|y|))) in ((|surface|))
    with (((|r|)), ((|g|)), ((|b|))) color.
    
    `Half-width' character is not rendered.

    * NOTES

      If Ruby/SDL m17n support is enabled, ((|text|)) 
      will be converted to suitable encoding.

    * See Also
      
      ((<SDL::Kanji#put>)), ((<SDL::Kanji#set_coding_system>))

