/* automatically generated by rust-bindgen */

pub type va_list = __builtin_va_list;
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __int16_t = libc::c_short;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __int64_t = libc::c_long;
pub type __uint64_t = libc::c_ulong;
pub type csh = usize;
#[repr(u32)]
#[doc = " Architecture type"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum cs_arch {
    #[doc = "< ARM architecture (including Thumb, Thumb-2)"]
    CS_ARCH_ARM = 0,
    #[doc = "< ARM-64, also called AArch64"]
    CS_ARCH_ARM64 = 1,
    #[doc = "< Mips architecture"]
    CS_ARCH_MIPS = 2,
    #[doc = "< X86 architecture (including x86 & x86-64)"]
    CS_ARCH_X86 = 3,
    #[doc = "< PowerPC architecture"]
    CS_ARCH_PPC = 4,
    #[doc = "< Sparc architecture"]
    CS_ARCH_SPARC = 5,
    #[doc = "< SystemZ architecture"]
    CS_ARCH_SYSZ = 6,
    #[doc = "< XCore architecture"]
    CS_ARCH_XCORE = 7,
    #[doc = "< 68K architecture"]
    CS_ARCH_M68K = 8,
    #[doc = "< TMS320C64x architecture"]
    CS_ARCH_TMS320C64X = 9,
    #[doc = "< 680X architecture"]
    CS_ARCH_M680X = 10,
    #[doc = "< Ethereum architecture"]
    CS_ARCH_EVM = 11,
    CS_ARCH_MAX = 12,
    CS_ARCH_ALL = 65535,
}
#[doc = "< little-endian mode (default mode)"]
pub const CS_MODE_LITTLE_ENDIAN: cs_mode = cs_mode(0);
#[doc = "< 32-bit ARM"]
pub const CS_MODE_ARM: cs_mode = cs_mode(0);
#[doc = "< 16-bit mode (X86)"]
pub const CS_MODE_16: cs_mode = cs_mode(2);
#[doc = "< 32-bit mode (X86)"]
pub const CS_MODE_32: cs_mode = cs_mode(4);
#[doc = "< 64-bit mode (X86, PPC)"]
pub const CS_MODE_64: cs_mode = cs_mode(8);
#[doc = "< ARM's Thumb mode, including Thumb-2"]
pub const CS_MODE_THUMB: cs_mode = cs_mode(16);
#[doc = "< ARM's Cortex-M series"]
pub const CS_MODE_MCLASS: cs_mode = cs_mode(32);
#[doc = "< ARMv8 A32 encodings for ARM"]
pub const CS_MODE_V8: cs_mode = cs_mode(64);
#[doc = "< MicroMips mode (MIPS)"]
pub const CS_MODE_MICRO: cs_mode = cs_mode(16);
#[doc = "< Mips III ISA"]
pub const CS_MODE_MIPS3: cs_mode = cs_mode(32);
#[doc = "< Mips32r6 ISA"]
pub const CS_MODE_MIPS32R6: cs_mode = cs_mode(64);
#[doc = "< Mips II ISA"]
pub const CS_MODE_MIPS2: cs_mode = cs_mode(128);
#[doc = "< SparcV9 mode (Sparc)"]
pub const CS_MODE_V9: cs_mode = cs_mode(16);
#[doc = "< Quad Processing eXtensions mode (PPC)"]
pub const CS_MODE_QPX: cs_mode = cs_mode(16);
#[doc = "< M68K 68000 mode"]
pub const CS_MODE_M68K_000: cs_mode = cs_mode(2);
#[doc = "< M68K 68010 mode"]
pub const CS_MODE_M68K_010: cs_mode = cs_mode(4);
#[doc = "< M68K 68020 mode"]
pub const CS_MODE_M68K_020: cs_mode = cs_mode(8);
#[doc = "< M68K 68030 mode"]
pub const CS_MODE_M68K_030: cs_mode = cs_mode(16);
#[doc = "< M68K 68040 mode"]
pub const CS_MODE_M68K_040: cs_mode = cs_mode(32);
#[doc = "< M68K 68060 mode"]
pub const CS_MODE_M68K_060: cs_mode = cs_mode(64);
#[doc = "< big-endian mode"]
pub const CS_MODE_BIG_ENDIAN: cs_mode = cs_mode(-2147483648);
#[doc = "< Mips32 ISA (Mips)"]
pub const CS_MODE_MIPS32: cs_mode = cs_mode(4);
#[doc = "< Mips64 ISA (Mips)"]
pub const CS_MODE_MIPS64: cs_mode = cs_mode(8);
#[doc = "< M680X Hitachi 6301,6303 mode"]
pub const CS_MODE_M680X_6301: cs_mode = cs_mode(2);
#[doc = "< M680X Hitachi 6309 mode"]
pub const CS_MODE_M680X_6309: cs_mode = cs_mode(4);
#[doc = "< M680X Motorola 6800,6802 mode"]
pub const CS_MODE_M680X_6800: cs_mode = cs_mode(8);
#[doc = "< M680X Motorola 6801,6803 mode"]
pub const CS_MODE_M680X_6801: cs_mode = cs_mode(16);
#[doc = "< M680X Motorola/Freescale 6805 mode"]
pub const CS_MODE_M680X_6805: cs_mode = cs_mode(32);
#[doc = "< M680X Motorola/Freescale/NXP 68HC08 mode"]
pub const CS_MODE_M680X_6808: cs_mode = cs_mode(64);
#[doc = "< M680X Motorola 6809 mode"]
pub const CS_MODE_M680X_6809: cs_mode = cs_mode(128);
#[doc = "< M680X Motorola/Freescale/NXP 68HC11 mode"]
pub const CS_MODE_M680X_6811: cs_mode = cs_mode(256);
#[doc = "< M680X Motorola/Freescale/NXP CPU12"]
#[doc = "< used on M68HC12/HCS12"]
pub const CS_MODE_M680X_CPU12: cs_mode = cs_mode(512);
#[doc = "< M680X Freescale/NXP HCS08 mode"]
pub const CS_MODE_M680X_HCS08: cs_mode = cs_mode(1024);
impl ::core::ops::BitOr<cs_mode> for cs_mode {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        cs_mode(self.0 | other.0)
    }
}
impl ::core::ops::BitOrAssign for cs_mode {
    #[inline]
    fn bitor_assign(&mut self, rhs: cs_mode) {
        self.0 |= rhs.0;
    }
}
impl ::core::ops::BitAnd<cs_mode> for cs_mode {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        cs_mode(self.0 & other.0)
    }
}
impl ::core::ops::BitAndAssign for cs_mode {
    #[inline]
    fn bitand_assign(&mut self, rhs: cs_mode) {
        self.0 &= rhs.0;
    }
}
#[repr(C)]
#[doc = " Mode type"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub struct cs_mode(pub i32);
pub type cs_malloc_t =
    ::core::option::Option<unsafe extern "C" fn(size: usize) -> *mut libc::c_void>;
pub type cs_calloc_t =
    ::core::option::Option<unsafe extern "C" fn(nmemb: usize, size: usize) -> *mut libc::c_void>;
pub type cs_realloc_t = ::core::option::Option<
    unsafe extern "C" fn(ptr: *mut libc::c_void, size: usize) -> *mut libc::c_void,
>;
pub type cs_free_t = ::core::option::Option<unsafe extern "C" fn(ptr: *mut libc::c_void)>;
pub type cs_vsnprintf_t = ::core::option::Option<
    unsafe extern "C" fn(
        str: *mut libc::c_char,
        size: usize,
        format: *const libc::c_char,
        ap: *mut __va_list_tag,
    ) -> libc::c_int,
>;
#[doc = " User-defined dynamic memory related functions: malloc/calloc/realloc/free/vsnprintf()"]
#[doc = " By default, Capstone uses system's malloc(), calloc(), realloc(), free() & vsnprintf()."]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_opt_mem {
    pub malloc: cs_malloc_t,
    pub calloc: cs_calloc_t,
    pub realloc: cs_realloc_t,
    pub free: cs_free_t,
    pub vsnprintf: cs_vsnprintf_t,
}
impl Clone for cs_opt_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Customize mnemonic for instructions with alternative name."]
#[doc = " To reset existing customized instruction to its default mnemonic,"]
#[doc = " call cs_option(CS_OPT_MNEMONIC) again with the same @id and NULL value"]
#[doc = " for @mnemonic."]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_opt_mnem {
    #[doc = " ID of instruction to be customized."]
    pub id: libc::c_uint,
    #[doc = " Customized instruction mnemonic."]
    pub mnemonic: *const libc::c_char,
}
impl Clone for cs_opt_mnem {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(u32)]
#[doc = " Runtime option for the disassembled engine"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum cs_opt_type {
    #[doc = "< No option specified"]
    CS_OPT_INVALID = 0,
    #[doc = "< Assembly output syntax"]
    CS_OPT_SYNTAX = 1,
    #[doc = "< Break down instruction structure into details"]
    CS_OPT_DETAIL = 2,
    #[doc = "< Change engine's mode at run-time"]
    CS_OPT_MODE = 3,
    #[doc = "< User-defined dynamic memory related functions"]
    CS_OPT_MEM = 4,
    #[doc = "< Skip data when disassembling. Then engine is in SKIPDATA mode."]
    CS_OPT_SKIPDATA = 5,
    #[doc = "< Setup user-defined function for SKIPDATA option"]
    CS_OPT_SKIPDATA_SETUP = 6,
    #[doc = "< Customize instruction mnemonic"]
    CS_OPT_MNEMONIC = 7,
    #[doc = "< print immediate operands in unsigned form"]
    CS_OPT_UNSIGNED = 8,
}
pub mod cs_opt_value {
    #[doc = " Runtime option value (associated with option type above)"]
    pub type Type = u32;
    #[doc = "< Turn OFF an option - default for CS_OPT_DETAIL, CS_OPT_SKIPDATA, CS_OPT_UNSIGNED."]
    pub const CS_OPT_OFF: Type = 0;
    #[doc = "< Turn ON an option (CS_OPT_DETAIL, CS_OPT_SKIPDATA)."]
    pub const CS_OPT_ON: Type = 3;
    #[doc = "< Default asm syntax (CS_OPT_SYNTAX)."]
    pub const CS_OPT_SYNTAX_DEFAULT: Type = 0;
    #[doc = "< X86 Intel asm syntax - default on X86 (CS_OPT_SYNTAX)."]
    pub const CS_OPT_SYNTAX_INTEL: Type = 1;
    #[doc = "< X86 ATT asm syntax (CS_OPT_SYNTAX)."]
    pub const CS_OPT_SYNTAX_ATT: Type = 2;
    #[doc = "< Prints register name with only number (CS_OPT_SYNTAX)"]
    pub const CS_OPT_SYNTAX_NOREGNAME: Type = 3;
    #[doc = "< X86 Intel Masm syntax (CS_OPT_SYNTAX)."]
    pub const CS_OPT_SYNTAX_MASM: Type = 4;
}
#[repr(u32)]
#[doc = " Common instruction operand types - to be consistent across all architectures."]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum cs_op_type {
    #[doc = "< uninitialized/invalid operand."]
    CS_OP_INVALID = 0,
    #[doc = "< Register operand."]
    CS_OP_REG = 1,
    #[doc = "< Immediate operand."]
    CS_OP_IMM = 2,
    #[doc = "< Memory operand."]
    CS_OP_MEM = 3,
    #[doc = "< Floating-Point operand."]
    CS_OP_FP = 4,
}
#[doc = "< Uninitialized/invalid access type."]
pub const CS_AC_INVALID: cs_ac_type = cs_ac_type(0);
#[doc = "< Operand read from memory or register."]
pub const CS_AC_READ: cs_ac_type = cs_ac_type(1);
#[doc = "< Operand write to memory or register."]
pub const CS_AC_WRITE: cs_ac_type = cs_ac_type(2);
impl ::core::ops::BitOr<cs_ac_type> for cs_ac_type {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        cs_ac_type(self.0 | other.0)
    }
}
impl ::core::ops::BitOrAssign for cs_ac_type {
    #[inline]
    fn bitor_assign(&mut self, rhs: cs_ac_type) {
        self.0 |= rhs.0;
    }
}
impl ::core::ops::BitAnd<cs_ac_type> for cs_ac_type {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        cs_ac_type(self.0 & other.0)
    }
}
impl ::core::ops::BitAndAssign for cs_ac_type {
    #[inline]
    fn bitand_assign(&mut self, rhs: cs_ac_type) {
        self.0 &= rhs.0;
    }
}
#[repr(C)]
#[doc = " Common instruction operand access types - to be consistent across all architectures."]
#[doc = " It is possible to combine access types, for example: CS_AC_READ | CS_AC_WRITE"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub struct cs_ac_type(pub u32);
pub mod cs_group_type {
    #[doc = " Common instruction groups - to be consistent across all architectures."]
    pub type Type = u32;
    #[doc = "< uninitialized/invalid group."]
    pub const CS_GRP_INVALID: Type = 0;
    #[doc = "< all jump instructions (conditional+direct+indirect jumps)"]
    pub const CS_GRP_JUMP: Type = 1;
    #[doc = "< all call instructions"]
    pub const CS_GRP_CALL: Type = 2;
    #[doc = "< all return instructions"]
    pub const CS_GRP_RET: Type = 3;
    #[doc = "< all interrupt instructions (int+syscall)"]
    pub const CS_GRP_INT: Type = 4;
    #[doc = "< all interrupt return instructions"]
    pub const CS_GRP_IRET: Type = 5;
    #[doc = "< all privileged instructions"]
    pub const CS_GRP_PRIVILEGE: Type = 6;
    #[doc = "< all relative branching instructions"]
    pub const CS_GRP_BRANCH_RELATIVE: Type = 7;
}
#[doc = "User-defined callback function for SKIPDATA option."]
#[doc = "See tests/test_skipdata.c for sample code demonstrating this API."]
#[doc = ""]
#[doc = "@code: the input buffer containing code to be disassembled."]
#[doc = "This is the same buffer passed to cs_disasm()."]
#[doc = "@code_size: size (in bytes) of the above @code buffer."]
#[doc = "@offset: the position of the currently-examining byte in the input"]
#[doc = "buffer @code mentioned above."]
#[doc = "@user_data: user-data passed to cs_option() via @user_data field in"]
#[doc = "cs_opt_skipdata struct below."]
#[doc = ""]
#[doc = "@return: return number of bytes to skip, or 0 to immediately stop disassembling."]
pub type cs_skipdata_cb_t = ::core::option::Option<
    unsafe extern "C" fn(
        code: *const u8,
        code_size: usize,
        offset: usize,
        user_data: *mut libc::c_void,
    ) -> usize,
>;
#[doc = " User-customized setup for SKIPDATA option"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_opt_skipdata {
    #[doc = " Capstone considers data to skip as special \"instructions\"."]
    #[doc = " User can specify the string for this instruction's \"mnemonic\" here."]
    #[doc = " By default (if @mnemonic is NULL), Capstone use \".byte\"."]
    pub mnemonic: *const libc::c_char,
    #[doc = " User-defined callback function to be called when Capstone hits data."]
    #[doc = " If the returned value from this callback is positive (>0), Capstone"]
    #[doc = " will skip exactly that number of bytes & continue. Otherwise, if"]
    #[doc = " the callback returns 0, Capstone stops disassembling and returns"]
    #[doc = " immediately from cs_disasm()"]
    #[doc = " NOTE: if this callback pointer is NULL, Capstone would skip a number"]
    #[doc = " of bytes depending on architectures, as following:"]
    #[doc = " Arm:     2 bytes (Thumb mode) or 4 bytes."]
    #[doc = " Arm64:   4 bytes."]
    #[doc = " Mips:    4 bytes."]
    #[doc = " M680x:   1 byte."]
    #[doc = " PowerPC: 4 bytes."]
    #[doc = " Sparc:   4 bytes."]
    #[doc = " SystemZ: 2 bytes."]
    #[doc = " X86:     1 bytes."]
    #[doc = " XCore:   2 bytes."]
    #[doc = " EVM:     1 bytes."]
    pub callback: cs_skipdata_cb_t,
    #[doc = " User-defined data to be passed to @callback function pointer."]
    pub user_data: *mut libc::c_void,
}
impl Clone for cs_opt_skipdata {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(u32)]
#[doc = " ARM shift type"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm_shifter {
    ARM_SFT_INVALID = 0,
    #[doc = "< shift with immediate const"]
    ARM_SFT_ASR = 1,
    #[doc = "< shift with immediate const"]
    ARM_SFT_LSL = 2,
    #[doc = "< shift with immediate const"]
    ARM_SFT_LSR = 3,
    #[doc = "< shift with immediate const"]
    ARM_SFT_ROR = 4,
    #[doc = "< shift with immediate const"]
    ARM_SFT_RRX = 5,
    #[doc = "< shift with register"]
    ARM_SFT_ASR_REG = 6,
    #[doc = "< shift with register"]
    ARM_SFT_LSL_REG = 7,
    #[doc = "< shift with register"]
    ARM_SFT_LSR_REG = 8,
    #[doc = "< shift with register"]
    ARM_SFT_ROR_REG = 9,
    #[doc = "< shift with register"]
    ARM_SFT_RRX_REG = 10,
}
#[repr(u32)]
#[doc = " ARM condition code"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm_cc {
    ARM_CC_INVALID = 0,
    #[doc = "< Equal                      Equal"]
    ARM_CC_EQ = 1,
    #[doc = "< Not equal                  Not equal, or unordered"]
    ARM_CC_NE = 2,
    #[doc = "< Carry set                  >, ==, or unordered"]
    ARM_CC_HS = 3,
    #[doc = "< Carry clear                Less than"]
    ARM_CC_LO = 4,
    #[doc = "< Minus, negative            Less than"]
    ARM_CC_MI = 5,
    #[doc = "< Plus, positive or zero     >, ==, or unordered"]
    ARM_CC_PL = 6,
    #[doc = "< Overflow                   Unordered"]
    ARM_CC_VS = 7,
    #[doc = "< No overflow                Not unordered"]
    ARM_CC_VC = 8,
    #[doc = "< Unsigned higher            Greater than, or unordered"]
    ARM_CC_HI = 9,
    #[doc = "< Unsigned lower or same     Less than or equal"]
    ARM_CC_LS = 10,
    #[doc = "< Greater than or equal      Greater than or equal"]
    ARM_CC_GE = 11,
    #[doc = "< Less than                  Less than, or unordered"]
    ARM_CC_LT = 12,
    #[doc = "< Greater than               Greater than"]
    ARM_CC_GT = 13,
    #[doc = "< Less than or equal         <, ==, or unordered"]
    ARM_CC_LE = 14,
    #[doc = "< Always (unconditional)     Always (unconditional)"]
    ARM_CC_AL = 15,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm_sysreg {
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_INVALID = 0,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_C = 1,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_X = 2,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_S = 4,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_F = 8,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_CPSR_C = 16,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_CPSR_X = 32,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_CPSR_S = 64,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_CPSR_F = 128,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_APSR = 256,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_APSR_G = 257,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_APSR_NZCVQ = 258,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_APSR_NZCVQG = 259,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_IAPSR = 260,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_IAPSR_G = 261,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_IAPSR_NZCVQG = 262,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_IAPSR_NZCVQ = 263,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_EAPSR = 264,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_EAPSR_G = 265,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_EAPSR_NZCVQG = 266,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_EAPSR_NZCVQ = 267,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_XPSR = 268,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_XPSR_G = 269,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_XPSR_NZCVQG = 270,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_XPSR_NZCVQ = 271,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_IPSR = 272,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_EPSR = 273,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_IEPSR = 274,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_MSP = 275,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_PSP = 276,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_PRIMASK = 277,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_BASEPRI = 278,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_BASEPRI_MAX = 279,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_FAULTMASK = 280,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_CONTROL = 281,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R8_USR = 282,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R9_USR = 283,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R10_USR = 284,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R11_USR = 285,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R12_USR = 286,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_USR = 287,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_LR_USR = 288,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R8_FIQ = 289,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R9_FIQ = 290,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R10_FIQ = 291,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R11_FIQ = 292,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R12_FIQ = 293,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_FIQ = 294,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_LR_FIQ = 295,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_LR_IRQ = 296,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_IRQ = 297,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_LR_SVC = 298,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_SVC = 299,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_LR_ABT = 300,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_ABT = 301,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_LR_UND = 302,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_UND = 303,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_LR_MON = 304,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_MON = 305,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_ELR_HYP = 306,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_HYP = 307,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_FIQ = 308,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_IRQ = 309,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_SVC = 310,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_ABT = 311,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_UND = 312,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_MON = 313,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_HYP = 314,
}
#[repr(u32)]
#[doc = " The memory barrier constants map directly to the 4-bit encoding of"]
#[doc = " the option field for Memory Barrier operations."]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm_mem_barrier {
    ARM_MB_INVALID = 0,
    ARM_MB_RESERVED_0 = 1,
    ARM_MB_OSHLD = 2,
    ARM_MB_OSHST = 3,
    ARM_MB_OSH = 4,
    ARM_MB_RESERVED_4 = 5,
    ARM_MB_NSHLD = 6,
    ARM_MB_NSHST = 7,
    ARM_MB_NSH = 8,
    ARM_MB_RESERVED_8 = 9,
    ARM_MB_ISHLD = 10,
    ARM_MB_ISHST = 11,
    ARM_MB_ISH = 12,
    ARM_MB_RESERVED_12 = 13,
    ARM_MB_LD = 14,
    ARM_MB_ST = 15,
    ARM_MB_SY = 16,
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    ARM_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    ARM_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    ARM_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    ARM_OP_MEM = 3,
    #[doc = "< = CS_OP_FP (Floating-Point operand)."]
    ARM_OP_FP = 4,
    #[doc = "< C-Immediate (coprocessor registers)"]
    ARM_OP_CIMM = 64,
    #[doc = "< P-Immediate (coprocessor registers)"]
    ARM_OP_PIMM = 65,
    #[doc = "< operand for SETEND instruction"]
    ARM_OP_SETEND = 66,
    #[doc = "< MSR/MRS special register operand"]
    ARM_OP_SYSREG = 67,
}
#[repr(u32)]
#[doc = " Operand type for SETEND instruction"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm_setend_type {
    #[doc = "< Uninitialized."]
    ARM_SETEND_INVALID = 0,
    #[doc = "< BE operand."]
    ARM_SETEND_BE = 1,
    #[doc = "< LE operand"]
    ARM_SETEND_LE = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm_cpsmode_type {
    ARM_CPSMODE_INVALID = 0,
    ARM_CPSMODE_IE = 2,
    ARM_CPSMODE_ID = 3,
}
#[repr(u32)]
#[doc = " Operand type for SETEND instruction"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm_cpsflag_type {
    ARM_CPSFLAG_INVALID = 0,
    ARM_CPSFLAG_F = 1,
    ARM_CPSFLAG_I = 2,
    ARM_CPSFLAG_A = 4,
    #[doc = "< no flag"]
    ARM_CPSFLAG_NONE = 16,
}
#[repr(u32)]
#[doc = " Data type for elements of vector instructions."]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm_vectordata_type {
    ARM_VECTORDATA_INVALID = 0,
    ARM_VECTORDATA_I8 = 1,
    ARM_VECTORDATA_I16 = 2,
    ARM_VECTORDATA_I32 = 3,
    ARM_VECTORDATA_I64 = 4,
    ARM_VECTORDATA_S8 = 5,
    ARM_VECTORDATA_S16 = 6,
    ARM_VECTORDATA_S32 = 7,
    ARM_VECTORDATA_S64 = 8,
    ARM_VECTORDATA_U8 = 9,
    ARM_VECTORDATA_U16 = 10,
    ARM_VECTORDATA_U32 = 11,
    ARM_VECTORDATA_U64 = 12,
    ARM_VECTORDATA_P8 = 13,
    ARM_VECTORDATA_F32 = 14,
    ARM_VECTORDATA_F64 = 15,
    ARM_VECTORDATA_F16F64 = 16,
    ARM_VECTORDATA_F64F16 = 17,
    ARM_VECTORDATA_F32F16 = 18,
    ARM_VECTORDATA_F16F32 = 19,
    ARM_VECTORDATA_F64F32 = 20,
    ARM_VECTORDATA_F32F64 = 21,
    ARM_VECTORDATA_S32F32 = 22,
    ARM_VECTORDATA_U32F32 = 23,
    ARM_VECTORDATA_F32S32 = 24,
    ARM_VECTORDATA_F32U32 = 25,
    ARM_VECTORDATA_F64S16 = 26,
    ARM_VECTORDATA_F32S16 = 27,
    ARM_VECTORDATA_F64S32 = 28,
    ARM_VECTORDATA_S16F64 = 29,
    ARM_VECTORDATA_S16F32 = 30,
    ARM_VECTORDATA_S32F64 = 31,
    ARM_VECTORDATA_U16F64 = 32,
    ARM_VECTORDATA_U16F32 = 33,
    ARM_VECTORDATA_U32F64 = 34,
    ARM_VECTORDATA_F64U16 = 35,
    ARM_VECTORDATA_F32U16 = 36,
    ARM_VECTORDATA_F64U32 = 37,
}
pub mod arm_reg {
    #[doc = " ARM registers"]
    pub type Type = u32;
    pub const ARM_REG_INVALID: Type = 0;
    pub const ARM_REG_APSR: Type = 1;
    pub const ARM_REG_APSR_NZCV: Type = 2;
    pub const ARM_REG_CPSR: Type = 3;
    pub const ARM_REG_FPEXC: Type = 4;
    pub const ARM_REG_FPINST: Type = 5;
    pub const ARM_REG_FPSCR: Type = 6;
    pub const ARM_REG_FPSCR_NZCV: Type = 7;
    pub const ARM_REG_FPSID: Type = 8;
    pub const ARM_REG_ITSTATE: Type = 9;
    pub const ARM_REG_LR: Type = 10;
    pub const ARM_REG_PC: Type = 11;
    pub const ARM_REG_SP: Type = 12;
    pub const ARM_REG_SPSR: Type = 13;
    pub const ARM_REG_D0: Type = 14;
    pub const ARM_REG_D1: Type = 15;
    pub const ARM_REG_D2: Type = 16;
    pub const ARM_REG_D3: Type = 17;
    pub const ARM_REG_D4: Type = 18;
    pub const ARM_REG_D5: Type = 19;
    pub const ARM_REG_D6: Type = 20;
    pub const ARM_REG_D7: Type = 21;
    pub const ARM_REG_D8: Type = 22;
    pub const ARM_REG_D9: Type = 23;
    pub const ARM_REG_D10: Type = 24;
    pub const ARM_REG_D11: Type = 25;
    pub const ARM_REG_D12: Type = 26;
    pub const ARM_REG_D13: Type = 27;
    pub const ARM_REG_D14: Type = 28;
    pub const ARM_REG_D15: Type = 29;
    pub const ARM_REG_D16: Type = 30;
    pub const ARM_REG_D17: Type = 31;
    pub const ARM_REG_D18: Type = 32;
    pub const ARM_REG_D19: Type = 33;
    pub const ARM_REG_D20: Type = 34;
    pub const ARM_REG_D21: Type = 35;
    pub const ARM_REG_D22: Type = 36;
    pub const ARM_REG_D23: Type = 37;
    pub const ARM_REG_D24: Type = 38;
    pub const ARM_REG_D25: Type = 39;
    pub const ARM_REG_D26: Type = 40;
    pub const ARM_REG_D27: Type = 41;
    pub const ARM_REG_D28: Type = 42;
    pub const ARM_REG_D29: Type = 43;
    pub const ARM_REG_D30: Type = 44;
    pub const ARM_REG_D31: Type = 45;
    pub const ARM_REG_FPINST2: Type = 46;
    pub const ARM_REG_MVFR0: Type = 47;
    pub const ARM_REG_MVFR1: Type = 48;
    pub const ARM_REG_MVFR2: Type = 49;
    pub const ARM_REG_Q0: Type = 50;
    pub const ARM_REG_Q1: Type = 51;
    pub const ARM_REG_Q2: Type = 52;
    pub const ARM_REG_Q3: Type = 53;
    pub const ARM_REG_Q4: Type = 54;
    pub const ARM_REG_Q5: Type = 55;
    pub const ARM_REG_Q6: Type = 56;
    pub const ARM_REG_Q7: Type = 57;
    pub const ARM_REG_Q8: Type = 58;
    pub const ARM_REG_Q9: Type = 59;
    pub const ARM_REG_Q10: Type = 60;
    pub const ARM_REG_Q11: Type = 61;
    pub const ARM_REG_Q12: Type = 62;
    pub const ARM_REG_Q13: Type = 63;
    pub const ARM_REG_Q14: Type = 64;
    pub const ARM_REG_Q15: Type = 65;
    pub const ARM_REG_R0: Type = 66;
    pub const ARM_REG_R1: Type = 67;
    pub const ARM_REG_R2: Type = 68;
    pub const ARM_REG_R3: Type = 69;
    pub const ARM_REG_R4: Type = 70;
    pub const ARM_REG_R5: Type = 71;
    pub const ARM_REG_R6: Type = 72;
    pub const ARM_REG_R7: Type = 73;
    pub const ARM_REG_R8: Type = 74;
    pub const ARM_REG_R9: Type = 75;
    pub const ARM_REG_R10: Type = 76;
    pub const ARM_REG_R11: Type = 77;
    pub const ARM_REG_R12: Type = 78;
    pub const ARM_REG_S0: Type = 79;
    pub const ARM_REG_S1: Type = 80;
    pub const ARM_REG_S2: Type = 81;
    pub const ARM_REG_S3: Type = 82;
    pub const ARM_REG_S4: Type = 83;
    pub const ARM_REG_S5: Type = 84;
    pub const ARM_REG_S6: Type = 85;
    pub const ARM_REG_S7: Type = 86;
    pub const ARM_REG_S8: Type = 87;
    pub const ARM_REG_S9: Type = 88;
    pub const ARM_REG_S10: Type = 89;
    pub const ARM_REG_S11: Type = 90;
    pub const ARM_REG_S12: Type = 91;
    pub const ARM_REG_S13: Type = 92;
    pub const ARM_REG_S14: Type = 93;
    pub const ARM_REG_S15: Type = 94;
    pub const ARM_REG_S16: Type = 95;
    pub const ARM_REG_S17: Type = 96;
    pub const ARM_REG_S18: Type = 97;
    pub const ARM_REG_S19: Type = 98;
    pub const ARM_REG_S20: Type = 99;
    pub const ARM_REG_S21: Type = 100;
    pub const ARM_REG_S22: Type = 101;
    pub const ARM_REG_S23: Type = 102;
    pub const ARM_REG_S24: Type = 103;
    pub const ARM_REG_S25: Type = 104;
    pub const ARM_REG_S26: Type = 105;
    pub const ARM_REG_S27: Type = 106;
    pub const ARM_REG_S28: Type = 107;
    pub const ARM_REG_S29: Type = 108;
    pub const ARM_REG_S30: Type = 109;
    pub const ARM_REG_S31: Type = 110;
    pub const ARM_REG_ENDING: Type = 111;
    pub const ARM_REG_R13: Type = 12;
    pub const ARM_REG_R14: Type = 10;
    pub const ARM_REG_R15: Type = 11;
    pub const ARM_REG_SB: Type = 75;
    pub const ARM_REG_SL: Type = 76;
    pub const ARM_REG_FP: Type = 77;
    pub const ARM_REG_IP: Type = 78;
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with ARM_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct arm_op_mem {
    #[doc = "< base register"]
    pub base: arm_reg::Type,
    #[doc = "< index register"]
    pub index: arm_reg::Type,
    #[doc = "< scale for index register (can be 1, or -1)"]
    pub scale: libc::c_int,
    #[doc = "< displacement/offset value"]
    pub disp: libc::c_int,
    #[doc = " left-shift on index register, or 0 if irrelevant"]
    #[doc = " NOTE: this value can also be fetched via operand.shift.value"]
    pub lshift: libc::c_int,
}
impl Clone for arm_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_arm_op {
    #[doc = "< Vector Index for some vector operands (or -1 if irrelevant)"]
    pub vector_index: libc::c_int,
    pub shift: cs_arm_op__bindgen_ty_1,
    #[doc = "< operand type"]
    pub type_: arm_op_type,
    pub __bindgen_anon_1: cs_arm_op__bindgen_ty_2,
    #[doc = " in some instructions, an operand can be subtracted or added to"]
    #[doc = " the base register,"]
    #[doc = " if TRUE, this operand is subtracted. otherwise, it is added."]
    pub subtracted: bool,
    #[doc = " How is this operand accessed? (READ, WRITE or READ|WRITE)"]
    #[doc = " This field is combined of cs_ac_type."]
    #[doc = " NOTE: this field is irrelevant if engine is compiled in DIET mode."]
    pub access: u8,
    #[doc = " Neon lane index for NEON instructions (or -1 if irrelevant)"]
    pub neon_lane: i8,
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_arm_op__bindgen_ty_1 {
    pub type_: arm_shifter,
    pub value: libc::c_uint,
}
impl Clone for cs_arm_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Copy)]
pub union cs_arm_op__bindgen_ty_2 {
    #[doc = "< register value for REG/SYSREG operand"]
    pub reg: libc::c_int,
    #[doc = "< immediate value for C-IMM, P-IMM or IMM operand"]
    pub imm: i32,
    #[doc = "< floating point value for FP operand"]
    pub fp: f64,
    #[doc = "< base/index/scale/disp value for MEM operand"]
    pub mem: arm_op_mem,
    #[doc = "< SETEND instruction's operand type"]
    pub setend: arm_setend_type,
    _bindgen_union_align: [u64; 3usize],
}
impl Clone for cs_arm_op__bindgen_ty_2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_arm_op__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_arm_op__bindgen_ty_2 {{ union }}")
    }
}
impl Clone for cs_arm_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_arm_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! ( f , "cs_arm_op {{ vector_index: {:?}, shift: {:?}, type: {:?}, __bindgen_anon_1: {:?}, subtracted: {:?}, access: {:?}, neon_lane: {:?} }}" , self . vector_index , self . shift , self . type_ , self . __bindgen_anon_1 , self . subtracted , self . access , self . neon_lane )
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_arm {
    #[doc = "< User-mode registers to be loaded (for LDM/STM instructions)"]
    pub usermode: bool,
    #[doc = "< Scalar size for vector instructions"]
    pub vector_size: libc::c_int,
    #[doc = "< Data type for elements of vector instructions"]
    pub vector_data: arm_vectordata_type,
    #[doc = "< CPS mode for CPS instruction"]
    pub cps_mode: arm_cpsmode_type,
    #[doc = "< CPS mode for CPS instruction"]
    pub cps_flag: arm_cpsflag_type,
    #[doc = "< conditional code for this insn"]
    pub cc: arm_cc,
    #[doc = "< does this insn update flags?"]
    pub update_flags: bool,
    #[doc = "< does this insn write-back?"]
    pub writeback: bool,
    #[doc = "< Option for some memory barrier instructions"]
    pub mem_barrier: arm_mem_barrier,
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_arm_op; 36usize],
}
impl Clone for cs_arm {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_arm {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! ( f , "cs_arm {{ usermode: {:?}, vector_size: {:?}, vector_data: {:?}, cps_mode: {:?}, cps_flag: {:?}, cc: {:?}, update_flags: {:?}, writeback: {:?}, mem_barrier: {:?}, op_count: {:?}, operands: [...] }}" , self . usermode , self . vector_size , self . vector_data , self . cps_mode , self . cps_flag , self . cc , self . update_flags , self . writeback , self . mem_barrier , self . op_count )
    }
}
#[repr(u32)]
#[doc = " ARM instruction"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm_insn {
    ARM_INS_INVALID = 0,
    ARM_INS_ADC = 1,
    ARM_INS_ADD = 2,
    ARM_INS_ADR = 3,
    ARM_INS_AESD = 4,
    ARM_INS_AESE = 5,
    ARM_INS_AESIMC = 6,
    ARM_INS_AESMC = 7,
    ARM_INS_AND = 8,
    ARM_INS_BFC = 9,
    ARM_INS_BFI = 10,
    ARM_INS_BIC = 11,
    ARM_INS_BKPT = 12,
    ARM_INS_BL = 13,
    ARM_INS_BLX = 14,
    ARM_INS_BX = 15,
    ARM_INS_BXJ = 16,
    ARM_INS_B = 17,
    ARM_INS_CDP = 18,
    ARM_INS_CDP2 = 19,
    ARM_INS_CLREX = 20,
    ARM_INS_CLZ = 21,
    ARM_INS_CMN = 22,
    ARM_INS_CMP = 23,
    ARM_INS_CPS = 24,
    ARM_INS_CRC32B = 25,
    ARM_INS_CRC32CB = 26,
    ARM_INS_CRC32CH = 27,
    ARM_INS_CRC32CW = 28,
    ARM_INS_CRC32H = 29,
    ARM_INS_CRC32W = 30,
    ARM_INS_DBG = 31,
    ARM_INS_DMB = 32,
    ARM_INS_DSB = 33,
    ARM_INS_EOR = 34,
    ARM_INS_ERET = 35,
    ARM_INS_VMOV = 36,
    ARM_INS_FLDMDBX = 37,
    ARM_INS_FLDMIAX = 38,
    ARM_INS_VMRS = 39,
    ARM_INS_FSTMDBX = 40,
    ARM_INS_FSTMIAX = 41,
    ARM_INS_HINT = 42,
    ARM_INS_HLT = 43,
    ARM_INS_HVC = 44,
    ARM_INS_ISB = 45,
    ARM_INS_LDA = 46,
    ARM_INS_LDAB = 47,
    ARM_INS_LDAEX = 48,
    ARM_INS_LDAEXB = 49,
    ARM_INS_LDAEXD = 50,
    ARM_INS_LDAEXH = 51,
    ARM_INS_LDAH = 52,
    ARM_INS_LDC2L = 53,
    ARM_INS_LDC2 = 54,
    ARM_INS_LDCL = 55,
    ARM_INS_LDC = 56,
    ARM_INS_LDMDA = 57,
    ARM_INS_LDMDB = 58,
    ARM_INS_LDM = 59,
    ARM_INS_LDMIB = 60,
    ARM_INS_LDRBT = 61,
    ARM_INS_LDRB = 62,
    ARM_INS_LDRD = 63,
    ARM_INS_LDREX = 64,
    ARM_INS_LDREXB = 65,
    ARM_INS_LDREXD = 66,
    ARM_INS_LDREXH = 67,
    ARM_INS_LDRH = 68,
    ARM_INS_LDRHT = 69,
    ARM_INS_LDRSB = 70,
    ARM_INS_LDRSBT = 71,
    ARM_INS_LDRSH = 72,
    ARM_INS_LDRSHT = 73,
    ARM_INS_LDRT = 74,
    ARM_INS_LDR = 75,
    ARM_INS_MCR = 76,
    ARM_INS_MCR2 = 77,
    ARM_INS_MCRR = 78,
    ARM_INS_MCRR2 = 79,
    ARM_INS_MLA = 80,
    ARM_INS_MLS = 81,
    ARM_INS_MOV = 82,
    ARM_INS_MOVT = 83,
    ARM_INS_MOVW = 84,
    ARM_INS_MRC = 85,
    ARM_INS_MRC2 = 86,
    ARM_INS_MRRC = 87,
    ARM_INS_MRRC2 = 88,
    ARM_INS_MRS = 89,
    ARM_INS_MSR = 90,
    ARM_INS_MUL = 91,
    ARM_INS_MVN = 92,
    ARM_INS_ORR = 93,
    ARM_INS_PKHBT = 94,
    ARM_INS_PKHTB = 95,
    ARM_INS_PLDW = 96,
    ARM_INS_PLD = 97,
    ARM_INS_PLI = 98,
    ARM_INS_QADD = 99,
    ARM_INS_QADD16 = 100,
    ARM_INS_QADD8 = 101,
    ARM_INS_QASX = 102,
    ARM_INS_QDADD = 103,
    ARM_INS_QDSUB = 104,
    ARM_INS_QSAX = 105,
    ARM_INS_QSUB = 106,
    ARM_INS_QSUB16 = 107,
    ARM_INS_QSUB8 = 108,
    ARM_INS_RBIT = 109,
    ARM_INS_REV = 110,
    ARM_INS_REV16 = 111,
    ARM_INS_REVSH = 112,
    ARM_INS_RFEDA = 113,
    ARM_INS_RFEDB = 114,
    ARM_INS_RFEIA = 115,
    ARM_INS_RFEIB = 116,
    ARM_INS_RSB = 117,
    ARM_INS_RSC = 118,
    ARM_INS_SADD16 = 119,
    ARM_INS_SADD8 = 120,
    ARM_INS_SASX = 121,
    ARM_INS_SBC = 122,
    ARM_INS_SBFX = 123,
    ARM_INS_SDIV = 124,
    ARM_INS_SEL = 125,
    ARM_INS_SETEND = 126,
    ARM_INS_SHA1C = 127,
    ARM_INS_SHA1H = 128,
    ARM_INS_SHA1M = 129,
    ARM_INS_SHA1P = 130,
    ARM_INS_SHA1SU0 = 131,
    ARM_INS_SHA1SU1 = 132,
    ARM_INS_SHA256H = 133,
    ARM_INS_SHA256H2 = 134,
    ARM_INS_SHA256SU0 = 135,
    ARM_INS_SHA256SU1 = 136,
    ARM_INS_SHADD16 = 137,
    ARM_INS_SHADD8 = 138,
    ARM_INS_SHASX = 139,
    ARM_INS_SHSAX = 140,
    ARM_INS_SHSUB16 = 141,
    ARM_INS_SHSUB8 = 142,
    ARM_INS_SMC = 143,
    ARM_INS_SMLABB = 144,
    ARM_INS_SMLABT = 145,
    ARM_INS_SMLAD = 146,
    ARM_INS_SMLADX = 147,
    ARM_INS_SMLAL = 148,
    ARM_INS_SMLALBB = 149,
    ARM_INS_SMLALBT = 150,
    ARM_INS_SMLALD = 151,
    ARM_INS_SMLALDX = 152,
    ARM_INS_SMLALTB = 153,
    ARM_INS_SMLALTT = 154,
    ARM_INS_SMLATB = 155,
    ARM_INS_SMLATT = 156,
    ARM_INS_SMLAWB = 157,
    ARM_INS_SMLAWT = 158,
    ARM_INS_SMLSD = 159,
    ARM_INS_SMLSDX = 160,
    ARM_INS_SMLSLD = 161,
    ARM_INS_SMLSLDX = 162,
    ARM_INS_SMMLA = 163,
    ARM_INS_SMMLAR = 164,
    ARM_INS_SMMLS = 165,
    ARM_INS_SMMLSR = 166,
    ARM_INS_SMMUL = 167,
    ARM_INS_SMMULR = 168,
    ARM_INS_SMUAD = 169,
    ARM_INS_SMUADX = 170,
    ARM_INS_SMULBB = 171,
    ARM_INS_SMULBT = 172,
    ARM_INS_SMULL = 173,
    ARM_INS_SMULTB = 174,
    ARM_INS_SMULTT = 175,
    ARM_INS_SMULWB = 176,
    ARM_INS_SMULWT = 177,
    ARM_INS_SMUSD = 178,
    ARM_INS_SMUSDX = 179,
    ARM_INS_SRSDA = 180,
    ARM_INS_SRSDB = 181,
    ARM_INS_SRSIA = 182,
    ARM_INS_SRSIB = 183,
    ARM_INS_SSAT = 184,
    ARM_INS_SSAT16 = 185,
    ARM_INS_SSAX = 186,
    ARM_INS_SSUB16 = 187,
    ARM_INS_SSUB8 = 188,
    ARM_INS_STC2L = 189,
    ARM_INS_STC2 = 190,
    ARM_INS_STCL = 191,
    ARM_INS_STC = 192,
    ARM_INS_STL = 193,
    ARM_INS_STLB = 194,
    ARM_INS_STLEX = 195,
    ARM_INS_STLEXB = 196,
    ARM_INS_STLEXD = 197,
    ARM_INS_STLEXH = 198,
    ARM_INS_STLH = 199,
    ARM_INS_STMDA = 200,
    ARM_INS_STMDB = 201,
    ARM_INS_STM = 202,
    ARM_INS_STMIB = 203,
    ARM_INS_STRBT = 204,
    ARM_INS_STRB = 205,
    ARM_INS_STRD = 206,
    ARM_INS_STREX = 207,
    ARM_INS_STREXB = 208,
    ARM_INS_STREXD = 209,
    ARM_INS_STREXH = 210,
    ARM_INS_STRH = 211,
    ARM_INS_STRHT = 212,
    ARM_INS_STRT = 213,
    ARM_INS_STR = 214,
    ARM_INS_SUB = 215,
    ARM_INS_SVC = 216,
    ARM_INS_SWP = 217,
    ARM_INS_SWPB = 218,
    ARM_INS_SXTAB = 219,
    ARM_INS_SXTAB16 = 220,
    ARM_INS_SXTAH = 221,
    ARM_INS_SXTB = 222,
    ARM_INS_SXTB16 = 223,
    ARM_INS_SXTH = 224,
    ARM_INS_TEQ = 225,
    ARM_INS_TRAP = 226,
    ARM_INS_TST = 227,
    ARM_INS_UADD16 = 228,
    ARM_INS_UADD8 = 229,
    ARM_INS_UASX = 230,
    ARM_INS_UBFX = 231,
    ARM_INS_UDF = 232,
    ARM_INS_UDIV = 233,
    ARM_INS_UHADD16 = 234,
    ARM_INS_UHADD8 = 235,
    ARM_INS_UHASX = 236,
    ARM_INS_UHSAX = 237,
    ARM_INS_UHSUB16 = 238,
    ARM_INS_UHSUB8 = 239,
    ARM_INS_UMAAL = 240,
    ARM_INS_UMLAL = 241,
    ARM_INS_UMULL = 242,
    ARM_INS_UQADD16 = 243,
    ARM_INS_UQADD8 = 244,
    ARM_INS_UQASX = 245,
    ARM_INS_UQSAX = 246,
    ARM_INS_UQSUB16 = 247,
    ARM_INS_UQSUB8 = 248,
    ARM_INS_USAD8 = 249,
    ARM_INS_USADA8 = 250,
    ARM_INS_USAT = 251,
    ARM_INS_USAT16 = 252,
    ARM_INS_USAX = 253,
    ARM_INS_USUB16 = 254,
    ARM_INS_USUB8 = 255,
    ARM_INS_UXTAB = 256,
    ARM_INS_UXTAB16 = 257,
    ARM_INS_UXTAH = 258,
    ARM_INS_UXTB = 259,
    ARM_INS_UXTB16 = 260,
    ARM_INS_UXTH = 261,
    ARM_INS_VABAL = 262,
    ARM_INS_VABA = 263,
    ARM_INS_VABDL = 264,
    ARM_INS_VABD = 265,
    ARM_INS_VABS = 266,
    ARM_INS_VACGE = 267,
    ARM_INS_VACGT = 268,
    ARM_INS_VADD = 269,
    ARM_INS_VADDHN = 270,
    ARM_INS_VADDL = 271,
    ARM_INS_VADDW = 272,
    ARM_INS_VAND = 273,
    ARM_INS_VBIC = 274,
    ARM_INS_VBIF = 275,
    ARM_INS_VBIT = 276,
    ARM_INS_VBSL = 277,
    ARM_INS_VCEQ = 278,
    ARM_INS_VCGE = 279,
    ARM_INS_VCGT = 280,
    ARM_INS_VCLE = 281,
    ARM_INS_VCLS = 282,
    ARM_INS_VCLT = 283,
    ARM_INS_VCLZ = 284,
    ARM_INS_VCMP = 285,
    ARM_INS_VCMPE = 286,
    ARM_INS_VCNT = 287,
    ARM_INS_VCVTA = 288,
    ARM_INS_VCVTB = 289,
    ARM_INS_VCVT = 290,
    ARM_INS_VCVTM = 291,
    ARM_INS_VCVTN = 292,
    ARM_INS_VCVTP = 293,
    ARM_INS_VCVTT = 294,
    ARM_INS_VDIV = 295,
    ARM_INS_VDUP = 296,
    ARM_INS_VEOR = 297,
    ARM_INS_VEXT = 298,
    ARM_INS_VFMA = 299,
    ARM_INS_VFMS = 300,
    ARM_INS_VFNMA = 301,
    ARM_INS_VFNMS = 302,
    ARM_INS_VHADD = 303,
    ARM_INS_VHSUB = 304,
    ARM_INS_VLD1 = 305,
    ARM_INS_VLD2 = 306,
    ARM_INS_VLD3 = 307,
    ARM_INS_VLD4 = 308,
    ARM_INS_VLDMDB = 309,
    ARM_INS_VLDMIA = 310,
    ARM_INS_VLDR = 311,
    ARM_INS_VMAXNM = 312,
    ARM_INS_VMAX = 313,
    ARM_INS_VMINNM = 314,
    ARM_INS_VMIN = 315,
    ARM_INS_VMLA = 316,
    ARM_INS_VMLAL = 317,
    ARM_INS_VMLS = 318,
    ARM_INS_VMLSL = 319,
    ARM_INS_VMOVL = 320,
    ARM_INS_VMOVN = 321,
    ARM_INS_VMSR = 322,
    ARM_INS_VMUL = 323,
    ARM_INS_VMULL = 324,
    ARM_INS_VMVN = 325,
    ARM_INS_VNEG = 326,
    ARM_INS_VNMLA = 327,
    ARM_INS_VNMLS = 328,
    ARM_INS_VNMUL = 329,
    ARM_INS_VORN = 330,
    ARM_INS_VORR = 331,
    ARM_INS_VPADAL = 332,
    ARM_INS_VPADDL = 333,
    ARM_INS_VPADD = 334,
    ARM_INS_VPMAX = 335,
    ARM_INS_VPMIN = 336,
    ARM_INS_VQABS = 337,
    ARM_INS_VQADD = 338,
    ARM_INS_VQDMLAL = 339,
    ARM_INS_VQDMLSL = 340,
    ARM_INS_VQDMULH = 341,
    ARM_INS_VQDMULL = 342,
    ARM_INS_VQMOVUN = 343,
    ARM_INS_VQMOVN = 344,
    ARM_INS_VQNEG = 345,
    ARM_INS_VQRDMULH = 346,
    ARM_INS_VQRSHL = 347,
    ARM_INS_VQRSHRN = 348,
    ARM_INS_VQRSHRUN = 349,
    ARM_INS_VQSHL = 350,
    ARM_INS_VQSHLU = 351,
    ARM_INS_VQSHRN = 352,
    ARM_INS_VQSHRUN = 353,
    ARM_INS_VQSUB = 354,
    ARM_INS_VRADDHN = 355,
    ARM_INS_VRECPE = 356,
    ARM_INS_VRECPS = 357,
    ARM_INS_VREV16 = 358,
    ARM_INS_VREV32 = 359,
    ARM_INS_VREV64 = 360,
    ARM_INS_VRHADD = 361,
    ARM_INS_VRINTA = 362,
    ARM_INS_VRINTM = 363,
    ARM_INS_VRINTN = 364,
    ARM_INS_VRINTP = 365,
    ARM_INS_VRINTR = 366,
    ARM_INS_VRINTX = 367,
    ARM_INS_VRINTZ = 368,
    ARM_INS_VRSHL = 369,
    ARM_INS_VRSHRN = 370,
    ARM_INS_VRSHR = 371,
    ARM_INS_VRSQRTE = 372,
    ARM_INS_VRSQRTS = 373,
    ARM_INS_VRSRA = 374,
    ARM_INS_VRSUBHN = 375,
    ARM_INS_VSELEQ = 376,
    ARM_INS_VSELGE = 377,
    ARM_INS_VSELGT = 378,
    ARM_INS_VSELVS = 379,
    ARM_INS_VSHLL = 380,
    ARM_INS_VSHL = 381,
    ARM_INS_VSHRN = 382,
    ARM_INS_VSHR = 383,
    ARM_INS_VSLI = 384,
    ARM_INS_VSQRT = 385,
    ARM_INS_VSRA = 386,
    ARM_INS_VSRI = 387,
    ARM_INS_VST1 = 388,
    ARM_INS_VST2 = 389,
    ARM_INS_VST3 = 390,
    ARM_INS_VST4 = 391,
    ARM_INS_VSTMDB = 392,
    ARM_INS_VSTMIA = 393,
    ARM_INS_VSTR = 394,
    ARM_INS_VSUB = 395,
    ARM_INS_VSUBHN = 396,
    ARM_INS_VSUBL = 397,
    ARM_INS_VSUBW = 398,
    ARM_INS_VSWP = 399,
    ARM_INS_VTBL = 400,
    ARM_INS_VTBX = 401,
    ARM_INS_VCVTR = 402,
    ARM_INS_VTRN = 403,
    ARM_INS_VTST = 404,
    ARM_INS_VUZP = 405,
    ARM_INS_VZIP = 406,
    ARM_INS_ADDW = 407,
    ARM_INS_ASR = 408,
    ARM_INS_DCPS1 = 409,
    ARM_INS_DCPS2 = 410,
    ARM_INS_DCPS3 = 411,
    ARM_INS_IT = 412,
    ARM_INS_LSL = 413,
    ARM_INS_LSR = 414,
    ARM_INS_ORN = 415,
    ARM_INS_ROR = 416,
    ARM_INS_RRX = 417,
    ARM_INS_SUBW = 418,
    ARM_INS_TBB = 419,
    ARM_INS_TBH = 420,
    ARM_INS_CBNZ = 421,
    ARM_INS_CBZ = 422,
    ARM_INS_POP = 423,
    ARM_INS_PUSH = 424,
    ARM_INS_NOP = 425,
    ARM_INS_YIELD = 426,
    ARM_INS_WFE = 427,
    ARM_INS_WFI = 428,
    ARM_INS_SEV = 429,
    ARM_INS_SEVL = 430,
    ARM_INS_VPUSH = 431,
    ARM_INS_VPOP = 432,
    ARM_INS_ENDING = 433,
}
pub mod arm_insn_group {
    #[doc = " Group of ARM instructions"]
    pub type Type = u32;
    #[doc = "< = CS_GRP_INVALID"]
    pub const ARM_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const ARM_GRP_JUMP: Type = 1;
    #[doc = "< = CS_GRP_CALL"]
    pub const ARM_GRP_CALL: Type = 2;
    #[doc = "< = CS_GRP_INT"]
    pub const ARM_GRP_INT: Type = 4;
    #[doc = "< = CS_GRP_PRIVILEGE"]
    pub const ARM_GRP_PRIVILEGE: Type = 6;
    #[doc = "< = CS_GRP_BRANCH_RELATIVE"]
    pub const ARM_GRP_BRANCH_RELATIVE: Type = 7;
    pub const ARM_GRP_CRYPTO: Type = 128;
    pub const ARM_GRP_DATABARRIER: Type = 129;
    pub const ARM_GRP_DIVIDE: Type = 130;
    pub const ARM_GRP_FPARMV8: Type = 131;
    pub const ARM_GRP_MULTPRO: Type = 132;
    pub const ARM_GRP_NEON: Type = 133;
    pub const ARM_GRP_T2EXTRACTPACK: Type = 134;
    pub const ARM_GRP_THUMB2DSP: Type = 135;
    pub const ARM_GRP_TRUSTZONE: Type = 136;
    pub const ARM_GRP_V4T: Type = 137;
    pub const ARM_GRP_V5T: Type = 138;
    pub const ARM_GRP_V5TE: Type = 139;
    pub const ARM_GRP_V6: Type = 140;
    pub const ARM_GRP_V6T2: Type = 141;
    pub const ARM_GRP_V7: Type = 142;
    pub const ARM_GRP_V8: Type = 143;
    pub const ARM_GRP_VFP2: Type = 144;
    pub const ARM_GRP_VFP3: Type = 145;
    pub const ARM_GRP_VFP4: Type = 146;
    pub const ARM_GRP_ARM: Type = 147;
    pub const ARM_GRP_MCLASS: Type = 148;
    pub const ARM_GRP_NOTMCLASS: Type = 149;
    pub const ARM_GRP_THUMB: Type = 150;
    pub const ARM_GRP_THUMB1ONLY: Type = 151;
    pub const ARM_GRP_THUMB2: Type = 152;
    pub const ARM_GRP_PREV8: Type = 153;
    pub const ARM_GRP_FPVMLX: Type = 154;
    pub const ARM_GRP_MULOPS: Type = 155;
    pub const ARM_GRP_CRC: Type = 156;
    pub const ARM_GRP_DPVFP: Type = 157;
    pub const ARM_GRP_V6M: Type = 158;
    pub const ARM_GRP_VIRTUALIZATION: Type = 159;
    pub const ARM_GRP_ENDING: Type = 160;
}
#[repr(u32)]
#[doc = " ARM64 shift type"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_shifter {
    ARM64_SFT_INVALID = 0,
    ARM64_SFT_LSL = 1,
    ARM64_SFT_MSL = 2,
    ARM64_SFT_LSR = 3,
    ARM64_SFT_ASR = 4,
    ARM64_SFT_ROR = 5,
}
#[repr(u32)]
#[doc = " ARM64 extender type"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_extender {
    ARM64_EXT_INVALID = 0,
    ARM64_EXT_UXTB = 1,
    ARM64_EXT_UXTH = 2,
    ARM64_EXT_UXTW = 3,
    ARM64_EXT_UXTX = 4,
    ARM64_EXT_SXTB = 5,
    ARM64_EXT_SXTH = 6,
    ARM64_EXT_SXTW = 7,
    ARM64_EXT_SXTX = 8,
}
#[repr(u32)]
#[doc = " ARM64 condition code"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_cc {
    ARM64_CC_INVALID = 0,
    #[doc = "< Equal"]
    ARM64_CC_EQ = 1,
    #[doc = "< Not equal:                 Not equal, or unordered"]
    ARM64_CC_NE = 2,
    #[doc = "< Unsigned higher or same:   >, ==, or unordered"]
    ARM64_CC_HS = 3,
    #[doc = "< Unsigned lower or same:    Less than"]
    ARM64_CC_LO = 4,
    #[doc = "< Minus, negative:           Less than"]
    ARM64_CC_MI = 5,
    #[doc = "< Plus, positive or zero:    >, ==, or unordered"]
    ARM64_CC_PL = 6,
    #[doc = "< Overflow:                  Unordered"]
    ARM64_CC_VS = 7,
    #[doc = "< No overflow:               Ordered"]
    ARM64_CC_VC = 8,
    #[doc = "< Unsigned higher:           Greater than, or unordered"]
    ARM64_CC_HI = 9,
    #[doc = "< Unsigned lower or same:    Less than or equal"]
    ARM64_CC_LS = 10,
    #[doc = "< Greater than or equal:     Greater than or equal"]
    ARM64_CC_GE = 11,
    #[doc = "< Less than:                 Less than, or unordered"]
    ARM64_CC_LT = 12,
    #[doc = "< Signed greater than:       Greater than"]
    ARM64_CC_GT = 13,
    #[doc = "< Signed less than or equal: <, ==, or unordered"]
    ARM64_CC_LE = 14,
    #[doc = "< Always (unconditional):    Always (unconditional)"]
    ARM64_CC_AL = 15,
    #[doc = "< Always (unconditional):   Always (unconditional)"]
    ARM64_CC_NV = 16,
}
#[repr(u32)]
#[doc = " System registers"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_sysreg {
    ARM64_SYSREG_INVALID = 0,
    ARM64_SYSREG_MDCCSR_EL0 = 38920,
    ARM64_SYSREG_DBGDTRRX_EL0 = 38952,
    ARM64_SYSREG_MDRAR_EL1 = 32896,
    ARM64_SYSREG_OSLSR_EL1 = 32908,
    ARM64_SYSREG_DBGAUTHSTATUS_EL1 = 33782,
    ARM64_SYSREG_PMCEID0_EL0 = 56550,
    ARM64_SYSREG_PMCEID1_EL0 = 56551,
    ARM64_SYSREG_MIDR_EL1 = 49152,
    ARM64_SYSREG_CCSIDR_EL1 = 51200,
    ARM64_SYSREG_CLIDR_EL1 = 51201,
    ARM64_SYSREG_CTR_EL0 = 55297,
    ARM64_SYSREG_MPIDR_EL1 = 49157,
    ARM64_SYSREG_REVIDR_EL1 = 49158,
    ARM64_SYSREG_AIDR_EL1 = 51207,
    ARM64_SYSREG_DCZID_EL0 = 55303,
    ARM64_SYSREG_ID_PFR0_EL1 = 49160,
    ARM64_SYSREG_ID_PFR1_EL1 = 49161,
    ARM64_SYSREG_ID_DFR0_EL1 = 49162,
    ARM64_SYSREG_ID_AFR0_EL1 = 49163,
    ARM64_SYSREG_ID_MMFR0_EL1 = 49164,
    ARM64_SYSREG_ID_MMFR1_EL1 = 49165,
    ARM64_SYSREG_ID_MMFR2_EL1 = 49166,
    ARM64_SYSREG_ID_MMFR3_EL1 = 49167,
    ARM64_SYSREG_ID_ISAR0_EL1 = 49168,
    ARM64_SYSREG_ID_ISAR1_EL1 = 49169,
    ARM64_SYSREG_ID_ISAR2_EL1 = 49170,
    ARM64_SYSREG_ID_ISAR3_EL1 = 49171,
    ARM64_SYSREG_ID_ISAR4_EL1 = 49172,
    ARM64_SYSREG_ID_ISAR5_EL1 = 49173,
    ARM64_SYSREG_ID_A64PFR0_EL1 = 49184,
    ARM64_SYSREG_ID_A64PFR1_EL1 = 49185,
    ARM64_SYSREG_ID_A64DFR0_EL1 = 49192,
    ARM64_SYSREG_ID_A64DFR1_EL1 = 49193,
    ARM64_SYSREG_ID_A64AFR0_EL1 = 49196,
    ARM64_SYSREG_ID_A64AFR1_EL1 = 49197,
    ARM64_SYSREG_ID_A64ISAR0_EL1 = 49200,
    ARM64_SYSREG_ID_A64ISAR1_EL1 = 49201,
    ARM64_SYSREG_ID_A64MMFR0_EL1 = 49208,
    ARM64_SYSREG_ID_A64MMFR1_EL1 = 49209,
    ARM64_SYSREG_MVFR0_EL1 = 49176,
    ARM64_SYSREG_MVFR1_EL1 = 49177,
    ARM64_SYSREG_MVFR2_EL1 = 49178,
    ARM64_SYSREG_RVBAR_EL1 = 50689,
    ARM64_SYSREG_RVBAR_EL2 = 58881,
    ARM64_SYSREG_RVBAR_EL3 = 62977,
    ARM64_SYSREG_ISR_EL1 = 50696,
    ARM64_SYSREG_CNTPCT_EL0 = 57089,
    ARM64_SYSREG_CNTVCT_EL0 = 57090,
    ARM64_SYSREG_TRCSTATR = 34840,
    ARM64_SYSREG_TRCIDR8 = 34822,
    ARM64_SYSREG_TRCIDR9 = 34830,
    ARM64_SYSREG_TRCIDR10 = 34838,
    ARM64_SYSREG_TRCIDR11 = 34846,
    ARM64_SYSREG_TRCIDR12 = 34854,
    ARM64_SYSREG_TRCIDR13 = 34862,
    ARM64_SYSREG_TRCIDR0 = 34887,
    ARM64_SYSREG_TRCIDR1 = 34895,
    ARM64_SYSREG_TRCIDR2 = 34903,
    ARM64_SYSREG_TRCIDR3 = 34911,
    ARM64_SYSREG_TRCIDR4 = 34919,
    ARM64_SYSREG_TRCIDR5 = 34927,
    ARM64_SYSREG_TRCIDR6 = 34935,
    ARM64_SYSREG_TRCIDR7 = 34943,
    ARM64_SYSREG_TRCOSLSR = 34956,
    ARM64_SYSREG_TRCPDSR = 34988,
    ARM64_SYSREG_TRCDEVAFF0 = 35798,
    ARM64_SYSREG_TRCDEVAFF1 = 35806,
    ARM64_SYSREG_TRCLSR = 35822,
    ARM64_SYSREG_TRCAUTHSTATUS = 35830,
    ARM64_SYSREG_TRCDEVARCH = 35838,
    ARM64_SYSREG_TRCDEVID = 35735,
    ARM64_SYSREG_TRCDEVTYPE = 35743,
    ARM64_SYSREG_TRCPIDR4 = 35751,
    ARM64_SYSREG_TRCPIDR5 = 35759,
    ARM64_SYSREG_TRCPIDR6 = 35767,
    ARM64_SYSREG_TRCPIDR7 = 35775,
    ARM64_SYSREG_TRCPIDR0 = 35783,
    ARM64_SYSREG_TRCPIDR1 = 35791,
    ARM64_SYSREG_TRCPIDR2 = 35799,
    ARM64_SYSREG_TRCPIDR3 = 35807,
    ARM64_SYSREG_TRCCIDR0 = 35815,
    ARM64_SYSREG_TRCCIDR1 = 35823,
    ARM64_SYSREG_TRCCIDR2 = 35831,
    ARM64_SYSREG_TRCCIDR3 = 35839,
    ARM64_SYSREG_ICC_IAR1_EL1 = 50784,
    ARM64_SYSREG_ICC_IAR0_EL1 = 50752,
    ARM64_SYSREG_ICC_HPPIR1_EL1 = 50786,
    ARM64_SYSREG_ICC_HPPIR0_EL1 = 50754,
    ARM64_SYSREG_ICC_RPR_EL1 = 50779,
    ARM64_SYSREG_ICH_VTR_EL2 = 58969,
    ARM64_SYSREG_ICH_EISR_EL2 = 58971,
    ARM64_SYSREG_ICH_ELSR_EL2 = 58973,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_msr_reg {
    ARM64_SYSREG_DBGDTRTX_EL0 = 38952,
    ARM64_SYSREG_OSLAR_EL1 = 32900,
    ARM64_SYSREG_PMSWINC_EL0 = 56548,
    ARM64_SYSREG_TRCOSLAR = 34948,
    ARM64_SYSREG_TRCLAR = 35814,
    ARM64_SYSREG_ICC_EOIR1_EL1 = 50785,
    ARM64_SYSREG_ICC_EOIR0_EL1 = 50753,
    ARM64_SYSREG_ICC_DIR_EL1 = 50777,
    ARM64_SYSREG_ICC_SGI1R_EL1 = 50781,
    ARM64_SYSREG_ICC_ASGI1R_EL1 = 50782,
    ARM64_SYSREG_ICC_SGI0R_EL1 = 50783,
}
#[repr(u32)]
#[doc = " System PState Field (MSR instruction)"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_pstate {
    ARM64_PSTATE_INVALID = 0,
    ARM64_PSTATE_SPSEL = 5,
    ARM64_PSTATE_DAIFSET = 30,
    ARM64_PSTATE_DAIFCLR = 31,
}
#[repr(u32)]
#[doc = " Vector arrangement specifier (for FloatingPoint/Advanced SIMD insn)"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_vas {
    ARM64_VAS_INVALID = 0,
    ARM64_VAS_8B = 1,
    ARM64_VAS_16B = 2,
    ARM64_VAS_4H = 3,
    ARM64_VAS_8H = 4,
    ARM64_VAS_2S = 5,
    ARM64_VAS_4S = 6,
    ARM64_VAS_1D = 7,
    ARM64_VAS_2D = 8,
    ARM64_VAS_1Q = 9,
}
#[repr(u32)]
#[doc = " Vector element size specifier"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_vess {
    ARM64_VESS_INVALID = 0,
    ARM64_VESS_B = 1,
    ARM64_VESS_H = 2,
    ARM64_VESS_S = 3,
    ARM64_VESS_D = 4,
}
#[repr(u32)]
#[doc = " Memory barrier operands"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_barrier_op {
    ARM64_BARRIER_INVALID = 0,
    ARM64_BARRIER_OSHLD = 1,
    ARM64_BARRIER_OSHST = 2,
    ARM64_BARRIER_OSH = 3,
    ARM64_BARRIER_NSHLD = 5,
    ARM64_BARRIER_NSHST = 6,
    ARM64_BARRIER_NSH = 7,
    ARM64_BARRIER_ISHLD = 9,
    ARM64_BARRIER_ISHST = 10,
    ARM64_BARRIER_ISH = 11,
    ARM64_BARRIER_LD = 13,
    ARM64_BARRIER_ST = 14,
    ARM64_BARRIER_SY = 15,
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    ARM64_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    ARM64_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    ARM64_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    ARM64_OP_MEM = 3,
    #[doc = "< = CS_OP_FP (Floating-Point operand)."]
    ARM64_OP_FP = 4,
    #[doc = "< C-Immediate"]
    ARM64_OP_CIMM = 64,
    #[doc = "< MRS register operand."]
    ARM64_OP_REG_MRS = 65,
    #[doc = "< MSR register operand."]
    ARM64_OP_REG_MSR = 66,
    #[doc = "< PState operand."]
    ARM64_OP_PSTATE = 67,
    #[doc = "< SYS operand for IC/DC/AT/TLBI instructions."]
    ARM64_OP_SYS = 68,
    #[doc = "< Prefetch operand (PRFM)."]
    ARM64_OP_PREFETCH = 69,
    #[doc = "< Memory barrier operand (ISB/DMB/DSB instructions)."]
    ARM64_OP_BARRIER = 70,
}
#[repr(u32)]
#[doc = " TLBI operations"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_tlbi_op {
    ARM64_TLBI_INVALID = 0,
    ARM64_TLBI_VMALLE1IS = 1,
    ARM64_TLBI_VAE1IS = 2,
    ARM64_TLBI_ASIDE1IS = 3,
    ARM64_TLBI_VAAE1IS = 4,
    ARM64_TLBI_VALE1IS = 5,
    ARM64_TLBI_VAALE1IS = 6,
    ARM64_TLBI_ALLE2IS = 7,
    ARM64_TLBI_VAE2IS = 8,
    ARM64_TLBI_ALLE1IS = 9,
    ARM64_TLBI_VALE2IS = 10,
    ARM64_TLBI_VMALLS12E1IS = 11,
    ARM64_TLBI_ALLE3IS = 12,
    ARM64_TLBI_VAE3IS = 13,
    ARM64_TLBI_VALE3IS = 14,
    ARM64_TLBI_IPAS2E1IS = 15,
    ARM64_TLBI_IPAS2LE1IS = 16,
    ARM64_TLBI_IPAS2E1 = 17,
    ARM64_TLBI_IPAS2LE1 = 18,
    ARM64_TLBI_VMALLE1 = 19,
    ARM64_TLBI_VAE1 = 20,
    ARM64_TLBI_ASIDE1 = 21,
    ARM64_TLBI_VAAE1 = 22,
    ARM64_TLBI_VALE1 = 23,
    ARM64_TLBI_VAALE1 = 24,
    ARM64_TLBI_ALLE2 = 25,
    ARM64_TLBI_VAE2 = 26,
    ARM64_TLBI_ALLE1 = 27,
    ARM64_TLBI_VALE2 = 28,
    ARM64_TLBI_VMALLS12E1 = 29,
    ARM64_TLBI_ALLE3 = 30,
    ARM64_TLBI_VAE3 = 31,
    ARM64_TLBI_VALE3 = 32,
}
#[repr(u32)]
#[doc = " AT operations"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_at_op {
    ARM64_AT_S1E1R = 0,
    ARM64_AT_S1E1W = 1,
    ARM64_AT_S1E0R = 2,
    ARM64_AT_S1E0W = 3,
    ARM64_AT_S1E2R = 4,
    ARM64_AT_S1E2W = 5,
    ARM64_AT_S12E1R = 6,
    ARM64_AT_S12E1W = 7,
    ARM64_AT_S12E0R = 8,
    ARM64_AT_S12E0W = 9,
    ARM64_AT_S1E3R = 10,
    ARM64_AT_S1E3W = 11,
}
#[repr(u32)]
#[doc = " DC operations"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_dc_op {
    ARM64_DC_INVALID = 0,
    ARM64_DC_ZVA = 1,
    ARM64_DC_IVAC = 2,
    ARM64_DC_ISW = 3,
    ARM64_DC_CVAC = 4,
    ARM64_DC_CSW = 5,
    ARM64_DC_CVAU = 6,
    ARM64_DC_CIVAC = 7,
    ARM64_DC_CISW = 8,
}
#[repr(u32)]
#[doc = " IC operations"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_ic_op {
    ARM64_IC_INVALID = 0,
    ARM64_IC_IALLUIS = 1,
    ARM64_IC_IALLU = 2,
    ARM64_IC_IVAU = 3,
}
#[repr(u32)]
#[doc = " Prefetch operations (PRFM)"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_prefetch_op {
    ARM64_PRFM_INVALID = 0,
    ARM64_PRFM_PLDL1KEEP = 1,
    ARM64_PRFM_PLDL1STRM = 2,
    ARM64_PRFM_PLDL2KEEP = 3,
    ARM64_PRFM_PLDL2STRM = 4,
    ARM64_PRFM_PLDL3KEEP = 5,
    ARM64_PRFM_PLDL3STRM = 6,
    ARM64_PRFM_PLIL1KEEP = 9,
    ARM64_PRFM_PLIL1STRM = 10,
    ARM64_PRFM_PLIL2KEEP = 11,
    ARM64_PRFM_PLIL2STRM = 12,
    ARM64_PRFM_PLIL3KEEP = 13,
    ARM64_PRFM_PLIL3STRM = 14,
    ARM64_PRFM_PSTL1KEEP = 17,
    ARM64_PRFM_PSTL1STRM = 18,
    ARM64_PRFM_PSTL2KEEP = 19,
    ARM64_PRFM_PSTL2STRM = 20,
    ARM64_PRFM_PSTL3KEEP = 21,
    ARM64_PRFM_PSTL3STRM = 22,
}
pub mod arm64_reg {
    #[doc = " ARM64 registers"]
    pub type Type = u32;
    pub const ARM64_REG_INVALID: Type = 0;
    pub const ARM64_REG_X29: Type = 1;
    pub const ARM64_REG_X30: Type = 2;
    pub const ARM64_REG_NZCV: Type = 3;
    pub const ARM64_REG_SP: Type = 4;
    pub const ARM64_REG_WSP: Type = 5;
    pub const ARM64_REG_WZR: Type = 6;
    pub const ARM64_REG_XZR: Type = 7;
    pub const ARM64_REG_B0: Type = 8;
    pub const ARM64_REG_B1: Type = 9;
    pub const ARM64_REG_B2: Type = 10;
    pub const ARM64_REG_B3: Type = 11;
    pub const ARM64_REG_B4: Type = 12;
    pub const ARM64_REG_B5: Type = 13;
    pub const ARM64_REG_B6: Type = 14;
    pub const ARM64_REG_B7: Type = 15;
    pub const ARM64_REG_B8: Type = 16;
    pub const ARM64_REG_B9: Type = 17;
    pub const ARM64_REG_B10: Type = 18;
    pub const ARM64_REG_B11: Type = 19;
    pub const ARM64_REG_B12: Type = 20;
    pub const ARM64_REG_B13: Type = 21;
    pub const ARM64_REG_B14: Type = 22;
    pub const ARM64_REG_B15: Type = 23;
    pub const ARM64_REG_B16: Type = 24;
    pub const ARM64_REG_B17: Type = 25;
    pub const ARM64_REG_B18: Type = 26;
    pub const ARM64_REG_B19: Type = 27;
    pub const ARM64_REG_B20: Type = 28;
    pub const ARM64_REG_B21: Type = 29;
    pub const ARM64_REG_B22: Type = 30;
    pub const ARM64_REG_B23: Type = 31;
    pub const ARM64_REG_B24: Type = 32;
    pub const ARM64_REG_B25: Type = 33;
    pub const ARM64_REG_B26: Type = 34;
    pub const ARM64_REG_B27: Type = 35;
    pub const ARM64_REG_B28: Type = 36;
    pub const ARM64_REG_B29: Type = 37;
    pub const ARM64_REG_B30: Type = 38;
    pub const ARM64_REG_B31: Type = 39;
    pub const ARM64_REG_D0: Type = 40;
    pub const ARM64_REG_D1: Type = 41;
    pub const ARM64_REG_D2: Type = 42;
    pub const ARM64_REG_D3: Type = 43;
    pub const ARM64_REG_D4: Type = 44;
    pub const ARM64_REG_D5: Type = 45;
    pub const ARM64_REG_D6: Type = 46;
    pub const ARM64_REG_D7: Type = 47;
    pub const ARM64_REG_D8: Type = 48;
    pub const ARM64_REG_D9: Type = 49;
    pub const ARM64_REG_D10: Type = 50;
    pub const ARM64_REG_D11: Type = 51;
    pub const ARM64_REG_D12: Type = 52;
    pub const ARM64_REG_D13: Type = 53;
    pub const ARM64_REG_D14: Type = 54;
    pub const ARM64_REG_D15: Type = 55;
    pub const ARM64_REG_D16: Type = 56;
    pub const ARM64_REG_D17: Type = 57;
    pub const ARM64_REG_D18: Type = 58;
    pub const ARM64_REG_D19: Type = 59;
    pub const ARM64_REG_D20: Type = 60;
    pub const ARM64_REG_D21: Type = 61;
    pub const ARM64_REG_D22: Type = 62;
    pub const ARM64_REG_D23: Type = 63;
    pub const ARM64_REG_D24: Type = 64;
    pub const ARM64_REG_D25: Type = 65;
    pub const ARM64_REG_D26: Type = 66;
    pub const ARM64_REG_D27: Type = 67;
    pub const ARM64_REG_D28: Type = 68;
    pub const ARM64_REG_D29: Type = 69;
    pub const ARM64_REG_D30: Type = 70;
    pub const ARM64_REG_D31: Type = 71;
    pub const ARM64_REG_H0: Type = 72;
    pub const ARM64_REG_H1: Type = 73;
    pub const ARM64_REG_H2: Type = 74;
    pub const ARM64_REG_H3: Type = 75;
    pub const ARM64_REG_H4: Type = 76;
    pub const ARM64_REG_H5: Type = 77;
    pub const ARM64_REG_H6: Type = 78;
    pub const ARM64_REG_H7: Type = 79;
    pub const ARM64_REG_H8: Type = 80;
    pub const ARM64_REG_H9: Type = 81;
    pub const ARM64_REG_H10: Type = 82;
    pub const ARM64_REG_H11: Type = 83;
    pub const ARM64_REG_H12: Type = 84;
    pub const ARM64_REG_H13: Type = 85;
    pub const ARM64_REG_H14: Type = 86;
    pub const ARM64_REG_H15: Type = 87;
    pub const ARM64_REG_H16: Type = 88;
    pub const ARM64_REG_H17: Type = 89;
    pub const ARM64_REG_H18: Type = 90;
    pub const ARM64_REG_H19: Type = 91;
    pub const ARM64_REG_H20: Type = 92;
    pub const ARM64_REG_H21: Type = 93;
    pub const ARM64_REG_H22: Type = 94;
    pub const ARM64_REG_H23: Type = 95;
    pub const ARM64_REG_H24: Type = 96;
    pub const ARM64_REG_H25: Type = 97;
    pub const ARM64_REG_H26: Type = 98;
    pub const ARM64_REG_H27: Type = 99;
    pub const ARM64_REG_H28: Type = 100;
    pub const ARM64_REG_H29: Type = 101;
    pub const ARM64_REG_H30: Type = 102;
    pub const ARM64_REG_H31: Type = 103;
    pub const ARM64_REG_Q0: Type = 104;
    pub const ARM64_REG_Q1: Type = 105;
    pub const ARM64_REG_Q2: Type = 106;
    pub const ARM64_REG_Q3: Type = 107;
    pub const ARM64_REG_Q4: Type = 108;
    pub const ARM64_REG_Q5: Type = 109;
    pub const ARM64_REG_Q6: Type = 110;
    pub const ARM64_REG_Q7: Type = 111;
    pub const ARM64_REG_Q8: Type = 112;
    pub const ARM64_REG_Q9: Type = 113;
    pub const ARM64_REG_Q10: Type = 114;
    pub const ARM64_REG_Q11: Type = 115;
    pub const ARM64_REG_Q12: Type = 116;
    pub const ARM64_REG_Q13: Type = 117;
    pub const ARM64_REG_Q14: Type = 118;
    pub const ARM64_REG_Q15: Type = 119;
    pub const ARM64_REG_Q16: Type = 120;
    pub const ARM64_REG_Q17: Type = 121;
    pub const ARM64_REG_Q18: Type = 122;
    pub const ARM64_REG_Q19: Type = 123;
    pub const ARM64_REG_Q20: Type = 124;
    pub const ARM64_REG_Q21: Type = 125;
    pub const ARM64_REG_Q22: Type = 126;
    pub const ARM64_REG_Q23: Type = 127;
    pub const ARM64_REG_Q24: Type = 128;
    pub const ARM64_REG_Q25: Type = 129;
    pub const ARM64_REG_Q26: Type = 130;
    pub const ARM64_REG_Q27: Type = 131;
    pub const ARM64_REG_Q28: Type = 132;
    pub const ARM64_REG_Q29: Type = 133;
    pub const ARM64_REG_Q30: Type = 134;
    pub const ARM64_REG_Q31: Type = 135;
    pub const ARM64_REG_S0: Type = 136;
    pub const ARM64_REG_S1: Type = 137;
    pub const ARM64_REG_S2: Type = 138;
    pub const ARM64_REG_S3: Type = 139;
    pub const ARM64_REG_S4: Type = 140;
    pub const ARM64_REG_S5: Type = 141;
    pub const ARM64_REG_S6: Type = 142;
    pub const ARM64_REG_S7: Type = 143;
    pub const ARM64_REG_S8: Type = 144;
    pub const ARM64_REG_S9: Type = 145;
    pub const ARM64_REG_S10: Type = 146;
    pub const ARM64_REG_S11: Type = 147;
    pub const ARM64_REG_S12: Type = 148;
    pub const ARM64_REG_S13: Type = 149;
    pub const ARM64_REG_S14: Type = 150;
    pub const ARM64_REG_S15: Type = 151;
    pub const ARM64_REG_S16: Type = 152;
    pub const ARM64_REG_S17: Type = 153;
    pub const ARM64_REG_S18: Type = 154;
    pub const ARM64_REG_S19: Type = 155;
    pub const ARM64_REG_S20: Type = 156;
    pub const ARM64_REG_S21: Type = 157;
    pub const ARM64_REG_S22: Type = 158;
    pub const ARM64_REG_S23: Type = 159;
    pub const ARM64_REG_S24: Type = 160;
    pub const ARM64_REG_S25: Type = 161;
    pub const ARM64_REG_S26: Type = 162;
    pub const ARM64_REG_S27: Type = 163;
    pub const ARM64_REG_S28: Type = 164;
    pub const ARM64_REG_S29: Type = 165;
    pub const ARM64_REG_S30: Type = 166;
    pub const ARM64_REG_S31: Type = 167;
    pub const ARM64_REG_W0: Type = 168;
    pub const ARM64_REG_W1: Type = 169;
    pub const ARM64_REG_W2: Type = 170;
    pub const ARM64_REG_W3: Type = 171;
    pub const ARM64_REG_W4: Type = 172;
    pub const ARM64_REG_W5: Type = 173;
    pub const ARM64_REG_W6: Type = 174;
    pub const ARM64_REG_W7: Type = 175;
    pub const ARM64_REG_W8: Type = 176;
    pub const ARM64_REG_W9: Type = 177;
    pub const ARM64_REG_W10: Type = 178;
    pub const ARM64_REG_W11: Type = 179;
    pub const ARM64_REG_W12: Type = 180;
    pub const ARM64_REG_W13: Type = 181;
    pub const ARM64_REG_W14: Type = 182;
    pub const ARM64_REG_W15: Type = 183;
    pub const ARM64_REG_W16: Type = 184;
    pub const ARM64_REG_W17: Type = 185;
    pub const ARM64_REG_W18: Type = 186;
    pub const ARM64_REG_W19: Type = 187;
    pub const ARM64_REG_W20: Type = 188;
    pub const ARM64_REG_W21: Type = 189;
    pub const ARM64_REG_W22: Type = 190;
    pub const ARM64_REG_W23: Type = 191;
    pub const ARM64_REG_W24: Type = 192;
    pub const ARM64_REG_W25: Type = 193;
    pub const ARM64_REG_W26: Type = 194;
    pub const ARM64_REG_W27: Type = 195;
    pub const ARM64_REG_W28: Type = 196;
    pub const ARM64_REG_W29: Type = 197;
    pub const ARM64_REG_W30: Type = 198;
    pub const ARM64_REG_X0: Type = 199;
    pub const ARM64_REG_X1: Type = 200;
    pub const ARM64_REG_X2: Type = 201;
    pub const ARM64_REG_X3: Type = 202;
    pub const ARM64_REG_X4: Type = 203;
    pub const ARM64_REG_X5: Type = 204;
    pub const ARM64_REG_X6: Type = 205;
    pub const ARM64_REG_X7: Type = 206;
    pub const ARM64_REG_X8: Type = 207;
    pub const ARM64_REG_X9: Type = 208;
    pub const ARM64_REG_X10: Type = 209;
    pub const ARM64_REG_X11: Type = 210;
    pub const ARM64_REG_X12: Type = 211;
    pub const ARM64_REG_X13: Type = 212;
    pub const ARM64_REG_X14: Type = 213;
    pub const ARM64_REG_X15: Type = 214;
    pub const ARM64_REG_X16: Type = 215;
    pub const ARM64_REG_X17: Type = 216;
    pub const ARM64_REG_X18: Type = 217;
    pub const ARM64_REG_X19: Type = 218;
    pub const ARM64_REG_X20: Type = 219;
    pub const ARM64_REG_X21: Type = 220;
    pub const ARM64_REG_X22: Type = 221;
    pub const ARM64_REG_X23: Type = 222;
    pub const ARM64_REG_X24: Type = 223;
    pub const ARM64_REG_X25: Type = 224;
    pub const ARM64_REG_X26: Type = 225;
    pub const ARM64_REG_X27: Type = 226;
    pub const ARM64_REG_X28: Type = 227;
    pub const ARM64_REG_V0: Type = 228;
    pub const ARM64_REG_V1: Type = 229;
    pub const ARM64_REG_V2: Type = 230;
    pub const ARM64_REG_V3: Type = 231;
    pub const ARM64_REG_V4: Type = 232;
    pub const ARM64_REG_V5: Type = 233;
    pub const ARM64_REG_V6: Type = 234;
    pub const ARM64_REG_V7: Type = 235;
    pub const ARM64_REG_V8: Type = 236;
    pub const ARM64_REG_V9: Type = 237;
    pub const ARM64_REG_V10: Type = 238;
    pub const ARM64_REG_V11: Type = 239;
    pub const ARM64_REG_V12: Type = 240;
    pub const ARM64_REG_V13: Type = 241;
    pub const ARM64_REG_V14: Type = 242;
    pub const ARM64_REG_V15: Type = 243;
    pub const ARM64_REG_V16: Type = 244;
    pub const ARM64_REG_V17: Type = 245;
    pub const ARM64_REG_V18: Type = 246;
    pub const ARM64_REG_V19: Type = 247;
    pub const ARM64_REG_V20: Type = 248;
    pub const ARM64_REG_V21: Type = 249;
    pub const ARM64_REG_V22: Type = 250;
    pub const ARM64_REG_V23: Type = 251;
    pub const ARM64_REG_V24: Type = 252;
    pub const ARM64_REG_V25: Type = 253;
    pub const ARM64_REG_V26: Type = 254;
    pub const ARM64_REG_V27: Type = 255;
    pub const ARM64_REG_V28: Type = 256;
    pub const ARM64_REG_V29: Type = 257;
    pub const ARM64_REG_V30: Type = 258;
    pub const ARM64_REG_V31: Type = 259;
    pub const ARM64_REG_ENDING: Type = 260;
    pub const ARM64_REG_IP0: Type = 215;
    pub const ARM64_REG_IP1: Type = 216;
    pub const ARM64_REG_FP: Type = 1;
    pub const ARM64_REG_LR: Type = 2;
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with ARM64_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct arm64_op_mem {
    #[doc = "< base register"]
    pub base: arm64_reg::Type,
    #[doc = "< index register"]
    pub index: arm64_reg::Type,
    #[doc = "< displacement/offset value"]
    pub disp: i32,
}
impl Clone for arm64_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_arm64_op {
    #[doc = "< Vector Index for some vector operands (or -1 if irrelevant)"]
    pub vector_index: libc::c_int,
    #[doc = "< Vector Arrangement Specifier"]
    pub vas: arm64_vas,
    #[doc = "< Vector Element Size Specifier"]
    pub vess: arm64_vess,
    pub shift: cs_arm64_op__bindgen_ty_1,
    #[doc = "< extender type of this operand"]
    pub ext: arm64_extender,
    #[doc = "< operand type"]
    pub type_: arm64_op_type,
    pub __bindgen_anon_1: cs_arm64_op__bindgen_ty_2,
    #[doc = " How is this operand accessed? (READ, WRITE or READ|WRITE)"]
    #[doc = " This field is combined of cs_ac_type."]
    #[doc = " NOTE: this field is irrelevant if engine is compiled in DIET mode."]
    pub access: u8,
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_arm64_op__bindgen_ty_1 {
    #[doc = "< shifter type of this operand"]
    pub type_: arm64_shifter,
    #[doc = "< shifter value of this operand"]
    pub value: libc::c_uint,
}
impl Clone for cs_arm64_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Copy)]
pub union cs_arm64_op__bindgen_ty_2 {
    #[doc = "< register value for REG operand"]
    pub reg: arm64_reg::Type,
    #[doc = "< immediate value, or index for C-IMM or IMM operand"]
    pub imm: i64,
    #[doc = "< floating point value for FP operand"]
    pub fp: f64,
    #[doc = "< base/index/scale/disp value for MEM operand"]
    pub mem: arm64_op_mem,
    #[doc = "< PState field of MSR instruction."]
    pub pstate: arm64_pstate,
    #[doc = "< IC/DC/AT/TLBI operation (see arm64_ic_op, arm64_dc_op, arm64_at_op, arm64_tlbi_op)"]
    pub sys: libc::c_uint,
    #[doc = "< PRFM operation."]
    pub prefetch: arm64_prefetch_op,
    #[doc = "< Memory barrier operation (ISB/DMB/DSB instructions)."]
    pub barrier: arm64_barrier_op,
    _bindgen_union_align: [u64; 2usize],
}
impl Clone for cs_arm64_op__bindgen_ty_2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_arm64_op__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_arm64_op__bindgen_ty_2 {{ union }}")
    }
}
impl Clone for cs_arm64_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_arm64_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! ( f , "cs_arm64_op {{ vector_index: {:?}, vas: {:?}, vess: {:?}, shift: {:?}, ext: {:?}, type: {:?}, __bindgen_anon_1: {:?}, access: {:?} }}" , self . vector_index , self . vas , self . vess , self . shift , self . ext , self . type_ , self . __bindgen_anon_1 , self . access )
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_arm64 {
    #[doc = "< conditional code for this insn"]
    pub cc: arm64_cc,
    #[doc = "< does this insn update flags?"]
    pub update_flags: bool,
    #[doc = "< does this insn request writeback? 'True' means 'yes'"]
    pub writeback: bool,
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_arm64_op; 8usize],
}
impl Clone for cs_arm64 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_arm64 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! ( f , "cs_arm64 {{ cc: {:?}, update_flags: {:?}, writeback: {:?}, op_count: {:?}, operands: {:?} }}" , self . cc , self . update_flags , self . writeback , self . op_count , self . operands )
    }
}
#[repr(u32)]
#[doc = " ARM64 instruction"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum arm64_insn {
    ARM64_INS_INVALID = 0,
    ARM64_INS_ABS = 1,
    ARM64_INS_ADC = 2,
    ARM64_INS_ADDHN = 3,
    ARM64_INS_ADDHN2 = 4,
    ARM64_INS_ADDP = 5,
    ARM64_INS_ADD = 6,
    ARM64_INS_ADDV = 7,
    ARM64_INS_ADR = 8,
    ARM64_INS_ADRP = 9,
    ARM64_INS_AESD = 10,
    ARM64_INS_AESE = 11,
    ARM64_INS_AESIMC = 12,
    ARM64_INS_AESMC = 13,
    ARM64_INS_AND = 14,
    ARM64_INS_ASR = 15,
    ARM64_INS_B = 16,
    ARM64_INS_BFM = 17,
    ARM64_INS_BIC = 18,
    ARM64_INS_BIF = 19,
    ARM64_INS_BIT = 20,
    ARM64_INS_BL = 21,
    ARM64_INS_BLR = 22,
    ARM64_INS_BR = 23,
    ARM64_INS_BRK = 24,
    ARM64_INS_BSL = 25,
    ARM64_INS_CBNZ = 26,
    ARM64_INS_CBZ = 27,
    ARM64_INS_CCMN = 28,
    ARM64_INS_CCMP = 29,
    ARM64_INS_CLREX = 30,
    ARM64_INS_CLS = 31,
    ARM64_INS_CLZ = 32,
    ARM64_INS_CMEQ = 33,
    ARM64_INS_CMGE = 34,
    ARM64_INS_CMGT = 35,
    ARM64_INS_CMHI = 36,
    ARM64_INS_CMHS = 37,
    ARM64_INS_CMLE = 38,
    ARM64_INS_CMLT = 39,
    ARM64_INS_CMTST = 40,
    ARM64_INS_CNT = 41,
    ARM64_INS_MOV = 42,
    ARM64_INS_CRC32B = 43,
    ARM64_INS_CRC32CB = 44,
    ARM64_INS_CRC32CH = 45,
    ARM64_INS_CRC32CW = 46,
    ARM64_INS_CRC32CX = 47,
    ARM64_INS_CRC32H = 48,
    ARM64_INS_CRC32W = 49,
    ARM64_INS_CRC32X = 50,
    ARM64_INS_CSEL = 51,
    ARM64_INS_CSINC = 52,
    ARM64_INS_CSINV = 53,
    ARM64_INS_CSNEG = 54,
    ARM64_INS_DCPS1 = 55,
    ARM64_INS_DCPS2 = 56,
    ARM64_INS_DCPS3 = 57,
    ARM64_INS_DMB = 58,
    ARM64_INS_DRPS = 59,
    ARM64_INS_DSB = 60,
    ARM64_INS_DUP = 61,
    ARM64_INS_EON = 62,
    ARM64_INS_EOR = 63,
    ARM64_INS_ERET = 64,
    ARM64_INS_EXTR = 65,
    ARM64_INS_EXT = 66,
    ARM64_INS_FABD = 67,
    ARM64_INS_FABS = 68,
    ARM64_INS_FACGE = 69,
    ARM64_INS_FACGT = 70,
    ARM64_INS_FADD = 71,
    ARM64_INS_FADDP = 72,
    ARM64_INS_FCCMP = 73,
    ARM64_INS_FCCMPE = 74,
    ARM64_INS_FCMEQ = 75,
    ARM64_INS_FCMGE = 76,
    ARM64_INS_FCMGT = 77,
    ARM64_INS_FCMLE = 78,
    ARM64_INS_FCMLT = 79,
    ARM64_INS_FCMP = 80,
    ARM64_INS_FCMPE = 81,
    ARM64_INS_FCSEL = 82,
    ARM64_INS_FCVTAS = 83,
    ARM64_INS_FCVTAU = 84,
    ARM64_INS_FCVT = 85,
    ARM64_INS_FCVTL = 86,
    ARM64_INS_FCVTL2 = 87,
    ARM64_INS_FCVTMS = 88,
    ARM64_INS_FCVTMU = 89,
    ARM64_INS_FCVTNS = 90,
    ARM64_INS_FCVTNU = 91,
    ARM64_INS_FCVTN = 92,
    ARM64_INS_FCVTN2 = 93,
    ARM64_INS_FCVTPS = 94,
    ARM64_INS_FCVTPU = 95,
    ARM64_INS_FCVTXN = 96,
    ARM64_INS_FCVTXN2 = 97,
    ARM64_INS_FCVTZS = 98,
    ARM64_INS_FCVTZU = 99,
    ARM64_INS_FDIV = 100,
    ARM64_INS_FMADD = 101,
    ARM64_INS_FMAX = 102,
    ARM64_INS_FMAXNM = 103,
    ARM64_INS_FMAXNMP = 104,
    ARM64_INS_FMAXNMV = 105,
    ARM64_INS_FMAXP = 106,
    ARM64_INS_FMAXV = 107,
    ARM64_INS_FMIN = 108,
    ARM64_INS_FMINNM = 109,
    ARM64_INS_FMINNMP = 110,
    ARM64_INS_FMINNMV = 111,
    ARM64_INS_FMINP = 112,
    ARM64_INS_FMINV = 113,
    ARM64_INS_FMLA = 114,
    ARM64_INS_FMLS = 115,
    ARM64_INS_FMOV = 116,
    ARM64_INS_FMSUB = 117,
    ARM64_INS_FMUL = 118,
    ARM64_INS_FMULX = 119,
    ARM64_INS_FNEG = 120,
    ARM64_INS_FNMADD = 121,
    ARM64_INS_FNMSUB = 122,
    ARM64_INS_FNMUL = 123,
    ARM64_INS_FRECPE = 124,
    ARM64_INS_FRECPS = 125,
    ARM64_INS_FRECPX = 126,
    ARM64_INS_FRINTA = 127,
    ARM64_INS_FRINTI = 128,
    ARM64_INS_FRINTM = 129,
    ARM64_INS_FRINTN = 130,
    ARM64_INS_FRINTP = 131,
    ARM64_INS_FRINTX = 132,
    ARM64_INS_FRINTZ = 133,
    ARM64_INS_FRSQRTE = 134,
    ARM64_INS_FRSQRTS = 135,
    ARM64_INS_FSQRT = 136,
    ARM64_INS_FSUB = 137,
    ARM64_INS_HINT = 138,
    ARM64_INS_HLT = 139,
    ARM64_INS_HVC = 140,
    ARM64_INS_INS = 141,
    ARM64_INS_ISB = 142,
    ARM64_INS_LD1 = 143,
    ARM64_INS_LD1R = 144,
    ARM64_INS_LD2R = 145,
    ARM64_INS_LD2 = 146,
    ARM64_INS_LD3R = 147,
    ARM64_INS_LD3 = 148,
    ARM64_INS_LD4 = 149,
    ARM64_INS_LD4R = 150,
    ARM64_INS_LDARB = 151,
    ARM64_INS_LDARH = 152,
    ARM64_INS_LDAR = 153,
    ARM64_INS_LDAXP = 154,
    ARM64_INS_LDAXRB = 155,
    ARM64_INS_LDAXRH = 156,
    ARM64_INS_LDAXR = 157,
    ARM64_INS_LDNP = 158,
    ARM64_INS_LDP = 159,
    ARM64_INS_LDPSW = 160,
    ARM64_INS_LDRB = 161,
    ARM64_INS_LDR = 162,
    ARM64_INS_LDRH = 163,
    ARM64_INS_LDRSB = 164,
    ARM64_INS_LDRSH = 165,
    ARM64_INS_LDRSW = 166,
    ARM64_INS_LDTRB = 167,
    ARM64_INS_LDTRH = 168,
    ARM64_INS_LDTRSB = 169,
    ARM64_INS_LDTRSH = 170,
    ARM64_INS_LDTRSW = 171,
    ARM64_INS_LDTR = 172,
    ARM64_INS_LDURB = 173,
    ARM64_INS_LDUR = 174,
    ARM64_INS_LDURH = 175,
    ARM64_INS_LDURSB = 176,
    ARM64_INS_LDURSH = 177,
    ARM64_INS_LDURSW = 178,
    ARM64_INS_LDXP = 179,
    ARM64_INS_LDXRB = 180,
    ARM64_INS_LDXRH = 181,
    ARM64_INS_LDXR = 182,
    ARM64_INS_LSL = 183,
    ARM64_INS_LSR = 184,
    ARM64_INS_MADD = 185,
    ARM64_INS_MLA = 186,
    ARM64_INS_MLS = 187,
    ARM64_INS_MOVI = 188,
    ARM64_INS_MOVK = 189,
    ARM64_INS_MOVN = 190,
    ARM64_INS_MOVZ = 191,
    ARM64_INS_MRS = 192,
    ARM64_INS_MSR = 193,
    ARM64_INS_MSUB = 194,
    ARM64_INS_MUL = 195,
    ARM64_INS_MVNI = 196,
    ARM64_INS_NEG = 197,
    ARM64_INS_NOT = 198,
    ARM64_INS_ORN = 199,
    ARM64_INS_ORR = 200,
    ARM64_INS_PMULL2 = 201,
    ARM64_INS_PMULL = 202,
    ARM64_INS_PMUL = 203,
    ARM64_INS_PRFM = 204,
    ARM64_INS_PRFUM = 205,
    ARM64_INS_RADDHN = 206,
    ARM64_INS_RADDHN2 = 207,
    ARM64_INS_RBIT = 208,
    ARM64_INS_RET = 209,
    ARM64_INS_REV16 = 210,
    ARM64_INS_REV32 = 211,
    ARM64_INS_REV64 = 212,
    ARM64_INS_REV = 213,
    ARM64_INS_ROR = 214,
    ARM64_INS_RSHRN2 = 215,
    ARM64_INS_RSHRN = 216,
    ARM64_INS_RSUBHN = 217,
    ARM64_INS_RSUBHN2 = 218,
    ARM64_INS_SABAL2 = 219,
    ARM64_INS_SABAL = 220,
    ARM64_INS_SABA = 221,
    ARM64_INS_SABDL2 = 222,
    ARM64_INS_SABDL = 223,
    ARM64_INS_SABD = 224,
    ARM64_INS_SADALP = 225,
    ARM64_INS_SADDLP = 226,
    ARM64_INS_SADDLV = 227,
    ARM64_INS_SADDL2 = 228,
    ARM64_INS_SADDL = 229,
    ARM64_INS_SADDW2 = 230,
    ARM64_INS_SADDW = 231,
    ARM64_INS_SBC = 232,
    ARM64_INS_SBFM = 233,
    ARM64_INS_SCVTF = 234,
    ARM64_INS_SDIV = 235,
    ARM64_INS_SHA1C = 236,
    ARM64_INS_SHA1H = 237,
    ARM64_INS_SHA1M = 238,
    ARM64_INS_SHA1P = 239,
    ARM64_INS_SHA1SU0 = 240,
    ARM64_INS_SHA1SU1 = 241,
    ARM64_INS_SHA256H2 = 242,
    ARM64_INS_SHA256H = 243,
    ARM64_INS_SHA256SU0 = 244,
    ARM64_INS_SHA256SU1 = 245,
    ARM64_INS_SHADD = 246,
    ARM64_INS_SHLL2 = 247,
    ARM64_INS_SHLL = 248,
    ARM64_INS_SHL = 249,
    ARM64_INS_SHRN2 = 250,
    ARM64_INS_SHRN = 251,
    ARM64_INS_SHSUB = 252,
    ARM64_INS_SLI = 253,
    ARM64_INS_SMADDL = 254,
    ARM64_INS_SMAXP = 255,
    ARM64_INS_SMAXV = 256,
    ARM64_INS_SMAX = 257,
    ARM64_INS_SMC = 258,
    ARM64_INS_SMINP = 259,
    ARM64_INS_SMINV = 260,
    ARM64_INS_SMIN = 261,
    ARM64_INS_SMLAL2 = 262,
    ARM64_INS_SMLAL = 263,
    ARM64_INS_SMLSL2 = 264,
    ARM64_INS_SMLSL = 265,
    ARM64_INS_SMOV = 266,
    ARM64_INS_SMSUBL = 267,
    ARM64_INS_SMULH = 268,
    ARM64_INS_SMULL2 = 269,
    ARM64_INS_SMULL = 270,
    ARM64_INS_SQABS = 271,
    ARM64_INS_SQADD = 272,
    ARM64_INS_SQDMLAL = 273,
    ARM64_INS_SQDMLAL2 = 274,
    ARM64_INS_SQDMLSL = 275,
    ARM64_INS_SQDMLSL2 = 276,
    ARM64_INS_SQDMULH = 277,
    ARM64_INS_SQDMULL = 278,
    ARM64_INS_SQDMULL2 = 279,
    ARM64_INS_SQNEG = 280,
    ARM64_INS_SQRDMULH = 281,
    ARM64_INS_SQRSHL = 282,
    ARM64_INS_SQRSHRN = 283,
    ARM64_INS_SQRSHRN2 = 284,
    ARM64_INS_SQRSHRUN = 285,
    ARM64_INS_SQRSHRUN2 = 286,
    ARM64_INS_SQSHLU = 287,
    ARM64_INS_SQSHL = 288,
    ARM64_INS_SQSHRN = 289,
    ARM64_INS_SQSHRN2 = 290,
    ARM64_INS_SQSHRUN = 291,
    ARM64_INS_SQSHRUN2 = 292,
    ARM64_INS_SQSUB = 293,
    ARM64_INS_SQXTN2 = 294,
    ARM64_INS_SQXTN = 295,
    ARM64_INS_SQXTUN2 = 296,
    ARM64_INS_SQXTUN = 297,
    ARM64_INS_SRHADD = 298,
    ARM64_INS_SRI = 299,
    ARM64_INS_SRSHL = 300,
    ARM64_INS_SRSHR = 301,
    ARM64_INS_SRSRA = 302,
    ARM64_INS_SSHLL2 = 303,
    ARM64_INS_SSHLL = 304,
    ARM64_INS_SSHL = 305,
    ARM64_INS_SSHR = 306,
    ARM64_INS_SSRA = 307,
    ARM64_INS_SSUBL2 = 308,
    ARM64_INS_SSUBL = 309,
    ARM64_INS_SSUBW2 = 310,
    ARM64_INS_SSUBW = 311,
    ARM64_INS_ST1 = 312,
    ARM64_INS_ST2 = 313,
    ARM64_INS_ST3 = 314,
    ARM64_INS_ST4 = 315,
    ARM64_INS_STLRB = 316,
    ARM64_INS_STLRH = 317,
    ARM64_INS_STLR = 318,
    ARM64_INS_STLXP = 319,
    ARM64_INS_STLXRB = 320,
    ARM64_INS_STLXRH = 321,
    ARM64_INS_STLXR = 322,
    ARM64_INS_STNP = 323,
    ARM64_INS_STP = 324,
    ARM64_INS_STRB = 325,
    ARM64_INS_STR = 326,
    ARM64_INS_STRH = 327,
    ARM64_INS_STTRB = 328,
    ARM64_INS_STTRH = 329,
    ARM64_INS_STTR = 330,
    ARM64_INS_STURB = 331,
    ARM64_INS_STUR = 332,
    ARM64_INS_STURH = 333,
    ARM64_INS_STXP = 334,
    ARM64_INS_STXRB = 335,
    ARM64_INS_STXRH = 336,
    ARM64_INS_STXR = 337,
    ARM64_INS_SUBHN = 338,
    ARM64_INS_SUBHN2 = 339,
    ARM64_INS_SUB = 340,
    ARM64_INS_SUQADD = 341,
    ARM64_INS_SVC = 342,
    ARM64_INS_SYSL = 343,
    ARM64_INS_SYS = 344,
    ARM64_INS_TBL = 345,
    ARM64_INS_TBNZ = 346,
    ARM64_INS_TBX = 347,
    ARM64_INS_TBZ = 348,
    ARM64_INS_TRN1 = 349,
    ARM64_INS_TRN2 = 350,
    ARM64_INS_UABAL2 = 351,
    ARM64_INS_UABAL = 352,
    ARM64_INS_UABA = 353,
    ARM64_INS_UABDL2 = 354,
    ARM64_INS_UABDL = 355,
    ARM64_INS_UABD = 356,
    ARM64_INS_UADALP = 357,
    ARM64_INS_UADDLP = 358,
    ARM64_INS_UADDLV = 359,
    ARM64_INS_UADDL2 = 360,
    ARM64_INS_UADDL = 361,
    ARM64_INS_UADDW2 = 362,
    ARM64_INS_UADDW = 363,
    ARM64_INS_UBFM = 364,
    ARM64_INS_UCVTF = 365,
    ARM64_INS_UDIV = 366,
    ARM64_INS_UHADD = 367,
    ARM64_INS_UHSUB = 368,
    ARM64_INS_UMADDL = 369,
    ARM64_INS_UMAXP = 370,
    ARM64_INS_UMAXV = 371,
    ARM64_INS_UMAX = 372,
    ARM64_INS_UMINP = 373,
    ARM64_INS_UMINV = 374,
    ARM64_INS_UMIN = 375,
    ARM64_INS_UMLAL2 = 376,
    ARM64_INS_UMLAL = 377,
    ARM64_INS_UMLSL2 = 378,
    ARM64_INS_UMLSL = 379,
    ARM64_INS_UMOV = 380,
    ARM64_INS_UMSUBL = 381,
    ARM64_INS_UMULH = 382,
    ARM64_INS_UMULL2 = 383,
    ARM64_INS_UMULL = 384,
    ARM64_INS_UQADD = 385,
    ARM64_INS_UQRSHL = 386,
    ARM64_INS_UQRSHRN = 387,
    ARM64_INS_UQRSHRN2 = 388,
    ARM64_INS_UQSHL = 389,
    ARM64_INS_UQSHRN = 390,
    ARM64_INS_UQSHRN2 = 391,
    ARM64_INS_UQSUB = 392,
    ARM64_INS_UQXTN2 = 393,
    ARM64_INS_UQXTN = 394,
    ARM64_INS_URECPE = 395,
    ARM64_INS_URHADD = 396,
    ARM64_INS_URSHL = 397,
    ARM64_INS_URSHR = 398,
    ARM64_INS_URSQRTE = 399,
    ARM64_INS_URSRA = 400,
    ARM64_INS_USHLL2 = 401,
    ARM64_INS_USHLL = 402,
    ARM64_INS_USHL = 403,
    ARM64_INS_USHR = 404,
    ARM64_INS_USQADD = 405,
    ARM64_INS_USRA = 406,
    ARM64_INS_USUBL2 = 407,
    ARM64_INS_USUBL = 408,
    ARM64_INS_USUBW2 = 409,
    ARM64_INS_USUBW = 410,
    ARM64_INS_UZP1 = 411,
    ARM64_INS_UZP2 = 412,
    ARM64_INS_XTN2 = 413,
    ARM64_INS_XTN = 414,
    ARM64_INS_ZIP1 = 415,
    ARM64_INS_ZIP2 = 416,
    ARM64_INS_MNEG = 417,
    ARM64_INS_UMNEGL = 418,
    ARM64_INS_SMNEGL = 419,
    ARM64_INS_NOP = 420,
    ARM64_INS_YIELD = 421,
    ARM64_INS_WFE = 422,
    ARM64_INS_WFI = 423,
    ARM64_INS_SEV = 424,
    ARM64_INS_SEVL = 425,
    ARM64_INS_NGC = 426,
    ARM64_INS_SBFIZ = 427,
    ARM64_INS_UBFIZ = 428,
    ARM64_INS_SBFX = 429,
    ARM64_INS_UBFX = 430,
    ARM64_INS_BFI = 431,
    ARM64_INS_BFXIL = 432,
    ARM64_INS_CMN = 433,
    ARM64_INS_MVN = 434,
    ARM64_INS_TST = 435,
    ARM64_INS_CSET = 436,
    ARM64_INS_CINC = 437,
    ARM64_INS_CSETM = 438,
    ARM64_INS_CINV = 439,
    ARM64_INS_CNEG = 440,
    ARM64_INS_SXTB = 441,
    ARM64_INS_SXTH = 442,
    ARM64_INS_SXTW = 443,
    ARM64_INS_CMP = 444,
    ARM64_INS_UXTB = 445,
    ARM64_INS_UXTH = 446,
    ARM64_INS_UXTW = 447,
    ARM64_INS_IC = 448,
    ARM64_INS_DC = 449,
    ARM64_INS_AT = 450,
    ARM64_INS_TLBI = 451,
    ARM64_INS_NEGS = 452,
    ARM64_INS_NGCS = 453,
    ARM64_INS_ENDING = 454,
}
pub mod arm64_insn_group {
    #[doc = " Group of ARM64 instructions"]
    pub type Type = u32;
    #[doc = "< = CS_GRP_INVALID"]
    pub const ARM64_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const ARM64_GRP_JUMP: Type = 1;
    pub const ARM64_GRP_CALL: Type = 2;
    pub const ARM64_GRP_RET: Type = 3;
    pub const ARM64_GRP_INT: Type = 4;
    #[doc = "< = CS_GRP_PRIVILEGE"]
    pub const ARM64_GRP_PRIVILEGE: Type = 6;
    #[doc = "< = CS_GRP_BRANCH_RELATIVE"]
    pub const ARM64_GRP_BRANCH_RELATIVE: Type = 7;
    pub const ARM64_GRP_CRYPTO: Type = 128;
    pub const ARM64_GRP_FPARMV8: Type = 129;
    pub const ARM64_GRP_NEON: Type = 130;
    pub const ARM64_GRP_CRC: Type = 131;
    pub const ARM64_GRP_ENDING: Type = 132;
}
pub mod m68k_reg {
    #[doc = " M68K registers and special registers"]
    pub type Type = u32;
    pub const M68K_REG_INVALID: Type = 0;
    pub const M68K_REG_D0: Type = 1;
    pub const M68K_REG_D1: Type = 2;
    pub const M68K_REG_D2: Type = 3;
    pub const M68K_REG_D3: Type = 4;
    pub const M68K_REG_D4: Type = 5;
    pub const M68K_REG_D5: Type = 6;
    pub const M68K_REG_D6: Type = 7;
    pub const M68K_REG_D7: Type = 8;
    pub const M68K_REG_A0: Type = 9;
    pub const M68K_REG_A1: Type = 10;
    pub const M68K_REG_A2: Type = 11;
    pub const M68K_REG_A3: Type = 12;
    pub const M68K_REG_A4: Type = 13;
    pub const M68K_REG_A5: Type = 14;
    pub const M68K_REG_A6: Type = 15;
    pub const M68K_REG_A7: Type = 16;
    pub const M68K_REG_FP0: Type = 17;
    pub const M68K_REG_FP1: Type = 18;
    pub const M68K_REG_FP2: Type = 19;
    pub const M68K_REG_FP3: Type = 20;
    pub const M68K_REG_FP4: Type = 21;
    pub const M68K_REG_FP5: Type = 22;
    pub const M68K_REG_FP6: Type = 23;
    pub const M68K_REG_FP7: Type = 24;
    pub const M68K_REG_PC: Type = 25;
    pub const M68K_REG_SR: Type = 26;
    pub const M68K_REG_CCR: Type = 27;
    pub const M68K_REG_SFC: Type = 28;
    pub const M68K_REG_DFC: Type = 29;
    pub const M68K_REG_USP: Type = 30;
    pub const M68K_REG_VBR: Type = 31;
    pub const M68K_REG_CACR: Type = 32;
    pub const M68K_REG_CAAR: Type = 33;
    pub const M68K_REG_MSP: Type = 34;
    pub const M68K_REG_ISP: Type = 35;
    pub const M68K_REG_TC: Type = 36;
    pub const M68K_REG_ITT0: Type = 37;
    pub const M68K_REG_ITT1: Type = 38;
    pub const M68K_REG_DTT0: Type = 39;
    pub const M68K_REG_DTT1: Type = 40;
    pub const M68K_REG_MMUSR: Type = 41;
    pub const M68K_REG_URP: Type = 42;
    pub const M68K_REG_SRP: Type = 43;
    pub const M68K_REG_FPCR: Type = 44;
    pub const M68K_REG_FPSR: Type = 45;
    pub const M68K_REG_FPIAR: Type = 46;
    pub const M68K_REG_ENDING: Type = 47;
}
#[repr(u32)]
#[doc = " M68K Addressing Modes"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum m68k_address_mode {
    #[doc = "< No address mode."]
    M68K_AM_NONE = 0,
    #[doc = "< Register Direct - Data"]
    M68K_AM_REG_DIRECT_DATA = 1,
    #[doc = "< Register Direct - Address"]
    M68K_AM_REG_DIRECT_ADDR = 2,
    #[doc = "< Register Indirect - Address"]
    M68K_AM_REGI_ADDR = 3,
    #[doc = "< Register Indirect - Address with Postincrement"]
    M68K_AM_REGI_ADDR_POST_INC = 4,
    #[doc = "< Register Indirect - Address with Predecrement"]
    M68K_AM_REGI_ADDR_PRE_DEC = 5,
    #[doc = "< Register Indirect - Address with Displacement"]
    M68K_AM_REGI_ADDR_DISP = 6,
    #[doc = "< Address Register Indirect With Index- 8-bit displacement"]
    M68K_AM_AREGI_INDEX_8_BIT_DISP = 7,
    #[doc = "< Address Register Indirect With Index- Base displacement"]
    M68K_AM_AREGI_INDEX_BASE_DISP = 8,
    #[doc = "< Memory indirect - Postindex"]
    M68K_AM_MEMI_POST_INDEX = 9,
    #[doc = "< Memory indirect - Preindex"]
    M68K_AM_MEMI_PRE_INDEX = 10,
    #[doc = "< Program Counter Indirect - with Displacement"]
    M68K_AM_PCI_DISP = 11,
    #[doc = "< Program Counter Indirect with Index - with 8-Bit Displacement"]
    M68K_AM_PCI_INDEX_8_BIT_DISP = 12,
    #[doc = "< Program Counter Indirect with Index - with Base Displacement"]
    M68K_AM_PCI_INDEX_BASE_DISP = 13,
    #[doc = "< Program Counter Memory Indirect - Postindexed"]
    M68K_AM_PC_MEMI_POST_INDEX = 14,
    #[doc = "< Program Counter Memory Indirect - Preindexed"]
    M68K_AM_PC_MEMI_PRE_INDEX = 15,
    #[doc = "< Absolute Data Addressing  - Short"]
    M68K_AM_ABSOLUTE_DATA_SHORT = 16,
    #[doc = "< Absolute Data Addressing  - Long"]
    M68K_AM_ABSOLUTE_DATA_LONG = 17,
    #[doc = "< Immediate value"]
    M68K_AM_IMMEDIATE = 18,
    #[doc = "< Address as displacement from (PC+2) used by branches"]
    M68K_AM_BRANCH_DISPLACEMENT = 19,
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum m68k_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    M68K_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    M68K_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    M68K_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    M68K_OP_MEM = 3,
    #[doc = "< single precision Floating-Point operand"]
    M68K_OP_FP_SINGLE = 4,
    #[doc = "< double precision Floating-Point operand"]
    M68K_OP_FP_DOUBLE = 5,
    #[doc = "< Register bits move"]
    M68K_OP_REG_BITS = 6,
    #[doc = "< Register pair in the same op (upper 4 bits for first reg, lower for second)"]
    M68K_OP_REG_PAIR = 7,
    #[doc = "< Branch displacement"]
    M68K_OP_BR_DISP = 8,
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with M68K_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct m68k_op_mem {
    #[doc = "< base register (or M68K_REG_INVALID if irrelevant)"]
    pub base_reg: m68k_reg::Type,
    #[doc = "< index register (or M68K_REG_INVALID if irrelevant)"]
    pub index_reg: m68k_reg::Type,
    #[doc = "< indirect base register (or M68K_REG_INVALID if irrelevant)"]
    pub in_base_reg: m68k_reg::Type,
    #[doc = "< indirect displacement"]
    pub in_disp: u32,
    #[doc = "< other displacement"]
    pub out_disp: u32,
    #[doc = "< displacement value"]
    pub disp: i16,
    #[doc = "< scale for index register"]
    pub scale: u8,
    #[doc = "< set to true if the two values below should be used"]
    pub bitfield: u8,
    #[doc = "< used for bf* instructions"]
    pub width: u8,
    #[doc = "< used for bf* instructions"]
    pub offset: u8,
    #[doc = "< 0 = w, 1 = l"]
    pub index_size: u8,
}
impl Clone for m68k_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum m68k_op_br_disp_size {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    M68K_OP_BR_DISP_SIZE_INVALID = 0,
    #[doc = "< signed 8-bit displacement"]
    M68K_OP_BR_DISP_SIZE_BYTE = 1,
    #[doc = "< signed 16-bit displacement"]
    M68K_OP_BR_DISP_SIZE_WORD = 2,
    #[doc = "< signed 32-bit displacement"]
    M68K_OP_BR_DISP_SIZE_LONG = 4,
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct m68k_op_br_disp {
    #[doc = "< displacement value"]
    pub disp: i32,
    #[doc = "< Size from m68k_op_br_disp_size type above"]
    pub disp_size: u8,
}
impl Clone for m68k_op_br_disp {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_m68k_op {
    pub __bindgen_anon_1: cs_m68k_op__bindgen_ty_1,
    #[doc = "< data when operand is targeting memory"]
    pub mem: m68k_op_mem,
    #[doc = "< data when operand is a branch displacement"]
    pub br_disp: m68k_op_br_disp,
    #[doc = "< register bits for movem etc. (always in d0-d7, a0-a7, fp0 - fp7 order)"]
    pub register_bits: u32,
    pub type_: m68k_op_type,
    #[doc = "< M68K addressing mode for this op"]
    pub address_mode: m68k_address_mode,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_m68k_op__bindgen_ty_1 {
    #[doc = "< immediate value for IMM operand"]
    pub imm: u64,
    #[doc = "< double imm"]
    pub dimm: f64,
    #[doc = "< float imm"]
    pub simm: f32,
    #[doc = "< register value for REG operand"]
    pub reg: m68k_reg::Type,
    pub reg_pair: cs_m68k_op__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_m68k_op__bindgen_ty_1__bindgen_ty_1 {
    pub reg_0: m68k_reg::Type,
    pub reg_1: m68k_reg::Type,
}
impl Clone for cs_m68k_op__bindgen_ty_1__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl Clone for cs_m68k_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_m68k_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_m68k_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_m68k_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_m68k_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! ( f , "cs_m68k_op {{ __bindgen_anon_1: {:?}, mem: {:?}, br_disp: {:?}, register_bits: {:?}, type: {:?}, address_mode: {:?} }}" , self . __bindgen_anon_1 , self . mem , self . br_disp , self . register_bits , self . type_ , self . address_mode )
    }
}
#[repr(u32)]
#[doc = " Operation size of the CPU instructions"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum m68k_cpu_size {
    #[doc = "< unsized or unspecified"]
    M68K_CPU_SIZE_NONE = 0,
    #[doc = "< 1 byte in size"]
    M68K_CPU_SIZE_BYTE = 1,
    #[doc = "< 2 bytes in size"]
    M68K_CPU_SIZE_WORD = 2,
    #[doc = "< 4 bytes in size"]
    M68K_CPU_SIZE_LONG = 4,
}
#[repr(u32)]
#[doc = " Operation size of the FPU instructions (Notice that FPU instruction can also use CPU sizes if needed)"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum m68k_fpu_size {
    #[doc = "< unsized like fsave/frestore"]
    M68K_FPU_SIZE_NONE = 0,
    #[doc = "< 4 byte in size (single float)"]
    M68K_FPU_SIZE_SINGLE = 4,
    #[doc = "< 8 byte in size (double)"]
    M68K_FPU_SIZE_DOUBLE = 8,
    #[doc = "< 12 byte in size (extended real format)"]
    M68K_FPU_SIZE_EXTENDED = 12,
}
#[repr(u32)]
#[doc = " Type of size that is being used for the current instruction"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum m68k_size_type {
    M68K_SIZE_TYPE_INVALID = 0,
    M68K_SIZE_TYPE_CPU = 1,
    M68K_SIZE_TYPE_FPU = 2,
}
#[doc = " Operation size of the current instruction (NOT the actually size of instruction)"]
#[repr(C)]
#[derive(Copy)]
pub struct m68k_op_size {
    pub type_: m68k_size_type,
    pub __bindgen_anon_1: m68k_op_size__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union m68k_op_size__bindgen_ty_1 {
    pub cpu_size: m68k_cpu_size,
    pub fpu_size: m68k_fpu_size,
    _bindgen_union_align: u32,
}
impl Clone for m68k_op_size__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for m68k_op_size__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "m68k_op_size__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for m68k_op_size {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for m68k_op_size {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "m68k_op_size {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[doc = " The M68K instruction and it's operands"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_m68k {
    #[doc = "< operands for this instruction."]
    pub operands: [cs_m68k_op; 4usize],
    #[doc = "< size of data operand works on in bytes (.b, .w, .l, etc)"]
    pub op_size: m68k_op_size,
    #[doc = "< number of operands for the instruction"]
    pub op_count: u8,
}
impl Clone for cs_m68k {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_m68k {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_m68k {{ operands: {:?}, op_size: {:?}, op_count: {:?} }}",
            self.operands, self.op_size, self.op_count
        )
    }
}
#[repr(u32)]
#[doc = " M68K instruction"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum m68k_insn {
    M68K_INS_INVALID = 0,
    M68K_INS_ABCD = 1,
    M68K_INS_ADD = 2,
    M68K_INS_ADDA = 3,
    M68K_INS_ADDI = 4,
    M68K_INS_ADDQ = 5,
    M68K_INS_ADDX = 6,
    M68K_INS_AND = 7,
    M68K_INS_ANDI = 8,
    M68K_INS_ASL = 9,
    M68K_INS_ASR = 10,
    M68K_INS_BHS = 11,
    M68K_INS_BLO = 12,
    M68K_INS_BHI = 13,
    M68K_INS_BLS = 14,
    M68K_INS_BCC = 15,
    M68K_INS_BCS = 16,
    M68K_INS_BNE = 17,
    M68K_INS_BEQ = 18,
    M68K_INS_BVC = 19,
    M68K_INS_BVS = 20,
    M68K_INS_BPL = 21,
    M68K_INS_BMI = 22,
    M68K_INS_BGE = 23,
    M68K_INS_BLT = 24,
    M68K_INS_BGT = 25,
    M68K_INS_BLE = 26,
    M68K_INS_BRA = 27,
    M68K_INS_BSR = 28,
    M68K_INS_BCHG = 29,
    M68K_INS_BCLR = 30,
    M68K_INS_BSET = 31,
    M68K_INS_BTST = 32,
    M68K_INS_BFCHG = 33,
    M68K_INS_BFCLR = 34,
    M68K_INS_BFEXTS = 35,
    M68K_INS_BFEXTU = 36,
    M68K_INS_BFFFO = 37,
    M68K_INS_BFINS = 38,
    M68K_INS_BFSET = 39,
    M68K_INS_BFTST = 40,
    M68K_INS_BKPT = 41,
    M68K_INS_CALLM = 42,
    M68K_INS_CAS = 43,
    M68K_INS_CAS2 = 44,
    M68K_INS_CHK = 45,
    M68K_INS_CHK2 = 46,
    M68K_INS_CLR = 47,
    M68K_INS_CMP = 48,
    M68K_INS_CMPA = 49,
    M68K_INS_CMPI = 50,
    M68K_INS_CMPM = 51,
    M68K_INS_CMP2 = 52,
    M68K_INS_CINVL = 53,
    M68K_INS_CINVP = 54,
    M68K_INS_CINVA = 55,
    M68K_INS_CPUSHL = 56,
    M68K_INS_CPUSHP = 57,
    M68K_INS_CPUSHA = 58,
    M68K_INS_DBT = 59,
    M68K_INS_DBF = 60,
    M68K_INS_DBHI = 61,
    M68K_INS_DBLS = 62,
    M68K_INS_DBCC = 63,
    M68K_INS_DBCS = 64,
    M68K_INS_DBNE = 65,
    M68K_INS_DBEQ = 66,
    M68K_INS_DBVC = 67,
    M68K_INS_DBVS = 68,
    M68K_INS_DBPL = 69,
    M68K_INS_DBMI = 70,
    M68K_INS_DBGE = 71,
    M68K_INS_DBLT = 72,
    M68K_INS_DBGT = 73,
    M68K_INS_DBLE = 74,
    M68K_INS_DBRA = 75,
    M68K_INS_DIVS = 76,
    M68K_INS_DIVSL = 77,
    M68K_INS_DIVU = 78,
    M68K_INS_DIVUL = 79,
    M68K_INS_EOR = 80,
    M68K_INS_EORI = 81,
    M68K_INS_EXG = 82,
    M68K_INS_EXT = 83,
    M68K_INS_EXTB = 84,
    M68K_INS_FABS = 85,
    M68K_INS_FSABS = 86,
    M68K_INS_FDABS = 87,
    M68K_INS_FACOS = 88,
    M68K_INS_FADD = 89,
    M68K_INS_FSADD = 90,
    M68K_INS_FDADD = 91,
    M68K_INS_FASIN = 92,
    M68K_INS_FATAN = 93,
    M68K_INS_FATANH = 94,
    M68K_INS_FBF = 95,
    M68K_INS_FBEQ = 96,
    M68K_INS_FBOGT = 97,
    M68K_INS_FBOGE = 98,
    M68K_INS_FBOLT = 99,
    M68K_INS_FBOLE = 100,
    M68K_INS_FBOGL = 101,
    M68K_INS_FBOR = 102,
    M68K_INS_FBUN = 103,
    M68K_INS_FBUEQ = 104,
    M68K_INS_FBUGT = 105,
    M68K_INS_FBUGE = 106,
    M68K_INS_FBULT = 107,
    M68K_INS_FBULE = 108,
    M68K_INS_FBNE = 109,
    M68K_INS_FBT = 110,
    M68K_INS_FBSF = 111,
    M68K_INS_FBSEQ = 112,
    M68K_INS_FBGT = 113,
    M68K_INS_FBGE = 114,
    M68K_INS_FBLT = 115,
    M68K_INS_FBLE = 116,
    M68K_INS_FBGL = 117,
    M68K_INS_FBGLE = 118,
    M68K_INS_FBNGLE = 119,
    M68K_INS_FBNGL = 120,
    M68K_INS_FBNLE = 121,
    M68K_INS_FBNLT = 122,
    M68K_INS_FBNGE = 123,
    M68K_INS_FBNGT = 124,
    M68K_INS_FBSNE = 125,
    M68K_INS_FBST = 126,
    M68K_INS_FCMP = 127,
    M68K_INS_FCOS = 128,
    M68K_INS_FCOSH = 129,
    M68K_INS_FDBF = 130,
    M68K_INS_FDBEQ = 131,
    M68K_INS_FDBOGT = 132,
    M68K_INS_FDBOGE = 133,
    M68K_INS_FDBOLT = 134,
    M68K_INS_FDBOLE = 135,
    M68K_INS_FDBOGL = 136,
    M68K_INS_FDBOR = 137,
    M68K_INS_FDBUN = 138,
    M68K_INS_FDBUEQ = 139,
    M68K_INS_FDBUGT = 140,
    M68K_INS_FDBUGE = 141,
    M68K_INS_FDBULT = 142,
    M68K_INS_FDBULE = 143,
    M68K_INS_FDBNE = 144,
    M68K_INS_FDBT = 145,
    M68K_INS_FDBSF = 146,
    M68K_INS_FDBSEQ = 147,
    M68K_INS_FDBGT = 148,
    M68K_INS_FDBGE = 149,
    M68K_INS_FDBLT = 150,
    M68K_INS_FDBLE = 151,
    M68K_INS_FDBGL = 152,
    M68K_INS_FDBGLE = 153,
    M68K_INS_FDBNGLE = 154,
    M68K_INS_FDBNGL = 155,
    M68K_INS_FDBNLE = 156,
    M68K_INS_FDBNLT = 157,
    M68K_INS_FDBNGE = 158,
    M68K_INS_FDBNGT = 159,
    M68K_INS_FDBSNE = 160,
    M68K_INS_FDBST = 161,
    M68K_INS_FDIV = 162,
    M68K_INS_FSDIV = 163,
    M68K_INS_FDDIV = 164,
    M68K_INS_FETOX = 165,
    M68K_INS_FETOXM1 = 166,
    M68K_INS_FGETEXP = 167,
    M68K_INS_FGETMAN = 168,
    M68K_INS_FINT = 169,
    M68K_INS_FINTRZ = 170,
    M68K_INS_FLOG10 = 171,
    M68K_INS_FLOG2 = 172,
    M68K_INS_FLOGN = 173,
    M68K_INS_FLOGNP1 = 174,
    M68K_INS_FMOD = 175,
    M68K_INS_FMOVE = 176,
    M68K_INS_FSMOVE = 177,
    M68K_INS_FDMOVE = 178,
    M68K_INS_FMOVECR = 179,
    M68K_INS_FMOVEM = 180,
    M68K_INS_FMUL = 181,
    M68K_INS_FSMUL = 182,
    M68K_INS_FDMUL = 183,
    M68K_INS_FNEG = 184,
    M68K_INS_FSNEG = 185,
    M68K_INS_FDNEG = 186,
    M68K_INS_FNOP = 187,
    M68K_INS_FREM = 188,
    M68K_INS_FRESTORE = 189,
    M68K_INS_FSAVE = 190,
    M68K_INS_FSCALE = 191,
    M68K_INS_FSGLDIV = 192,
    M68K_INS_FSGLMUL = 193,
    M68K_INS_FSIN = 194,
    M68K_INS_FSINCOS = 195,
    M68K_INS_FSINH = 196,
    M68K_INS_FSQRT = 197,
    M68K_INS_FSSQRT = 198,
    M68K_INS_FDSQRT = 199,
    M68K_INS_FSF = 200,
    M68K_INS_FSBEQ = 201,
    M68K_INS_FSOGT = 202,
    M68K_INS_FSOGE = 203,
    M68K_INS_FSOLT = 204,
    M68K_INS_FSOLE = 205,
    M68K_INS_FSOGL = 206,
    M68K_INS_FSOR = 207,
    M68K_INS_FSUN = 208,
    M68K_INS_FSUEQ = 209,
    M68K_INS_FSUGT = 210,
    M68K_INS_FSUGE = 211,
    M68K_INS_FSULT = 212,
    M68K_INS_FSULE = 213,
    M68K_INS_FSNE = 214,
    M68K_INS_FST = 215,
    M68K_INS_FSSF = 216,
    M68K_INS_FSSEQ = 217,
    M68K_INS_FSGT = 218,
    M68K_INS_FSGE = 219,
    M68K_INS_FSLT = 220,
    M68K_INS_FSLE = 221,
    M68K_INS_FSGL = 222,
    M68K_INS_FSGLE = 223,
    M68K_INS_FSNGLE = 224,
    M68K_INS_FSNGL = 225,
    M68K_INS_FSNLE = 226,
    M68K_INS_FSNLT = 227,
    M68K_INS_FSNGE = 228,
    M68K_INS_FSNGT = 229,
    M68K_INS_FSSNE = 230,
    M68K_INS_FSST = 231,
    M68K_INS_FSUB = 232,
    M68K_INS_FSSUB = 233,
    M68K_INS_FDSUB = 234,
    M68K_INS_FTAN = 235,
    M68K_INS_FTANH = 236,
    M68K_INS_FTENTOX = 237,
    M68K_INS_FTRAPF = 238,
    M68K_INS_FTRAPEQ = 239,
    M68K_INS_FTRAPOGT = 240,
    M68K_INS_FTRAPOGE = 241,
    M68K_INS_FTRAPOLT = 242,
    M68K_INS_FTRAPOLE = 243,
    M68K_INS_FTRAPOGL = 244,
    M68K_INS_FTRAPOR = 245,
    M68K_INS_FTRAPUN = 246,
    M68K_INS_FTRAPUEQ = 247,
    M68K_INS_FTRAPUGT = 248,
    M68K_INS_FTRAPUGE = 249,
    M68K_INS_FTRAPULT = 250,
    M68K_INS_FTRAPULE = 251,
    M68K_INS_FTRAPNE = 252,
    M68K_INS_FTRAPT = 253,
    M68K_INS_FTRAPSF = 254,
    M68K_INS_FTRAPSEQ = 255,
    M68K_INS_FTRAPGT = 256,
    M68K_INS_FTRAPGE = 257,
    M68K_INS_FTRAPLT = 258,
    M68K_INS_FTRAPLE = 259,
    M68K_INS_FTRAPGL = 260,
    M68K_INS_FTRAPGLE = 261,
    M68K_INS_FTRAPNGLE = 262,
    M68K_INS_FTRAPNGL = 263,
    M68K_INS_FTRAPNLE = 264,
    M68K_INS_FTRAPNLT = 265,
    M68K_INS_FTRAPNGE = 266,
    M68K_INS_FTRAPNGT = 267,
    M68K_INS_FTRAPSNE = 268,
    M68K_INS_FTRAPST = 269,
    M68K_INS_FTST = 270,
    M68K_INS_FTWOTOX = 271,
    M68K_INS_HALT = 272,
    M68K_INS_ILLEGAL = 273,
    M68K_INS_JMP = 274,
    M68K_INS_JSR = 275,
    M68K_INS_LEA = 276,
    M68K_INS_LINK = 277,
    M68K_INS_LPSTOP = 278,
    M68K_INS_LSL = 279,
    M68K_INS_LSR = 280,
    M68K_INS_MOVE = 281,
    M68K_INS_MOVEA = 282,
    M68K_INS_MOVEC = 283,
    M68K_INS_MOVEM = 284,
    M68K_INS_MOVEP = 285,
    M68K_INS_MOVEQ = 286,
    M68K_INS_MOVES = 287,
    M68K_INS_MOVE16 = 288,
    M68K_INS_MULS = 289,
    M68K_INS_MULU = 290,
    M68K_INS_NBCD = 291,
    M68K_INS_NEG = 292,
    M68K_INS_NEGX = 293,
    M68K_INS_NOP = 294,
    M68K_INS_NOT = 295,
    M68K_INS_OR = 296,
    M68K_INS_ORI = 297,
    M68K_INS_PACK = 298,
    M68K_INS_PEA = 299,
    M68K_INS_PFLUSH = 300,
    M68K_INS_PFLUSHA = 301,
    M68K_INS_PFLUSHAN = 302,
    M68K_INS_PFLUSHN = 303,
    M68K_INS_PLOADR = 304,
    M68K_INS_PLOADW = 305,
    M68K_INS_PLPAR = 306,
    M68K_INS_PLPAW = 307,
    M68K_INS_PMOVE = 308,
    M68K_INS_PMOVEFD = 309,
    M68K_INS_PTESTR = 310,
    M68K_INS_PTESTW = 311,
    M68K_INS_PULSE = 312,
    M68K_INS_REMS = 313,
    M68K_INS_REMU = 314,
    M68K_INS_RESET = 315,
    M68K_INS_ROL = 316,
    M68K_INS_ROR = 317,
    M68K_INS_ROXL = 318,
    M68K_INS_ROXR = 319,
    M68K_INS_RTD = 320,
    M68K_INS_RTE = 321,
    M68K_INS_RTM = 322,
    M68K_INS_RTR = 323,
    M68K_INS_RTS = 324,
    M68K_INS_SBCD = 325,
    M68K_INS_ST = 326,
    M68K_INS_SF = 327,
    M68K_INS_SHI = 328,
    M68K_INS_SLS = 329,
    M68K_INS_SCC = 330,
    M68K_INS_SHS = 331,
    M68K_INS_SCS = 332,
    M68K_INS_SLO = 333,
    M68K_INS_SNE = 334,
    M68K_INS_SEQ = 335,
    M68K_INS_SVC = 336,
    M68K_INS_SVS = 337,
    M68K_INS_SPL = 338,
    M68K_INS_SMI = 339,
    M68K_INS_SGE = 340,
    M68K_INS_SLT = 341,
    M68K_INS_SGT = 342,
    M68K_INS_SLE = 343,
    M68K_INS_STOP = 344,
    M68K_INS_SUB = 345,
    M68K_INS_SUBA = 346,
    M68K_INS_SUBI = 347,
    M68K_INS_SUBQ = 348,
    M68K_INS_SUBX = 349,
    M68K_INS_SWAP = 350,
    M68K_INS_TAS = 351,
    M68K_INS_TRAP = 352,
    M68K_INS_TRAPV = 353,
    M68K_INS_TRAPT = 354,
    M68K_INS_TRAPF = 355,
    M68K_INS_TRAPHI = 356,
    M68K_INS_TRAPLS = 357,
    M68K_INS_TRAPCC = 358,
    M68K_INS_TRAPHS = 359,
    M68K_INS_TRAPCS = 360,
    M68K_INS_TRAPLO = 361,
    M68K_INS_TRAPNE = 362,
    M68K_INS_TRAPEQ = 363,
    M68K_INS_TRAPVC = 364,
    M68K_INS_TRAPVS = 365,
    M68K_INS_TRAPPL = 366,
    M68K_INS_TRAPMI = 367,
    M68K_INS_TRAPGE = 368,
    M68K_INS_TRAPLT = 369,
    M68K_INS_TRAPGT = 370,
    M68K_INS_TRAPLE = 371,
    M68K_INS_TST = 372,
    M68K_INS_UNLK = 373,
    M68K_INS_UNPK = 374,
    M68K_INS_ENDING = 375,
}
#[repr(u32)]
#[doc = " Group of M68K instructions"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum m68k_group_type {
    #[doc = "< CS_GRUP_INVALID"]
    M68K_GRP_INVALID = 0,
    #[doc = "< = CS_GRP_JUMP"]
    M68K_GRP_JUMP = 1,
    #[doc = "< = CS_GRP_RET"]
    M68K_GRP_RET = 3,
    #[doc = "< = CS_GRP_IRET"]
    M68K_GRP_IRET = 5,
    #[doc = "< = CS_GRP_BRANCH_RELATIVE"]
    M68K_GRP_BRANCH_RELATIVE = 7,
    M68K_GRP_ENDING = 8,
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum mips_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    MIPS_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    MIPS_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    MIPS_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    MIPS_OP_MEM = 3,
}
pub mod mips_reg {
    #[doc = " MIPS registers"]
    pub type Type = u32;
    pub const MIPS_REG_INVALID: Type = 0;
    pub const MIPS_REG_PC: Type = 1;
    pub const MIPS_REG_0: Type = 2;
    pub const MIPS_REG_1: Type = 3;
    pub const MIPS_REG_2: Type = 4;
    pub const MIPS_REG_3: Type = 5;
    pub const MIPS_REG_4: Type = 6;
    pub const MIPS_REG_5: Type = 7;
    pub const MIPS_REG_6: Type = 8;
    pub const MIPS_REG_7: Type = 9;
    pub const MIPS_REG_8: Type = 10;
    pub const MIPS_REG_9: Type = 11;
    pub const MIPS_REG_10: Type = 12;
    pub const MIPS_REG_11: Type = 13;
    pub const MIPS_REG_12: Type = 14;
    pub const MIPS_REG_13: Type = 15;
    pub const MIPS_REG_14: Type = 16;
    pub const MIPS_REG_15: Type = 17;
    pub const MIPS_REG_16: Type = 18;
    pub const MIPS_REG_17: Type = 19;
    pub const MIPS_REG_18: Type = 20;
    pub const MIPS_REG_19: Type = 21;
    pub const MIPS_REG_20: Type = 22;
    pub const MIPS_REG_21: Type = 23;
    pub const MIPS_REG_22: Type = 24;
    pub const MIPS_REG_23: Type = 25;
    pub const MIPS_REG_24: Type = 26;
    pub const MIPS_REG_25: Type = 27;
    pub const MIPS_REG_26: Type = 28;
    pub const MIPS_REG_27: Type = 29;
    pub const MIPS_REG_28: Type = 30;
    pub const MIPS_REG_29: Type = 31;
    pub const MIPS_REG_30: Type = 32;
    pub const MIPS_REG_31: Type = 33;
    pub const MIPS_REG_DSPCCOND: Type = 34;
    pub const MIPS_REG_DSPCARRY: Type = 35;
    pub const MIPS_REG_DSPEFI: Type = 36;
    pub const MIPS_REG_DSPOUTFLAG: Type = 37;
    pub const MIPS_REG_DSPOUTFLAG16_19: Type = 38;
    pub const MIPS_REG_DSPOUTFLAG20: Type = 39;
    pub const MIPS_REG_DSPOUTFLAG21: Type = 40;
    pub const MIPS_REG_DSPOUTFLAG22: Type = 41;
    pub const MIPS_REG_DSPOUTFLAG23: Type = 42;
    pub const MIPS_REG_DSPPOS: Type = 43;
    pub const MIPS_REG_DSPSCOUNT: Type = 44;
    pub const MIPS_REG_AC0: Type = 45;
    pub const MIPS_REG_AC1: Type = 46;
    pub const MIPS_REG_AC2: Type = 47;
    pub const MIPS_REG_AC3: Type = 48;
    pub const MIPS_REG_CC0: Type = 49;
    pub const MIPS_REG_CC1: Type = 50;
    pub const MIPS_REG_CC2: Type = 51;
    pub const MIPS_REG_CC3: Type = 52;
    pub const MIPS_REG_CC4: Type = 53;
    pub const MIPS_REG_CC5: Type = 54;
    pub const MIPS_REG_CC6: Type = 55;
    pub const MIPS_REG_CC7: Type = 56;
    pub const MIPS_REG_F0: Type = 57;
    pub const MIPS_REG_F1: Type = 58;
    pub const MIPS_REG_F2: Type = 59;
    pub const MIPS_REG_F3: Type = 60;
    pub const MIPS_REG_F4: Type = 61;
    pub const MIPS_REG_F5: Type = 62;
    pub const MIPS_REG_F6: Type = 63;
    pub const MIPS_REG_F7: Type = 64;
    pub const MIPS_REG_F8: Type = 65;
    pub const MIPS_REG_F9: Type = 66;
    pub const MIPS_REG_F10: Type = 67;
    pub const MIPS_REG_F11: Type = 68;
    pub const MIPS_REG_F12: Type = 69;
    pub const MIPS_REG_F13: Type = 70;
    pub const MIPS_REG_F14: Type = 71;
    pub const MIPS_REG_F15: Type = 72;
    pub const MIPS_REG_F16: Type = 73;
    pub const MIPS_REG_F17: Type = 74;
    pub const MIPS_REG_F18: Type = 75;
    pub const MIPS_REG_F19: Type = 76;
    pub const MIPS_REG_F20: Type = 77;
    pub const MIPS_REG_F21: Type = 78;
    pub const MIPS_REG_F22: Type = 79;
    pub const MIPS_REG_F23: Type = 80;
    pub const MIPS_REG_F24: Type = 81;
    pub const MIPS_REG_F25: Type = 82;
    pub const MIPS_REG_F26: Type = 83;
    pub const MIPS_REG_F27: Type = 84;
    pub const MIPS_REG_F28: Type = 85;
    pub const MIPS_REG_F29: Type = 86;
    pub const MIPS_REG_F30: Type = 87;
    pub const MIPS_REG_F31: Type = 88;
    pub const MIPS_REG_FCC0: Type = 89;
    pub const MIPS_REG_FCC1: Type = 90;
    pub const MIPS_REG_FCC2: Type = 91;
    pub const MIPS_REG_FCC3: Type = 92;
    pub const MIPS_REG_FCC4: Type = 93;
    pub const MIPS_REG_FCC5: Type = 94;
    pub const MIPS_REG_FCC6: Type = 95;
    pub const MIPS_REG_FCC7: Type = 96;
    pub const MIPS_REG_W0: Type = 97;
    pub const MIPS_REG_W1: Type = 98;
    pub const MIPS_REG_W2: Type = 99;
    pub const MIPS_REG_W3: Type = 100;
    pub const MIPS_REG_W4: Type = 101;
    pub const MIPS_REG_W5: Type = 102;
    pub const MIPS_REG_W6: Type = 103;
    pub const MIPS_REG_W7: Type = 104;
    pub const MIPS_REG_W8: Type = 105;
    pub const MIPS_REG_W9: Type = 106;
    pub const MIPS_REG_W10: Type = 107;
    pub const MIPS_REG_W11: Type = 108;
    pub const MIPS_REG_W12: Type = 109;
    pub const MIPS_REG_W13: Type = 110;
    pub const MIPS_REG_W14: Type = 111;
    pub const MIPS_REG_W15: Type = 112;
    pub const MIPS_REG_W16: Type = 113;
    pub const MIPS_REG_W17: Type = 114;
    pub const MIPS_REG_W18: Type = 115;
    pub const MIPS_REG_W19: Type = 116;
    pub const MIPS_REG_W20: Type = 117;
    pub const MIPS_REG_W21: Type = 118;
    pub const MIPS_REG_W22: Type = 119;
    pub const MIPS_REG_W23: Type = 120;
    pub const MIPS_REG_W24: Type = 121;
    pub const MIPS_REG_W25: Type = 122;
    pub const MIPS_REG_W26: Type = 123;
    pub const MIPS_REG_W27: Type = 124;
    pub const MIPS_REG_W28: Type = 125;
    pub const MIPS_REG_W29: Type = 126;
    pub const MIPS_REG_W30: Type = 127;
    pub const MIPS_REG_W31: Type = 128;
    pub const MIPS_REG_HI: Type = 129;
    pub const MIPS_REG_LO: Type = 130;
    pub const MIPS_REG_P0: Type = 131;
    pub const MIPS_REG_P1: Type = 132;
    pub const MIPS_REG_P2: Type = 133;
    pub const MIPS_REG_MPL0: Type = 134;
    pub const MIPS_REG_MPL1: Type = 135;
    pub const MIPS_REG_MPL2: Type = 136;
    pub const MIPS_REG_ENDING: Type = 137;
    pub const MIPS_REG_ZERO: Type = 2;
    pub const MIPS_REG_AT: Type = 3;
    pub const MIPS_REG_V0: Type = 4;
    pub const MIPS_REG_V1: Type = 5;
    pub const MIPS_REG_A0: Type = 6;
    pub const MIPS_REG_A1: Type = 7;
    pub const MIPS_REG_A2: Type = 8;
    pub const MIPS_REG_A3: Type = 9;
    pub const MIPS_REG_T0: Type = 10;
    pub const MIPS_REG_T1: Type = 11;
    pub const MIPS_REG_T2: Type = 12;
    pub const MIPS_REG_T3: Type = 13;
    pub const MIPS_REG_T4: Type = 14;
    pub const MIPS_REG_T5: Type = 15;
    pub const MIPS_REG_T6: Type = 16;
    pub const MIPS_REG_T7: Type = 17;
    pub const MIPS_REG_S0: Type = 18;
    pub const MIPS_REG_S1: Type = 19;
    pub const MIPS_REG_S2: Type = 20;
    pub const MIPS_REG_S3: Type = 21;
    pub const MIPS_REG_S4: Type = 22;
    pub const MIPS_REG_S5: Type = 23;
    pub const MIPS_REG_S6: Type = 24;
    pub const MIPS_REG_S7: Type = 25;
    pub const MIPS_REG_T8: Type = 26;
    pub const MIPS_REG_T9: Type = 27;
    pub const MIPS_REG_K0: Type = 28;
    pub const MIPS_REG_K1: Type = 29;
    pub const MIPS_REG_GP: Type = 30;
    pub const MIPS_REG_SP: Type = 31;
    pub const MIPS_REG_FP: Type = 32;
    pub const MIPS_REG_S8: Type = 32;
    pub const MIPS_REG_RA: Type = 33;
    pub const MIPS_REG_HI0: Type = 45;
    pub const MIPS_REG_HI1: Type = 46;
    pub const MIPS_REG_HI2: Type = 47;
    pub const MIPS_REG_HI3: Type = 48;
    pub const MIPS_REG_LO0: Type = 45;
    pub const MIPS_REG_LO1: Type = 46;
    pub const MIPS_REG_LO2: Type = 47;
    pub const MIPS_REG_LO3: Type = 48;
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with MIPS_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct mips_op_mem {
    #[doc = "< base register"]
    pub base: mips_reg::Type,
    #[doc = "< displacement/offset value"]
    pub disp: i64,
}
impl Clone for mips_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_mips_op {
    #[doc = "< operand type"]
    pub type_: mips_op_type,
    pub __bindgen_anon_1: cs_mips_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_mips_op__bindgen_ty_1 {
    #[doc = "< register value for REG operand"]
    pub reg: mips_reg::Type,
    #[doc = "< immediate value for IMM operand"]
    pub imm: i64,
    #[doc = "< base/index/scale/disp value for MEM operand"]
    pub mem: mips_op_mem,
    _bindgen_union_align: [u64; 2usize],
}
impl Clone for cs_mips_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_mips_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_mips_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_mips_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_mips_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_mips_op {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_mips {
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_mips_op; 10usize],
}
impl Clone for cs_mips {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_mips {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_mips {{ op_count: {:?}, operands: {:?} }}",
            self.op_count, self.operands
        )
    }
}
#[repr(u32)]
#[doc = " MIPS instruction"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum mips_insn {
    MIPS_INS_INVALID = 0,
    MIPS_INS_ABSQ_S = 1,
    MIPS_INS_ADD = 2,
    MIPS_INS_ADDIUPC = 3,
    MIPS_INS_ADDIUR1SP = 4,
    MIPS_INS_ADDIUR2 = 5,
    MIPS_INS_ADDIUS5 = 6,
    MIPS_INS_ADDIUSP = 7,
    MIPS_INS_ADDQH = 8,
    MIPS_INS_ADDQH_R = 9,
    MIPS_INS_ADDQ = 10,
    MIPS_INS_ADDQ_S = 11,
    MIPS_INS_ADDSC = 12,
    MIPS_INS_ADDS_A = 13,
    MIPS_INS_ADDS_S = 14,
    MIPS_INS_ADDS_U = 15,
    MIPS_INS_ADDU16 = 16,
    MIPS_INS_ADDUH = 17,
    MIPS_INS_ADDUH_R = 18,
    MIPS_INS_ADDU = 19,
    MIPS_INS_ADDU_S = 20,
    MIPS_INS_ADDVI = 21,
    MIPS_INS_ADDV = 22,
    MIPS_INS_ADDWC = 23,
    MIPS_INS_ADD_A = 24,
    MIPS_INS_ADDI = 25,
    MIPS_INS_ADDIU = 26,
    MIPS_INS_ALIGN = 27,
    MIPS_INS_ALUIPC = 28,
    MIPS_INS_AND = 29,
    MIPS_INS_AND16 = 30,
    MIPS_INS_ANDI16 = 31,
    MIPS_INS_ANDI = 32,
    MIPS_INS_APPEND = 33,
    MIPS_INS_ASUB_S = 34,
    MIPS_INS_ASUB_U = 35,
    MIPS_INS_AUI = 36,
    MIPS_INS_AUIPC = 37,
    MIPS_INS_AVER_S = 38,
    MIPS_INS_AVER_U = 39,
    MIPS_INS_AVE_S = 40,
    MIPS_INS_AVE_U = 41,
    MIPS_INS_B16 = 42,
    MIPS_INS_BADDU = 43,
    MIPS_INS_BAL = 44,
    MIPS_INS_BALC = 45,
    MIPS_INS_BALIGN = 46,
    MIPS_INS_BBIT0 = 47,
    MIPS_INS_BBIT032 = 48,
    MIPS_INS_BBIT1 = 49,
    MIPS_INS_BBIT132 = 50,
    MIPS_INS_BC = 51,
    MIPS_INS_BC0F = 52,
    MIPS_INS_BC0FL = 53,
    MIPS_INS_BC0T = 54,
    MIPS_INS_BC0TL = 55,
    MIPS_INS_BC1EQZ = 56,
    MIPS_INS_BC1F = 57,
    MIPS_INS_BC1FL = 58,
    MIPS_INS_BC1NEZ = 59,
    MIPS_INS_BC1T = 60,
    MIPS_INS_BC1TL = 61,
    MIPS_INS_BC2EQZ = 62,
    MIPS_INS_BC2F = 63,
    MIPS_INS_BC2FL = 64,
    MIPS_INS_BC2NEZ = 65,
    MIPS_INS_BC2T = 66,
    MIPS_INS_BC2TL = 67,
    MIPS_INS_BC3F = 68,
    MIPS_INS_BC3FL = 69,
    MIPS_INS_BC3T = 70,
    MIPS_INS_BC3TL = 71,
    MIPS_INS_BCLRI = 72,
    MIPS_INS_BCLR = 73,
    MIPS_INS_BEQ = 74,
    MIPS_INS_BEQC = 75,
    MIPS_INS_BEQL = 76,
    MIPS_INS_BEQZ16 = 77,
    MIPS_INS_BEQZALC = 78,
    MIPS_INS_BEQZC = 79,
    MIPS_INS_BGEC = 80,
    MIPS_INS_BGEUC = 81,
    MIPS_INS_BGEZ = 82,
    MIPS_INS_BGEZAL = 83,
    MIPS_INS_BGEZALC = 84,
    MIPS_INS_BGEZALL = 85,
    MIPS_INS_BGEZALS = 86,
    MIPS_INS_BGEZC = 87,
    MIPS_INS_BGEZL = 88,
    MIPS_INS_BGTZ = 89,
    MIPS_INS_BGTZALC = 90,
    MIPS_INS_BGTZC = 91,
    MIPS_INS_BGTZL = 92,
    MIPS_INS_BINSLI = 93,
    MIPS_INS_BINSL = 94,
    MIPS_INS_BINSRI = 95,
    MIPS_INS_BINSR = 96,
    MIPS_INS_BITREV = 97,
    MIPS_INS_BITSWAP = 98,
    MIPS_INS_BLEZ = 99,
    MIPS_INS_BLEZALC = 100,
    MIPS_INS_BLEZC = 101,
    MIPS_INS_BLEZL = 102,
    MIPS_INS_BLTC = 103,
    MIPS_INS_BLTUC = 104,
    MIPS_INS_BLTZ = 105,
    MIPS_INS_BLTZAL = 106,
    MIPS_INS_BLTZALC = 107,
    MIPS_INS_BLTZALL = 108,
    MIPS_INS_BLTZALS = 109,
    MIPS_INS_BLTZC = 110,
    MIPS_INS_BLTZL = 111,
    MIPS_INS_BMNZI = 112,
    MIPS_INS_BMNZ = 113,
    MIPS_INS_BMZI = 114,
    MIPS_INS_BMZ = 115,
    MIPS_INS_BNE = 116,
    MIPS_INS_BNEC = 117,
    MIPS_INS_BNEGI = 118,
    MIPS_INS_BNEG = 119,
    MIPS_INS_BNEL = 120,
    MIPS_INS_BNEZ16 = 121,
    MIPS_INS_BNEZALC = 122,
    MIPS_INS_BNEZC = 123,
    MIPS_INS_BNVC = 124,
    MIPS_INS_BNZ = 125,
    MIPS_INS_BOVC = 126,
    MIPS_INS_BPOSGE32 = 127,
    MIPS_INS_BREAK = 128,
    MIPS_INS_BREAK16 = 129,
    MIPS_INS_BSELI = 130,
    MIPS_INS_BSEL = 131,
    MIPS_INS_BSETI = 132,
    MIPS_INS_BSET = 133,
    MIPS_INS_BZ = 134,
    MIPS_INS_BEQZ = 135,
    MIPS_INS_B = 136,
    MIPS_INS_BNEZ = 137,
    MIPS_INS_BTEQZ = 138,
    MIPS_INS_BTNEZ = 139,
    MIPS_INS_CACHE = 140,
    MIPS_INS_CEIL = 141,
    MIPS_INS_CEQI = 142,
    MIPS_INS_CEQ = 143,
    MIPS_INS_CFC1 = 144,
    MIPS_INS_CFCMSA = 145,
    MIPS_INS_CINS = 146,
    MIPS_INS_CINS32 = 147,
    MIPS_INS_CLASS = 148,
    MIPS_INS_CLEI_S = 149,
    MIPS_INS_CLEI_U = 150,
    MIPS_INS_CLE_S = 151,
    MIPS_INS_CLE_U = 152,
    MIPS_INS_CLO = 153,
    MIPS_INS_CLTI_S = 154,
    MIPS_INS_CLTI_U = 155,
    MIPS_INS_CLT_S = 156,
    MIPS_INS_CLT_U = 157,
    MIPS_INS_CLZ = 158,
    MIPS_INS_CMPGDU = 159,
    MIPS_INS_CMPGU = 160,
    MIPS_INS_CMPU = 161,
    MIPS_INS_CMP = 162,
    MIPS_INS_COPY_S = 163,
    MIPS_INS_COPY_U = 164,
    MIPS_INS_CTC1 = 165,
    MIPS_INS_CTCMSA = 166,
    MIPS_INS_CVT = 167,
    MIPS_INS_C = 168,
    MIPS_INS_CMPI = 169,
    MIPS_INS_DADD = 170,
    MIPS_INS_DADDI = 171,
    MIPS_INS_DADDIU = 172,
    MIPS_INS_DADDU = 173,
    MIPS_INS_DAHI = 174,
    MIPS_INS_DALIGN = 175,
    MIPS_INS_DATI = 176,
    MIPS_INS_DAUI = 177,
    MIPS_INS_DBITSWAP = 178,
    MIPS_INS_DCLO = 179,
    MIPS_INS_DCLZ = 180,
    MIPS_INS_DDIV = 181,
    MIPS_INS_DDIVU = 182,
    MIPS_INS_DERET = 183,
    MIPS_INS_DEXT = 184,
    MIPS_INS_DEXTM = 185,
    MIPS_INS_DEXTU = 186,
    MIPS_INS_DI = 187,
    MIPS_INS_DINS = 188,
    MIPS_INS_DINSM = 189,
    MIPS_INS_DINSU = 190,
    MIPS_INS_DIV = 191,
    MIPS_INS_DIVU = 192,
    MIPS_INS_DIV_S = 193,
    MIPS_INS_DIV_U = 194,
    MIPS_INS_DLSA = 195,
    MIPS_INS_DMFC0 = 196,
    MIPS_INS_DMFC1 = 197,
    MIPS_INS_DMFC2 = 198,
    MIPS_INS_DMOD = 199,
    MIPS_INS_DMODU = 200,
    MIPS_INS_DMTC0 = 201,
    MIPS_INS_DMTC1 = 202,
    MIPS_INS_DMTC2 = 203,
    MIPS_INS_DMUH = 204,
    MIPS_INS_DMUHU = 205,
    MIPS_INS_DMUL = 206,
    MIPS_INS_DMULT = 207,
    MIPS_INS_DMULTU = 208,
    MIPS_INS_DMULU = 209,
    MIPS_INS_DOTP_S = 210,
    MIPS_INS_DOTP_U = 211,
    MIPS_INS_DPADD_S = 212,
    MIPS_INS_DPADD_U = 213,
    MIPS_INS_DPAQX_SA = 214,
    MIPS_INS_DPAQX_S = 215,
    MIPS_INS_DPAQ_SA = 216,
    MIPS_INS_DPAQ_S = 217,
    MIPS_INS_DPAU = 218,
    MIPS_INS_DPAX = 219,
    MIPS_INS_DPA = 220,
    MIPS_INS_DPOP = 221,
    MIPS_INS_DPSQX_SA = 222,
    MIPS_INS_DPSQX_S = 223,
    MIPS_INS_DPSQ_SA = 224,
    MIPS_INS_DPSQ_S = 225,
    MIPS_INS_DPSUB_S = 226,
    MIPS_INS_DPSUB_U = 227,
    MIPS_INS_DPSU = 228,
    MIPS_INS_DPSX = 229,
    MIPS_INS_DPS = 230,
    MIPS_INS_DROTR = 231,
    MIPS_INS_DROTR32 = 232,
    MIPS_INS_DROTRV = 233,
    MIPS_INS_DSBH = 234,
    MIPS_INS_DSHD = 235,
    MIPS_INS_DSLL = 236,
    MIPS_INS_DSLL32 = 237,
    MIPS_INS_DSLLV = 238,
    MIPS_INS_DSRA = 239,
    MIPS_INS_DSRA32 = 240,
    MIPS_INS_DSRAV = 241,
    MIPS_INS_DSRL = 242,
    MIPS_INS_DSRL32 = 243,
    MIPS_INS_DSRLV = 244,
    MIPS_INS_DSUB = 245,
    MIPS_INS_DSUBU = 246,
    MIPS_INS_EHB = 247,
    MIPS_INS_EI = 248,
    MIPS_INS_ERET = 249,
    MIPS_INS_EXT = 250,
    MIPS_INS_EXTP = 251,
    MIPS_INS_EXTPDP = 252,
    MIPS_INS_EXTPDPV = 253,
    MIPS_INS_EXTPV = 254,
    MIPS_INS_EXTRV_RS = 255,
    MIPS_INS_EXTRV_R = 256,
    MIPS_INS_EXTRV_S = 257,
    MIPS_INS_EXTRV = 258,
    MIPS_INS_EXTR_RS = 259,
    MIPS_INS_EXTR_R = 260,
    MIPS_INS_EXTR_S = 261,
    MIPS_INS_EXTR = 262,
    MIPS_INS_EXTS = 263,
    MIPS_INS_EXTS32 = 264,
    MIPS_INS_ABS = 265,
    MIPS_INS_FADD = 266,
    MIPS_INS_FCAF = 267,
    MIPS_INS_FCEQ = 268,
    MIPS_INS_FCLASS = 269,
    MIPS_INS_FCLE = 270,
    MIPS_INS_FCLT = 271,
    MIPS_INS_FCNE = 272,
    MIPS_INS_FCOR = 273,
    MIPS_INS_FCUEQ = 274,
    MIPS_INS_FCULE = 275,
    MIPS_INS_FCULT = 276,
    MIPS_INS_FCUNE = 277,
    MIPS_INS_FCUN = 278,
    MIPS_INS_FDIV = 279,
    MIPS_INS_FEXDO = 280,
    MIPS_INS_FEXP2 = 281,
    MIPS_INS_FEXUPL = 282,
    MIPS_INS_FEXUPR = 283,
    MIPS_INS_FFINT_S = 284,
    MIPS_INS_FFINT_U = 285,
    MIPS_INS_FFQL = 286,
    MIPS_INS_FFQR = 287,
    MIPS_INS_FILL = 288,
    MIPS_INS_FLOG2 = 289,
    MIPS_INS_FLOOR = 290,
    MIPS_INS_FMADD = 291,
    MIPS_INS_FMAX_A = 292,
    MIPS_INS_FMAX = 293,
    MIPS_INS_FMIN_A = 294,
    MIPS_INS_FMIN = 295,
    MIPS_INS_MOV = 296,
    MIPS_INS_FMSUB = 297,
    MIPS_INS_FMUL = 298,
    MIPS_INS_MUL = 299,
    MIPS_INS_NEG = 300,
    MIPS_INS_FRCP = 301,
    MIPS_INS_FRINT = 302,
    MIPS_INS_FRSQRT = 303,
    MIPS_INS_FSAF = 304,
    MIPS_INS_FSEQ = 305,
    MIPS_INS_FSLE = 306,
    MIPS_INS_FSLT = 307,
    MIPS_INS_FSNE = 308,
    MIPS_INS_FSOR = 309,
    MIPS_INS_FSQRT = 310,
    MIPS_INS_SQRT = 311,
    MIPS_INS_FSUB = 312,
    MIPS_INS_SUB = 313,
    MIPS_INS_FSUEQ = 314,
    MIPS_INS_FSULE = 315,
    MIPS_INS_FSULT = 316,
    MIPS_INS_FSUNE = 317,
    MIPS_INS_FSUN = 318,
    MIPS_INS_FTINT_S = 319,
    MIPS_INS_FTINT_U = 320,
    MIPS_INS_FTQ = 321,
    MIPS_INS_FTRUNC_S = 322,
    MIPS_INS_FTRUNC_U = 323,
    MIPS_INS_HADD_S = 324,
    MIPS_INS_HADD_U = 325,
    MIPS_INS_HSUB_S = 326,
    MIPS_INS_HSUB_U = 327,
    MIPS_INS_ILVEV = 328,
    MIPS_INS_ILVL = 329,
    MIPS_INS_ILVOD = 330,
    MIPS_INS_ILVR = 331,
    MIPS_INS_INS = 332,
    MIPS_INS_INSERT = 333,
    MIPS_INS_INSV = 334,
    MIPS_INS_INSVE = 335,
    MIPS_INS_J = 336,
    MIPS_INS_JAL = 337,
    MIPS_INS_JALR = 338,
    MIPS_INS_JALRS16 = 339,
    MIPS_INS_JALRS = 340,
    MIPS_INS_JALS = 341,
    MIPS_INS_JALX = 342,
    MIPS_INS_JIALC = 343,
    MIPS_INS_JIC = 344,
    MIPS_INS_JR = 345,
    MIPS_INS_JR16 = 346,
    MIPS_INS_JRADDIUSP = 347,
    MIPS_INS_JRC = 348,
    MIPS_INS_JALRC = 349,
    MIPS_INS_LB = 350,
    MIPS_INS_LBU16 = 351,
    MIPS_INS_LBUX = 352,
    MIPS_INS_LBU = 353,
    MIPS_INS_LD = 354,
    MIPS_INS_LDC1 = 355,
    MIPS_INS_LDC2 = 356,
    MIPS_INS_LDC3 = 357,
    MIPS_INS_LDI = 358,
    MIPS_INS_LDL = 359,
    MIPS_INS_LDPC = 360,
    MIPS_INS_LDR = 361,
    MIPS_INS_LDXC1 = 362,
    MIPS_INS_LH = 363,
    MIPS_INS_LHU16 = 364,
    MIPS_INS_LHX = 365,
    MIPS_INS_LHU = 366,
    MIPS_INS_LI16 = 367,
    MIPS_INS_LL = 368,
    MIPS_INS_LLD = 369,
    MIPS_INS_LSA = 370,
    MIPS_INS_LUXC1 = 371,
    MIPS_INS_LUI = 372,
    MIPS_INS_LW = 373,
    MIPS_INS_LW16 = 374,
    MIPS_INS_LWC1 = 375,
    MIPS_INS_LWC2 = 376,
    MIPS_INS_LWC3 = 377,
    MIPS_INS_LWL = 378,
    MIPS_INS_LWM16 = 379,
    MIPS_INS_LWM32 = 380,
    MIPS_INS_LWPC = 381,
    MIPS_INS_LWP = 382,
    MIPS_INS_LWR = 383,
    MIPS_INS_LWUPC = 384,
    MIPS_INS_LWU = 385,
    MIPS_INS_LWX = 386,
    MIPS_INS_LWXC1 = 387,
    MIPS_INS_LWXS = 388,
    MIPS_INS_LI = 389,
    MIPS_INS_MADD = 390,
    MIPS_INS_MADDF = 391,
    MIPS_INS_MADDR_Q = 392,
    MIPS_INS_MADDU = 393,
    MIPS_INS_MADDV = 394,
    MIPS_INS_MADD_Q = 395,
    MIPS_INS_MAQ_SA = 396,
    MIPS_INS_MAQ_S = 397,
    MIPS_INS_MAXA = 398,
    MIPS_INS_MAXI_S = 399,
    MIPS_INS_MAXI_U = 400,
    MIPS_INS_MAX_A = 401,
    MIPS_INS_MAX = 402,
    MIPS_INS_MAX_S = 403,
    MIPS_INS_MAX_U = 404,
    MIPS_INS_MFC0 = 405,
    MIPS_INS_MFC1 = 406,
    MIPS_INS_MFC2 = 407,
    MIPS_INS_MFHC1 = 408,
    MIPS_INS_MFHI = 409,
    MIPS_INS_MFLO = 410,
    MIPS_INS_MINA = 411,
    MIPS_INS_MINI_S = 412,
    MIPS_INS_MINI_U = 413,
    MIPS_INS_MIN_A = 414,
    MIPS_INS_MIN = 415,
    MIPS_INS_MIN_S = 416,
    MIPS_INS_MIN_U = 417,
    MIPS_INS_MOD = 418,
    MIPS_INS_MODSUB = 419,
    MIPS_INS_MODU = 420,
    MIPS_INS_MOD_S = 421,
    MIPS_INS_MOD_U = 422,
    MIPS_INS_MOVE = 423,
    MIPS_INS_MOVEP = 424,
    MIPS_INS_MOVF = 425,
    MIPS_INS_MOVN = 426,
    MIPS_INS_MOVT = 427,
    MIPS_INS_MOVZ = 428,
    MIPS_INS_MSUB = 429,
    MIPS_INS_MSUBF = 430,
    MIPS_INS_MSUBR_Q = 431,
    MIPS_INS_MSUBU = 432,
    MIPS_INS_MSUBV = 433,
    MIPS_INS_MSUB_Q = 434,
    MIPS_INS_MTC0 = 435,
    MIPS_INS_MTC1 = 436,
    MIPS_INS_MTC2 = 437,
    MIPS_INS_MTHC1 = 438,
    MIPS_INS_MTHI = 439,
    MIPS_INS_MTHLIP = 440,
    MIPS_INS_MTLO = 441,
    MIPS_INS_MTM0 = 442,
    MIPS_INS_MTM1 = 443,
    MIPS_INS_MTM2 = 444,
    MIPS_INS_MTP0 = 445,
    MIPS_INS_MTP1 = 446,
    MIPS_INS_MTP2 = 447,
    MIPS_INS_MUH = 448,
    MIPS_INS_MUHU = 449,
    MIPS_INS_MULEQ_S = 450,
    MIPS_INS_MULEU_S = 451,
    MIPS_INS_MULQ_RS = 452,
    MIPS_INS_MULQ_S = 453,
    MIPS_INS_MULR_Q = 454,
    MIPS_INS_MULSAQ_S = 455,
    MIPS_INS_MULSA = 456,
    MIPS_INS_MULT = 457,
    MIPS_INS_MULTU = 458,
    MIPS_INS_MULU = 459,
    MIPS_INS_MULV = 460,
    MIPS_INS_MUL_Q = 461,
    MIPS_INS_MUL_S = 462,
    MIPS_INS_NLOC = 463,
    MIPS_INS_NLZC = 464,
    MIPS_INS_NMADD = 465,
    MIPS_INS_NMSUB = 466,
    MIPS_INS_NOR = 467,
    MIPS_INS_NORI = 468,
    MIPS_INS_NOT16 = 469,
    MIPS_INS_NOT = 470,
    MIPS_INS_OR = 471,
    MIPS_INS_OR16 = 472,
    MIPS_INS_ORI = 473,
    MIPS_INS_PACKRL = 474,
    MIPS_INS_PAUSE = 475,
    MIPS_INS_PCKEV = 476,
    MIPS_INS_PCKOD = 477,
    MIPS_INS_PCNT = 478,
    MIPS_INS_PICK = 479,
    MIPS_INS_POP = 480,
    MIPS_INS_PRECEQU = 481,
    MIPS_INS_PRECEQ = 482,
    MIPS_INS_PRECEU = 483,
    MIPS_INS_PRECRQU_S = 484,
    MIPS_INS_PRECRQ = 485,
    MIPS_INS_PRECRQ_RS = 486,
    MIPS_INS_PRECR = 487,
    MIPS_INS_PRECR_SRA = 488,
    MIPS_INS_PRECR_SRA_R = 489,
    MIPS_INS_PREF = 490,
    MIPS_INS_PREPEND = 491,
    MIPS_INS_RADDU = 492,
    MIPS_INS_RDDSP = 493,
    MIPS_INS_RDHWR = 494,
    MIPS_INS_REPLV = 495,
    MIPS_INS_REPL = 496,
    MIPS_INS_RINT = 497,
    MIPS_INS_ROTR = 498,
    MIPS_INS_ROTRV = 499,
    MIPS_INS_ROUND = 500,
    MIPS_INS_SAT_S = 501,
    MIPS_INS_SAT_U = 502,
    MIPS_INS_SB = 503,
    MIPS_INS_SB16 = 504,
    MIPS_INS_SC = 505,
    MIPS_INS_SCD = 506,
    MIPS_INS_SD = 507,
    MIPS_INS_SDBBP = 508,
    MIPS_INS_SDBBP16 = 509,
    MIPS_INS_SDC1 = 510,
    MIPS_INS_SDC2 = 511,
    MIPS_INS_SDC3 = 512,
    MIPS_INS_SDL = 513,
    MIPS_INS_SDR = 514,
    MIPS_INS_SDXC1 = 515,
    MIPS_INS_SEB = 516,
    MIPS_INS_SEH = 517,
    MIPS_INS_SELEQZ = 518,
    MIPS_INS_SELNEZ = 519,
    MIPS_INS_SEL = 520,
    MIPS_INS_SEQ = 521,
    MIPS_INS_SEQI = 522,
    MIPS_INS_SH = 523,
    MIPS_INS_SH16 = 524,
    MIPS_INS_SHF = 525,
    MIPS_INS_SHILO = 526,
    MIPS_INS_SHILOV = 527,
    MIPS_INS_SHLLV = 528,
    MIPS_INS_SHLLV_S = 529,
    MIPS_INS_SHLL = 530,
    MIPS_INS_SHLL_S = 531,
    MIPS_INS_SHRAV = 532,
    MIPS_INS_SHRAV_R = 533,
    MIPS_INS_SHRA = 534,
    MIPS_INS_SHRA_R = 535,
    MIPS_INS_SHRLV = 536,
    MIPS_INS_SHRL = 537,
    MIPS_INS_SLDI = 538,
    MIPS_INS_SLD = 539,
    MIPS_INS_SLL = 540,
    MIPS_INS_SLL16 = 541,
    MIPS_INS_SLLI = 542,
    MIPS_INS_SLLV = 543,
    MIPS_INS_SLT = 544,
    MIPS_INS_SLTI = 545,
    MIPS_INS_SLTIU = 546,
    MIPS_INS_SLTU = 547,
    MIPS_INS_SNE = 548,
    MIPS_INS_SNEI = 549,
    MIPS_INS_SPLATI = 550,
    MIPS_INS_SPLAT = 551,
    MIPS_INS_SRA = 552,
    MIPS_INS_SRAI = 553,
    MIPS_INS_SRARI = 554,
    MIPS_INS_SRAR = 555,
    MIPS_INS_SRAV = 556,
    MIPS_INS_SRL = 557,
    MIPS_INS_SRL16 = 558,
    MIPS_INS_SRLI = 559,
    MIPS_INS_SRLRI = 560,
    MIPS_INS_SRLR = 561,
    MIPS_INS_SRLV = 562,
    MIPS_INS_SSNOP = 563,
    MIPS_INS_ST = 564,
    MIPS_INS_SUBQH = 565,
    MIPS_INS_SUBQH_R = 566,
    MIPS_INS_SUBQ = 567,
    MIPS_INS_SUBQ_S = 568,
    MIPS_INS_SUBSUS_U = 569,
    MIPS_INS_SUBSUU_S = 570,
    MIPS_INS_SUBS_S = 571,
    MIPS_INS_SUBS_U = 572,
    MIPS_INS_SUBU16 = 573,
    MIPS_INS_SUBUH = 574,
    MIPS_INS_SUBUH_R = 575,
    MIPS_INS_SUBU = 576,
    MIPS_INS_SUBU_S = 577,
    MIPS_INS_SUBVI = 578,
    MIPS_INS_SUBV = 579,
    MIPS_INS_SUXC1 = 580,
    MIPS_INS_SW = 581,
    MIPS_INS_SW16 = 582,
    MIPS_INS_SWC1 = 583,
    MIPS_INS_SWC2 = 584,
    MIPS_INS_SWC3 = 585,
    MIPS_INS_SWL = 586,
    MIPS_INS_SWM16 = 587,
    MIPS_INS_SWM32 = 588,
    MIPS_INS_SWP = 589,
    MIPS_INS_SWR = 590,
    MIPS_INS_SWXC1 = 591,
    MIPS_INS_SYNC = 592,
    MIPS_INS_SYNCI = 593,
    MIPS_INS_SYSCALL = 594,
    MIPS_INS_TEQ = 595,
    MIPS_INS_TEQI = 596,
    MIPS_INS_TGE = 597,
    MIPS_INS_TGEI = 598,
    MIPS_INS_TGEIU = 599,
    MIPS_INS_TGEU = 600,
    MIPS_INS_TLBP = 601,
    MIPS_INS_TLBR = 602,
    MIPS_INS_TLBWI = 603,
    MIPS_INS_TLBWR = 604,
    MIPS_INS_TLT = 605,
    MIPS_INS_TLTI = 606,
    MIPS_INS_TLTIU = 607,
    MIPS_INS_TLTU = 608,
    MIPS_INS_TNE = 609,
    MIPS_INS_TNEI = 610,
    MIPS_INS_TRUNC = 611,
    MIPS_INS_V3MULU = 612,
    MIPS_INS_VMM0 = 613,
    MIPS_INS_VMULU = 614,
    MIPS_INS_VSHF = 615,
    MIPS_INS_WAIT = 616,
    MIPS_INS_WRDSP = 617,
    MIPS_INS_WSBH = 618,
    MIPS_INS_XOR = 619,
    MIPS_INS_XOR16 = 620,
    MIPS_INS_XORI = 621,
    MIPS_INS_NOP = 622,
    MIPS_INS_NEGU = 623,
    MIPS_INS_JALR_HB = 624,
    MIPS_INS_JR_HB = 625,
    MIPS_INS_ENDING = 626,
}
pub mod mips_insn_group {
    #[doc = " Group of MIPS instructions"]
    pub type Type = u32;
    #[doc = "< = CS_GRP_INVALID"]
    pub const MIPS_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const MIPS_GRP_JUMP: Type = 1;
    #[doc = "< = CS_GRP_CALL"]
    pub const MIPS_GRP_CALL: Type = 2;
    #[doc = "< = CS_GRP_RET"]
    pub const MIPS_GRP_RET: Type = 3;
    #[doc = "< = CS_GRP_INT"]
    pub const MIPS_GRP_INT: Type = 4;
    #[doc = "< = CS_GRP_IRET"]
    pub const MIPS_GRP_IRET: Type = 5;
    #[doc = "< = CS_GRP_PRIVILEGE"]
    pub const MIPS_GRP_PRIVILEGE: Type = 6;
    #[doc = "< = CS_GRP_BRANCH_RELATIVE"]
    pub const MIPS_GRP_BRANCH_RELATIVE: Type = 7;
    pub const MIPS_GRP_BITCOUNT: Type = 128;
    pub const MIPS_GRP_DSP: Type = 129;
    pub const MIPS_GRP_DSPR2: Type = 130;
    pub const MIPS_GRP_FPIDX: Type = 131;
    pub const MIPS_GRP_MSA: Type = 132;
    pub const MIPS_GRP_MIPS32R2: Type = 133;
    pub const MIPS_GRP_MIPS64: Type = 134;
    pub const MIPS_GRP_MIPS64R2: Type = 135;
    pub const MIPS_GRP_SEINREG: Type = 136;
    pub const MIPS_GRP_STDENC: Type = 137;
    pub const MIPS_GRP_SWAP: Type = 138;
    pub const MIPS_GRP_MICROMIPS: Type = 139;
    pub const MIPS_GRP_MIPS16MODE: Type = 140;
    pub const MIPS_GRP_FP64BIT: Type = 141;
    pub const MIPS_GRP_NONANSFPMATH: Type = 142;
    pub const MIPS_GRP_NOTFP64BIT: Type = 143;
    pub const MIPS_GRP_NOTINMICROMIPS: Type = 144;
    pub const MIPS_GRP_NOTNACL: Type = 145;
    pub const MIPS_GRP_NOTMIPS32R6: Type = 146;
    pub const MIPS_GRP_NOTMIPS64R6: Type = 147;
    pub const MIPS_GRP_CNMIPS: Type = 148;
    pub const MIPS_GRP_MIPS32: Type = 149;
    pub const MIPS_GRP_MIPS32R6: Type = 150;
    pub const MIPS_GRP_MIPS64R6: Type = 151;
    pub const MIPS_GRP_MIPS2: Type = 152;
    pub const MIPS_GRP_MIPS3: Type = 153;
    pub const MIPS_GRP_MIPS3_32: Type = 154;
    pub const MIPS_GRP_MIPS3_32R2: Type = 155;
    pub const MIPS_GRP_MIPS4_32: Type = 156;
    pub const MIPS_GRP_MIPS4_32R2: Type = 157;
    pub const MIPS_GRP_MIPS5_32R2: Type = 158;
    pub const MIPS_GRP_GP32BIT: Type = 159;
    pub const MIPS_GRP_GP64BIT: Type = 160;
    pub const MIPS_GRP_ENDING: Type = 161;
}
#[repr(u32)]
#[doc = " PPC branch codes for some branch instructions"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum ppc_bc {
    PPC_BC_INVALID = 0,
    PPC_BC_LT = 12,
    PPC_BC_LE = 36,
    PPC_BC_EQ = 76,
    PPC_BC_GE = 4,
    PPC_BC_GT = 44,
    PPC_BC_NE = 68,
    PPC_BC_UN = 108,
    PPC_BC_NU = 100,
    #[doc = "< summary overflow"]
    PPC_BC_SO = 140,
    #[doc = "< not summary overflow"]
    PPC_BC_NS = 132,
}
#[repr(u32)]
#[doc = " PPC branch hint for some branch instructions"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum ppc_bh {
    #[doc = "< no hint"]
    PPC_BH_INVALID = 0,
    #[doc = "< PLUS hint"]
    PPC_BH_PLUS = 1,
    #[doc = "< MINUS hint"]
    PPC_BH_MINUS = 2,
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum ppc_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    PPC_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    PPC_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    PPC_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    PPC_OP_MEM = 3,
    #[doc = "< Condition Register field"]
    PPC_OP_CRX = 64,
}
pub mod ppc_reg {
    #[doc = " PPC registers"]
    pub type Type = u32;
    pub const PPC_REG_INVALID: Type = 0;
    pub const PPC_REG_CARRY: Type = 1;
    pub const PPC_REG_CR0: Type = 2;
    pub const PPC_REG_CR1: Type = 3;
    pub const PPC_REG_CR2: Type = 4;
    pub const PPC_REG_CR3: Type = 5;
    pub const PPC_REG_CR4: Type = 6;
    pub const PPC_REG_CR5: Type = 7;
    pub const PPC_REG_CR6: Type = 8;
    pub const PPC_REG_CR7: Type = 9;
    pub const PPC_REG_CTR: Type = 10;
    pub const PPC_REG_F0: Type = 11;
    pub const PPC_REG_F1: Type = 12;
    pub const PPC_REG_F2: Type = 13;
    pub const PPC_REG_F3: Type = 14;
    pub const PPC_REG_F4: Type = 15;
    pub const PPC_REG_F5: Type = 16;
    pub const PPC_REG_F6: Type = 17;
    pub const PPC_REG_F7: Type = 18;
    pub const PPC_REG_F8: Type = 19;
    pub const PPC_REG_F9: Type = 20;
    pub const PPC_REG_F10: Type = 21;
    pub const PPC_REG_F11: Type = 22;
    pub const PPC_REG_F12: Type = 23;
    pub const PPC_REG_F13: Type = 24;
    pub const PPC_REG_F14: Type = 25;
    pub const PPC_REG_F15: Type = 26;
    pub const PPC_REG_F16: Type = 27;
    pub const PPC_REG_F17: Type = 28;
    pub const PPC_REG_F18: Type = 29;
    pub const PPC_REG_F19: Type = 30;
    pub const PPC_REG_F20: Type = 31;
    pub const PPC_REG_F21: Type = 32;
    pub const PPC_REG_F22: Type = 33;
    pub const PPC_REG_F23: Type = 34;
    pub const PPC_REG_F24: Type = 35;
    pub const PPC_REG_F25: Type = 36;
    pub const PPC_REG_F26: Type = 37;
    pub const PPC_REG_F27: Type = 38;
    pub const PPC_REG_F28: Type = 39;
    pub const PPC_REG_F29: Type = 40;
    pub const PPC_REG_F30: Type = 41;
    pub const PPC_REG_F31: Type = 42;
    pub const PPC_REG_LR: Type = 43;
    pub const PPC_REG_R0: Type = 44;
    pub const PPC_REG_R1: Type = 45;
    pub const PPC_REG_R2: Type = 46;
    pub const PPC_REG_R3: Type = 47;
    pub const PPC_REG_R4: Type = 48;
    pub const PPC_REG_R5: Type = 49;
    pub const PPC_REG_R6: Type = 50;
    pub const PPC_REG_R7: Type = 51;
    pub const PPC_REG_R8: Type = 52;
    pub const PPC_REG_R9: Type = 53;
    pub const PPC_REG_R10: Type = 54;
    pub const PPC_REG_R11: Type = 55;
    pub const PPC_REG_R12: Type = 56;
    pub const PPC_REG_R13: Type = 57;
    pub const PPC_REG_R14: Type = 58;
    pub const PPC_REG_R15: Type = 59;
    pub const PPC_REG_R16: Type = 60;
    pub const PPC_REG_R17: Type = 61;
    pub const PPC_REG_R18: Type = 62;
    pub const PPC_REG_R19: Type = 63;
    pub const PPC_REG_R20: Type = 64;
    pub const PPC_REG_R21: Type = 65;
    pub const PPC_REG_R22: Type = 66;
    pub const PPC_REG_R23: Type = 67;
    pub const PPC_REG_R24: Type = 68;
    pub const PPC_REG_R25: Type = 69;
    pub const PPC_REG_R26: Type = 70;
    pub const PPC_REG_R27: Type = 71;
    pub const PPC_REG_R28: Type = 72;
    pub const PPC_REG_R29: Type = 73;
    pub const PPC_REG_R30: Type = 74;
    pub const PPC_REG_R31: Type = 75;
    pub const PPC_REG_V0: Type = 76;
    pub const PPC_REG_V1: Type = 77;
    pub const PPC_REG_V2: Type = 78;
    pub const PPC_REG_V3: Type = 79;
    pub const PPC_REG_V4: Type = 80;
    pub const PPC_REG_V5: Type = 81;
    pub const PPC_REG_V6: Type = 82;
    pub const PPC_REG_V7: Type = 83;
    pub const PPC_REG_V8: Type = 84;
    pub const PPC_REG_V9: Type = 85;
    pub const PPC_REG_V10: Type = 86;
    pub const PPC_REG_V11: Type = 87;
    pub const PPC_REG_V12: Type = 88;
    pub const PPC_REG_V13: Type = 89;
    pub const PPC_REG_V14: Type = 90;
    pub const PPC_REG_V15: Type = 91;
    pub const PPC_REG_V16: Type = 92;
    pub const PPC_REG_V17: Type = 93;
    pub const PPC_REG_V18: Type = 94;
    pub const PPC_REG_V19: Type = 95;
    pub const PPC_REG_V20: Type = 96;
    pub const PPC_REG_V21: Type = 97;
    pub const PPC_REG_V22: Type = 98;
    pub const PPC_REG_V23: Type = 99;
    pub const PPC_REG_V24: Type = 100;
    pub const PPC_REG_V25: Type = 101;
    pub const PPC_REG_V26: Type = 102;
    pub const PPC_REG_V27: Type = 103;
    pub const PPC_REG_V28: Type = 104;
    pub const PPC_REG_V29: Type = 105;
    pub const PPC_REG_V30: Type = 106;
    pub const PPC_REG_V31: Type = 107;
    pub const PPC_REG_VRSAVE: Type = 108;
    pub const PPC_REG_VS0: Type = 109;
    pub const PPC_REG_VS1: Type = 110;
    pub const PPC_REG_VS2: Type = 111;
    pub const PPC_REG_VS3: Type = 112;
    pub const PPC_REG_VS4: Type = 113;
    pub const PPC_REG_VS5: Type = 114;
    pub const PPC_REG_VS6: Type = 115;
    pub const PPC_REG_VS7: Type = 116;
    pub const PPC_REG_VS8: Type = 117;
    pub const PPC_REG_VS9: Type = 118;
    pub const PPC_REG_VS10: Type = 119;
    pub const PPC_REG_VS11: Type = 120;
    pub const PPC_REG_VS12: Type = 121;
    pub const PPC_REG_VS13: Type = 122;
    pub const PPC_REG_VS14: Type = 123;
    pub const PPC_REG_VS15: Type = 124;
    pub const PPC_REG_VS16: Type = 125;
    pub const PPC_REG_VS17: Type = 126;
    pub const PPC_REG_VS18: Type = 127;
    pub const PPC_REG_VS19: Type = 128;
    pub const PPC_REG_VS20: Type = 129;
    pub const PPC_REG_VS21: Type = 130;
    pub const PPC_REG_VS22: Type = 131;
    pub const PPC_REG_VS23: Type = 132;
    pub const PPC_REG_VS24: Type = 133;
    pub const PPC_REG_VS25: Type = 134;
    pub const PPC_REG_VS26: Type = 135;
    pub const PPC_REG_VS27: Type = 136;
    pub const PPC_REG_VS28: Type = 137;
    pub const PPC_REG_VS29: Type = 138;
    pub const PPC_REG_VS30: Type = 139;
    pub const PPC_REG_VS31: Type = 140;
    pub const PPC_REG_VS32: Type = 141;
    pub const PPC_REG_VS33: Type = 142;
    pub const PPC_REG_VS34: Type = 143;
    pub const PPC_REG_VS35: Type = 144;
    pub const PPC_REG_VS36: Type = 145;
    pub const PPC_REG_VS37: Type = 146;
    pub const PPC_REG_VS38: Type = 147;
    pub const PPC_REG_VS39: Type = 148;
    pub const PPC_REG_VS40: Type = 149;
    pub const PPC_REG_VS41: Type = 150;
    pub const PPC_REG_VS42: Type = 151;
    pub const PPC_REG_VS43: Type = 152;
    pub const PPC_REG_VS44: Type = 153;
    pub const PPC_REG_VS45: Type = 154;
    pub const PPC_REG_VS46: Type = 155;
    pub const PPC_REG_VS47: Type = 156;
    pub const PPC_REG_VS48: Type = 157;
    pub const PPC_REG_VS49: Type = 158;
    pub const PPC_REG_VS50: Type = 159;
    pub const PPC_REG_VS51: Type = 160;
    pub const PPC_REG_VS52: Type = 161;
    pub const PPC_REG_VS53: Type = 162;
    pub const PPC_REG_VS54: Type = 163;
    pub const PPC_REG_VS55: Type = 164;
    pub const PPC_REG_VS56: Type = 165;
    pub const PPC_REG_VS57: Type = 166;
    pub const PPC_REG_VS58: Type = 167;
    pub const PPC_REG_VS59: Type = 168;
    pub const PPC_REG_VS60: Type = 169;
    pub const PPC_REG_VS61: Type = 170;
    pub const PPC_REG_VS62: Type = 171;
    pub const PPC_REG_VS63: Type = 172;
    pub const PPC_REG_Q0: Type = 173;
    pub const PPC_REG_Q1: Type = 174;
    pub const PPC_REG_Q2: Type = 175;
    pub const PPC_REG_Q3: Type = 176;
    pub const PPC_REG_Q4: Type = 177;
    pub const PPC_REG_Q5: Type = 178;
    pub const PPC_REG_Q6: Type = 179;
    pub const PPC_REG_Q7: Type = 180;
    pub const PPC_REG_Q8: Type = 181;
    pub const PPC_REG_Q9: Type = 182;
    pub const PPC_REG_Q10: Type = 183;
    pub const PPC_REG_Q11: Type = 184;
    pub const PPC_REG_Q12: Type = 185;
    pub const PPC_REG_Q13: Type = 186;
    pub const PPC_REG_Q14: Type = 187;
    pub const PPC_REG_Q15: Type = 188;
    pub const PPC_REG_Q16: Type = 189;
    pub const PPC_REG_Q17: Type = 190;
    pub const PPC_REG_Q18: Type = 191;
    pub const PPC_REG_Q19: Type = 192;
    pub const PPC_REG_Q20: Type = 193;
    pub const PPC_REG_Q21: Type = 194;
    pub const PPC_REG_Q22: Type = 195;
    pub const PPC_REG_Q23: Type = 196;
    pub const PPC_REG_Q24: Type = 197;
    pub const PPC_REG_Q25: Type = 198;
    pub const PPC_REG_Q26: Type = 199;
    pub const PPC_REG_Q27: Type = 200;
    pub const PPC_REG_Q28: Type = 201;
    pub const PPC_REG_Q29: Type = 202;
    pub const PPC_REG_Q30: Type = 203;
    pub const PPC_REG_Q31: Type = 204;
    pub const PPC_REG_RM: Type = 205;
    pub const PPC_REG_CTR8: Type = 206;
    pub const PPC_REG_LR8: Type = 207;
    pub const PPC_REG_CR1EQ: Type = 208;
    pub const PPC_REG_X2: Type = 209;
    pub const PPC_REG_ENDING: Type = 210;
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with PPC_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct ppc_op_mem {
    #[doc = "< base register"]
    pub base: ppc_reg::Type,
    #[doc = "< displacement/offset value"]
    pub disp: i32,
}
impl Clone for ppc_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct ppc_op_crx {
    pub scale: libc::c_uint,
    pub reg: ppc_reg::Type,
    pub cond: ppc_bc,
}
impl Clone for ppc_op_crx {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_ppc_op {
    #[doc = "< operand type"]
    pub type_: ppc_op_type,
    pub __bindgen_anon_1: cs_ppc_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_ppc_op__bindgen_ty_1 {
    #[doc = "< register value for REG operand"]
    pub reg: ppc_reg::Type,
    #[doc = "< immediate value for IMM operand"]
    pub imm: i64,
    #[doc = "< base/disp value for MEM operand"]
    pub mem: ppc_op_mem,
    #[doc = "< operand with condition register"]
    pub crx: ppc_op_crx,
    _bindgen_union_align: [u64; 2usize],
}
impl Clone for cs_ppc_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_ppc_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_ppc_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_ppc_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_ppc_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_ppc_op {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_ppc {
    #[doc = " branch code for branch instructions"]
    pub bc: ppc_bc,
    #[doc = " branch hint for branch instructions"]
    pub bh: ppc_bh,
    #[doc = " if update_cr0 = True, then this 'dot' insn updates CR0"]
    pub update_cr0: bool,
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_ppc_op; 8usize],
}
impl Clone for cs_ppc {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_ppc {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_ppc {{ bc: {:?}, bh: {:?}, update_cr0: {:?}, op_count: {:?}, operands: {:?} }}",
            self.bc, self.bh, self.update_cr0, self.op_count, self.operands
        )
    }
}
#[repr(u32)]
#[doc = " PPC instruction"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum ppc_insn {
    PPC_INS_INVALID = 0,
    PPC_INS_ADD = 1,
    PPC_INS_ADDC = 2,
    PPC_INS_ADDE = 3,
    PPC_INS_ADDI = 4,
    PPC_INS_ADDIC = 5,
    PPC_INS_ADDIS = 6,
    PPC_INS_ADDME = 7,
    PPC_INS_ADDZE = 8,
    PPC_INS_AND = 9,
    PPC_INS_ANDC = 10,
    PPC_INS_ANDIS = 11,
    PPC_INS_ANDI = 12,
    PPC_INS_ATTN = 13,
    PPC_INS_B = 14,
    PPC_INS_BA = 15,
    PPC_INS_BC = 16,
    PPC_INS_BCCTR = 17,
    PPC_INS_BCCTRL = 18,
    PPC_INS_BCL = 19,
    PPC_INS_BCLR = 20,
    PPC_INS_BCLRL = 21,
    PPC_INS_BCTR = 22,
    PPC_INS_BCTRL = 23,
    PPC_INS_BCT = 24,
    PPC_INS_BDNZ = 25,
    PPC_INS_BDNZA = 26,
    PPC_INS_BDNZL = 27,
    PPC_INS_BDNZLA = 28,
    PPC_INS_BDNZLR = 29,
    PPC_INS_BDNZLRL = 30,
    PPC_INS_BDZ = 31,
    PPC_INS_BDZA = 32,
    PPC_INS_BDZL = 33,
    PPC_INS_BDZLA = 34,
    PPC_INS_BDZLR = 35,
    PPC_INS_BDZLRL = 36,
    PPC_INS_BL = 37,
    PPC_INS_BLA = 38,
    PPC_INS_BLR = 39,
    PPC_INS_BLRL = 40,
    PPC_INS_BRINC = 41,
    PPC_INS_CMPB = 42,
    PPC_INS_CMPD = 43,
    PPC_INS_CMPDI = 44,
    PPC_INS_CMPLD = 45,
    PPC_INS_CMPLDI = 46,
    PPC_INS_CMPLW = 47,
    PPC_INS_CMPLWI = 48,
    PPC_INS_CMPW = 49,
    PPC_INS_CMPWI = 50,
    PPC_INS_CNTLZD = 51,
    PPC_INS_CNTLZW = 52,
    PPC_INS_CREQV = 53,
    PPC_INS_CRXOR = 54,
    PPC_INS_CRAND = 55,
    PPC_INS_CRANDC = 56,
    PPC_INS_CRNAND = 57,
    PPC_INS_CRNOR = 58,
    PPC_INS_CROR = 59,
    PPC_INS_CRORC = 60,
    PPC_INS_DCBA = 61,
    PPC_INS_DCBF = 62,
    PPC_INS_DCBI = 63,
    PPC_INS_DCBST = 64,
    PPC_INS_DCBT = 65,
    PPC_INS_DCBTST = 66,
    PPC_INS_DCBZ = 67,
    PPC_INS_DCBZL = 68,
    PPC_INS_DCCCI = 69,
    PPC_INS_DIVD = 70,
    PPC_INS_DIVDU = 71,
    PPC_INS_DIVW = 72,
    PPC_INS_DIVWU = 73,
    PPC_INS_DSS = 74,
    PPC_INS_DSSALL = 75,
    PPC_INS_DST = 76,
    PPC_INS_DSTST = 77,
    PPC_INS_DSTSTT = 78,
    PPC_INS_DSTT = 79,
    PPC_INS_EQV = 80,
    PPC_INS_EVABS = 81,
    PPC_INS_EVADDIW = 82,
    PPC_INS_EVADDSMIAAW = 83,
    PPC_INS_EVADDSSIAAW = 84,
    PPC_INS_EVADDUMIAAW = 85,
    PPC_INS_EVADDUSIAAW = 86,
    PPC_INS_EVADDW = 87,
    PPC_INS_EVAND = 88,
    PPC_INS_EVANDC = 89,
    PPC_INS_EVCMPEQ = 90,
    PPC_INS_EVCMPGTS = 91,
    PPC_INS_EVCMPGTU = 92,
    PPC_INS_EVCMPLTS = 93,
    PPC_INS_EVCMPLTU = 94,
    PPC_INS_EVCNTLSW = 95,
    PPC_INS_EVCNTLZW = 96,
    PPC_INS_EVDIVWS = 97,
    PPC_INS_EVDIVWU = 98,
    PPC_INS_EVEQV = 99,
    PPC_INS_EVEXTSB = 100,
    PPC_INS_EVEXTSH = 101,
    PPC_INS_EVLDD = 102,
    PPC_INS_EVLDDX = 103,
    PPC_INS_EVLDH = 104,
    PPC_INS_EVLDHX = 105,
    PPC_INS_EVLDW = 106,
    PPC_INS_EVLDWX = 107,
    PPC_INS_EVLHHESPLAT = 108,
    PPC_INS_EVLHHESPLATX = 109,
    PPC_INS_EVLHHOSSPLAT = 110,
    PPC_INS_EVLHHOSSPLATX = 111,
    PPC_INS_EVLHHOUSPLAT = 112,
    PPC_INS_EVLHHOUSPLATX = 113,
    PPC_INS_EVLWHE = 114,
    PPC_INS_EVLWHEX = 115,
    PPC_INS_EVLWHOS = 116,
    PPC_INS_EVLWHOSX = 117,
    PPC_INS_EVLWHOU = 118,
    PPC_INS_EVLWHOUX = 119,
    PPC_INS_EVLWHSPLAT = 120,
    PPC_INS_EVLWHSPLATX = 121,
    PPC_INS_EVLWWSPLAT = 122,
    PPC_INS_EVLWWSPLATX = 123,
    PPC_INS_EVMERGEHI = 124,
    PPC_INS_EVMERGEHILO = 125,
    PPC_INS_EVMERGELO = 126,
    PPC_INS_EVMERGELOHI = 127,
    PPC_INS_EVMHEGSMFAA = 128,
    PPC_INS_EVMHEGSMFAN = 129,
    PPC_INS_EVMHEGSMIAA = 130,
    PPC_INS_EVMHEGSMIAN = 131,
    PPC_INS_EVMHEGUMIAA = 132,
    PPC_INS_EVMHEGUMIAN = 133,
    PPC_INS_EVMHESMF = 134,
    PPC_INS_EVMHESMFA = 135,
    PPC_INS_EVMHESMFAAW = 136,
    PPC_INS_EVMHESMFANW = 137,
    PPC_INS_EVMHESMI = 138,
    PPC_INS_EVMHESMIA = 139,
    PPC_INS_EVMHESMIAAW = 140,
    PPC_INS_EVMHESMIANW = 141,
    PPC_INS_EVMHESSF = 142,
    PPC_INS_EVMHESSFA = 143,
    PPC_INS_EVMHESSFAAW = 144,
    PPC_INS_EVMHESSFANW = 145,
    PPC_INS_EVMHESSIAAW = 146,
    PPC_INS_EVMHESSIANW = 147,
    PPC_INS_EVMHEUMI = 148,
    PPC_INS_EVMHEUMIA = 149,
    PPC_INS_EVMHEUMIAAW = 150,
    PPC_INS_EVMHEUMIANW = 151,
    PPC_INS_EVMHEUSIAAW = 152,
    PPC_INS_EVMHEUSIANW = 153,
    PPC_INS_EVMHOGSMFAA = 154,
    PPC_INS_EVMHOGSMFAN = 155,
    PPC_INS_EVMHOGSMIAA = 156,
    PPC_INS_EVMHOGSMIAN = 157,
    PPC_INS_EVMHOGUMIAA = 158,
    PPC_INS_EVMHOGUMIAN = 159,
    PPC_INS_EVMHOSMF = 160,
    PPC_INS_EVMHOSMFA = 161,
    PPC_INS_EVMHOSMFAAW = 162,
    PPC_INS_EVMHOSMFANW = 163,
    PPC_INS_EVMHOSMI = 164,
    PPC_INS_EVMHOSMIA = 165,
    PPC_INS_EVMHOSMIAAW = 166,
    PPC_INS_EVMHOSMIANW = 167,
    PPC_INS_EVMHOSSF = 168,
    PPC_INS_EVMHOSSFA = 169,
    PPC_INS_EVMHOSSFAAW = 170,
    PPC_INS_EVMHOSSFANW = 171,
    PPC_INS_EVMHOSSIAAW = 172,
    PPC_INS_EVMHOSSIANW = 173,
    PPC_INS_EVMHOUMI = 174,
    PPC_INS_EVMHOUMIA = 175,
    PPC_INS_EVMHOUMIAAW = 176,
    PPC_INS_EVMHOUMIANW = 177,
    PPC_INS_EVMHOUSIAAW = 178,
    PPC_INS_EVMHOUSIANW = 179,
    PPC_INS_EVMRA = 180,
    PPC_INS_EVMWHSMF = 181,
    PPC_INS_EVMWHSMFA = 182,
    PPC_INS_EVMWHSMI = 183,
    PPC_INS_EVMWHSMIA = 184,
    PPC_INS_EVMWHSSF = 185,
    PPC_INS_EVMWHSSFA = 186,
    PPC_INS_EVMWHUMI = 187,
    PPC_INS_EVMWHUMIA = 188,
    PPC_INS_EVMWLSMIAAW = 189,
    PPC_INS_EVMWLSMIANW = 190,
    PPC_INS_EVMWLSSIAAW = 191,
    PPC_INS_EVMWLSSIANW = 192,
    PPC_INS_EVMWLUMI = 193,
    PPC_INS_EVMWLUMIA = 194,
    PPC_INS_EVMWLUMIAAW = 195,
    PPC_INS_EVMWLUMIANW = 196,
    PPC_INS_EVMWLUSIAAW = 197,
    PPC_INS_EVMWLUSIANW = 198,
    PPC_INS_EVMWSMF = 199,
    PPC_INS_EVMWSMFA = 200,
    PPC_INS_EVMWSMFAA = 201,
    PPC_INS_EVMWSMFAN = 202,
    PPC_INS_EVMWSMI = 203,
    PPC_INS_EVMWSMIA = 204,
    PPC_INS_EVMWSMIAA = 205,
    PPC_INS_EVMWSMIAN = 206,
    PPC_INS_EVMWSSF = 207,
    PPC_INS_EVMWSSFA = 208,
    PPC_INS_EVMWSSFAA = 209,
    PPC_INS_EVMWSSFAN = 210,
    PPC_INS_EVMWUMI = 211,
    PPC_INS_EVMWUMIA = 212,
    PPC_INS_EVMWUMIAA = 213,
    PPC_INS_EVMWUMIAN = 214,
    PPC_INS_EVNAND = 215,
    PPC_INS_EVNEG = 216,
    PPC_INS_EVNOR = 217,
    PPC_INS_EVOR = 218,
    PPC_INS_EVORC = 219,
    PPC_INS_EVRLW = 220,
    PPC_INS_EVRLWI = 221,
    PPC_INS_EVRNDW = 222,
    PPC_INS_EVSLW = 223,
    PPC_INS_EVSLWI = 224,
    PPC_INS_EVSPLATFI = 225,
    PPC_INS_EVSPLATI = 226,
    PPC_INS_EVSRWIS = 227,
    PPC_INS_EVSRWIU = 228,
    PPC_INS_EVSRWS = 229,
    PPC_INS_EVSRWU = 230,
    PPC_INS_EVSTDD = 231,
    PPC_INS_EVSTDDX = 232,
    PPC_INS_EVSTDH = 233,
    PPC_INS_EVSTDHX = 234,
    PPC_INS_EVSTDW = 235,
    PPC_INS_EVSTDWX = 236,
    PPC_INS_EVSTWHE = 237,
    PPC_INS_EVSTWHEX = 238,
    PPC_INS_EVSTWHO = 239,
    PPC_INS_EVSTWHOX = 240,
    PPC_INS_EVSTWWE = 241,
    PPC_INS_EVSTWWEX = 242,
    PPC_INS_EVSTWWO = 243,
    PPC_INS_EVSTWWOX = 244,
    PPC_INS_EVSUBFSMIAAW = 245,
    PPC_INS_EVSUBFSSIAAW = 246,
    PPC_INS_EVSUBFUMIAAW = 247,
    PPC_INS_EVSUBFUSIAAW = 248,
    PPC_INS_EVSUBFW = 249,
    PPC_INS_EVSUBIFW = 250,
    PPC_INS_EVXOR = 251,
    PPC_INS_EXTSB = 252,
    PPC_INS_EXTSH = 253,
    PPC_INS_EXTSW = 254,
    PPC_INS_EIEIO = 255,
    PPC_INS_FABS = 256,
    PPC_INS_FADD = 257,
    PPC_INS_FADDS = 258,
    PPC_INS_FCFID = 259,
    PPC_INS_FCFIDS = 260,
    PPC_INS_FCFIDU = 261,
    PPC_INS_FCFIDUS = 262,
    PPC_INS_FCMPU = 263,
    PPC_INS_FCPSGN = 264,
    PPC_INS_FCTID = 265,
    PPC_INS_FCTIDUZ = 266,
    PPC_INS_FCTIDZ = 267,
    PPC_INS_FCTIW = 268,
    PPC_INS_FCTIWUZ = 269,
    PPC_INS_FCTIWZ = 270,
    PPC_INS_FDIV = 271,
    PPC_INS_FDIVS = 272,
    PPC_INS_FMADD = 273,
    PPC_INS_FMADDS = 274,
    PPC_INS_FMR = 275,
    PPC_INS_FMSUB = 276,
    PPC_INS_FMSUBS = 277,
    PPC_INS_FMUL = 278,
    PPC_INS_FMULS = 279,
    PPC_INS_FNABS = 280,
    PPC_INS_FNEG = 281,
    PPC_INS_FNMADD = 282,
    PPC_INS_FNMADDS = 283,
    PPC_INS_FNMSUB = 284,
    PPC_INS_FNMSUBS = 285,
    PPC_INS_FRE = 286,
    PPC_INS_FRES = 287,
    PPC_INS_FRIM = 288,
    PPC_INS_FRIN = 289,
    PPC_INS_FRIP = 290,
    PPC_INS_FRIZ = 291,
    PPC_INS_FRSP = 292,
    PPC_INS_FRSQRTE = 293,
    PPC_INS_FRSQRTES = 294,
    PPC_INS_FSEL = 295,
    PPC_INS_FSQRT = 296,
    PPC_INS_FSQRTS = 297,
    PPC_INS_FSUB = 298,
    PPC_INS_FSUBS = 299,
    PPC_INS_ICBI = 300,
    PPC_INS_ICBT = 301,
    PPC_INS_ICCCI = 302,
    PPC_INS_ISEL = 303,
    PPC_INS_ISYNC = 304,
    PPC_INS_LA = 305,
    PPC_INS_LBZ = 306,
    PPC_INS_LBZCIX = 307,
    PPC_INS_LBZU = 308,
    PPC_INS_LBZUX = 309,
    PPC_INS_LBZX = 310,
    PPC_INS_LD = 311,
    PPC_INS_LDARX = 312,
    PPC_INS_LDBRX = 313,
    PPC_INS_LDCIX = 314,
    PPC_INS_LDU = 315,
    PPC_INS_LDUX = 316,
    PPC_INS_LDX = 317,
    PPC_INS_LFD = 318,
    PPC_INS_LFDU = 319,
    PPC_INS_LFDUX = 320,
    PPC_INS_LFDX = 321,
    PPC_INS_LFIWAX = 322,
    PPC_INS_LFIWZX = 323,
    PPC_INS_LFS = 324,
    PPC_INS_LFSU = 325,
    PPC_INS_LFSUX = 326,
    PPC_INS_LFSX = 327,
    PPC_INS_LHA = 328,
    PPC_INS_LHAU = 329,
    PPC_INS_LHAUX = 330,
    PPC_INS_LHAX = 331,
    PPC_INS_LHBRX = 332,
    PPC_INS_LHZ = 333,
    PPC_INS_LHZCIX = 334,
    PPC_INS_LHZU = 335,
    PPC_INS_LHZUX = 336,
    PPC_INS_LHZX = 337,
    PPC_INS_LI = 338,
    PPC_INS_LIS = 339,
    PPC_INS_LMW = 340,
    PPC_INS_LSWI = 341,
    PPC_INS_LVEBX = 342,
    PPC_INS_LVEHX = 343,
    PPC_INS_LVEWX = 344,
    PPC_INS_LVSL = 345,
    PPC_INS_LVSR = 346,
    PPC_INS_LVX = 347,
    PPC_INS_LVXL = 348,
    PPC_INS_LWA = 349,
    PPC_INS_LWARX = 350,
    PPC_INS_LWAUX = 351,
    PPC_INS_LWAX = 352,
    PPC_INS_LWBRX = 353,
    PPC_INS_LWZ = 354,
    PPC_INS_LWZCIX = 355,
    PPC_INS_LWZU = 356,
    PPC_INS_LWZUX = 357,
    PPC_INS_LWZX = 358,
    PPC_INS_LXSDX = 359,
    PPC_INS_LXVD2X = 360,
    PPC_INS_LXVDSX = 361,
    PPC_INS_LXVW4X = 362,
    PPC_INS_MBAR = 363,
    PPC_INS_MCRF = 364,
    PPC_INS_MCRFS = 365,
    PPC_INS_MFCR = 366,
    PPC_INS_MFCTR = 367,
    PPC_INS_MFDCR = 368,
    PPC_INS_MFFS = 369,
    PPC_INS_MFLR = 370,
    PPC_INS_MFMSR = 371,
    PPC_INS_MFOCRF = 372,
    PPC_INS_MFSPR = 373,
    PPC_INS_MFSR = 374,
    PPC_INS_MFSRIN = 375,
    PPC_INS_MFTB = 376,
    PPC_INS_MFVSCR = 377,
    PPC_INS_MSYNC = 378,
    PPC_INS_MTCRF = 379,
    PPC_INS_MTCTR = 380,
    PPC_INS_MTDCR = 381,
    PPC_INS_MTFSB0 = 382,
    PPC_INS_MTFSB1 = 383,
    PPC_INS_MTFSF = 384,
    PPC_INS_MTFSFI = 385,
    PPC_INS_MTLR = 386,
    PPC_INS_MTMSR = 387,
    PPC_INS_MTMSRD = 388,
    PPC_INS_MTOCRF = 389,
    PPC_INS_MTSPR = 390,
    PPC_INS_MTSR = 391,
    PPC_INS_MTSRIN = 392,
    PPC_INS_MTVSCR = 393,
    PPC_INS_MULHD = 394,
    PPC_INS_MULHDU = 395,
    PPC_INS_MULHW = 396,
    PPC_INS_MULHWU = 397,
    PPC_INS_MULLD = 398,
    PPC_INS_MULLI = 399,
    PPC_INS_MULLW = 400,
    PPC_INS_NAND = 401,
    PPC_INS_NEG = 402,
    PPC_INS_NOP = 403,
    PPC_INS_ORI = 404,
    PPC_INS_NOR = 405,
    PPC_INS_OR = 406,
    PPC_INS_ORC = 407,
    PPC_INS_ORIS = 408,
    PPC_INS_POPCNTD = 409,
    PPC_INS_POPCNTW = 410,
    PPC_INS_QVALIGNI = 411,
    PPC_INS_QVESPLATI = 412,
    PPC_INS_QVFABS = 413,
    PPC_INS_QVFADD = 414,
    PPC_INS_QVFADDS = 415,
    PPC_INS_QVFCFID = 416,
    PPC_INS_QVFCFIDS = 417,
    PPC_INS_QVFCFIDU = 418,
    PPC_INS_QVFCFIDUS = 419,
    PPC_INS_QVFCMPEQ = 420,
    PPC_INS_QVFCMPGT = 421,
    PPC_INS_QVFCMPLT = 422,
    PPC_INS_QVFCPSGN = 423,
    PPC_INS_QVFCTID = 424,
    PPC_INS_QVFCTIDU = 425,
    PPC_INS_QVFCTIDUZ = 426,
    PPC_INS_QVFCTIDZ = 427,
    PPC_INS_QVFCTIW = 428,
    PPC_INS_QVFCTIWU = 429,
    PPC_INS_QVFCTIWUZ = 430,
    PPC_INS_QVFCTIWZ = 431,
    PPC_INS_QVFLOGICAL = 432,
    PPC_INS_QVFMADD = 433,
    PPC_INS_QVFMADDS = 434,
    PPC_INS_QVFMR = 435,
    PPC_INS_QVFMSUB = 436,
    PPC_INS_QVFMSUBS = 437,
    PPC_INS_QVFMUL = 438,
    PPC_INS_QVFMULS = 439,
    PPC_INS_QVFNABS = 440,
    PPC_INS_QVFNEG = 441,
    PPC_INS_QVFNMADD = 442,
    PPC_INS_QVFNMADDS = 443,
    PPC_INS_QVFNMSUB = 444,
    PPC_INS_QVFNMSUBS = 445,
    PPC_INS_QVFPERM = 446,
    PPC_INS_QVFRE = 447,
    PPC_INS_QVFRES = 448,
    PPC_INS_QVFRIM = 449,
    PPC_INS_QVFRIN = 450,
    PPC_INS_QVFRIP = 451,
    PPC_INS_QVFRIZ = 452,
    PPC_INS_QVFRSP = 453,
    PPC_INS_QVFRSQRTE = 454,
    PPC_INS_QVFRSQRTES = 455,
    PPC_INS_QVFSEL = 456,
    PPC_INS_QVFSUB = 457,
    PPC_INS_QVFSUBS = 458,
    PPC_INS_QVFTSTNAN = 459,
    PPC_INS_QVFXMADD = 460,
    PPC_INS_QVFXMADDS = 461,
    PPC_INS_QVFXMUL = 462,
    PPC_INS_QVFXMULS = 463,
    PPC_INS_QVFXXCPNMADD = 464,
    PPC_INS_QVFXXCPNMADDS = 465,
    PPC_INS_QVFXXMADD = 466,
    PPC_INS_QVFXXMADDS = 467,
    PPC_INS_QVFXXNPMADD = 468,
    PPC_INS_QVFXXNPMADDS = 469,
    PPC_INS_QVGPCI = 470,
    PPC_INS_QVLFCDUX = 471,
    PPC_INS_QVLFCDUXA = 472,
    PPC_INS_QVLFCDX = 473,
    PPC_INS_QVLFCDXA = 474,
    PPC_INS_QVLFCSUX = 475,
    PPC_INS_QVLFCSUXA = 476,
    PPC_INS_QVLFCSX = 477,
    PPC_INS_QVLFCSXA = 478,
    PPC_INS_QVLFDUX = 479,
    PPC_INS_QVLFDUXA = 480,
    PPC_INS_QVLFDX = 481,
    PPC_INS_QVLFDXA = 482,
    PPC_INS_QVLFIWAX = 483,
    PPC_INS_QVLFIWAXA = 484,
    PPC_INS_QVLFIWZX = 485,
    PPC_INS_QVLFIWZXA = 486,
    PPC_INS_QVLFSUX = 487,
    PPC_INS_QVLFSUXA = 488,
    PPC_INS_QVLFSX = 489,
    PPC_INS_QVLFSXA = 490,
    PPC_INS_QVLPCLDX = 491,
    PPC_INS_QVLPCLSX = 492,
    PPC_INS_QVLPCRDX = 493,
    PPC_INS_QVLPCRSX = 494,
    PPC_INS_QVSTFCDUX = 495,
    PPC_INS_QVSTFCDUXA = 496,
    PPC_INS_QVSTFCDUXI = 497,
    PPC_INS_QVSTFCDUXIA = 498,
    PPC_INS_QVSTFCDX = 499,
    PPC_INS_QVSTFCDXA = 500,
    PPC_INS_QVSTFCDXI = 501,
    PPC_INS_QVSTFCDXIA = 502,
    PPC_INS_QVSTFCSUX = 503,
    PPC_INS_QVSTFCSUXA = 504,
    PPC_INS_QVSTFCSUXI = 505,
    PPC_INS_QVSTFCSUXIA = 506,
    PPC_INS_QVSTFCSX = 507,
    PPC_INS_QVSTFCSXA = 508,
    PPC_INS_QVSTFCSXI = 509,
    PPC_INS_QVSTFCSXIA = 510,
    PPC_INS_QVSTFDUX = 511,
    PPC_INS_QVSTFDUXA = 512,
    PPC_INS_QVSTFDUXI = 513,
    PPC_INS_QVSTFDUXIA = 514,
    PPC_INS_QVSTFDX = 515,
    PPC_INS_QVSTFDXA = 516,
    PPC_INS_QVSTFDXI = 517,
    PPC_INS_QVSTFDXIA = 518,
    PPC_INS_QVSTFIWX = 519,
    PPC_INS_QVSTFIWXA = 520,
    PPC_INS_QVSTFSUX = 521,
    PPC_INS_QVSTFSUXA = 522,
    PPC_INS_QVSTFSUXI = 523,
    PPC_INS_QVSTFSUXIA = 524,
    PPC_INS_QVSTFSX = 525,
    PPC_INS_QVSTFSXA = 526,
    PPC_INS_QVSTFSXI = 527,
    PPC_INS_QVSTFSXIA = 528,
    PPC_INS_RFCI = 529,
    PPC_INS_RFDI = 530,
    PPC_INS_RFI = 531,
    PPC_INS_RFID = 532,
    PPC_INS_RFMCI = 533,
    PPC_INS_RLDCL = 534,
    PPC_INS_RLDCR = 535,
    PPC_INS_RLDIC = 536,
    PPC_INS_RLDICL = 537,
    PPC_INS_RLDICR = 538,
    PPC_INS_RLDIMI = 539,
    PPC_INS_RLWIMI = 540,
    PPC_INS_RLWINM = 541,
    PPC_INS_RLWNM = 542,
    PPC_INS_SC = 543,
    PPC_INS_SLBIA = 544,
    PPC_INS_SLBIE = 545,
    PPC_INS_SLBMFEE = 546,
    PPC_INS_SLBMTE = 547,
    PPC_INS_SLD = 548,
    PPC_INS_SLW = 549,
    PPC_INS_SRAD = 550,
    PPC_INS_SRADI = 551,
    PPC_INS_SRAW = 552,
    PPC_INS_SRAWI = 553,
    PPC_INS_SRD = 554,
    PPC_INS_SRW = 555,
    PPC_INS_STB = 556,
    PPC_INS_STBCIX = 557,
    PPC_INS_STBU = 558,
    PPC_INS_STBUX = 559,
    PPC_INS_STBX = 560,
    PPC_INS_STD = 561,
    PPC_INS_STDBRX = 562,
    PPC_INS_STDCIX = 563,
    PPC_INS_STDCX = 564,
    PPC_INS_STDU = 565,
    PPC_INS_STDUX = 566,
    PPC_INS_STDX = 567,
    PPC_INS_STFD = 568,
    PPC_INS_STFDU = 569,
    PPC_INS_STFDUX = 570,
    PPC_INS_STFDX = 571,
    PPC_INS_STFIWX = 572,
    PPC_INS_STFS = 573,
    PPC_INS_STFSU = 574,
    PPC_INS_STFSUX = 575,
    PPC_INS_STFSX = 576,
    PPC_INS_STH = 577,
    PPC_INS_STHBRX = 578,
    PPC_INS_STHCIX = 579,
    PPC_INS_STHU = 580,
    PPC_INS_STHUX = 581,
    PPC_INS_STHX = 582,
    PPC_INS_STMW = 583,
    PPC_INS_STSWI = 584,
    PPC_INS_STVEBX = 585,
    PPC_INS_STVEHX = 586,
    PPC_INS_STVEWX = 587,
    PPC_INS_STVX = 588,
    PPC_INS_STVXL = 589,
    PPC_INS_STW = 590,
    PPC_INS_STWBRX = 591,
    PPC_INS_STWCIX = 592,
    PPC_INS_STWCX = 593,
    PPC_INS_STWU = 594,
    PPC_INS_STWUX = 595,
    PPC_INS_STWX = 596,
    PPC_INS_STXSDX = 597,
    PPC_INS_STXVD2X = 598,
    PPC_INS_STXVW4X = 599,
    PPC_INS_SUBF = 600,
    PPC_INS_SUBFC = 601,
    PPC_INS_SUBFE = 602,
    PPC_INS_SUBFIC = 603,
    PPC_INS_SUBFME = 604,
    PPC_INS_SUBFZE = 605,
    PPC_INS_SYNC = 606,
    PPC_INS_TD = 607,
    PPC_INS_TDI = 608,
    PPC_INS_TLBIA = 609,
    PPC_INS_TLBIE = 610,
    PPC_INS_TLBIEL = 611,
    PPC_INS_TLBIVAX = 612,
    PPC_INS_TLBLD = 613,
    PPC_INS_TLBLI = 614,
    PPC_INS_TLBRE = 615,
    PPC_INS_TLBSX = 616,
    PPC_INS_TLBSYNC = 617,
    PPC_INS_TLBWE = 618,
    PPC_INS_TRAP = 619,
    PPC_INS_TW = 620,
    PPC_INS_TWI = 621,
    PPC_INS_VADDCUW = 622,
    PPC_INS_VADDFP = 623,
    PPC_INS_VADDSBS = 624,
    PPC_INS_VADDSHS = 625,
    PPC_INS_VADDSWS = 626,
    PPC_INS_VADDUBM = 627,
    PPC_INS_VADDUBS = 628,
    PPC_INS_VADDUDM = 629,
    PPC_INS_VADDUHM = 630,
    PPC_INS_VADDUHS = 631,
    PPC_INS_VADDUWM = 632,
    PPC_INS_VADDUWS = 633,
    PPC_INS_VAND = 634,
    PPC_INS_VANDC = 635,
    PPC_INS_VAVGSB = 636,
    PPC_INS_VAVGSH = 637,
    PPC_INS_VAVGSW = 638,
    PPC_INS_VAVGUB = 639,
    PPC_INS_VAVGUH = 640,
    PPC_INS_VAVGUW = 641,
    PPC_INS_VCFSX = 642,
    PPC_INS_VCFUX = 643,
    PPC_INS_VCLZB = 644,
    PPC_INS_VCLZD = 645,
    PPC_INS_VCLZH = 646,
    PPC_INS_VCLZW = 647,
    PPC_INS_VCMPBFP = 648,
    PPC_INS_VCMPEQFP = 649,
    PPC_INS_VCMPEQUB = 650,
    PPC_INS_VCMPEQUD = 651,
    PPC_INS_VCMPEQUH = 652,
    PPC_INS_VCMPEQUW = 653,
    PPC_INS_VCMPGEFP = 654,
    PPC_INS_VCMPGTFP = 655,
    PPC_INS_VCMPGTSB = 656,
    PPC_INS_VCMPGTSD = 657,
    PPC_INS_VCMPGTSH = 658,
    PPC_INS_VCMPGTSW = 659,
    PPC_INS_VCMPGTUB = 660,
    PPC_INS_VCMPGTUD = 661,
    PPC_INS_VCMPGTUH = 662,
    PPC_INS_VCMPGTUW = 663,
    PPC_INS_VCTSXS = 664,
    PPC_INS_VCTUXS = 665,
    PPC_INS_VEQV = 666,
    PPC_INS_VEXPTEFP = 667,
    PPC_INS_VLOGEFP = 668,
    PPC_INS_VMADDFP = 669,
    PPC_INS_VMAXFP = 670,
    PPC_INS_VMAXSB = 671,
    PPC_INS_VMAXSD = 672,
    PPC_INS_VMAXSH = 673,
    PPC_INS_VMAXSW = 674,
    PPC_INS_VMAXUB = 675,
    PPC_INS_VMAXUD = 676,
    PPC_INS_VMAXUH = 677,
    PPC_INS_VMAXUW = 678,
    PPC_INS_VMHADDSHS = 679,
    PPC_INS_VMHRADDSHS = 680,
    PPC_INS_VMINUD = 681,
    PPC_INS_VMINFP = 682,
    PPC_INS_VMINSB = 683,
    PPC_INS_VMINSD = 684,
    PPC_INS_VMINSH = 685,
    PPC_INS_VMINSW = 686,
    PPC_INS_VMINUB = 687,
    PPC_INS_VMINUH = 688,
    PPC_INS_VMINUW = 689,
    PPC_INS_VMLADDUHM = 690,
    PPC_INS_VMRGHB = 691,
    PPC_INS_VMRGHH = 692,
    PPC_INS_VMRGHW = 693,
    PPC_INS_VMRGLB = 694,
    PPC_INS_VMRGLH = 695,
    PPC_INS_VMRGLW = 696,
    PPC_INS_VMSUMMBM = 697,
    PPC_INS_VMSUMSHM = 698,
    PPC_INS_VMSUMSHS = 699,
    PPC_INS_VMSUMUBM = 700,
    PPC_INS_VMSUMUHM = 701,
    PPC_INS_VMSUMUHS = 702,
    PPC_INS_VMULESB = 703,
    PPC_INS_VMULESH = 704,
    PPC_INS_VMULESW = 705,
    PPC_INS_VMULEUB = 706,
    PPC_INS_VMULEUH = 707,
    PPC_INS_VMULEUW = 708,
    PPC_INS_VMULOSB = 709,
    PPC_INS_VMULOSH = 710,
    PPC_INS_VMULOSW = 711,
    PPC_INS_VMULOUB = 712,
    PPC_INS_VMULOUH = 713,
    PPC_INS_VMULOUW = 714,
    PPC_INS_VMULUWM = 715,
    PPC_INS_VNAND = 716,
    PPC_INS_VNMSUBFP = 717,
    PPC_INS_VNOR = 718,
    PPC_INS_VOR = 719,
    PPC_INS_VORC = 720,
    PPC_INS_VPERM = 721,
    PPC_INS_VPKPX = 722,
    PPC_INS_VPKSHSS = 723,
    PPC_INS_VPKSHUS = 724,
    PPC_INS_VPKSWSS = 725,
    PPC_INS_VPKSWUS = 726,
    PPC_INS_VPKUHUM = 727,
    PPC_INS_VPKUHUS = 728,
    PPC_INS_VPKUWUM = 729,
    PPC_INS_VPKUWUS = 730,
    PPC_INS_VPOPCNTB = 731,
    PPC_INS_VPOPCNTD = 732,
    PPC_INS_VPOPCNTH = 733,
    PPC_INS_VPOPCNTW = 734,
    PPC_INS_VREFP = 735,
    PPC_INS_VRFIM = 736,
    PPC_INS_VRFIN = 737,
    PPC_INS_VRFIP = 738,
    PPC_INS_VRFIZ = 739,
    PPC_INS_VRLB = 740,
    PPC_INS_VRLD = 741,
    PPC_INS_VRLH = 742,
    PPC_INS_VRLW = 743,
    PPC_INS_VRSQRTEFP = 744,
    PPC_INS_VSEL = 745,
    PPC_INS_VSL = 746,
    PPC_INS_VSLB = 747,
    PPC_INS_VSLD = 748,
    PPC_INS_VSLDOI = 749,
    PPC_INS_VSLH = 750,
    PPC_INS_VSLO = 751,
    PPC_INS_VSLW = 752,
    PPC_INS_VSPLTB = 753,
    PPC_INS_VSPLTH = 754,
    PPC_INS_VSPLTISB = 755,
    PPC_INS_VSPLTISH = 756,
    PPC_INS_VSPLTISW = 757,
    PPC_INS_VSPLTW = 758,
    PPC_INS_VSR = 759,
    PPC_INS_VSRAB = 760,
    PPC_INS_VSRAD = 761,
    PPC_INS_VSRAH = 762,
    PPC_INS_VSRAW = 763,
    PPC_INS_VSRB = 764,
    PPC_INS_VSRD = 765,
    PPC_INS_VSRH = 766,
    PPC_INS_VSRO = 767,
    PPC_INS_VSRW = 768,
    PPC_INS_VSUBCUW = 769,
    PPC_INS_VSUBFP = 770,
    PPC_INS_VSUBSBS = 771,
    PPC_INS_VSUBSHS = 772,
    PPC_INS_VSUBSWS = 773,
    PPC_INS_VSUBUBM = 774,
    PPC_INS_VSUBUBS = 775,
    PPC_INS_VSUBUDM = 776,
    PPC_INS_VSUBUHM = 777,
    PPC_INS_VSUBUHS = 778,
    PPC_INS_VSUBUWM = 779,
    PPC_INS_VSUBUWS = 780,
    PPC_INS_VSUM2SWS = 781,
    PPC_INS_VSUM4SBS = 782,
    PPC_INS_VSUM4SHS = 783,
    PPC_INS_VSUM4UBS = 784,
    PPC_INS_VSUMSWS = 785,
    PPC_INS_VUPKHPX = 786,
    PPC_INS_VUPKHSB = 787,
    PPC_INS_VUPKHSH = 788,
    PPC_INS_VUPKLPX = 789,
    PPC_INS_VUPKLSB = 790,
    PPC_INS_VUPKLSH = 791,
    PPC_INS_VXOR = 792,
    PPC_INS_WAIT = 793,
    PPC_INS_WRTEE = 794,
    PPC_INS_WRTEEI = 795,
    PPC_INS_XOR = 796,
    PPC_INS_XORI = 797,
    PPC_INS_XORIS = 798,
    PPC_INS_XSABSDP = 799,
    PPC_INS_XSADDDP = 800,
    PPC_INS_XSCMPODP = 801,
    PPC_INS_XSCMPUDP = 802,
    PPC_INS_XSCPSGNDP = 803,
    PPC_INS_XSCVDPSP = 804,
    PPC_INS_XSCVDPSXDS = 805,
    PPC_INS_XSCVDPSXWS = 806,
    PPC_INS_XSCVDPUXDS = 807,
    PPC_INS_XSCVDPUXWS = 808,
    PPC_INS_XSCVSPDP = 809,
    PPC_INS_XSCVSXDDP = 810,
    PPC_INS_XSCVUXDDP = 811,
    PPC_INS_XSDIVDP = 812,
    PPC_INS_XSMADDADP = 813,
    PPC_INS_XSMADDMDP = 814,
    PPC_INS_XSMAXDP = 815,
    PPC_INS_XSMINDP = 816,
    PPC_INS_XSMSUBADP = 817,
    PPC_INS_XSMSUBMDP = 818,
    PPC_INS_XSMULDP = 819,
    PPC_INS_XSNABSDP = 820,
    PPC_INS_XSNEGDP = 821,
    PPC_INS_XSNMADDADP = 822,
    PPC_INS_XSNMADDMDP = 823,
    PPC_INS_XSNMSUBADP = 824,
    PPC_INS_XSNMSUBMDP = 825,
    PPC_INS_XSRDPI = 826,
    PPC_INS_XSRDPIC = 827,
    PPC_INS_XSRDPIM = 828,
    PPC_INS_XSRDPIP = 829,
    PPC_INS_XSRDPIZ = 830,
    PPC_INS_XSREDP = 831,
    PPC_INS_XSRSQRTEDP = 832,
    PPC_INS_XSSQRTDP = 833,
    PPC_INS_XSSUBDP = 834,
    PPC_INS_XSTDIVDP = 835,
    PPC_INS_XSTSQRTDP = 836,
    PPC_INS_XVABSDP = 837,
    PPC_INS_XVABSSP = 838,
    PPC_INS_XVADDDP = 839,
    PPC_INS_XVADDSP = 840,
    PPC_INS_XVCMPEQDP = 841,
    PPC_INS_XVCMPEQSP = 842,
    PPC_INS_XVCMPGEDP = 843,
    PPC_INS_XVCMPGESP = 844,
    PPC_INS_XVCMPGTDP = 845,
    PPC_INS_XVCMPGTSP = 846,
    PPC_INS_XVCPSGNDP = 847,
    PPC_INS_XVCPSGNSP = 848,
    PPC_INS_XVCVDPSP = 849,
    PPC_INS_XVCVDPSXDS = 850,
    PPC_INS_XVCVDPSXWS = 851,
    PPC_INS_XVCVDPUXDS = 852,
    PPC_INS_XVCVDPUXWS = 853,
    PPC_INS_XVCVSPDP = 854,
    PPC_INS_XVCVSPSXDS = 855,
    PPC_INS_XVCVSPSXWS = 856,
    PPC_INS_XVCVSPUXDS = 857,
    PPC_INS_XVCVSPUXWS = 858,
    PPC_INS_XVCVSXDDP = 859,
    PPC_INS_XVCVSXDSP = 860,
    PPC_INS_XVCVSXWDP = 861,
    PPC_INS_XVCVSXWSP = 862,
    PPC_INS_XVCVUXDDP = 863,
    PPC_INS_XVCVUXDSP = 864,
    PPC_INS_XVCVUXWDP = 865,
    PPC_INS_XVCVUXWSP = 866,
    PPC_INS_XVDIVDP = 867,
    PPC_INS_XVDIVSP = 868,
    PPC_INS_XVMADDADP = 869,
    PPC_INS_XVMADDASP = 870,
    PPC_INS_XVMADDMDP = 871,
    PPC_INS_XVMADDMSP = 872,
    PPC_INS_XVMAXDP = 873,
    PPC_INS_XVMAXSP = 874,
    PPC_INS_XVMINDP = 875,
    PPC_INS_XVMINSP = 876,
    PPC_INS_XVMSUBADP = 877,
    PPC_INS_XVMSUBASP = 878,
    PPC_INS_XVMSUBMDP = 879,
    PPC_INS_XVMSUBMSP = 880,
    PPC_INS_XVMULDP = 881,
    PPC_INS_XVMULSP = 882,
    PPC_INS_XVNABSDP = 883,
    PPC_INS_XVNABSSP = 884,
    PPC_INS_XVNEGDP = 885,
    PPC_INS_XVNEGSP = 886,
    PPC_INS_XVNMADDADP = 887,
    PPC_INS_XVNMADDASP = 888,
    PPC_INS_XVNMADDMDP = 889,
    PPC_INS_XVNMADDMSP = 890,
    PPC_INS_XVNMSUBADP = 891,
    PPC_INS_XVNMSUBASP = 892,
    PPC_INS_XVNMSUBMDP = 893,
    PPC_INS_XVNMSUBMSP = 894,
    PPC_INS_XVRDPI = 895,
    PPC_INS_XVRDPIC = 896,
    PPC_INS_XVRDPIM = 897,
    PPC_INS_XVRDPIP = 898,
    PPC_INS_XVRDPIZ = 899,
    PPC_INS_XVREDP = 900,
    PPC_INS_XVRESP = 901,
    PPC_INS_XVRSPI = 902,
    PPC_INS_XVRSPIC = 903,
    PPC_INS_XVRSPIM = 904,
    PPC_INS_XVRSPIP = 905,
    PPC_INS_XVRSPIZ = 906,
    PPC_INS_XVRSQRTEDP = 907,
    PPC_INS_XVRSQRTESP = 908,
    PPC_INS_XVSQRTDP = 909,
    PPC_INS_XVSQRTSP = 910,
    PPC_INS_XVSUBDP = 911,
    PPC_INS_XVSUBSP = 912,
    PPC_INS_XVTDIVDP = 913,
    PPC_INS_XVTDIVSP = 914,
    PPC_INS_XVTSQRTDP = 915,
    PPC_INS_XVTSQRTSP = 916,
    PPC_INS_XXLAND = 917,
    PPC_INS_XXLANDC = 918,
    PPC_INS_XXLEQV = 919,
    PPC_INS_XXLNAND = 920,
    PPC_INS_XXLNOR = 921,
    PPC_INS_XXLOR = 922,
    PPC_INS_XXLORC = 923,
    PPC_INS_XXLXOR = 924,
    PPC_INS_XXMRGHW = 925,
    PPC_INS_XXMRGLW = 926,
    PPC_INS_XXPERMDI = 927,
    PPC_INS_XXSEL = 928,
    PPC_INS_XXSLDWI = 929,
    PPC_INS_XXSPLTW = 930,
    PPC_INS_BCA = 931,
    PPC_INS_BCLA = 932,
    PPC_INS_SLWI = 933,
    PPC_INS_SRWI = 934,
    PPC_INS_SLDI = 935,
    PPC_INS_BTA = 936,
    PPC_INS_CRSET = 937,
    PPC_INS_CRNOT = 938,
    PPC_INS_CRMOVE = 939,
    PPC_INS_CRCLR = 940,
    PPC_INS_MFBR0 = 941,
    PPC_INS_MFBR1 = 942,
    PPC_INS_MFBR2 = 943,
    PPC_INS_MFBR3 = 944,
    PPC_INS_MFBR4 = 945,
    PPC_INS_MFBR5 = 946,
    PPC_INS_MFBR6 = 947,
    PPC_INS_MFBR7 = 948,
    PPC_INS_MFXER = 949,
    PPC_INS_MFRTCU = 950,
    PPC_INS_MFRTCL = 951,
    PPC_INS_MFDSCR = 952,
    PPC_INS_MFDSISR = 953,
    PPC_INS_MFDAR = 954,
    PPC_INS_MFSRR2 = 955,
    PPC_INS_MFSRR3 = 956,
    PPC_INS_MFCFAR = 957,
    PPC_INS_MFAMR = 958,
    PPC_INS_MFPID = 959,
    PPC_INS_MFTBLO = 960,
    PPC_INS_MFTBHI = 961,
    PPC_INS_MFDBATU = 962,
    PPC_INS_MFDBATL = 963,
    PPC_INS_MFIBATU = 964,
    PPC_INS_MFIBATL = 965,
    PPC_INS_MFDCCR = 966,
    PPC_INS_MFICCR = 967,
    PPC_INS_MFDEAR = 968,
    PPC_INS_MFESR = 969,
    PPC_INS_MFSPEFSCR = 970,
    PPC_INS_MFTCR = 971,
    PPC_INS_MFASR = 972,
    PPC_INS_MFPVR = 973,
    PPC_INS_MFTBU = 974,
    PPC_INS_MTCR = 975,
    PPC_INS_MTBR0 = 976,
    PPC_INS_MTBR1 = 977,
    PPC_INS_MTBR2 = 978,
    PPC_INS_MTBR3 = 979,
    PPC_INS_MTBR4 = 980,
    PPC_INS_MTBR5 = 981,
    PPC_INS_MTBR6 = 982,
    PPC_INS_MTBR7 = 983,
    PPC_INS_MTXER = 984,
    PPC_INS_MTDSCR = 985,
    PPC_INS_MTDSISR = 986,
    PPC_INS_MTDAR = 987,
    PPC_INS_MTSRR2 = 988,
    PPC_INS_MTSRR3 = 989,
    PPC_INS_MTCFAR = 990,
    PPC_INS_MTAMR = 991,
    PPC_INS_MTPID = 992,
    PPC_INS_MTTBL = 993,
    PPC_INS_MTTBU = 994,
    PPC_INS_MTTBLO = 995,
    PPC_INS_MTTBHI = 996,
    PPC_INS_MTDBATU = 997,
    PPC_INS_MTDBATL = 998,
    PPC_INS_MTIBATU = 999,
    PPC_INS_MTIBATL = 1000,
    PPC_INS_MTDCCR = 1001,
    PPC_INS_MTICCR = 1002,
    PPC_INS_MTDEAR = 1003,
    PPC_INS_MTESR = 1004,
    PPC_INS_MTSPEFSCR = 1005,
    PPC_INS_MTTCR = 1006,
    PPC_INS_NOT = 1007,
    PPC_INS_MR = 1008,
    PPC_INS_ROTLD = 1009,
    PPC_INS_ROTLDI = 1010,
    PPC_INS_CLRLDI = 1011,
    PPC_INS_ROTLWI = 1012,
    PPC_INS_CLRLWI = 1013,
    PPC_INS_ROTLW = 1014,
    PPC_INS_SUB = 1015,
    PPC_INS_SUBC = 1016,
    PPC_INS_LWSYNC = 1017,
    PPC_INS_PTESYNC = 1018,
    PPC_INS_TDLT = 1019,
    PPC_INS_TDEQ = 1020,
    PPC_INS_TDGT = 1021,
    PPC_INS_TDNE = 1022,
    PPC_INS_TDLLT = 1023,
    PPC_INS_TDLGT = 1024,
    PPC_INS_TDU = 1025,
    PPC_INS_TDLTI = 1026,
    PPC_INS_TDEQI = 1027,
    PPC_INS_TDGTI = 1028,
    PPC_INS_TDNEI = 1029,
    PPC_INS_TDLLTI = 1030,
    PPC_INS_TDLGTI = 1031,
    PPC_INS_TDUI = 1032,
    PPC_INS_TLBREHI = 1033,
    PPC_INS_TLBRELO = 1034,
    PPC_INS_TLBWEHI = 1035,
    PPC_INS_TLBWELO = 1036,
    PPC_INS_TWLT = 1037,
    PPC_INS_TWEQ = 1038,
    PPC_INS_TWGT = 1039,
    PPC_INS_TWNE = 1040,
    PPC_INS_TWLLT = 1041,
    PPC_INS_TWLGT = 1042,
    PPC_INS_TWU = 1043,
    PPC_INS_TWLTI = 1044,
    PPC_INS_TWEQI = 1045,
    PPC_INS_TWGTI = 1046,
    PPC_INS_TWNEI = 1047,
    PPC_INS_TWLLTI = 1048,
    PPC_INS_TWLGTI = 1049,
    PPC_INS_TWUI = 1050,
    PPC_INS_WAITRSV = 1051,
    PPC_INS_WAITIMPL = 1052,
    PPC_INS_XNOP = 1053,
    PPC_INS_XVMOVDP = 1054,
    PPC_INS_XVMOVSP = 1055,
    PPC_INS_XXSPLTD = 1056,
    PPC_INS_XXMRGHD = 1057,
    PPC_INS_XXMRGLD = 1058,
    PPC_INS_XXSWAPD = 1059,
    PPC_INS_BT = 1060,
    PPC_INS_BF = 1061,
    PPC_INS_BDNZT = 1062,
    PPC_INS_BDNZF = 1063,
    PPC_INS_BDZF = 1064,
    PPC_INS_BDZT = 1065,
    PPC_INS_BFA = 1066,
    PPC_INS_BDNZTA = 1067,
    PPC_INS_BDNZFA = 1068,
    PPC_INS_BDZTA = 1069,
    PPC_INS_BDZFA = 1070,
    PPC_INS_BTCTR = 1071,
    PPC_INS_BFCTR = 1072,
    PPC_INS_BTCTRL = 1073,
    PPC_INS_BFCTRL = 1074,
    PPC_INS_BTL = 1075,
    PPC_INS_BFL = 1076,
    PPC_INS_BDNZTL = 1077,
    PPC_INS_BDNZFL = 1078,
    PPC_INS_BDZTL = 1079,
    PPC_INS_BDZFL = 1080,
    PPC_INS_BTLA = 1081,
    PPC_INS_BFLA = 1082,
    PPC_INS_BDNZTLA = 1083,
    PPC_INS_BDNZFLA = 1084,
    PPC_INS_BDZTLA = 1085,
    PPC_INS_BDZFLA = 1086,
    PPC_INS_BTLR = 1087,
    PPC_INS_BFLR = 1088,
    PPC_INS_BDNZTLR = 1089,
    PPC_INS_BDZTLR = 1090,
    PPC_INS_BDZFLR = 1091,
    PPC_INS_BTLRL = 1092,
    PPC_INS_BFLRL = 1093,
    PPC_INS_BDNZTLRL = 1094,
    PPC_INS_BDNZFLRL = 1095,
    PPC_INS_BDZTLRL = 1096,
    PPC_INS_BDZFLRL = 1097,
    PPC_INS_QVFAND = 1098,
    PPC_INS_QVFCLR = 1099,
    PPC_INS_QVFANDC = 1100,
    PPC_INS_QVFCTFB = 1101,
    PPC_INS_QVFXOR = 1102,
    PPC_INS_QVFOR = 1103,
    PPC_INS_QVFNOR = 1104,
    PPC_INS_QVFEQU = 1105,
    PPC_INS_QVFNOT = 1106,
    PPC_INS_QVFORC = 1107,
    PPC_INS_QVFNAND = 1108,
    PPC_INS_QVFSET = 1109,
    PPC_INS_ENDING = 1110,
}
pub mod ppc_insn_group {
    #[doc = " Group of PPC instructions"]
    pub type Type = u32;
    #[doc = "< = CS_GRP_INVALID"]
    pub const PPC_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const PPC_GRP_JUMP: Type = 1;
    pub const PPC_GRP_ALTIVEC: Type = 128;
    pub const PPC_GRP_MODE32: Type = 129;
    pub const PPC_GRP_MODE64: Type = 130;
    pub const PPC_GRP_BOOKE: Type = 131;
    pub const PPC_GRP_NOTBOOKE: Type = 132;
    pub const PPC_GRP_SPE: Type = 133;
    pub const PPC_GRP_VSX: Type = 134;
    pub const PPC_GRP_E500: Type = 135;
    pub const PPC_GRP_PPC4XX: Type = 136;
    pub const PPC_GRP_PPC6XX: Type = 137;
    pub const PPC_GRP_ICBT: Type = 138;
    pub const PPC_GRP_P8ALTIVEC: Type = 139;
    pub const PPC_GRP_P8VECTOR: Type = 140;
    pub const PPC_GRP_QPX: Type = 141;
    pub const PPC_GRP_ENDING: Type = 142;
}
#[repr(u32)]
#[doc = " Enums corresponding to Sparc condition codes, both icc's and fcc's."]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum sparc_cc {
    #[doc = "< invalid CC (default)"]
    SPARC_CC_INVALID = 0,
    #[doc = "< Always"]
    SPARC_CC_ICC_A = 264,
    #[doc = "< Never"]
    SPARC_CC_ICC_N = 256,
    #[doc = "< Not Equal"]
    SPARC_CC_ICC_NE = 265,
    #[doc = "< Equal"]
    SPARC_CC_ICC_E = 257,
    #[doc = "< Greater"]
    SPARC_CC_ICC_G = 266,
    #[doc = "< Less or Equal"]
    SPARC_CC_ICC_LE = 258,
    #[doc = "< Greater or Equal"]
    SPARC_CC_ICC_GE = 267,
    #[doc = "< Less"]
    SPARC_CC_ICC_L = 259,
    #[doc = "< Greater Unsigned"]
    SPARC_CC_ICC_GU = 268,
    #[doc = "< Less or Equal Unsigned"]
    SPARC_CC_ICC_LEU = 260,
    #[doc = "< Carry Clear/Great or Equal Unsigned"]
    SPARC_CC_ICC_CC = 269,
    #[doc = "< Carry Set/Less Unsigned"]
    SPARC_CC_ICC_CS = 261,
    #[doc = "< Positive"]
    SPARC_CC_ICC_POS = 270,
    #[doc = "< Negative"]
    SPARC_CC_ICC_NEG = 262,
    #[doc = "< Overflow Clear"]
    SPARC_CC_ICC_VC = 271,
    #[doc = "< Overflow Set"]
    SPARC_CC_ICC_VS = 263,
    #[doc = "< Always"]
    SPARC_CC_FCC_A = 280,
    #[doc = "< Never"]
    SPARC_CC_FCC_N = 272,
    #[doc = "< Unordered"]
    SPARC_CC_FCC_U = 279,
    #[doc = "< Greater"]
    SPARC_CC_FCC_G = 278,
    #[doc = "< Unordered or Greater"]
    SPARC_CC_FCC_UG = 277,
    #[doc = "< Less"]
    SPARC_CC_FCC_L = 276,
    #[doc = "< Unordered or Less"]
    SPARC_CC_FCC_UL = 275,
    #[doc = "< Less or Greater"]
    SPARC_CC_FCC_LG = 274,
    #[doc = "< Not Equal"]
    SPARC_CC_FCC_NE = 273,
    #[doc = "< Equal"]
    SPARC_CC_FCC_E = 281,
    #[doc = "< Unordered or Equal"]
    SPARC_CC_FCC_UE = 282,
    #[doc = "< Greater or Equal"]
    SPARC_CC_FCC_GE = 283,
    #[doc = "< Unordered or Greater or Equal"]
    SPARC_CC_FCC_UGE = 284,
    #[doc = "< Less or Equal"]
    SPARC_CC_FCC_LE = 285,
    #[doc = "< Unordered or Less or Equal"]
    SPARC_CC_FCC_ULE = 286,
    #[doc = "< Ordered"]
    SPARC_CC_FCC_O = 287,
}
#[repr(u32)]
#[doc = " Branch hint"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum sparc_hint {
    #[doc = "< no hint"]
    SPARC_HINT_INVALID = 0,
    #[doc = "< annul delay slot instruction"]
    SPARC_HINT_A = 1,
    #[doc = "< branch taken"]
    SPARC_HINT_PT = 2,
    #[doc = "< branch NOT taken"]
    SPARC_HINT_PN = 4,
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum sparc_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    SPARC_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    SPARC_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    SPARC_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    SPARC_OP_MEM = 3,
}
pub mod sparc_reg {
    #[doc = " SPARC registers"]
    pub type Type = u32;
    pub const SPARC_REG_INVALID: Type = 0;
    pub const SPARC_REG_F0: Type = 1;
    pub const SPARC_REG_F1: Type = 2;
    pub const SPARC_REG_F2: Type = 3;
    pub const SPARC_REG_F3: Type = 4;
    pub const SPARC_REG_F4: Type = 5;
    pub const SPARC_REG_F5: Type = 6;
    pub const SPARC_REG_F6: Type = 7;
    pub const SPARC_REG_F7: Type = 8;
    pub const SPARC_REG_F8: Type = 9;
    pub const SPARC_REG_F9: Type = 10;
    pub const SPARC_REG_F10: Type = 11;
    pub const SPARC_REG_F11: Type = 12;
    pub const SPARC_REG_F12: Type = 13;
    pub const SPARC_REG_F13: Type = 14;
    pub const SPARC_REG_F14: Type = 15;
    pub const SPARC_REG_F15: Type = 16;
    pub const SPARC_REG_F16: Type = 17;
    pub const SPARC_REG_F17: Type = 18;
    pub const SPARC_REG_F18: Type = 19;
    pub const SPARC_REG_F19: Type = 20;
    pub const SPARC_REG_F20: Type = 21;
    pub const SPARC_REG_F21: Type = 22;
    pub const SPARC_REG_F22: Type = 23;
    pub const SPARC_REG_F23: Type = 24;
    pub const SPARC_REG_F24: Type = 25;
    pub const SPARC_REG_F25: Type = 26;
    pub const SPARC_REG_F26: Type = 27;
    pub const SPARC_REG_F27: Type = 28;
    pub const SPARC_REG_F28: Type = 29;
    pub const SPARC_REG_F29: Type = 30;
    pub const SPARC_REG_F30: Type = 31;
    pub const SPARC_REG_F31: Type = 32;
    pub const SPARC_REG_F32: Type = 33;
    pub const SPARC_REG_F34: Type = 34;
    pub const SPARC_REG_F36: Type = 35;
    pub const SPARC_REG_F38: Type = 36;
    pub const SPARC_REG_F40: Type = 37;
    pub const SPARC_REG_F42: Type = 38;
    pub const SPARC_REG_F44: Type = 39;
    pub const SPARC_REG_F46: Type = 40;
    pub const SPARC_REG_F48: Type = 41;
    pub const SPARC_REG_F50: Type = 42;
    pub const SPARC_REG_F52: Type = 43;
    pub const SPARC_REG_F54: Type = 44;
    pub const SPARC_REG_F56: Type = 45;
    pub const SPARC_REG_F58: Type = 46;
    pub const SPARC_REG_F60: Type = 47;
    pub const SPARC_REG_F62: Type = 48;
    pub const SPARC_REG_FCC0: Type = 49;
    pub const SPARC_REG_FCC1: Type = 50;
    pub const SPARC_REG_FCC2: Type = 51;
    pub const SPARC_REG_FCC3: Type = 52;
    pub const SPARC_REG_FP: Type = 53;
    pub const SPARC_REG_G0: Type = 54;
    pub const SPARC_REG_G1: Type = 55;
    pub const SPARC_REG_G2: Type = 56;
    pub const SPARC_REG_G3: Type = 57;
    pub const SPARC_REG_G4: Type = 58;
    pub const SPARC_REG_G5: Type = 59;
    pub const SPARC_REG_G6: Type = 60;
    pub const SPARC_REG_G7: Type = 61;
    pub const SPARC_REG_I0: Type = 62;
    pub const SPARC_REG_I1: Type = 63;
    pub const SPARC_REG_I2: Type = 64;
    pub const SPARC_REG_I3: Type = 65;
    pub const SPARC_REG_I4: Type = 66;
    pub const SPARC_REG_I5: Type = 67;
    pub const SPARC_REG_I7: Type = 68;
    pub const SPARC_REG_ICC: Type = 69;
    pub const SPARC_REG_L0: Type = 70;
    pub const SPARC_REG_L1: Type = 71;
    pub const SPARC_REG_L2: Type = 72;
    pub const SPARC_REG_L3: Type = 73;
    pub const SPARC_REG_L4: Type = 74;
    pub const SPARC_REG_L5: Type = 75;
    pub const SPARC_REG_L6: Type = 76;
    pub const SPARC_REG_L7: Type = 77;
    pub const SPARC_REG_O0: Type = 78;
    pub const SPARC_REG_O1: Type = 79;
    pub const SPARC_REG_O2: Type = 80;
    pub const SPARC_REG_O3: Type = 81;
    pub const SPARC_REG_O4: Type = 82;
    pub const SPARC_REG_O5: Type = 83;
    pub const SPARC_REG_O7: Type = 84;
    pub const SPARC_REG_SP: Type = 85;
    pub const SPARC_REG_Y: Type = 86;
    pub const SPARC_REG_XCC: Type = 87;
    pub const SPARC_REG_ENDING: Type = 88;
    pub const SPARC_REG_O6: Type = 85;
    pub const SPARC_REG_I6: Type = 53;
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with SPARC_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct sparc_op_mem {
    #[doc = "< base register, can be safely interpreted as"]
    #[doc = "< a value of type `sparc_reg`, but it is only"]
    #[doc = "< one byte wide"]
    pub base: u8,
    #[doc = "< index register, same conditions apply here"]
    pub index: u8,
    #[doc = "< displacement/offset value"]
    pub disp: i32,
}
impl Clone for sparc_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_sparc_op {
    #[doc = "< operand type"]
    pub type_: sparc_op_type,
    pub __bindgen_anon_1: cs_sparc_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_sparc_op__bindgen_ty_1 {
    #[doc = "< register value for REG operand"]
    pub reg: sparc_reg::Type,
    #[doc = "< immediate value for IMM operand"]
    pub imm: i64,
    #[doc = "< base/disp value for MEM operand"]
    pub mem: sparc_op_mem,
    _bindgen_union_align: u64,
}
impl Clone for cs_sparc_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_sparc_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_sparc_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_sparc_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_sparc_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_sparc_op {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_sparc {
    #[doc = "< code condition for this insn"]
    pub cc: sparc_cc,
    #[doc = "< branch hint: encoding as bitwise OR of sparc_hint."]
    pub hint: sparc_hint,
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_sparc_op; 4usize],
}
impl Clone for cs_sparc {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_sparc {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_sparc {{ cc: {:?}, hint: {:?}, op_count: {:?}, operands: {:?} }}",
            self.cc, self.hint, self.op_count, self.operands
        )
    }
}
#[repr(u32)]
#[doc = " SPARC instruction"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum sparc_insn {
    SPARC_INS_INVALID = 0,
    SPARC_INS_ADDCC = 1,
    SPARC_INS_ADDX = 2,
    SPARC_INS_ADDXCC = 3,
    SPARC_INS_ADDXC = 4,
    SPARC_INS_ADDXCCC = 5,
    SPARC_INS_ADD = 6,
    SPARC_INS_ALIGNADDR = 7,
    SPARC_INS_ALIGNADDRL = 8,
    SPARC_INS_ANDCC = 9,
    SPARC_INS_ANDNCC = 10,
    SPARC_INS_ANDN = 11,
    SPARC_INS_AND = 12,
    SPARC_INS_ARRAY16 = 13,
    SPARC_INS_ARRAY32 = 14,
    SPARC_INS_ARRAY8 = 15,
    SPARC_INS_B = 16,
    SPARC_INS_JMP = 17,
    SPARC_INS_BMASK = 18,
    SPARC_INS_FB = 19,
    SPARC_INS_BRGEZ = 20,
    SPARC_INS_BRGZ = 21,
    SPARC_INS_BRLEZ = 22,
    SPARC_INS_BRLZ = 23,
    SPARC_INS_BRNZ = 24,
    SPARC_INS_BRZ = 25,
    SPARC_INS_BSHUFFLE = 26,
    SPARC_INS_CALL = 27,
    SPARC_INS_CASX = 28,
    SPARC_INS_CAS = 29,
    SPARC_INS_CMASK16 = 30,
    SPARC_INS_CMASK32 = 31,
    SPARC_INS_CMASK8 = 32,
    SPARC_INS_CMP = 33,
    SPARC_INS_EDGE16 = 34,
    SPARC_INS_EDGE16L = 35,
    SPARC_INS_EDGE16LN = 36,
    SPARC_INS_EDGE16N = 37,
    SPARC_INS_EDGE32 = 38,
    SPARC_INS_EDGE32L = 39,
    SPARC_INS_EDGE32LN = 40,
    SPARC_INS_EDGE32N = 41,
    SPARC_INS_EDGE8 = 42,
    SPARC_INS_EDGE8L = 43,
    SPARC_INS_EDGE8LN = 44,
    SPARC_INS_EDGE8N = 45,
    SPARC_INS_FABSD = 46,
    SPARC_INS_FABSQ = 47,
    SPARC_INS_FABSS = 48,
    SPARC_INS_FADDD = 49,
    SPARC_INS_FADDQ = 50,
    SPARC_INS_FADDS = 51,
    SPARC_INS_FALIGNDATA = 52,
    SPARC_INS_FAND = 53,
    SPARC_INS_FANDNOT1 = 54,
    SPARC_INS_FANDNOT1S = 55,
    SPARC_INS_FANDNOT2 = 56,
    SPARC_INS_FANDNOT2S = 57,
    SPARC_INS_FANDS = 58,
    SPARC_INS_FCHKSM16 = 59,
    SPARC_INS_FCMPD = 60,
    SPARC_INS_FCMPEQ16 = 61,
    SPARC_INS_FCMPEQ32 = 62,
    SPARC_INS_FCMPGT16 = 63,
    SPARC_INS_FCMPGT32 = 64,
    SPARC_INS_FCMPLE16 = 65,
    SPARC_INS_FCMPLE32 = 66,
    SPARC_INS_FCMPNE16 = 67,
    SPARC_INS_FCMPNE32 = 68,
    SPARC_INS_FCMPQ = 69,
    SPARC_INS_FCMPS = 70,
    SPARC_INS_FDIVD = 71,
    SPARC_INS_FDIVQ = 72,
    SPARC_INS_FDIVS = 73,
    SPARC_INS_FDMULQ = 74,
    SPARC_INS_FDTOI = 75,
    SPARC_INS_FDTOQ = 76,
    SPARC_INS_FDTOS = 77,
    SPARC_INS_FDTOX = 78,
    SPARC_INS_FEXPAND = 79,
    SPARC_INS_FHADDD = 80,
    SPARC_INS_FHADDS = 81,
    SPARC_INS_FHSUBD = 82,
    SPARC_INS_FHSUBS = 83,
    SPARC_INS_FITOD = 84,
    SPARC_INS_FITOQ = 85,
    SPARC_INS_FITOS = 86,
    SPARC_INS_FLCMPD = 87,
    SPARC_INS_FLCMPS = 88,
    SPARC_INS_FLUSHW = 89,
    SPARC_INS_FMEAN16 = 90,
    SPARC_INS_FMOVD = 91,
    SPARC_INS_FMOVQ = 92,
    SPARC_INS_FMOVRDGEZ = 93,
    SPARC_INS_FMOVRQGEZ = 94,
    SPARC_INS_FMOVRSGEZ = 95,
    SPARC_INS_FMOVRDGZ = 96,
    SPARC_INS_FMOVRQGZ = 97,
    SPARC_INS_FMOVRSGZ = 98,
    SPARC_INS_FMOVRDLEZ = 99,
    SPARC_INS_FMOVRQLEZ = 100,
    SPARC_INS_FMOVRSLEZ = 101,
    SPARC_INS_FMOVRDLZ = 102,
    SPARC_INS_FMOVRQLZ = 103,
    SPARC_INS_FMOVRSLZ = 104,
    SPARC_INS_FMOVRDNZ = 105,
    SPARC_INS_FMOVRQNZ = 106,
    SPARC_INS_FMOVRSNZ = 107,
    SPARC_INS_FMOVRDZ = 108,
    SPARC_INS_FMOVRQZ = 109,
    SPARC_INS_FMOVRSZ = 110,
    SPARC_INS_FMOVS = 111,
    SPARC_INS_FMUL8SUX16 = 112,
    SPARC_INS_FMUL8ULX16 = 113,
    SPARC_INS_FMUL8X16 = 114,
    SPARC_INS_FMUL8X16AL = 115,
    SPARC_INS_FMUL8X16AU = 116,
    SPARC_INS_FMULD = 117,
    SPARC_INS_FMULD8SUX16 = 118,
    SPARC_INS_FMULD8ULX16 = 119,
    SPARC_INS_FMULQ = 120,
    SPARC_INS_FMULS = 121,
    SPARC_INS_FNADDD = 122,
    SPARC_INS_FNADDS = 123,
    SPARC_INS_FNAND = 124,
    SPARC_INS_FNANDS = 125,
    SPARC_INS_FNEGD = 126,
    SPARC_INS_FNEGQ = 127,
    SPARC_INS_FNEGS = 128,
    SPARC_INS_FNHADDD = 129,
    SPARC_INS_FNHADDS = 130,
    SPARC_INS_FNOR = 131,
    SPARC_INS_FNORS = 132,
    SPARC_INS_FNOT1 = 133,
    SPARC_INS_FNOT1S = 134,
    SPARC_INS_FNOT2 = 135,
    SPARC_INS_FNOT2S = 136,
    SPARC_INS_FONE = 137,
    SPARC_INS_FONES = 138,
    SPARC_INS_FOR = 139,
    SPARC_INS_FORNOT1 = 140,
    SPARC_INS_FORNOT1S = 141,
    SPARC_INS_FORNOT2 = 142,
    SPARC_INS_FORNOT2S = 143,
    SPARC_INS_FORS = 144,
    SPARC_INS_FPACK16 = 145,
    SPARC_INS_FPACK32 = 146,
    SPARC_INS_FPACKFIX = 147,
    SPARC_INS_FPADD16 = 148,
    SPARC_INS_FPADD16S = 149,
    SPARC_INS_FPADD32 = 150,
    SPARC_INS_FPADD32S = 151,
    SPARC_INS_FPADD64 = 152,
    SPARC_INS_FPMERGE = 153,
    SPARC_INS_FPSUB16 = 154,
    SPARC_INS_FPSUB16S = 155,
    SPARC_INS_FPSUB32 = 156,
    SPARC_INS_FPSUB32S = 157,
    SPARC_INS_FQTOD = 158,
    SPARC_INS_FQTOI = 159,
    SPARC_INS_FQTOS = 160,
    SPARC_INS_FQTOX = 161,
    SPARC_INS_FSLAS16 = 162,
    SPARC_INS_FSLAS32 = 163,
    SPARC_INS_FSLL16 = 164,
    SPARC_INS_FSLL32 = 165,
    SPARC_INS_FSMULD = 166,
    SPARC_INS_FSQRTD = 167,
    SPARC_INS_FSQRTQ = 168,
    SPARC_INS_FSQRTS = 169,
    SPARC_INS_FSRA16 = 170,
    SPARC_INS_FSRA32 = 171,
    SPARC_INS_FSRC1 = 172,
    SPARC_INS_FSRC1S = 173,
    SPARC_INS_FSRC2 = 174,
    SPARC_INS_FSRC2S = 175,
    SPARC_INS_FSRL16 = 176,
    SPARC_INS_FSRL32 = 177,
    SPARC_INS_FSTOD = 178,
    SPARC_INS_FSTOI = 179,
    SPARC_INS_FSTOQ = 180,
    SPARC_INS_FSTOX = 181,
    SPARC_INS_FSUBD = 182,
    SPARC_INS_FSUBQ = 183,
    SPARC_INS_FSUBS = 184,
    SPARC_INS_FXNOR = 185,
    SPARC_INS_FXNORS = 186,
    SPARC_INS_FXOR = 187,
    SPARC_INS_FXORS = 188,
    SPARC_INS_FXTOD = 189,
    SPARC_INS_FXTOQ = 190,
    SPARC_INS_FXTOS = 191,
    SPARC_INS_FZERO = 192,
    SPARC_INS_FZEROS = 193,
    SPARC_INS_JMPL = 194,
    SPARC_INS_LDD = 195,
    SPARC_INS_LD = 196,
    SPARC_INS_LDQ = 197,
    SPARC_INS_LDSB = 198,
    SPARC_INS_LDSH = 199,
    SPARC_INS_LDSW = 200,
    SPARC_INS_LDUB = 201,
    SPARC_INS_LDUH = 202,
    SPARC_INS_LDX = 203,
    SPARC_INS_LZCNT = 204,
    SPARC_INS_MEMBAR = 205,
    SPARC_INS_MOVDTOX = 206,
    SPARC_INS_MOV = 207,
    SPARC_INS_MOVRGEZ = 208,
    SPARC_INS_MOVRGZ = 209,
    SPARC_INS_MOVRLEZ = 210,
    SPARC_INS_MOVRLZ = 211,
    SPARC_INS_MOVRNZ = 212,
    SPARC_INS_MOVRZ = 213,
    SPARC_INS_MOVSTOSW = 214,
    SPARC_INS_MOVSTOUW = 215,
    SPARC_INS_MULX = 216,
    SPARC_INS_NOP = 217,
    SPARC_INS_ORCC = 218,
    SPARC_INS_ORNCC = 219,
    SPARC_INS_ORN = 220,
    SPARC_INS_OR = 221,
    SPARC_INS_PDIST = 222,
    SPARC_INS_PDISTN = 223,
    SPARC_INS_POPC = 224,
    SPARC_INS_RD = 225,
    SPARC_INS_RESTORE = 226,
    SPARC_INS_RETT = 227,
    SPARC_INS_SAVE = 228,
    SPARC_INS_SDIVCC = 229,
    SPARC_INS_SDIVX = 230,
    SPARC_INS_SDIV = 231,
    SPARC_INS_SETHI = 232,
    SPARC_INS_SHUTDOWN = 233,
    SPARC_INS_SIAM = 234,
    SPARC_INS_SLLX = 235,
    SPARC_INS_SLL = 236,
    SPARC_INS_SMULCC = 237,
    SPARC_INS_SMUL = 238,
    SPARC_INS_SRAX = 239,
    SPARC_INS_SRA = 240,
    SPARC_INS_SRLX = 241,
    SPARC_INS_SRL = 242,
    SPARC_INS_STBAR = 243,
    SPARC_INS_STB = 244,
    SPARC_INS_STD = 245,
    SPARC_INS_ST = 246,
    SPARC_INS_STH = 247,
    SPARC_INS_STQ = 248,
    SPARC_INS_STX = 249,
    SPARC_INS_SUBCC = 250,
    SPARC_INS_SUBX = 251,
    SPARC_INS_SUBXCC = 252,
    SPARC_INS_SUB = 253,
    SPARC_INS_SWAP = 254,
    SPARC_INS_TADDCCTV = 255,
    SPARC_INS_TADDCC = 256,
    SPARC_INS_T = 257,
    SPARC_INS_TSUBCCTV = 258,
    SPARC_INS_TSUBCC = 259,
    SPARC_INS_UDIVCC = 260,
    SPARC_INS_UDIVX = 261,
    SPARC_INS_UDIV = 262,
    SPARC_INS_UMULCC = 263,
    SPARC_INS_UMULXHI = 264,
    SPARC_INS_UMUL = 265,
    SPARC_INS_UNIMP = 266,
    SPARC_INS_FCMPED = 267,
    SPARC_INS_FCMPEQ = 268,
    SPARC_INS_FCMPES = 269,
    SPARC_INS_WR = 270,
    SPARC_INS_XMULX = 271,
    SPARC_INS_XMULXHI = 272,
    SPARC_INS_XNORCC = 273,
    SPARC_INS_XNOR = 274,
    SPARC_INS_XORCC = 275,
    SPARC_INS_XOR = 276,
    SPARC_INS_RET = 277,
    SPARC_INS_RETL = 278,
    SPARC_INS_ENDING = 279,
}
pub mod sparc_insn_group {
    #[doc = " Group of SPARC instructions"]
    pub type Type = u32;
    #[doc = "< = CS_GRP_INVALID"]
    pub const SPARC_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const SPARC_GRP_JUMP: Type = 1;
    pub const SPARC_GRP_HARDQUAD: Type = 128;
    pub const SPARC_GRP_V9: Type = 129;
    pub const SPARC_GRP_VIS: Type = 130;
    pub const SPARC_GRP_VIS2: Type = 131;
    pub const SPARC_GRP_VIS3: Type = 132;
    pub const SPARC_GRP_32BIT: Type = 133;
    pub const SPARC_GRP_64BIT: Type = 134;
    pub const SPARC_GRP_ENDING: Type = 135;
}
#[repr(u32)]
#[doc = " Enums corresponding to SystemZ condition codes"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum sysz_cc {
    #[doc = "< invalid CC (default)"]
    SYSZ_CC_INVALID = 0,
    SYSZ_CC_O = 1,
    SYSZ_CC_H = 2,
    SYSZ_CC_NLE = 3,
    SYSZ_CC_L = 4,
    SYSZ_CC_NHE = 5,
    SYSZ_CC_LH = 6,
    SYSZ_CC_NE = 7,
    SYSZ_CC_E = 8,
    SYSZ_CC_NLH = 9,
    SYSZ_CC_HE = 10,
    SYSZ_CC_NL = 11,
    SYSZ_CC_LE = 12,
    SYSZ_CC_NH = 13,
    SYSZ_CC_NO = 14,
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum sysz_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    SYSZ_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    SYSZ_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    SYSZ_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    SYSZ_OP_MEM = 3,
    #[doc = "< Access register operand."]
    SYSZ_OP_ACREG = 64,
}
pub mod sysz_reg {
    #[doc = " SystemZ registers"]
    pub type Type = u32;
    pub const SYSZ_REG_INVALID: Type = 0;
    pub const SYSZ_REG_0: Type = 1;
    pub const SYSZ_REG_1: Type = 2;
    pub const SYSZ_REG_2: Type = 3;
    pub const SYSZ_REG_3: Type = 4;
    pub const SYSZ_REG_4: Type = 5;
    pub const SYSZ_REG_5: Type = 6;
    pub const SYSZ_REG_6: Type = 7;
    pub const SYSZ_REG_7: Type = 8;
    pub const SYSZ_REG_8: Type = 9;
    pub const SYSZ_REG_9: Type = 10;
    pub const SYSZ_REG_10: Type = 11;
    pub const SYSZ_REG_11: Type = 12;
    pub const SYSZ_REG_12: Type = 13;
    pub const SYSZ_REG_13: Type = 14;
    pub const SYSZ_REG_14: Type = 15;
    pub const SYSZ_REG_15: Type = 16;
    pub const SYSZ_REG_CC: Type = 17;
    pub const SYSZ_REG_F0: Type = 18;
    pub const SYSZ_REG_F1: Type = 19;
    pub const SYSZ_REG_F2: Type = 20;
    pub const SYSZ_REG_F3: Type = 21;
    pub const SYSZ_REG_F4: Type = 22;
    pub const SYSZ_REG_F5: Type = 23;
    pub const SYSZ_REG_F6: Type = 24;
    pub const SYSZ_REG_F7: Type = 25;
    pub const SYSZ_REG_F8: Type = 26;
    pub const SYSZ_REG_F9: Type = 27;
    pub const SYSZ_REG_F10: Type = 28;
    pub const SYSZ_REG_F11: Type = 29;
    pub const SYSZ_REG_F12: Type = 30;
    pub const SYSZ_REG_F13: Type = 31;
    pub const SYSZ_REG_F14: Type = 32;
    pub const SYSZ_REG_F15: Type = 33;
    pub const SYSZ_REG_R0L: Type = 34;
    pub const SYSZ_REG_ENDING: Type = 35;
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with SYSZ_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct sysz_op_mem {
    #[doc = "< base register, can be safely interpreted as"]
    #[doc = "< a value of type `sysz_reg`, but it is only"]
    #[doc = "< one byte wide"]
    pub base: u8,
    #[doc = "< index register, same conditions apply here"]
    pub index: u8,
    #[doc = "< BDLAddr operand"]
    pub length: u64,
    #[doc = "< displacement/offset value"]
    pub disp: i64,
}
impl Clone for sysz_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_sysz_op {
    #[doc = "< operand type"]
    pub type_: sysz_op_type,
    pub __bindgen_anon_1: cs_sysz_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_sysz_op__bindgen_ty_1 {
    #[doc = "< register value for REG operand"]
    pub reg: sysz_reg::Type,
    #[doc = "< immediate value for IMM operand"]
    pub imm: i64,
    #[doc = "< base/disp value for MEM operand"]
    pub mem: sysz_op_mem,
    _bindgen_union_align: [u64; 3usize],
}
impl Clone for cs_sysz_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_sysz_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_sysz_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_sysz_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_sysz_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_sysz_op {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[repr(C)]
#[derive(Copy)]
pub struct cs_sysz {
    #[doc = "< Code condition"]
    pub cc: sysz_cc,
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_sysz_op; 6usize],
}
impl Clone for cs_sysz {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_sysz {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_sysz {{ cc: {:?}, op_count: {:?}, operands: {:?} }}",
            self.cc, self.op_count, self.operands
        )
    }
}
#[repr(u32)]
#[doc = " SystemZ instruction"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum sysz_insn {
    SYSZ_INS_INVALID = 0,
    SYSZ_INS_A = 1,
    SYSZ_INS_ADB = 2,
    SYSZ_INS_ADBR = 3,
    SYSZ_INS_AEB = 4,
    SYSZ_INS_AEBR = 5,
    SYSZ_INS_AFI = 6,
    SYSZ_INS_AG = 7,
    SYSZ_INS_AGF = 8,
    SYSZ_INS_AGFI = 9,
    SYSZ_INS_AGFR = 10,
    SYSZ_INS_AGHI = 11,
    SYSZ_INS_AGHIK = 12,
    SYSZ_INS_AGR = 13,
    SYSZ_INS_AGRK = 14,
    SYSZ_INS_AGSI = 15,
    SYSZ_INS_AH = 16,
    SYSZ_INS_AHI = 17,
    SYSZ_INS_AHIK = 18,
    SYSZ_INS_AHY = 19,
    SYSZ_INS_AIH = 20,
    SYSZ_INS_AL = 21,
    SYSZ_INS_ALC = 22,
    SYSZ_INS_ALCG = 23,
    SYSZ_INS_ALCGR = 24,
    SYSZ_INS_ALCR = 25,
    SYSZ_INS_ALFI = 26,
    SYSZ_INS_ALG = 27,
    SYSZ_INS_ALGF = 28,
    SYSZ_INS_ALGFI = 29,
    SYSZ_INS_ALGFR = 30,
    SYSZ_INS_ALGHSIK = 31,
    SYSZ_INS_ALGR = 32,
    SYSZ_INS_ALGRK = 33,
    SYSZ_INS_ALHSIK = 34,
    SYSZ_INS_ALR = 35,
    SYSZ_INS_ALRK = 36,
    SYSZ_INS_ALY = 37,
    SYSZ_INS_AR = 38,
    SYSZ_INS_ARK = 39,
    SYSZ_INS_ASI = 40,
    SYSZ_INS_AXBR = 41,
    SYSZ_INS_AY = 42,
    SYSZ_INS_BCR = 43,
    SYSZ_INS_BRC = 44,
    SYSZ_INS_BRCL = 45,
    SYSZ_INS_CGIJ = 46,
    SYSZ_INS_CGRJ = 47,
    SYSZ_INS_CIJ = 48,
    SYSZ_INS_CLGIJ = 49,
    SYSZ_INS_CLGRJ = 50,
    SYSZ_INS_CLIJ = 51,
    SYSZ_INS_CLRJ = 52,
    SYSZ_INS_CRJ = 53,
    SYSZ_INS_BER = 54,
    SYSZ_INS_JE = 55,
    SYSZ_INS_JGE = 56,
    SYSZ_INS_LOCE = 57,
    SYSZ_INS_LOCGE = 58,
    SYSZ_INS_LOCGRE = 59,
    SYSZ_INS_LOCRE = 60,
    SYSZ_INS_STOCE = 61,
    SYSZ_INS_STOCGE = 62,
    SYSZ_INS_BHR = 63,
    SYSZ_INS_BHER = 64,
    SYSZ_INS_JHE = 65,
    SYSZ_INS_JGHE = 66,
    SYSZ_INS_LOCHE = 67,
    SYSZ_INS_LOCGHE = 68,
    SYSZ_INS_LOCGRHE = 69,
    SYSZ_INS_LOCRHE = 70,
    SYSZ_INS_STOCHE = 71,
    SYSZ_INS_STOCGHE = 72,
    SYSZ_INS_JH = 73,
    SYSZ_INS_JGH = 74,
    SYSZ_INS_LOCH = 75,
    SYSZ_INS_LOCGH = 76,
    SYSZ_INS_LOCGRH = 77,
    SYSZ_INS_LOCRH = 78,
    SYSZ_INS_STOCH = 79,
    SYSZ_INS_STOCGH = 80,
    SYSZ_INS_CGIJNLH = 81,
    SYSZ_INS_CGRJNLH = 82,
    SYSZ_INS_CIJNLH = 83,
    SYSZ_INS_CLGIJNLH = 84,
    SYSZ_INS_CLGRJNLH = 85,
    SYSZ_INS_CLIJNLH = 86,
    SYSZ_INS_CLRJNLH = 87,
    SYSZ_INS_CRJNLH = 88,
    SYSZ_INS_CGIJE = 89,
    SYSZ_INS_CGRJE = 90,
    SYSZ_INS_CIJE = 91,
    SYSZ_INS_CLGIJE = 92,
    SYSZ_INS_CLGRJE = 93,
    SYSZ_INS_CLIJE = 94,
    SYSZ_INS_CLRJE = 95,
    SYSZ_INS_CRJE = 96,
    SYSZ_INS_CGIJNLE = 97,
    SYSZ_INS_CGRJNLE = 98,
    SYSZ_INS_CIJNLE = 99,
    SYSZ_INS_CLGIJNLE = 100,
    SYSZ_INS_CLGRJNLE = 101,
    SYSZ_INS_CLIJNLE = 102,
    SYSZ_INS_CLRJNLE = 103,
    SYSZ_INS_CRJNLE = 104,
    SYSZ_INS_CGIJH = 105,
    SYSZ_INS_CGRJH = 106,
    SYSZ_INS_CIJH = 107,
    SYSZ_INS_CLGIJH = 108,
    SYSZ_INS_CLGRJH = 109,
    SYSZ_INS_CLIJH = 110,
    SYSZ_INS_CLRJH = 111,
    SYSZ_INS_CRJH = 112,
    SYSZ_INS_CGIJNL = 113,
    SYSZ_INS_CGRJNL = 114,
    SYSZ_INS_CIJNL = 115,
    SYSZ_INS_CLGIJNL = 116,
    SYSZ_INS_CLGRJNL = 117,
    SYSZ_INS_CLIJNL = 118,
    SYSZ_INS_CLRJNL = 119,
    SYSZ_INS_CRJNL = 120,
    SYSZ_INS_CGIJHE = 121,
    SYSZ_INS_CGRJHE = 122,
    SYSZ_INS_CIJHE = 123,
    SYSZ_INS_CLGIJHE = 124,
    SYSZ_INS_CLGRJHE = 125,
    SYSZ_INS_CLIJHE = 126,
    SYSZ_INS_CLRJHE = 127,
    SYSZ_INS_CRJHE = 128,
    SYSZ_INS_CGIJNHE = 129,
    SYSZ_INS_CGRJNHE = 130,
    SYSZ_INS_CIJNHE = 131,
    SYSZ_INS_CLGIJNHE = 132,
    SYSZ_INS_CLGRJNHE = 133,
    SYSZ_INS_CLIJNHE = 134,
    SYSZ_INS_CLRJNHE = 135,
    SYSZ_INS_CRJNHE = 136,
    SYSZ_INS_CGIJL = 137,
    SYSZ_INS_CGRJL = 138,
    SYSZ_INS_CIJL = 139,
    SYSZ_INS_CLGIJL = 140,
    SYSZ_INS_CLGRJL = 141,
    SYSZ_INS_CLIJL = 142,
    SYSZ_INS_CLRJL = 143,
    SYSZ_INS_CRJL = 144,
    SYSZ_INS_CGIJNH = 145,
    SYSZ_INS_CGRJNH = 146,
    SYSZ_INS_CIJNH = 147,
    SYSZ_INS_CLGIJNH = 148,
    SYSZ_INS_CLGRJNH = 149,
    SYSZ_INS_CLIJNH = 150,
    SYSZ_INS_CLRJNH = 151,
    SYSZ_INS_CRJNH = 152,
    SYSZ_INS_CGIJLE = 153,
    SYSZ_INS_CGRJLE = 154,
    SYSZ_INS_CIJLE = 155,
    SYSZ_INS_CLGIJLE = 156,
    SYSZ_INS_CLGRJLE = 157,
    SYSZ_INS_CLIJLE = 158,
    SYSZ_INS_CLRJLE = 159,
    SYSZ_INS_CRJLE = 160,
    SYSZ_INS_CGIJNE = 161,
    SYSZ_INS_CGRJNE = 162,
    SYSZ_INS_CIJNE = 163,
    SYSZ_INS_CLGIJNE = 164,
    SYSZ_INS_CLGRJNE = 165,
    SYSZ_INS_CLIJNE = 166,
    SYSZ_INS_CLRJNE = 167,
    SYSZ_INS_CRJNE = 168,
    SYSZ_INS_CGIJLH = 169,
    SYSZ_INS_CGRJLH = 170,
    SYSZ_INS_CIJLH = 171,
    SYSZ_INS_CLGIJLH = 172,
    SYSZ_INS_CLGRJLH = 173,
    SYSZ_INS_CLIJLH = 174,
    SYSZ_INS_CLRJLH = 175,
    SYSZ_INS_CRJLH = 176,
    SYSZ_INS_BLR = 177,
    SYSZ_INS_BLER = 178,
    SYSZ_INS_JLE = 179,
    SYSZ_INS_JGLE = 180,
    SYSZ_INS_LOCLE = 181,
    SYSZ_INS_LOCGLE = 182,
    SYSZ_INS_LOCGRLE = 183,
    SYSZ_INS_LOCRLE = 184,
    SYSZ_INS_STOCLE = 185,
    SYSZ_INS_STOCGLE = 186,
    SYSZ_INS_BLHR = 187,
    SYSZ_INS_JLH = 188,
    SYSZ_INS_JGLH = 189,
    SYSZ_INS_LOCLH = 190,
    SYSZ_INS_LOCGLH = 191,
    SYSZ_INS_LOCGRLH = 192,
    SYSZ_INS_LOCRLH = 193,
    SYSZ_INS_STOCLH = 194,
    SYSZ_INS_STOCGLH = 195,
    SYSZ_INS_JL = 196,
    SYSZ_INS_JGL = 197,
    SYSZ_INS_LOCL = 198,
    SYSZ_INS_LOCGL = 199,
    SYSZ_INS_LOCGRL = 200,
    SYSZ_INS_LOCRL = 201,
    SYSZ_INS_LOC = 202,
    SYSZ_INS_LOCG = 203,
    SYSZ_INS_LOCGR = 204,
    SYSZ_INS_LOCR = 205,
    SYSZ_INS_STOCL = 206,
    SYSZ_INS_STOCGL = 207,
    SYSZ_INS_BNER = 208,
    SYSZ_INS_JNE = 209,
    SYSZ_INS_JGNE = 210,
    SYSZ_INS_LOCNE = 211,
    SYSZ_INS_LOCGNE = 212,
    SYSZ_INS_LOCGRNE = 213,
    SYSZ_INS_LOCRNE = 214,
    SYSZ_INS_STOCNE = 215,
    SYSZ_INS_STOCGNE = 216,
    SYSZ_INS_BNHR = 217,
    SYSZ_INS_BNHER = 218,
    SYSZ_INS_JNHE = 219,
    SYSZ_INS_JGNHE = 220,
    SYSZ_INS_LOCNHE = 221,
    SYSZ_INS_LOCGNHE = 222,
    SYSZ_INS_LOCGRNHE = 223,
    SYSZ_INS_LOCRNHE = 224,
    SYSZ_INS_STOCNHE = 225,
    SYSZ_INS_STOCGNHE = 226,
    SYSZ_INS_JNH = 227,
    SYSZ_INS_JGNH = 228,
    SYSZ_INS_LOCNH = 229,
    SYSZ_INS_LOCGNH = 230,
    SYSZ_INS_LOCGRNH = 231,
    SYSZ_INS_LOCRNH = 232,
    SYSZ_INS_STOCNH = 233,
    SYSZ_INS_STOCGNH = 234,
    SYSZ_INS_BNLR = 235,
    SYSZ_INS_BNLER = 236,
    SYSZ_INS_JNLE = 237,
    SYSZ_INS_JGNLE = 238,
    SYSZ_INS_LOCNLE = 239,
    SYSZ_INS_LOCGNLE = 240,
    SYSZ_INS_LOCGRNLE = 241,
    SYSZ_INS_LOCRNLE = 242,
    SYSZ_INS_STOCNLE = 243,
    SYSZ_INS_STOCGNLE = 244,
    SYSZ_INS_BNLHR = 245,
    SYSZ_INS_JNLH = 246,
    SYSZ_INS_JGNLH = 247,
    SYSZ_INS_LOCNLH = 248,
    SYSZ_INS_LOCGNLH = 249,
    SYSZ_INS_LOCGRNLH = 250,
    SYSZ_INS_LOCRNLH = 251,
    SYSZ_INS_STOCNLH = 252,
    SYSZ_INS_STOCGNLH = 253,
    SYSZ_INS_JNL = 254,
    SYSZ_INS_JGNL = 255,
    SYSZ_INS_LOCNL = 256,
    SYSZ_INS_LOCGNL = 257,
    SYSZ_INS_LOCGRNL = 258,
    SYSZ_INS_LOCRNL = 259,
    SYSZ_INS_STOCNL = 260,
    SYSZ_INS_STOCGNL = 261,
    SYSZ_INS_BNOR = 262,
    SYSZ_INS_JNO = 263,
    SYSZ_INS_JGNO = 264,
    SYSZ_INS_LOCNO = 265,
    SYSZ_INS_LOCGNO = 266,
    SYSZ_INS_LOCGRNO = 267,
    SYSZ_INS_LOCRNO = 268,
    SYSZ_INS_STOCNO = 269,
    SYSZ_INS_STOCGNO = 270,
    SYSZ_INS_BOR = 271,
    SYSZ_INS_JO = 272,
    SYSZ_INS_JGO = 273,
    SYSZ_INS_LOCO = 274,
    SYSZ_INS_LOCGO = 275,
    SYSZ_INS_LOCGRO = 276,
    SYSZ_INS_LOCRO = 277,
    SYSZ_INS_STOCO = 278,
    SYSZ_INS_STOCGO = 279,
    SYSZ_INS_STOC = 280,
    SYSZ_INS_STOCG = 281,
    SYSZ_INS_BASR = 282,
    SYSZ_INS_BR = 283,
    SYSZ_INS_BRAS = 284,
    SYSZ_INS_BRASL = 285,
    SYSZ_INS_J = 286,
    SYSZ_INS_JG = 287,
    SYSZ_INS_BRCT = 288,
    SYSZ_INS_BRCTG = 289,
    SYSZ_INS_C = 290,
    SYSZ_INS_CDB = 291,
    SYSZ_INS_CDBR = 292,
    SYSZ_INS_CDFBR = 293,
    SYSZ_INS_CDGBR = 294,
    SYSZ_INS_CDLFBR = 295,
    SYSZ_INS_CDLGBR = 296,
    SYSZ_INS_CEB = 297,
    SYSZ_INS_CEBR = 298,
    SYSZ_INS_CEFBR = 299,
    SYSZ_INS_CEGBR = 300,
    SYSZ_INS_CELFBR = 301,
    SYSZ_INS_CELGBR = 302,
    SYSZ_INS_CFDBR = 303,
    SYSZ_INS_CFEBR = 304,
    SYSZ_INS_CFI = 305,
    SYSZ_INS_CFXBR = 306,
    SYSZ_INS_CG = 307,
    SYSZ_INS_CGDBR = 308,
    SYSZ_INS_CGEBR = 309,
    SYSZ_INS_CGF = 310,
    SYSZ_INS_CGFI = 311,
    SYSZ_INS_CGFR = 312,
    SYSZ_INS_CGFRL = 313,
    SYSZ_INS_CGH = 314,
    SYSZ_INS_CGHI = 315,
    SYSZ_INS_CGHRL = 316,
    SYSZ_INS_CGHSI = 317,
    SYSZ_INS_CGR = 318,
    SYSZ_INS_CGRL = 319,
    SYSZ_INS_CGXBR = 320,
    SYSZ_INS_CH = 321,
    SYSZ_INS_CHF = 322,
    SYSZ_INS_CHHSI = 323,
    SYSZ_INS_CHI = 324,
    SYSZ_INS_CHRL = 325,
    SYSZ_INS_CHSI = 326,
    SYSZ_INS_CHY = 327,
    SYSZ_INS_CIH = 328,
    SYSZ_INS_CL = 329,
    SYSZ_INS_CLC = 330,
    SYSZ_INS_CLFDBR = 331,
    SYSZ_INS_CLFEBR = 332,
    SYSZ_INS_CLFHSI = 333,
    SYSZ_INS_CLFI = 334,
    SYSZ_INS_CLFXBR = 335,
    SYSZ_INS_CLG = 336,
    SYSZ_INS_CLGDBR = 337,
    SYSZ_INS_CLGEBR = 338,
    SYSZ_INS_CLGF = 339,
    SYSZ_INS_CLGFI = 340,
    SYSZ_INS_CLGFR = 341,
    SYSZ_INS_CLGFRL = 342,
    SYSZ_INS_CLGHRL = 343,
    SYSZ_INS_CLGHSI = 344,
    SYSZ_INS_CLGR = 345,
    SYSZ_INS_CLGRL = 346,
    SYSZ_INS_CLGXBR = 347,
    SYSZ_INS_CLHF = 348,
    SYSZ_INS_CLHHSI = 349,
    SYSZ_INS_CLHRL = 350,
    SYSZ_INS_CLI = 351,
    SYSZ_INS_CLIH = 352,
    SYSZ_INS_CLIY = 353,
    SYSZ_INS_CLR = 354,
    SYSZ_INS_CLRL = 355,
    SYSZ_INS_CLST = 356,
    SYSZ_INS_CLY = 357,
    SYSZ_INS_CPSDR = 358,
    SYSZ_INS_CR = 359,
    SYSZ_INS_CRL = 360,
    SYSZ_INS_CS = 361,
    SYSZ_INS_CSG = 362,
    SYSZ_INS_CSY = 363,
    SYSZ_INS_CXBR = 364,
    SYSZ_INS_CXFBR = 365,
    SYSZ_INS_CXGBR = 366,
    SYSZ_INS_CXLFBR = 367,
    SYSZ_INS_CXLGBR = 368,
    SYSZ_INS_CY = 369,
    SYSZ_INS_DDB = 370,
    SYSZ_INS_DDBR = 371,
    SYSZ_INS_DEB = 372,
    SYSZ_INS_DEBR = 373,
    SYSZ_INS_DL = 374,
    SYSZ_INS_DLG = 375,
    SYSZ_INS_DLGR = 376,
    SYSZ_INS_DLR = 377,
    SYSZ_INS_DSG = 378,
    SYSZ_INS_DSGF = 379,
    SYSZ_INS_DSGFR = 380,
    SYSZ_INS_DSGR = 381,
    SYSZ_INS_DXBR = 382,
    SYSZ_INS_EAR = 383,
    SYSZ_INS_FIDBR = 384,
    SYSZ_INS_FIDBRA = 385,
    SYSZ_INS_FIEBR = 386,
    SYSZ_INS_FIEBRA = 387,
    SYSZ_INS_FIXBR = 388,
    SYSZ_INS_FIXBRA = 389,
    SYSZ_INS_FLOGR = 390,
    SYSZ_INS_IC = 391,
    SYSZ_INS_ICY = 392,
    SYSZ_INS_IIHF = 393,
    SYSZ_INS_IIHH = 394,
    SYSZ_INS_IIHL = 395,
    SYSZ_INS_IILF = 396,
    SYSZ_INS_IILH = 397,
    SYSZ_INS_IILL = 398,
    SYSZ_INS_IPM = 399,
    SYSZ_INS_L = 400,
    SYSZ_INS_LA = 401,
    SYSZ_INS_LAA = 402,
    SYSZ_INS_LAAG = 403,
    SYSZ_INS_LAAL = 404,
    SYSZ_INS_LAALG = 405,
    SYSZ_INS_LAN = 406,
    SYSZ_INS_LANG = 407,
    SYSZ_INS_LAO = 408,
    SYSZ_INS_LAOG = 409,
    SYSZ_INS_LARL = 410,
    SYSZ_INS_LAX = 411,
    SYSZ_INS_LAXG = 412,
    SYSZ_INS_LAY = 413,
    SYSZ_INS_LB = 414,
    SYSZ_INS_LBH = 415,
    SYSZ_INS_LBR = 416,
    SYSZ_INS_LCDBR = 417,
    SYSZ_INS_LCEBR = 418,
    SYSZ_INS_LCGFR = 419,
    SYSZ_INS_LCGR = 420,
    SYSZ_INS_LCR = 421,
    SYSZ_INS_LCXBR = 422,
    SYSZ_INS_LD = 423,
    SYSZ_INS_LDEB = 424,
    SYSZ_INS_LDEBR = 425,
    SYSZ_INS_LDGR = 426,
    SYSZ_INS_LDR = 427,
    SYSZ_INS_LDXBR = 428,
    SYSZ_INS_LDXBRA = 429,
    SYSZ_INS_LDY = 430,
    SYSZ_INS_LE = 431,
    SYSZ_INS_LEDBR = 432,
    SYSZ_INS_LEDBRA = 433,
    SYSZ_INS_LER = 434,
    SYSZ_INS_LEXBR = 435,
    SYSZ_INS_LEXBRA = 436,
    SYSZ_INS_LEY = 437,
    SYSZ_INS_LFH = 438,
    SYSZ_INS_LG = 439,
    SYSZ_INS_LGB = 440,
    SYSZ_INS_LGBR = 441,
    SYSZ_INS_LGDR = 442,
    SYSZ_INS_LGF = 443,
    SYSZ_INS_LGFI = 444,
    SYSZ_INS_LGFR = 445,
    SYSZ_INS_LGFRL = 446,
    SYSZ_INS_LGH = 447,
    SYSZ_INS_LGHI = 448,
    SYSZ_INS_LGHR = 449,
    SYSZ_INS_LGHRL = 450,
    SYSZ_INS_LGR = 451,
    SYSZ_INS_LGRL = 452,
    SYSZ_INS_LH = 453,
    SYSZ_INS_LHH = 454,
    SYSZ_INS_LHI = 455,
    SYSZ_INS_LHR = 456,
    SYSZ_INS_LHRL = 457,
    SYSZ_INS_LHY = 458,
    SYSZ_INS_LLC = 459,
    SYSZ_INS_LLCH = 460,
    SYSZ_INS_LLCR = 461,
    SYSZ_INS_LLGC = 462,
    SYSZ_INS_LLGCR = 463,
    SYSZ_INS_LLGF = 464,
    SYSZ_INS_LLGFR = 465,
    SYSZ_INS_LLGFRL = 466,
    SYSZ_INS_LLGH = 467,
    SYSZ_INS_LLGHR = 468,
    SYSZ_INS_LLGHRL = 469,
    SYSZ_INS_LLH = 470,
    SYSZ_INS_LLHH = 471,
    SYSZ_INS_LLHR = 472,
    SYSZ_INS_LLHRL = 473,
    SYSZ_INS_LLIHF = 474,
    SYSZ_INS_LLIHH = 475,
    SYSZ_INS_LLIHL = 476,
    SYSZ_INS_LLILF = 477,
    SYSZ_INS_LLILH = 478,
    SYSZ_INS_LLILL = 479,
    SYSZ_INS_LMG = 480,
    SYSZ_INS_LNDBR = 481,
    SYSZ_INS_LNEBR = 482,
    SYSZ_INS_LNGFR = 483,
    SYSZ_INS_LNGR = 484,
    SYSZ_INS_LNR = 485,
    SYSZ_INS_LNXBR = 486,
    SYSZ_INS_LPDBR = 487,
    SYSZ_INS_LPEBR = 488,
    SYSZ_INS_LPGFR = 489,
    SYSZ_INS_LPGR = 490,
    SYSZ_INS_LPR = 491,
    SYSZ_INS_LPXBR = 492,
    SYSZ_INS_LR = 493,
    SYSZ_INS_LRL = 494,
    SYSZ_INS_LRV = 495,
    SYSZ_INS_LRVG = 496,
    SYSZ_INS_LRVGR = 497,
    SYSZ_INS_LRVR = 498,
    SYSZ_INS_LT = 499,
    SYSZ_INS_LTDBR = 500,
    SYSZ_INS_LTEBR = 501,
    SYSZ_INS_LTG = 502,
    SYSZ_INS_LTGF = 503,
    SYSZ_INS_LTGFR = 504,
    SYSZ_INS_LTGR = 505,
    SYSZ_INS_LTR = 506,
    SYSZ_INS_LTXBR = 507,
    SYSZ_INS_LXDB = 508,
    SYSZ_INS_LXDBR = 509,
    SYSZ_INS_LXEB = 510,
    SYSZ_INS_LXEBR = 511,
    SYSZ_INS_LXR = 512,
    SYSZ_INS_LY = 513,
    SYSZ_INS_LZDR = 514,
    SYSZ_INS_LZER = 515,
    SYSZ_INS_LZXR = 516,
    SYSZ_INS_MADB = 517,
    SYSZ_INS_MADBR = 518,
    SYSZ_INS_MAEB = 519,
    SYSZ_INS_MAEBR = 520,
    SYSZ_INS_MDB = 521,
    SYSZ_INS_MDBR = 522,
    SYSZ_INS_MDEB = 523,
    SYSZ_INS_MDEBR = 524,
    SYSZ_INS_MEEB = 525,
    SYSZ_INS_MEEBR = 526,
    SYSZ_INS_MGHI = 527,
    SYSZ_INS_MH = 528,
    SYSZ_INS_MHI = 529,
    SYSZ_INS_MHY = 530,
    SYSZ_INS_MLG = 531,
    SYSZ_INS_MLGR = 532,
    SYSZ_INS_MS = 533,
    SYSZ_INS_MSDB = 534,
    SYSZ_INS_MSDBR = 535,
    SYSZ_INS_MSEB = 536,
    SYSZ_INS_MSEBR = 537,
    SYSZ_INS_MSFI = 538,
    SYSZ_INS_MSG = 539,
    SYSZ_INS_MSGF = 540,
    SYSZ_INS_MSGFI = 541,
    SYSZ_INS_MSGFR = 542,
    SYSZ_INS_MSGR = 543,
    SYSZ_INS_MSR = 544,
    SYSZ_INS_MSY = 545,
    SYSZ_INS_MVC = 546,
    SYSZ_INS_MVGHI = 547,
    SYSZ_INS_MVHHI = 548,
    SYSZ_INS_MVHI = 549,
    SYSZ_INS_MVI = 550,
    SYSZ_INS_MVIY = 551,
    SYSZ_INS_MVST = 552,
    SYSZ_INS_MXBR = 553,
    SYSZ_INS_MXDB = 554,
    SYSZ_INS_MXDBR = 555,
    SYSZ_INS_N = 556,
    SYSZ_INS_NC = 557,
    SYSZ_INS_NG = 558,
    SYSZ_INS_NGR = 559,
    SYSZ_INS_NGRK = 560,
    SYSZ_INS_NI = 561,
    SYSZ_INS_NIHF = 562,
    SYSZ_INS_NIHH = 563,
    SYSZ_INS_NIHL = 564,
    SYSZ_INS_NILF = 565,
    SYSZ_INS_NILH = 566,
    SYSZ_INS_NILL = 567,
    SYSZ_INS_NIY = 568,
    SYSZ_INS_NR = 569,
    SYSZ_INS_NRK = 570,
    SYSZ_INS_NY = 571,
    SYSZ_INS_O = 572,
    SYSZ_INS_OC = 573,
    SYSZ_INS_OG = 574,
    SYSZ_INS_OGR = 575,
    SYSZ_INS_OGRK = 576,
    SYSZ_INS_OI = 577,
    SYSZ_INS_OIHF = 578,
    SYSZ_INS_OIHH = 579,
    SYSZ_INS_OIHL = 580,
    SYSZ_INS_OILF = 581,
    SYSZ_INS_OILH = 582,
    SYSZ_INS_OILL = 583,
    SYSZ_INS_OIY = 584,
    SYSZ_INS_OR = 585,
    SYSZ_INS_ORK = 586,
    SYSZ_INS_OY = 587,
    SYSZ_INS_PFD = 588,
    SYSZ_INS_PFDRL = 589,
    SYSZ_INS_RISBG = 590,
    SYSZ_INS_RISBHG = 591,
    SYSZ_INS_RISBLG = 592,
    SYSZ_INS_RLL = 593,
    SYSZ_INS_RLLG = 594,
    SYSZ_INS_RNSBG = 595,
    SYSZ_INS_ROSBG = 596,
    SYSZ_INS_RXSBG = 597,
    SYSZ_INS_S = 598,
    SYSZ_INS_SDB = 599,
    SYSZ_INS_SDBR = 600,
    SYSZ_INS_SEB = 601,
    SYSZ_INS_SEBR = 602,
    SYSZ_INS_SG = 603,
    SYSZ_INS_SGF = 604,
    SYSZ_INS_SGFR = 605,
    SYSZ_INS_SGR = 606,
    SYSZ_INS_SGRK = 607,
    SYSZ_INS_SH = 608,
    SYSZ_INS_SHY = 609,
    SYSZ_INS_SL = 610,
    SYSZ_INS_SLB = 611,
    SYSZ_INS_SLBG = 612,
    SYSZ_INS_SLBR = 613,
    SYSZ_INS_SLFI = 614,
    SYSZ_INS_SLG = 615,
    SYSZ_INS_SLBGR = 616,
    SYSZ_INS_SLGF = 617,
    SYSZ_INS_SLGFI = 618,
    SYSZ_INS_SLGFR = 619,
    SYSZ_INS_SLGR = 620,
    SYSZ_INS_SLGRK = 621,
    SYSZ_INS_SLL = 622,
    SYSZ_INS_SLLG = 623,
    SYSZ_INS_SLLK = 624,
    SYSZ_INS_SLR = 625,
    SYSZ_INS_SLRK = 626,
    SYSZ_INS_SLY = 627,
    SYSZ_INS_SQDB = 628,
    SYSZ_INS_SQDBR = 629,
    SYSZ_INS_SQEB = 630,
    SYSZ_INS_SQEBR = 631,
    SYSZ_INS_SQXBR = 632,
    SYSZ_INS_SR = 633,
    SYSZ_INS_SRA = 634,
    SYSZ_INS_SRAG = 635,
    SYSZ_INS_SRAK = 636,
    SYSZ_INS_SRK = 637,
    SYSZ_INS_SRL = 638,
    SYSZ_INS_SRLG = 639,
    SYSZ_INS_SRLK = 640,
    SYSZ_INS_SRST = 641,
    SYSZ_INS_ST = 642,
    SYSZ_INS_STC = 643,
    SYSZ_INS_STCH = 644,
    SYSZ_INS_STCY = 645,
    SYSZ_INS_STD = 646,
    SYSZ_INS_STDY = 647,
    SYSZ_INS_STE = 648,
    SYSZ_INS_STEY = 649,
    SYSZ_INS_STFH = 650,
    SYSZ_INS_STG = 651,
    SYSZ_INS_STGRL = 652,
    SYSZ_INS_STH = 653,
    SYSZ_INS_STHH = 654,
    SYSZ_INS_STHRL = 655,
    SYSZ_INS_STHY = 656,
    SYSZ_INS_STMG = 657,
    SYSZ_INS_STRL = 658,
    SYSZ_INS_STRV = 659,
    SYSZ_INS_STRVG = 660,
    SYSZ_INS_STY = 661,
    SYSZ_INS_SXBR = 662,
    SYSZ_INS_SY = 663,
    SYSZ_INS_TM = 664,
    SYSZ_INS_TMHH = 665,
    SYSZ_INS_TMHL = 666,
    SYSZ_INS_TMLH = 667,
    SYSZ_INS_TMLL = 668,
    SYSZ_INS_TMY = 669,
    SYSZ_INS_X = 670,
    SYSZ_INS_XC = 671,
    SYSZ_INS_XG = 672,
    SYSZ_INS_XGR = 673,
    SYSZ_INS_XGRK = 674,
    SYSZ_INS_XI = 675,
    SYSZ_INS_XIHF = 676,
    SYSZ_INS_XILF = 677,
    SYSZ_INS_XIY = 678,
    SYSZ_INS_XR = 679,
    SYSZ_INS_XRK = 680,
    SYSZ_INS_XY = 681,
    SYSZ_INS_ENDING = 682,
}
pub mod sysz_insn_group {
    #[doc = " Group of SystemZ instructions"]
    pub type Type = u32;
    #[doc = "< = CS_GRP_INVALID"]
    pub const SYSZ_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const SYSZ_GRP_JUMP: Type = 1;
    pub const SYSZ_GRP_DISTINCTOPS: Type = 128;
    pub const SYSZ_GRP_FPEXTENSION: Type = 129;
    pub const SYSZ_GRP_HIGHWORD: Type = 130;
    pub const SYSZ_GRP_INTERLOCKEDACCESS1: Type = 131;
    pub const SYSZ_GRP_LOADSTOREONCOND: Type = 132;
    pub const SYSZ_GRP_ENDING: Type = 133;
}
pub mod x86_reg {
    #[doc = " X86 registers"]
    pub type Type = u32;
    pub const X86_REG_INVALID: Type = 0;
    pub const X86_REG_AH: Type = 1;
    pub const X86_REG_AL: Type = 2;
    pub const X86_REG_AX: Type = 3;
    pub const X86_REG_BH: Type = 4;
    pub const X86_REG_BL: Type = 5;
    pub const X86_REG_BP: Type = 6;
    pub const X86_REG_BPL: Type = 7;
    pub const X86_REG_BX: Type = 8;
    pub const X86_REG_CH: Type = 9;
    pub const X86_REG_CL: Type = 10;
    pub const X86_REG_CS: Type = 11;
    pub const X86_REG_CX: Type = 12;
    pub const X86_REG_DH: Type = 13;
    pub const X86_REG_DI: Type = 14;
    pub const X86_REG_DIL: Type = 15;
    pub const X86_REG_DL: Type = 16;
    pub const X86_REG_DS: Type = 17;
    pub const X86_REG_DX: Type = 18;
    pub const X86_REG_EAX: Type = 19;
    pub const X86_REG_EBP: Type = 20;
    pub const X86_REG_EBX: Type = 21;
    pub const X86_REG_ECX: Type = 22;
    pub const X86_REG_EDI: Type = 23;
    pub const X86_REG_EDX: Type = 24;
    pub const X86_REG_EFLAGS: Type = 25;
    pub const X86_REG_EIP: Type = 26;
    pub const X86_REG_EIZ: Type = 27;
    pub const X86_REG_ES: Type = 28;
    pub const X86_REG_ESI: Type = 29;
    pub const X86_REG_ESP: Type = 30;
    pub const X86_REG_FPSW: Type = 31;
    pub const X86_REG_FS: Type = 32;
    pub const X86_REG_GS: Type = 33;
    pub const X86_REG_IP: Type = 34;
    pub const X86_REG_RAX: Type = 35;
    pub const X86_REG_RBP: Type = 36;
    pub const X86_REG_RBX: Type = 37;
    pub const X86_REG_RCX: Type = 38;
    pub const X86_REG_RDI: Type = 39;
    pub const X86_REG_RDX: Type = 40;
    pub const X86_REG_RIP: Type = 41;
    pub const X86_REG_RIZ: Type = 42;
    pub const X86_REG_RSI: Type = 43;
    pub const X86_REG_RSP: Type = 44;
    pub const X86_REG_SI: Type = 45;
    pub const X86_REG_SIL: Type = 46;
    pub const X86_REG_SP: Type = 47;
    pub const X86_REG_SPL: Type = 48;
    pub const X86_REG_SS: Type = 49;
    pub const X86_REG_CR0: Type = 50;
    pub const X86_REG_CR1: Type = 51;
    pub const X86_REG_CR2: Type = 52;
    pub const X86_REG_CR3: Type = 53;
    pub const X86_REG_CR4: Type = 54;
    pub const X86_REG_CR5: Type = 55;
    pub const X86_REG_CR6: Type = 56;
    pub const X86_REG_CR7: Type = 57;
    pub const X86_REG_CR8: Type = 58;
    pub const X86_REG_CR9: Type = 59;
    pub const X86_REG_CR10: Type = 60;
    pub const X86_REG_CR11: Type = 61;
    pub const X86_REG_CR12: Type = 62;
    pub const X86_REG_CR13: Type = 63;
    pub const X86_REG_CR14: Type = 64;
    pub const X86_REG_CR15: Type = 65;
    pub const X86_REG_DR0: Type = 66;
    pub const X86_REG_DR1: Type = 67;
    pub const X86_REG_DR2: Type = 68;
    pub const X86_REG_DR3: Type = 69;
    pub const X86_REG_DR4: Type = 70;
    pub const X86_REG_DR5: Type = 71;
    pub const X86_REG_DR6: Type = 72;
    pub const X86_REG_DR7: Type = 73;
    pub const X86_REG_DR8: Type = 74;
    pub const X86_REG_DR9: Type = 75;
    pub const X86_REG_DR10: Type = 76;
    pub const X86_REG_DR11: Type = 77;
    pub const X86_REG_DR12: Type = 78;
    pub const X86_REG_DR13: Type = 79;
    pub const X86_REG_DR14: Type = 80;
    pub const X86_REG_DR15: Type = 81;
    pub const X86_REG_FP0: Type = 82;
    pub const X86_REG_FP1: Type = 83;
    pub const X86_REG_FP2: Type = 84;
    pub const X86_REG_FP3: Type = 85;
    pub const X86_REG_FP4: Type = 86;
    pub const X86_REG_FP5: Type = 87;
    pub const X86_REG_FP6: Type = 88;
    pub const X86_REG_FP7: Type = 89;
    pub const X86_REG_K0: Type = 90;
    pub const X86_REG_K1: Type = 91;
    pub const X86_REG_K2: Type = 92;
    pub const X86_REG_K3: Type = 93;
    pub const X86_REG_K4: Type = 94;
    pub const X86_REG_K5: Type = 95;
    pub const X86_REG_K6: Type = 96;
    pub const X86_REG_K7: Type = 97;
    pub const X86_REG_MM0: Type = 98;
    pub const X86_REG_MM1: Type = 99;
    pub const X86_REG_MM2: Type = 100;
    pub const X86_REG_MM3: Type = 101;
    pub const X86_REG_MM4: Type = 102;
    pub const X86_REG_MM5: Type = 103;
    pub const X86_REG_MM6: Type = 104;
    pub const X86_REG_MM7: Type = 105;
    pub const X86_REG_R8: Type = 106;
    pub const X86_REG_R9: Type = 107;
    pub const X86_REG_R10: Type = 108;
    pub const X86_REG_R11: Type = 109;
    pub const X86_REG_R12: Type = 110;
    pub const X86_REG_R13: Type = 111;
    pub const X86_REG_R14: Type = 112;
    pub const X86_REG_R15: Type = 113;
    pub const X86_REG_ST0: Type = 114;
    pub const X86_REG_ST1: Type = 115;
    pub const X86_REG_ST2: Type = 116;
    pub const X86_REG_ST3: Type = 117;
    pub const X86_REG_ST4: Type = 118;
    pub const X86_REG_ST5: Type = 119;
    pub const X86_REG_ST6: Type = 120;
    pub const X86_REG_ST7: Type = 121;
    pub const X86_REG_XMM0: Type = 122;
    pub const X86_REG_XMM1: Type = 123;
    pub const X86_REG_XMM2: Type = 124;
    pub const X86_REG_XMM3: Type = 125;
    pub const X86_REG_XMM4: Type = 126;
    pub const X86_REG_XMM5: Type = 127;
    pub const X86_REG_XMM6: Type = 128;
    pub const X86_REG_XMM7: Type = 129;
    pub const X86_REG_XMM8: Type = 130;
    pub const X86_REG_XMM9: Type = 131;
    pub const X86_REG_XMM10: Type = 132;
    pub const X86_REG_XMM11: Type = 133;
    pub const X86_REG_XMM12: Type = 134;
    pub const X86_REG_XMM13: Type = 135;
    pub const X86_REG_XMM14: Type = 136;
    pub const X86_REG_XMM15: Type = 137;
    pub const X86_REG_XMM16: Type = 138;
    pub const X86_REG_XMM17: Type = 139;
    pub const X86_REG_XMM18: Type = 140;
    pub const X86_REG_XMM19: Type = 141;
    pub const X86_REG_XMM20: Type = 142;
    pub const X86_REG_XMM21: Type = 143;
    pub const X86_REG_XMM22: Type = 144;
    pub const X86_REG_XMM23: Type = 145;
    pub const X86_REG_XMM24: Type = 146;
    pub const X86_REG_XMM25: Type = 147;
    pub const X86_REG_XMM26: Type = 148;
    pub const X86_REG_XMM27: Type = 149;
    pub const X86_REG_XMM28: Type = 150;
    pub const X86_REG_XMM29: Type = 151;
    pub const X86_REG_XMM30: Type = 152;
    pub const X86_REG_XMM31: Type = 153;
    pub const X86_REG_YMM0: Type = 154;
    pub const X86_REG_YMM1: Type = 155;
    pub const X86_REG_YMM2: Type = 156;
    pub const X86_REG_YMM3: Type = 157;
    pub const X86_REG_YMM4: Type = 158;
    pub const X86_REG_YMM5: Type = 159;
    pub const X86_REG_YMM6: Type = 160;
    pub const X86_REG_YMM7: Type = 161;
    pub const X86_REG_YMM8: Type = 162;
    pub const X86_REG_YMM9: Type = 163;
    pub const X86_REG_YMM10: Type = 164;
    pub const X86_REG_YMM11: Type = 165;
    pub const X86_REG_YMM12: Type = 166;
    pub const X86_REG_YMM13: Type = 167;
    pub const X86_REG_YMM14: Type = 168;
    pub const X86_REG_YMM15: Type = 169;
    pub const X86_REG_YMM16: Type = 170;
    pub const X86_REG_YMM17: Type = 171;
    pub const X86_REG_YMM18: Type = 172;
    pub const X86_REG_YMM19: Type = 173;
    pub const X86_REG_YMM20: Type = 174;
    pub const X86_REG_YMM21: Type = 175;
    pub const X86_REG_YMM22: Type = 176;
    pub const X86_REG_YMM23: Type = 177;
    pub const X86_REG_YMM24: Type = 178;
    pub const X86_REG_YMM25: Type = 179;
    pub const X86_REG_YMM26: Type = 180;
    pub const X86_REG_YMM27: Type = 181;
    pub const X86_REG_YMM28: Type = 182;
    pub const X86_REG_YMM29: Type = 183;
    pub const X86_REG_YMM30: Type = 184;
    pub const X86_REG_YMM31: Type = 185;
    pub const X86_REG_ZMM0: Type = 186;
    pub const X86_REG_ZMM1: Type = 187;
    pub const X86_REG_ZMM2: Type = 188;
    pub const X86_REG_ZMM3: Type = 189;
    pub const X86_REG_ZMM4: Type = 190;
    pub const X86_REG_ZMM5: Type = 191;
    pub const X86_REG_ZMM6: Type = 192;
    pub const X86_REG_ZMM7: Type = 193;
    pub const X86_REG_ZMM8: Type = 194;
    pub const X86_REG_ZMM9: Type = 195;
    pub const X86_REG_ZMM10: Type = 196;
    pub const X86_REG_ZMM11: Type = 197;
    pub const X86_REG_ZMM12: Type = 198;
    pub const X86_REG_ZMM13: Type = 199;
    pub const X86_REG_ZMM14: Type = 200;
    pub const X86_REG_ZMM15: Type = 201;
    pub const X86_REG_ZMM16: Type = 202;
    pub const X86_REG_ZMM17: Type = 203;
    pub const X86_REG_ZMM18: Type = 204;
    pub const X86_REG_ZMM19: Type = 205;
    pub const X86_REG_ZMM20: Type = 206;
    pub const X86_REG_ZMM21: Type = 207;
    pub const X86_REG_ZMM22: Type = 208;
    pub const X86_REG_ZMM23: Type = 209;
    pub const X86_REG_ZMM24: Type = 210;
    pub const X86_REG_ZMM25: Type = 211;
    pub const X86_REG_ZMM26: Type = 212;
    pub const X86_REG_ZMM27: Type = 213;
    pub const X86_REG_ZMM28: Type = 214;
    pub const X86_REG_ZMM29: Type = 215;
    pub const X86_REG_ZMM30: Type = 216;
    pub const X86_REG_ZMM31: Type = 217;
    pub const X86_REG_R8B: Type = 218;
    pub const X86_REG_R9B: Type = 219;
    pub const X86_REG_R10B: Type = 220;
    pub const X86_REG_R11B: Type = 221;
    pub const X86_REG_R12B: Type = 222;
    pub const X86_REG_R13B: Type = 223;
    pub const X86_REG_R14B: Type = 224;
    pub const X86_REG_R15B: Type = 225;
    pub const X86_REG_R8D: Type = 226;
    pub const X86_REG_R9D: Type = 227;
    pub const X86_REG_R10D: Type = 228;
    pub const X86_REG_R11D: Type = 229;
    pub const X86_REG_R12D: Type = 230;
    pub const X86_REG_R13D: Type = 231;
    pub const X86_REG_R14D: Type = 232;
    pub const X86_REG_R15D: Type = 233;
    pub const X86_REG_R8W: Type = 234;
    pub const X86_REG_R9W: Type = 235;
    pub const X86_REG_R10W: Type = 236;
    pub const X86_REG_R11W: Type = 237;
    pub const X86_REG_R12W: Type = 238;
    pub const X86_REG_R13W: Type = 239;
    pub const X86_REG_R14W: Type = 240;
    pub const X86_REG_R15W: Type = 241;
    pub const X86_REG_ENDING: Type = 242;
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum x86_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    X86_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    X86_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    X86_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    X86_OP_MEM = 3,
}
#[repr(u32)]
#[doc = " XOP Code Condition type"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum x86_xop_cc {
    #[doc = "< Uninitialized."]
    X86_XOP_CC_INVALID = 0,
    X86_XOP_CC_LT = 1,
    X86_XOP_CC_LE = 2,
    X86_XOP_CC_GT = 3,
    X86_XOP_CC_GE = 4,
    X86_XOP_CC_EQ = 5,
    X86_XOP_CC_NEQ = 6,
    X86_XOP_CC_FALSE = 7,
    X86_XOP_CC_TRUE = 8,
}
#[repr(u32)]
#[doc = " AVX broadcast type"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum x86_avx_bcast {
    #[doc = "< Uninitialized."]
    X86_AVX_BCAST_INVALID = 0,
    #[doc = "< AVX512 broadcast type {1to2}"]
    X86_AVX_BCAST_2 = 1,
    #[doc = "< AVX512 broadcast type {1to4}"]
    X86_AVX_BCAST_4 = 2,
    #[doc = "< AVX512 broadcast type {1to8}"]
    X86_AVX_BCAST_8 = 3,
    #[doc = "< AVX512 broadcast type {1to16}"]
    X86_AVX_BCAST_16 = 4,
}
#[repr(u32)]
#[doc = " SSE Code Condition type"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum x86_sse_cc {
    #[doc = "< Uninitialized."]
    X86_SSE_CC_INVALID = 0,
    X86_SSE_CC_EQ = 1,
    X86_SSE_CC_LT = 2,
    X86_SSE_CC_LE = 3,
    X86_SSE_CC_UNORD = 4,
    X86_SSE_CC_NEQ = 5,
    X86_SSE_CC_NLT = 6,
    X86_SSE_CC_NLE = 7,
    X86_SSE_CC_ORD = 8,
}
#[repr(u32)]
#[doc = " AVX Code Condition type"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum x86_avx_cc {
    #[doc = "< Uninitialized."]
    X86_AVX_CC_INVALID = 0,
    X86_AVX_CC_EQ = 1,
    X86_AVX_CC_LT = 2,
    X86_AVX_CC_LE = 3,
    X86_AVX_CC_UNORD = 4,
    X86_AVX_CC_NEQ = 5,
    X86_AVX_CC_NLT = 6,
    X86_AVX_CC_NLE = 7,
    X86_AVX_CC_ORD = 8,
    X86_AVX_CC_EQ_UQ = 9,
    X86_AVX_CC_NGE = 10,
    X86_AVX_CC_NGT = 11,
    X86_AVX_CC_FALSE = 12,
    X86_AVX_CC_NEQ_OQ = 13,
    X86_AVX_CC_GE = 14,
    X86_AVX_CC_GT = 15,
    X86_AVX_CC_TRUE = 16,
    X86_AVX_CC_EQ_OS = 17,
    X86_AVX_CC_LT_OQ = 18,
    X86_AVX_CC_LE_OQ = 19,
    X86_AVX_CC_UNORD_S = 20,
    X86_AVX_CC_NEQ_US = 21,
    X86_AVX_CC_NLT_UQ = 22,
    X86_AVX_CC_NLE_UQ = 23,
    X86_AVX_CC_ORD_S = 24,
    X86_AVX_CC_EQ_US = 25,
    X86_AVX_CC_NGE_UQ = 26,
    X86_AVX_CC_NGT_UQ = 27,
    X86_AVX_CC_FALSE_OS = 28,
    X86_AVX_CC_NEQ_OS = 29,
    X86_AVX_CC_GE_OQ = 30,
    X86_AVX_CC_GT_OQ = 31,
    X86_AVX_CC_TRUE_US = 32,
}
#[repr(u32)]
#[doc = " AVX static rounding mode type"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum x86_avx_rm {
    #[doc = "< Uninitialized."]
    X86_AVX_RM_INVALID = 0,
    #[doc = "< Round to nearest"]
    X86_AVX_RM_RN = 1,
    #[doc = "< Round down"]
    X86_AVX_RM_RD = 2,
    #[doc = "< Round up"]
    X86_AVX_RM_RU = 3,
    #[doc = "< Round toward zero"]
    X86_AVX_RM_RZ = 4,
}
pub const X86_PREFIX_REPE: x86_prefix = x86_prefix::X86_PREFIX_REP;
#[repr(u32)]
#[doc = " Instruction prefixes - to be used in cs_x86.prefix[]"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum x86_prefix {
    #[doc = "< lock (cs_x86.prefix[0]"]
    X86_PREFIX_LOCK = 240,
    #[doc = "< rep (cs_x86.prefix[0]"]
    X86_PREFIX_REP = 243,
    #[doc = "< repne/repnz (cs_x86.prefix[0]"]
    X86_PREFIX_REPNE = 242,
    #[doc = "< segment override CS (cs_x86.prefix[1]"]
    X86_PREFIX_CS = 46,
    #[doc = "< segment override SS (cs_x86.prefix[1]"]
    X86_PREFIX_SS = 54,
    #[doc = "< segment override DS (cs_x86.prefix[1]"]
    X86_PREFIX_DS = 62,
    #[doc = "< segment override ES (cs_x86.prefix[1]"]
    X86_PREFIX_ES = 38,
    #[doc = "< segment override FS (cs_x86.prefix[1]"]
    X86_PREFIX_FS = 100,
    #[doc = "< segment override GS (cs_x86.prefix[1]"]
    X86_PREFIX_GS = 101,
    #[doc = "< operand-size override (cs_x86.prefix[2]"]
    X86_PREFIX_OPSIZE = 102,
    #[doc = "< address-size override (cs_x86.prefix[3]"]
    X86_PREFIX_ADDRSIZE = 103,
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with X86_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct x86_op_mem {
    #[doc = "< segment register (or X86_REG_INVALID if irrelevant)"]
    pub segment: x86_reg::Type,
    #[doc = "< base register (or X86_REG_INVALID if irrelevant)"]
    pub base: x86_reg::Type,
    #[doc = "< index register (or X86_REG_INVALID if irrelevant)"]
    pub index: x86_reg::Type,
    #[doc = "< scale for index register"]
    pub scale: libc::c_int,
    #[doc = "< displacement value"]
    pub disp: i64,
}
impl Clone for x86_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_x86_op {
    #[doc = "< operand type"]
    pub type_: x86_op_type,
    pub __bindgen_anon_1: cs_x86_op__bindgen_ty_1,
    #[doc = " size of this operand (in bytes)."]
    pub size: u8,
    #[doc = " How is this operand accessed? (READ, WRITE or READ|WRITE)"]
    #[doc = " This field is combined of cs_ac_type."]
    #[doc = " NOTE: this field is irrelevant if engine is compiled in DIET mode."]
    pub access: u8,
    #[doc = " AVX broadcast type, or 0 if irrelevant"]
    pub avx_bcast: x86_avx_bcast,
    #[doc = " AVX zero opmask {z}"]
    pub avx_zero_opmask: bool,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_x86_op__bindgen_ty_1 {
    #[doc = "< register value for REG operand"]
    pub reg: x86_reg::Type,
    #[doc = "< immediate value for IMM operand"]
    pub imm: i64,
    #[doc = "< base/index/scale/disp value for MEM operand"]
    pub mem: x86_op_mem,
    _bindgen_union_align: [u64; 3usize],
}
impl Clone for cs_x86_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_x86_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_x86_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_x86_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_x86_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! ( f , "cs_x86_op {{ type: {:?}, __bindgen_anon_1: {:?}, size: {:?}, access: {:?}, avx_bcast: {:?}, avx_zero_opmask: {:?} }}" , self . type_ , self . __bindgen_anon_1 , self . size , self . access , self . avx_bcast , self . avx_zero_opmask )
    }
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_x86_encoding {
    #[doc = " ModR/M offset, or 0 when irrelevant"]
    pub modrm_offset: u8,
    #[doc = " Displacement offset, or 0 when irrelevant."]
    pub disp_offset: u8,
    pub disp_size: u8,
    #[doc = " Immediate offset, or 0 when irrelevant."]
    pub imm_offset: u8,
    pub imm_size: u8,
}
impl Clone for cs_x86_encoding {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_x86 {
    #[doc = " Instruction prefix, which can be up to 4 bytes."]
    #[doc = " A prefix byte gets value 0 when irrelevant."]
    #[doc = " prefix[0] indicates REP/REPNE/LOCK prefix (See X86_PREFIX_REP/REPNE/LOCK above)"]
    #[doc = " prefix[1] indicates segment override (irrelevant for x86_64):"]
    #[doc = " See X86_PREFIX_CS/SS/DS/ES/FS/GS above."]
    #[doc = " prefix[2] indicates operand-size override (X86_PREFIX_OPSIZE)"]
    #[doc = " prefix[3] indicates address-size override (X86_PREFIX_ADDRSIZE)"]
    pub prefix: [u8; 4usize],
    #[doc = " Instruction opcode, which can be from 1 to 4 bytes in size."]
    #[doc = " This contains VEX opcode as well."]
    #[doc = " An trailing opcode byte gets value 0 when irrelevant."]
    pub opcode: [u8; 4usize],
    #[doc = " REX prefix: only a non-zero value is relevant for x86_64"]
    pub rex: u8,
    #[doc = " Address size, which can be overridden with above prefix[5]."]
    pub addr_size: u8,
    #[doc = " ModR/M byte"]
    pub modrm: u8,
    #[doc = " SIB value, or 0 when irrelevant."]
    pub sib: u8,
    #[doc = " Displacement value, valid if encoding.disp_offset != 0"]
    pub disp: i64,
    #[doc = " SIB index register, or X86_REG_INVALID when irrelevant."]
    pub sib_index: x86_reg::Type,
    #[doc = " SIB scale, only applicable if sib_index is valid."]
    pub sib_scale: i8,
    #[doc = " SIB base register, or X86_REG_INVALID when irrelevant."]
    pub sib_base: x86_reg::Type,
    #[doc = " XOP Code Condition"]
    pub xop_cc: x86_xop_cc,
    #[doc = " SSE Code Condition"]
    pub sse_cc: x86_sse_cc,
    #[doc = " AVX Code Condition"]
    pub avx_cc: x86_avx_cc,
    #[doc = " AVX Suppress all Exception"]
    pub avx_sae: bool,
    #[doc = " AVX static rounding mode"]
    pub avx_rm: x86_avx_rm,
    pub __bindgen_anon_1: cs_x86__bindgen_ty_1,
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_x86_op; 8usize],
    #[doc = "< encoding information"]
    pub encoding: cs_x86_encoding,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_x86__bindgen_ty_1 {
    #[doc = " EFLAGS updated by this instruction."]
    #[doc = " This can be formed from OR combination of X86_EFLAGS_* symbols in x86.h"]
    pub eflags: u64,
    #[doc = " FPU_FLAGS updated by this instruction."]
    #[doc = " This can be formed from OR combination of X86_FPU_FLAGS_* symbols in x86.h"]
    pub fpu_flags: u64,
    _bindgen_union_align: u64,
}
impl Clone for cs_x86__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_x86__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_x86__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_x86 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_x86 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! ( f , "cs_x86 {{ prefix: {:?}, opcode: {:?}, rex: {:?}, addr_size: {:?}, modrm: {:?}, sib: {:?}, disp: {:?}, sib_index: {:?}, sib_scale: {:?}, sib_base: {:?}, xop_cc: {:?}, sse_cc: {:?}, avx_cc: {:?}, avx_sae: {:?}, avx_rm: {:?}, __bindgen_anon_1: {:?}, op_count: {:?}, operands: {:?}, encoding: {:?} }}" , self . prefix , self . opcode , self . rex , self . addr_size , self . modrm , self . sib , self . disp , self . sib_index , self . sib_scale , self . sib_base , self . xop_cc , self . sse_cc , self . avx_cc , self . avx_sae , self . avx_rm , self . __bindgen_anon_1 , self . op_count , self . operands , self . encoding )
    }
}
#[repr(u32)]
#[doc = " X86 instructions"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum x86_insn {
    X86_INS_INVALID = 0,
    X86_INS_AAA = 1,
    X86_INS_AAD = 2,
    X86_INS_AAM = 3,
    X86_INS_AAS = 4,
    X86_INS_FABS = 5,
    X86_INS_ADC = 6,
    X86_INS_ADCX = 7,
    X86_INS_ADD = 8,
    X86_INS_ADDPD = 9,
    X86_INS_ADDPS = 10,
    X86_INS_ADDSD = 11,
    X86_INS_ADDSS = 12,
    X86_INS_ADDSUBPD = 13,
    X86_INS_ADDSUBPS = 14,
    X86_INS_FADD = 15,
    X86_INS_FIADD = 16,
    X86_INS_FADDP = 17,
    X86_INS_ADOX = 18,
    X86_INS_AESDECLAST = 19,
    X86_INS_AESDEC = 20,
    X86_INS_AESENCLAST = 21,
    X86_INS_AESENC = 22,
    X86_INS_AESIMC = 23,
    X86_INS_AESKEYGENASSIST = 24,
    X86_INS_AND = 25,
    X86_INS_ANDN = 26,
    X86_INS_ANDNPD = 27,
    X86_INS_ANDNPS = 28,
    X86_INS_ANDPD = 29,
    X86_INS_ANDPS = 30,
    X86_INS_ARPL = 31,
    X86_INS_BEXTR = 32,
    X86_INS_BLCFILL = 33,
    X86_INS_BLCI = 34,
    X86_INS_BLCIC = 35,
    X86_INS_BLCMSK = 36,
    X86_INS_BLCS = 37,
    X86_INS_BLENDPD = 38,
    X86_INS_BLENDPS = 39,
    X86_INS_BLENDVPD = 40,
    X86_INS_BLENDVPS = 41,
    X86_INS_BLSFILL = 42,
    X86_INS_BLSI = 43,
    X86_INS_BLSIC = 44,
    X86_INS_BLSMSK = 45,
    X86_INS_BLSR = 46,
    X86_INS_BOUND = 47,
    X86_INS_BSF = 48,
    X86_INS_BSR = 49,
    X86_INS_BSWAP = 50,
    X86_INS_BT = 51,
    X86_INS_BTC = 52,
    X86_INS_BTR = 53,
    X86_INS_BTS = 54,
    X86_INS_BZHI = 55,
    X86_INS_CALL = 56,
    X86_INS_CBW = 57,
    X86_INS_CDQ = 58,
    X86_INS_CDQE = 59,
    X86_INS_FCHS = 60,
    X86_INS_CLAC = 61,
    X86_INS_CLC = 62,
    X86_INS_CLD = 63,
    X86_INS_CLFLUSH = 64,
    X86_INS_CLFLUSHOPT = 65,
    X86_INS_CLGI = 66,
    X86_INS_CLI = 67,
    X86_INS_CLTS = 68,
    X86_INS_CLWB = 69,
    X86_INS_CMC = 70,
    X86_INS_CMOVA = 71,
    X86_INS_CMOVAE = 72,
    X86_INS_CMOVB = 73,
    X86_INS_CMOVBE = 74,
    X86_INS_FCMOVBE = 75,
    X86_INS_FCMOVB = 76,
    X86_INS_CMOVE = 77,
    X86_INS_FCMOVE = 78,
    X86_INS_CMOVG = 79,
    X86_INS_CMOVGE = 80,
    X86_INS_CMOVL = 81,
    X86_INS_CMOVLE = 82,
    X86_INS_FCMOVNBE = 83,
    X86_INS_FCMOVNB = 84,
    X86_INS_CMOVNE = 85,
    X86_INS_FCMOVNE = 86,
    X86_INS_CMOVNO = 87,
    X86_INS_CMOVNP = 88,
    X86_INS_FCMOVNU = 89,
    X86_INS_CMOVNS = 90,
    X86_INS_CMOVO = 91,
    X86_INS_CMOVP = 92,
    X86_INS_FCMOVU = 93,
    X86_INS_CMOVS = 94,
    X86_INS_CMP = 95,
    X86_INS_CMPSB = 96,
    X86_INS_CMPSQ = 97,
    X86_INS_CMPSW = 98,
    X86_INS_CMPXCHG16B = 99,
    X86_INS_CMPXCHG = 100,
    X86_INS_CMPXCHG8B = 101,
    X86_INS_COMISD = 102,
    X86_INS_COMISS = 103,
    X86_INS_FCOMP = 104,
    X86_INS_FCOMIP = 105,
    X86_INS_FCOMI = 106,
    X86_INS_FCOM = 107,
    X86_INS_FCOS = 108,
    X86_INS_CPUID = 109,
    X86_INS_CQO = 110,
    X86_INS_CRC32 = 111,
    X86_INS_CVTDQ2PD = 112,
    X86_INS_CVTDQ2PS = 113,
    X86_INS_CVTPD2DQ = 114,
    X86_INS_CVTPD2PS = 115,
    X86_INS_CVTPS2DQ = 116,
    X86_INS_CVTPS2PD = 117,
    X86_INS_CVTSD2SI = 118,
    X86_INS_CVTSD2SS = 119,
    X86_INS_CVTSI2SD = 120,
    X86_INS_CVTSI2SS = 121,
    X86_INS_CVTSS2SD = 122,
    X86_INS_CVTSS2SI = 123,
    X86_INS_CVTTPD2DQ = 124,
    X86_INS_CVTTPS2DQ = 125,
    X86_INS_CVTTSD2SI = 126,
    X86_INS_CVTTSS2SI = 127,
    X86_INS_CWD = 128,
    X86_INS_CWDE = 129,
    X86_INS_DAA = 130,
    X86_INS_DAS = 131,
    X86_INS_DATA16 = 132,
    X86_INS_DEC = 133,
    X86_INS_DIV = 134,
    X86_INS_DIVPD = 135,
    X86_INS_DIVPS = 136,
    X86_INS_FDIVR = 137,
    X86_INS_FIDIVR = 138,
    X86_INS_FDIVRP = 139,
    X86_INS_DIVSD = 140,
    X86_INS_DIVSS = 141,
    X86_INS_FDIV = 142,
    X86_INS_FIDIV = 143,
    X86_INS_FDIVP = 144,
    X86_INS_DPPD = 145,
    X86_INS_DPPS = 146,
    X86_INS_RET = 147,
    X86_INS_ENCLS = 148,
    X86_INS_ENCLU = 149,
    X86_INS_ENTER = 150,
    X86_INS_EXTRACTPS = 151,
    X86_INS_EXTRQ = 152,
    X86_INS_F2XM1 = 153,
    X86_INS_LCALL = 154,
    X86_INS_LJMP = 155,
    X86_INS_FBLD = 156,
    X86_INS_FBSTP = 157,
    X86_INS_FCOMPP = 158,
    X86_INS_FDECSTP = 159,
    X86_INS_FEMMS = 160,
    X86_INS_FFREE = 161,
    X86_INS_FICOM = 162,
    X86_INS_FICOMP = 163,
    X86_INS_FINCSTP = 164,
    X86_INS_FLDCW = 165,
    X86_INS_FLDENV = 166,
    X86_INS_FLDL2E = 167,
    X86_INS_FLDL2T = 168,
    X86_INS_FLDLG2 = 169,
    X86_INS_FLDLN2 = 170,
    X86_INS_FLDPI = 171,
    X86_INS_FNCLEX = 172,
    X86_INS_FNINIT = 173,
    X86_INS_FNOP = 174,
    X86_INS_FNSTCW = 175,
    X86_INS_FNSTSW = 176,
    X86_INS_FPATAN = 177,
    X86_INS_FPREM = 178,
    X86_INS_FPREM1 = 179,
    X86_INS_FPTAN = 180,
    X86_INS_FFREEP = 181,
    X86_INS_FRNDINT = 182,
    X86_INS_FRSTOR = 183,
    X86_INS_FNSAVE = 184,
    X86_INS_FSCALE = 185,
    X86_INS_FSETPM = 186,
    X86_INS_FSINCOS = 187,
    X86_INS_FNSTENV = 188,
    X86_INS_FXAM = 189,
    X86_INS_FXRSTOR = 190,
    X86_INS_FXRSTOR64 = 191,
    X86_INS_FXSAVE = 192,
    X86_INS_FXSAVE64 = 193,
    X86_INS_FXTRACT = 194,
    X86_INS_FYL2X = 195,
    X86_INS_FYL2XP1 = 196,
    X86_INS_MOVAPD = 197,
    X86_INS_MOVAPS = 198,
    X86_INS_ORPD = 199,
    X86_INS_ORPS = 200,
    X86_INS_VMOVAPD = 201,
    X86_INS_VMOVAPS = 202,
    X86_INS_XORPD = 203,
    X86_INS_XORPS = 204,
    X86_INS_GETSEC = 205,
    X86_INS_HADDPD = 206,
    X86_INS_HADDPS = 207,
    X86_INS_HLT = 208,
    X86_INS_HSUBPD = 209,
    X86_INS_HSUBPS = 210,
    X86_INS_IDIV = 211,
    X86_INS_FILD = 212,
    X86_INS_IMUL = 213,
    X86_INS_IN = 214,
    X86_INS_INC = 215,
    X86_INS_INSB = 216,
    X86_INS_INSERTPS = 217,
    X86_INS_INSERTQ = 218,
    X86_INS_INSD = 219,
    X86_INS_INSW = 220,
    X86_INS_INT = 221,
    X86_INS_INT1 = 222,
    X86_INS_INT3 = 223,
    X86_INS_INTO = 224,
    X86_INS_INVD = 225,
    X86_INS_INVEPT = 226,
    X86_INS_INVLPG = 227,
    X86_INS_INVLPGA = 228,
    X86_INS_INVPCID = 229,
    X86_INS_INVVPID = 230,
    X86_INS_IRET = 231,
    X86_INS_IRETD = 232,
    X86_INS_IRETQ = 233,
    X86_INS_FISTTP = 234,
    X86_INS_FIST = 235,
    X86_INS_FISTP = 236,
    X86_INS_UCOMISD = 237,
    X86_INS_UCOMISS = 238,
    X86_INS_VCOMISD = 239,
    X86_INS_VCOMISS = 240,
    X86_INS_VCVTSD2SS = 241,
    X86_INS_VCVTSI2SD = 242,
    X86_INS_VCVTSI2SS = 243,
    X86_INS_VCVTSS2SD = 244,
    X86_INS_VCVTTSD2SI = 245,
    X86_INS_VCVTTSD2USI = 246,
    X86_INS_VCVTTSS2SI = 247,
    X86_INS_VCVTTSS2USI = 248,
    X86_INS_VCVTUSI2SD = 249,
    X86_INS_VCVTUSI2SS = 250,
    X86_INS_VUCOMISD = 251,
    X86_INS_VUCOMISS = 252,
    X86_INS_JAE = 253,
    X86_INS_JA = 254,
    X86_INS_JBE = 255,
    X86_INS_JB = 256,
    X86_INS_JCXZ = 257,
    X86_INS_JECXZ = 258,
    X86_INS_JE = 259,
    X86_INS_JGE = 260,
    X86_INS_JG = 261,
    X86_INS_JLE = 262,
    X86_INS_JL = 263,
    X86_INS_JMP = 264,
    X86_INS_JNE = 265,
    X86_INS_JNO = 266,
    X86_INS_JNP = 267,
    X86_INS_JNS = 268,
    X86_INS_JO = 269,
    X86_INS_JP = 270,
    X86_INS_JRCXZ = 271,
    X86_INS_JS = 272,
    X86_INS_KANDB = 273,
    X86_INS_KANDD = 274,
    X86_INS_KANDNB = 275,
    X86_INS_KANDND = 276,
    X86_INS_KANDNQ = 277,
    X86_INS_KANDNW = 278,
    X86_INS_KANDQ = 279,
    X86_INS_KANDW = 280,
    X86_INS_KMOVB = 281,
    X86_INS_KMOVD = 282,
    X86_INS_KMOVQ = 283,
    X86_INS_KMOVW = 284,
    X86_INS_KNOTB = 285,
    X86_INS_KNOTD = 286,
    X86_INS_KNOTQ = 287,
    X86_INS_KNOTW = 288,
    X86_INS_KORB = 289,
    X86_INS_KORD = 290,
    X86_INS_KORQ = 291,
    X86_INS_KORTESTB = 292,
    X86_INS_KORTESTD = 293,
    X86_INS_KORTESTQ = 294,
    X86_INS_KORTESTW = 295,
    X86_INS_KORW = 296,
    X86_INS_KSHIFTLB = 297,
    X86_INS_KSHIFTLD = 298,
    X86_INS_KSHIFTLQ = 299,
    X86_INS_KSHIFTLW = 300,
    X86_INS_KSHIFTRB = 301,
    X86_INS_KSHIFTRD = 302,
    X86_INS_KSHIFTRQ = 303,
    X86_INS_KSHIFTRW = 304,
    X86_INS_KUNPCKBW = 305,
    X86_INS_KXNORB = 306,
    X86_INS_KXNORD = 307,
    X86_INS_KXNORQ = 308,
    X86_INS_KXNORW = 309,
    X86_INS_KXORB = 310,
    X86_INS_KXORD = 311,
    X86_INS_KXORQ = 312,
    X86_INS_KXORW = 313,
    X86_INS_LAHF = 314,
    X86_INS_LAR = 315,
    X86_INS_LDDQU = 316,
    X86_INS_LDMXCSR = 317,
    X86_INS_LDS = 318,
    X86_INS_FLDZ = 319,
    X86_INS_FLD1 = 320,
    X86_INS_FLD = 321,
    X86_INS_LEA = 322,
    X86_INS_LEAVE = 323,
    X86_INS_LES = 324,
    X86_INS_LFENCE = 325,
    X86_INS_LFS = 326,
    X86_INS_LGDT = 327,
    X86_INS_LGS = 328,
    X86_INS_LIDT = 329,
    X86_INS_LLDT = 330,
    X86_INS_LMSW = 331,
    X86_INS_OR = 332,
    X86_INS_SUB = 333,
    X86_INS_XOR = 334,
    X86_INS_LODSB = 335,
    X86_INS_LODSD = 336,
    X86_INS_LODSQ = 337,
    X86_INS_LODSW = 338,
    X86_INS_LOOP = 339,
    X86_INS_LOOPE = 340,
    X86_INS_LOOPNE = 341,
    X86_INS_RETF = 342,
    X86_INS_RETFQ = 343,
    X86_INS_LSL = 344,
    X86_INS_LSS = 345,
    X86_INS_LTR = 346,
    X86_INS_XADD = 347,
    X86_INS_LZCNT = 348,
    X86_INS_MASKMOVDQU = 349,
    X86_INS_MAXPD = 350,
    X86_INS_MAXPS = 351,
    X86_INS_MAXSD = 352,
    X86_INS_MAXSS = 353,
    X86_INS_MFENCE = 354,
    X86_INS_MINPD = 355,
    X86_INS_MINPS = 356,
    X86_INS_MINSD = 357,
    X86_INS_MINSS = 358,
    X86_INS_CVTPD2PI = 359,
    X86_INS_CVTPI2PD = 360,
    X86_INS_CVTPI2PS = 361,
    X86_INS_CVTPS2PI = 362,
    X86_INS_CVTTPD2PI = 363,
    X86_INS_CVTTPS2PI = 364,
    X86_INS_EMMS = 365,
    X86_INS_MASKMOVQ = 366,
    X86_INS_MOVD = 367,
    X86_INS_MOVDQ2Q = 368,
    X86_INS_MOVNTQ = 369,
    X86_INS_MOVQ2DQ = 370,
    X86_INS_MOVQ = 371,
    X86_INS_PABSB = 372,
    X86_INS_PABSD = 373,
    X86_INS_PABSW = 374,
    X86_INS_PACKSSDW = 375,
    X86_INS_PACKSSWB = 376,
    X86_INS_PACKUSWB = 377,
    X86_INS_PADDB = 378,
    X86_INS_PADDD = 379,
    X86_INS_PADDQ = 380,
    X86_INS_PADDSB = 381,
    X86_INS_PADDSW = 382,
    X86_INS_PADDUSB = 383,
    X86_INS_PADDUSW = 384,
    X86_INS_PADDW = 385,
    X86_INS_PALIGNR = 386,
    X86_INS_PANDN = 387,
    X86_INS_PAND = 388,
    X86_INS_PAVGB = 389,
    X86_INS_PAVGW = 390,
    X86_INS_PCMPEQB = 391,
    X86_INS_PCMPEQD = 392,
    X86_INS_PCMPEQW = 393,
    X86_INS_PCMPGTB = 394,
    X86_INS_PCMPGTD = 395,
    X86_INS_PCMPGTW = 396,
    X86_INS_PEXTRW = 397,
    X86_INS_PHADDSW = 398,
    X86_INS_PHADDW = 399,
    X86_INS_PHADDD = 400,
    X86_INS_PHSUBD = 401,
    X86_INS_PHSUBSW = 402,
    X86_INS_PHSUBW = 403,
    X86_INS_PINSRW = 404,
    X86_INS_PMADDUBSW = 405,
    X86_INS_PMADDWD = 406,
    X86_INS_PMAXSW = 407,
    X86_INS_PMAXUB = 408,
    X86_INS_PMINSW = 409,
    X86_INS_PMINUB = 410,
    X86_INS_PMOVMSKB = 411,
    X86_INS_PMULHRSW = 412,
    X86_INS_PMULHUW = 413,
    X86_INS_PMULHW = 414,
    X86_INS_PMULLW = 415,
    X86_INS_PMULUDQ = 416,
    X86_INS_POR = 417,
    X86_INS_PSADBW = 418,
    X86_INS_PSHUFB = 419,
    X86_INS_PSHUFW = 420,
    X86_INS_PSIGNB = 421,
    X86_INS_PSIGND = 422,
    X86_INS_PSIGNW = 423,
    X86_INS_PSLLD = 424,
    X86_INS_PSLLQ = 425,
    X86_INS_PSLLW = 426,
    X86_INS_PSRAD = 427,
    X86_INS_PSRAW = 428,
    X86_INS_PSRLD = 429,
    X86_INS_PSRLQ = 430,
    X86_INS_PSRLW = 431,
    X86_INS_PSUBB = 432,
    X86_INS_PSUBD = 433,
    X86_INS_PSUBQ = 434,
    X86_INS_PSUBSB = 435,
    X86_INS_PSUBSW = 436,
    X86_INS_PSUBUSB = 437,
    X86_INS_PSUBUSW = 438,
    X86_INS_PSUBW = 439,
    X86_INS_PUNPCKHBW = 440,
    X86_INS_PUNPCKHDQ = 441,
    X86_INS_PUNPCKHWD = 442,
    X86_INS_PUNPCKLBW = 443,
    X86_INS_PUNPCKLDQ = 444,
    X86_INS_PUNPCKLWD = 445,
    X86_INS_PXOR = 446,
    X86_INS_MONITOR = 447,
    X86_INS_MONTMUL = 448,
    X86_INS_MOV = 449,
    X86_INS_MOVABS = 450,
    X86_INS_MOVBE = 451,
    X86_INS_MOVDDUP = 452,
    X86_INS_MOVDQA = 453,
    X86_INS_MOVDQU = 454,
    X86_INS_MOVHLPS = 455,
    X86_INS_MOVHPD = 456,
    X86_INS_MOVHPS = 457,
    X86_INS_MOVLHPS = 458,
    X86_INS_MOVLPD = 459,
    X86_INS_MOVLPS = 460,
    X86_INS_MOVMSKPD = 461,
    X86_INS_MOVMSKPS = 462,
    X86_INS_MOVNTDQA = 463,
    X86_INS_MOVNTDQ = 464,
    X86_INS_MOVNTI = 465,
    X86_INS_MOVNTPD = 466,
    X86_INS_MOVNTPS = 467,
    X86_INS_MOVNTSD = 468,
    X86_INS_MOVNTSS = 469,
    X86_INS_MOVSB = 470,
    X86_INS_MOVSD = 471,
    X86_INS_MOVSHDUP = 472,
    X86_INS_MOVSLDUP = 473,
    X86_INS_MOVSQ = 474,
    X86_INS_MOVSS = 475,
    X86_INS_MOVSW = 476,
    X86_INS_MOVSX = 477,
    X86_INS_MOVSXD = 478,
    X86_INS_MOVUPD = 479,
    X86_INS_MOVUPS = 480,
    X86_INS_MOVZX = 481,
    X86_INS_MPSADBW = 482,
    X86_INS_MUL = 483,
    X86_INS_MULPD = 484,
    X86_INS_MULPS = 485,
    X86_INS_MULSD = 486,
    X86_INS_MULSS = 487,
    X86_INS_MULX = 488,
    X86_INS_FMUL = 489,
    X86_INS_FIMUL = 490,
    X86_INS_FMULP = 491,
    X86_INS_MWAIT = 492,
    X86_INS_NEG = 493,
    X86_INS_NOP = 494,
    X86_INS_NOT = 495,
    X86_INS_OUT = 496,
    X86_INS_OUTSB = 497,
    X86_INS_OUTSD = 498,
    X86_INS_OUTSW = 499,
    X86_INS_PACKUSDW = 500,
    X86_INS_PAUSE = 501,
    X86_INS_PAVGUSB = 502,
    X86_INS_PBLENDVB = 503,
    X86_INS_PBLENDW = 504,
    X86_INS_PCLMULQDQ = 505,
    X86_INS_PCMPEQQ = 506,
    X86_INS_PCMPESTRI = 507,
    X86_INS_PCMPESTRM = 508,
    X86_INS_PCMPGTQ = 509,
    X86_INS_PCMPISTRI = 510,
    X86_INS_PCMPISTRM = 511,
    X86_INS_PCOMMIT = 512,
    X86_INS_PDEP = 513,
    X86_INS_PEXT = 514,
    X86_INS_PEXTRB = 515,
    X86_INS_PEXTRD = 516,
    X86_INS_PEXTRQ = 517,
    X86_INS_PF2ID = 518,
    X86_INS_PF2IW = 519,
    X86_INS_PFACC = 520,
    X86_INS_PFADD = 521,
    X86_INS_PFCMPEQ = 522,
    X86_INS_PFCMPGE = 523,
    X86_INS_PFCMPGT = 524,
    X86_INS_PFMAX = 525,
    X86_INS_PFMIN = 526,
    X86_INS_PFMUL = 527,
    X86_INS_PFNACC = 528,
    X86_INS_PFPNACC = 529,
    X86_INS_PFRCPIT1 = 530,
    X86_INS_PFRCPIT2 = 531,
    X86_INS_PFRCP = 532,
    X86_INS_PFRSQIT1 = 533,
    X86_INS_PFRSQRT = 534,
    X86_INS_PFSUBR = 535,
    X86_INS_PFSUB = 536,
    X86_INS_PHMINPOSUW = 537,
    X86_INS_PI2FD = 538,
    X86_INS_PI2FW = 539,
    X86_INS_PINSRB = 540,
    X86_INS_PINSRD = 541,
    X86_INS_PINSRQ = 542,
    X86_INS_PMAXSB = 543,
    X86_INS_PMAXSD = 544,
    X86_INS_PMAXUD = 545,
    X86_INS_PMAXUW = 546,
    X86_INS_PMINSB = 547,
    X86_INS_PMINSD = 548,
    X86_INS_PMINUD = 549,
    X86_INS_PMINUW = 550,
    X86_INS_PMOVSXBD = 551,
    X86_INS_PMOVSXBQ = 552,
    X86_INS_PMOVSXBW = 553,
    X86_INS_PMOVSXDQ = 554,
    X86_INS_PMOVSXWD = 555,
    X86_INS_PMOVSXWQ = 556,
    X86_INS_PMOVZXBD = 557,
    X86_INS_PMOVZXBQ = 558,
    X86_INS_PMOVZXBW = 559,
    X86_INS_PMOVZXDQ = 560,
    X86_INS_PMOVZXWD = 561,
    X86_INS_PMOVZXWQ = 562,
    X86_INS_PMULDQ = 563,
    X86_INS_PMULHRW = 564,
    X86_INS_PMULLD = 565,
    X86_INS_POP = 566,
    X86_INS_POPAW = 567,
    X86_INS_POPAL = 568,
    X86_INS_POPCNT = 569,
    X86_INS_POPF = 570,
    X86_INS_POPFD = 571,
    X86_INS_POPFQ = 572,
    X86_INS_PREFETCH = 573,
    X86_INS_PREFETCHNTA = 574,
    X86_INS_PREFETCHT0 = 575,
    X86_INS_PREFETCHT1 = 576,
    X86_INS_PREFETCHT2 = 577,
    X86_INS_PREFETCHW = 578,
    X86_INS_PSHUFD = 579,
    X86_INS_PSHUFHW = 580,
    X86_INS_PSHUFLW = 581,
    X86_INS_PSLLDQ = 582,
    X86_INS_PSRLDQ = 583,
    X86_INS_PSWAPD = 584,
    X86_INS_PTEST = 585,
    X86_INS_PUNPCKHQDQ = 586,
    X86_INS_PUNPCKLQDQ = 587,
    X86_INS_PUSH = 588,
    X86_INS_PUSHAW = 589,
    X86_INS_PUSHAL = 590,
    X86_INS_PUSHF = 591,
    X86_INS_PUSHFD = 592,
    X86_INS_PUSHFQ = 593,
    X86_INS_RCL = 594,
    X86_INS_RCPPS = 595,
    X86_INS_RCPSS = 596,
    X86_INS_RCR = 597,
    X86_INS_RDFSBASE = 598,
    X86_INS_RDGSBASE = 599,
    X86_INS_RDMSR = 600,
    X86_INS_RDPMC = 601,
    X86_INS_RDRAND = 602,
    X86_INS_RDSEED = 603,
    X86_INS_RDTSC = 604,
    X86_INS_RDTSCP = 605,
    X86_INS_ROL = 606,
    X86_INS_ROR = 607,
    X86_INS_RORX = 608,
    X86_INS_ROUNDPD = 609,
    X86_INS_ROUNDPS = 610,
    X86_INS_ROUNDSD = 611,
    X86_INS_ROUNDSS = 612,
    X86_INS_RSM = 613,
    X86_INS_RSQRTPS = 614,
    X86_INS_RSQRTSS = 615,
    X86_INS_SAHF = 616,
    X86_INS_SAL = 617,
    X86_INS_SALC = 618,
    X86_INS_SAR = 619,
    X86_INS_SARX = 620,
    X86_INS_SBB = 621,
    X86_INS_SCASB = 622,
    X86_INS_SCASD = 623,
    X86_INS_SCASQ = 624,
    X86_INS_SCASW = 625,
    X86_INS_SETAE = 626,
    X86_INS_SETA = 627,
    X86_INS_SETBE = 628,
    X86_INS_SETB = 629,
    X86_INS_SETE = 630,
    X86_INS_SETGE = 631,
    X86_INS_SETG = 632,
    X86_INS_SETLE = 633,
    X86_INS_SETL = 634,
    X86_INS_SETNE = 635,
    X86_INS_SETNO = 636,
    X86_INS_SETNP = 637,
    X86_INS_SETNS = 638,
    X86_INS_SETO = 639,
    X86_INS_SETP = 640,
    X86_INS_SETS = 641,
    X86_INS_SFENCE = 642,
    X86_INS_SGDT = 643,
    X86_INS_SHA1MSG1 = 644,
    X86_INS_SHA1MSG2 = 645,
    X86_INS_SHA1NEXTE = 646,
    X86_INS_SHA1RNDS4 = 647,
    X86_INS_SHA256MSG1 = 648,
    X86_INS_SHA256MSG2 = 649,
    X86_INS_SHA256RNDS2 = 650,
    X86_INS_SHL = 651,
    X86_INS_SHLD = 652,
    X86_INS_SHLX = 653,
    X86_INS_SHR = 654,
    X86_INS_SHRD = 655,
    X86_INS_SHRX = 656,
    X86_INS_SHUFPD = 657,
    X86_INS_SHUFPS = 658,
    X86_INS_SIDT = 659,
    X86_INS_FSIN = 660,
    X86_INS_SKINIT = 661,
    X86_INS_SLDT = 662,
    X86_INS_SMSW = 663,
    X86_INS_SQRTPD = 664,
    X86_INS_SQRTPS = 665,
    X86_INS_SQRTSD = 666,
    X86_INS_SQRTSS = 667,
    X86_INS_FSQRT = 668,
    X86_INS_STAC = 669,
    X86_INS_STC = 670,
    X86_INS_STD = 671,
    X86_INS_STGI = 672,
    X86_INS_STI = 673,
    X86_INS_STMXCSR = 674,
    X86_INS_STOSB = 675,
    X86_INS_STOSD = 676,
    X86_INS_STOSQ = 677,
    X86_INS_STOSW = 678,
    X86_INS_STR = 679,
    X86_INS_FST = 680,
    X86_INS_FSTP = 681,
    X86_INS_FSTPNCE = 682,
    X86_INS_FXCH = 683,
    X86_INS_SUBPD = 684,
    X86_INS_SUBPS = 685,
    X86_INS_FSUBR = 686,
    X86_INS_FISUBR = 687,
    X86_INS_FSUBRP = 688,
    X86_INS_SUBSD = 689,
    X86_INS_SUBSS = 690,
    X86_INS_FSUB = 691,
    X86_INS_FISUB = 692,
    X86_INS_FSUBP = 693,
    X86_INS_SWAPGS = 694,
    X86_INS_SYSCALL = 695,
    X86_INS_SYSENTER = 696,
    X86_INS_SYSEXIT = 697,
    X86_INS_SYSRET = 698,
    X86_INS_T1MSKC = 699,
    X86_INS_TEST = 700,
    X86_INS_UD2 = 701,
    X86_INS_FTST = 702,
    X86_INS_TZCNT = 703,
    X86_INS_TZMSK = 704,
    X86_INS_FUCOMIP = 705,
    X86_INS_FUCOMI = 706,
    X86_INS_FUCOMPP = 707,
    X86_INS_FUCOMP = 708,
    X86_INS_FUCOM = 709,
    X86_INS_UD2B = 710,
    X86_INS_UNPCKHPD = 711,
    X86_INS_UNPCKHPS = 712,
    X86_INS_UNPCKLPD = 713,
    X86_INS_UNPCKLPS = 714,
    X86_INS_VADDPD = 715,
    X86_INS_VADDPS = 716,
    X86_INS_VADDSD = 717,
    X86_INS_VADDSS = 718,
    X86_INS_VADDSUBPD = 719,
    X86_INS_VADDSUBPS = 720,
    X86_INS_VAESDECLAST = 721,
    X86_INS_VAESDEC = 722,
    X86_INS_VAESENCLAST = 723,
    X86_INS_VAESENC = 724,
    X86_INS_VAESIMC = 725,
    X86_INS_VAESKEYGENASSIST = 726,
    X86_INS_VALIGND = 727,
    X86_INS_VALIGNQ = 728,
    X86_INS_VANDNPD = 729,
    X86_INS_VANDNPS = 730,
    X86_INS_VANDPD = 731,
    X86_INS_VANDPS = 732,
    X86_INS_VBLENDMPD = 733,
    X86_INS_VBLENDMPS = 734,
    X86_INS_VBLENDPD = 735,
    X86_INS_VBLENDPS = 736,
    X86_INS_VBLENDVPD = 737,
    X86_INS_VBLENDVPS = 738,
    X86_INS_VBROADCASTF128 = 739,
    X86_INS_VBROADCASTI32X4 = 740,
    X86_INS_VBROADCASTI64X4 = 741,
    X86_INS_VBROADCASTSD = 742,
    X86_INS_VBROADCASTSS = 743,
    X86_INS_VCOMPRESSPD = 744,
    X86_INS_VCOMPRESSPS = 745,
    X86_INS_VCVTDQ2PD = 746,
    X86_INS_VCVTDQ2PS = 747,
    X86_INS_VCVTPD2DQX = 748,
    X86_INS_VCVTPD2DQ = 749,
    X86_INS_VCVTPD2PSX = 750,
    X86_INS_VCVTPD2PS = 751,
    X86_INS_VCVTPD2UDQ = 752,
    X86_INS_VCVTPH2PS = 753,
    X86_INS_VCVTPS2DQ = 754,
    X86_INS_VCVTPS2PD = 755,
    X86_INS_VCVTPS2PH = 756,
    X86_INS_VCVTPS2UDQ = 757,
    X86_INS_VCVTSD2SI = 758,
    X86_INS_VCVTSD2USI = 759,
    X86_INS_VCVTSS2SI = 760,
    X86_INS_VCVTSS2USI = 761,
    X86_INS_VCVTTPD2DQX = 762,
    X86_INS_VCVTTPD2DQ = 763,
    X86_INS_VCVTTPD2UDQ = 764,
    X86_INS_VCVTTPS2DQ = 765,
    X86_INS_VCVTTPS2UDQ = 766,
    X86_INS_VCVTUDQ2PD = 767,
    X86_INS_VCVTUDQ2PS = 768,
    X86_INS_VDIVPD = 769,
    X86_INS_VDIVPS = 770,
    X86_INS_VDIVSD = 771,
    X86_INS_VDIVSS = 772,
    X86_INS_VDPPD = 773,
    X86_INS_VDPPS = 774,
    X86_INS_VERR = 775,
    X86_INS_VERW = 776,
    X86_INS_VEXP2PD = 777,
    X86_INS_VEXP2PS = 778,
    X86_INS_VEXPANDPD = 779,
    X86_INS_VEXPANDPS = 780,
    X86_INS_VEXTRACTF128 = 781,
    X86_INS_VEXTRACTF32X4 = 782,
    X86_INS_VEXTRACTF64X4 = 783,
    X86_INS_VEXTRACTI128 = 784,
    X86_INS_VEXTRACTI32X4 = 785,
    X86_INS_VEXTRACTI64X4 = 786,
    X86_INS_VEXTRACTPS = 787,
    X86_INS_VFMADD132PD = 788,
    X86_INS_VFMADD132PS = 789,
    X86_INS_VFMADDPD = 790,
    X86_INS_VFMADD213PD = 791,
    X86_INS_VFMADD231PD = 792,
    X86_INS_VFMADDPS = 793,
    X86_INS_VFMADD213PS = 794,
    X86_INS_VFMADD231PS = 795,
    X86_INS_VFMADDSD = 796,
    X86_INS_VFMADD213SD = 797,
    X86_INS_VFMADD132SD = 798,
    X86_INS_VFMADD231SD = 799,
    X86_INS_VFMADDSS = 800,
    X86_INS_VFMADD213SS = 801,
    X86_INS_VFMADD132SS = 802,
    X86_INS_VFMADD231SS = 803,
    X86_INS_VFMADDSUB132PD = 804,
    X86_INS_VFMADDSUB132PS = 805,
    X86_INS_VFMADDSUBPD = 806,
    X86_INS_VFMADDSUB213PD = 807,
    X86_INS_VFMADDSUB231PD = 808,
    X86_INS_VFMADDSUBPS = 809,
    X86_INS_VFMADDSUB213PS = 810,
    X86_INS_VFMADDSUB231PS = 811,
    X86_INS_VFMSUB132PD = 812,
    X86_INS_VFMSUB132PS = 813,
    X86_INS_VFMSUBADD132PD = 814,
    X86_INS_VFMSUBADD132PS = 815,
    X86_INS_VFMSUBADDPD = 816,
    X86_INS_VFMSUBADD213PD = 817,
    X86_INS_VFMSUBADD231PD = 818,
    X86_INS_VFMSUBADDPS = 819,
    X86_INS_VFMSUBADD213PS = 820,
    X86_INS_VFMSUBADD231PS = 821,
    X86_INS_VFMSUBPD = 822,
    X86_INS_VFMSUB213PD = 823,
    X86_INS_VFMSUB231PD = 824,
    X86_INS_VFMSUBPS = 825,
    X86_INS_VFMSUB213PS = 826,
    X86_INS_VFMSUB231PS = 827,
    X86_INS_VFMSUBSD = 828,
    X86_INS_VFMSUB213SD = 829,
    X86_INS_VFMSUB132SD = 830,
    X86_INS_VFMSUB231SD = 831,
    X86_INS_VFMSUBSS = 832,
    X86_INS_VFMSUB213SS = 833,
    X86_INS_VFMSUB132SS = 834,
    X86_INS_VFMSUB231SS = 835,
    X86_INS_VFNMADD132PD = 836,
    X86_INS_VFNMADD132PS = 837,
    X86_INS_VFNMADDPD = 838,
    X86_INS_VFNMADD213PD = 839,
    X86_INS_VFNMADD231PD = 840,
    X86_INS_VFNMADDPS = 841,
    X86_INS_VFNMADD213PS = 842,
    X86_INS_VFNMADD231PS = 843,
    X86_INS_VFNMADDSD = 844,
    X86_INS_VFNMADD213SD = 845,
    X86_INS_VFNMADD132SD = 846,
    X86_INS_VFNMADD231SD = 847,
    X86_INS_VFNMADDSS = 848,
    X86_INS_VFNMADD213SS = 849,
    X86_INS_VFNMADD132SS = 850,
    X86_INS_VFNMADD231SS = 851,
    X86_INS_VFNMSUB132PD = 852,
    X86_INS_VFNMSUB132PS = 853,
    X86_INS_VFNMSUBPD = 854,
    X86_INS_VFNMSUB213PD = 855,
    X86_INS_VFNMSUB231PD = 856,
    X86_INS_VFNMSUBPS = 857,
    X86_INS_VFNMSUB213PS = 858,
    X86_INS_VFNMSUB231PS = 859,
    X86_INS_VFNMSUBSD = 860,
    X86_INS_VFNMSUB213SD = 861,
    X86_INS_VFNMSUB132SD = 862,
    X86_INS_VFNMSUB231SD = 863,
    X86_INS_VFNMSUBSS = 864,
    X86_INS_VFNMSUB213SS = 865,
    X86_INS_VFNMSUB132SS = 866,
    X86_INS_VFNMSUB231SS = 867,
    X86_INS_VFRCZPD = 868,
    X86_INS_VFRCZPS = 869,
    X86_INS_VFRCZSD = 870,
    X86_INS_VFRCZSS = 871,
    X86_INS_VORPD = 872,
    X86_INS_VORPS = 873,
    X86_INS_VXORPD = 874,
    X86_INS_VXORPS = 875,
    X86_INS_VGATHERDPD = 876,
    X86_INS_VGATHERDPS = 877,
    X86_INS_VGATHERPF0DPD = 878,
    X86_INS_VGATHERPF0DPS = 879,
    X86_INS_VGATHERPF0QPD = 880,
    X86_INS_VGATHERPF0QPS = 881,
    X86_INS_VGATHERPF1DPD = 882,
    X86_INS_VGATHERPF1DPS = 883,
    X86_INS_VGATHERPF1QPD = 884,
    X86_INS_VGATHERPF1QPS = 885,
    X86_INS_VGATHERQPD = 886,
    X86_INS_VGATHERQPS = 887,
    X86_INS_VHADDPD = 888,
    X86_INS_VHADDPS = 889,
    X86_INS_VHSUBPD = 890,
    X86_INS_VHSUBPS = 891,
    X86_INS_VINSERTF128 = 892,
    X86_INS_VINSERTF32X4 = 893,
    X86_INS_VINSERTF32X8 = 894,
    X86_INS_VINSERTF64X2 = 895,
    X86_INS_VINSERTF64X4 = 896,
    X86_INS_VINSERTI128 = 897,
    X86_INS_VINSERTI32X4 = 898,
    X86_INS_VINSERTI32X8 = 899,
    X86_INS_VINSERTI64X2 = 900,
    X86_INS_VINSERTI64X4 = 901,
    X86_INS_VINSERTPS = 902,
    X86_INS_VLDDQU = 903,
    X86_INS_VLDMXCSR = 904,
    X86_INS_VMASKMOVDQU = 905,
    X86_INS_VMASKMOVPD = 906,
    X86_INS_VMASKMOVPS = 907,
    X86_INS_VMAXPD = 908,
    X86_INS_VMAXPS = 909,
    X86_INS_VMAXSD = 910,
    X86_INS_VMAXSS = 911,
    X86_INS_VMCALL = 912,
    X86_INS_VMCLEAR = 913,
    X86_INS_VMFUNC = 914,
    X86_INS_VMINPD = 915,
    X86_INS_VMINPS = 916,
    X86_INS_VMINSD = 917,
    X86_INS_VMINSS = 918,
    X86_INS_VMLAUNCH = 919,
    X86_INS_VMLOAD = 920,
    X86_INS_VMMCALL = 921,
    X86_INS_VMOVQ = 922,
    X86_INS_VMOVDDUP = 923,
    X86_INS_VMOVD = 924,
    X86_INS_VMOVDQA32 = 925,
    X86_INS_VMOVDQA64 = 926,
    X86_INS_VMOVDQA = 927,
    X86_INS_VMOVDQU16 = 928,
    X86_INS_VMOVDQU32 = 929,
    X86_INS_VMOVDQU64 = 930,
    X86_INS_VMOVDQU8 = 931,
    X86_INS_VMOVDQU = 932,
    X86_INS_VMOVHLPS = 933,
    X86_INS_VMOVHPD = 934,
    X86_INS_VMOVHPS = 935,
    X86_INS_VMOVLHPS = 936,
    X86_INS_VMOVLPD = 937,
    X86_INS_VMOVLPS = 938,
    X86_INS_VMOVMSKPD = 939,
    X86_INS_VMOVMSKPS = 940,
    X86_INS_VMOVNTDQA = 941,
    X86_INS_VMOVNTDQ = 942,
    X86_INS_VMOVNTPD = 943,
    X86_INS_VMOVNTPS = 944,
    X86_INS_VMOVSD = 945,
    X86_INS_VMOVSHDUP = 946,
    X86_INS_VMOVSLDUP = 947,
    X86_INS_VMOVSS = 948,
    X86_INS_VMOVUPD = 949,
    X86_INS_VMOVUPS = 950,
    X86_INS_VMPSADBW = 951,
    X86_INS_VMPTRLD = 952,
    X86_INS_VMPTRST = 953,
    X86_INS_VMREAD = 954,
    X86_INS_VMRESUME = 955,
    X86_INS_VMRUN = 956,
    X86_INS_VMSAVE = 957,
    X86_INS_VMULPD = 958,
    X86_INS_VMULPS = 959,
    X86_INS_VMULSD = 960,
    X86_INS_VMULSS = 961,
    X86_INS_VMWRITE = 962,
    X86_INS_VMXOFF = 963,
    X86_INS_VMXON = 964,
    X86_INS_VPABSB = 965,
    X86_INS_VPABSD = 966,
    X86_INS_VPABSQ = 967,
    X86_INS_VPABSW = 968,
    X86_INS_VPACKSSDW = 969,
    X86_INS_VPACKSSWB = 970,
    X86_INS_VPACKUSDW = 971,
    X86_INS_VPACKUSWB = 972,
    X86_INS_VPADDB = 973,
    X86_INS_VPADDD = 974,
    X86_INS_VPADDQ = 975,
    X86_INS_VPADDSB = 976,
    X86_INS_VPADDSW = 977,
    X86_INS_VPADDUSB = 978,
    X86_INS_VPADDUSW = 979,
    X86_INS_VPADDW = 980,
    X86_INS_VPALIGNR = 981,
    X86_INS_VPANDD = 982,
    X86_INS_VPANDND = 983,
    X86_INS_VPANDNQ = 984,
    X86_INS_VPANDN = 985,
    X86_INS_VPANDQ = 986,
    X86_INS_VPAND = 987,
    X86_INS_VPAVGB = 988,
    X86_INS_VPAVGW = 989,
    X86_INS_VPBLENDD = 990,
    X86_INS_VPBLENDMB = 991,
    X86_INS_VPBLENDMD = 992,
    X86_INS_VPBLENDMQ = 993,
    X86_INS_VPBLENDMW = 994,
    X86_INS_VPBLENDVB = 995,
    X86_INS_VPBLENDW = 996,
    X86_INS_VPBROADCASTB = 997,
    X86_INS_VPBROADCASTD = 998,
    X86_INS_VPBROADCASTMB2Q = 999,
    X86_INS_VPBROADCASTMW2D = 1000,
    X86_INS_VPBROADCASTQ = 1001,
    X86_INS_VPBROADCASTW = 1002,
    X86_INS_VPCLMULQDQ = 1003,
    X86_INS_VPCMOV = 1004,
    X86_INS_VPCMPB = 1005,
    X86_INS_VPCMPD = 1006,
    X86_INS_VPCMPEQB = 1007,
    X86_INS_VPCMPEQD = 1008,
    X86_INS_VPCMPEQQ = 1009,
    X86_INS_VPCMPEQW = 1010,
    X86_INS_VPCMPESTRI = 1011,
    X86_INS_VPCMPESTRM = 1012,
    X86_INS_VPCMPGTB = 1013,
    X86_INS_VPCMPGTD = 1014,
    X86_INS_VPCMPGTQ = 1015,
    X86_INS_VPCMPGTW = 1016,
    X86_INS_VPCMPISTRI = 1017,
    X86_INS_VPCMPISTRM = 1018,
    X86_INS_VPCMPQ = 1019,
    X86_INS_VPCMPUB = 1020,
    X86_INS_VPCMPUD = 1021,
    X86_INS_VPCMPUQ = 1022,
    X86_INS_VPCMPUW = 1023,
    X86_INS_VPCMPW = 1024,
    X86_INS_VPCOMB = 1025,
    X86_INS_VPCOMD = 1026,
    X86_INS_VPCOMPRESSD = 1027,
    X86_INS_VPCOMPRESSQ = 1028,
    X86_INS_VPCOMQ = 1029,
    X86_INS_VPCOMUB = 1030,
    X86_INS_VPCOMUD = 1031,
    X86_INS_VPCOMUQ = 1032,
    X86_INS_VPCOMUW = 1033,
    X86_INS_VPCOMW = 1034,
    X86_INS_VPCONFLICTD = 1035,
    X86_INS_VPCONFLICTQ = 1036,
    X86_INS_VPERM2F128 = 1037,
    X86_INS_VPERM2I128 = 1038,
    X86_INS_VPERMD = 1039,
    X86_INS_VPERMI2D = 1040,
    X86_INS_VPERMI2PD = 1041,
    X86_INS_VPERMI2PS = 1042,
    X86_INS_VPERMI2Q = 1043,
    X86_INS_VPERMIL2PD = 1044,
    X86_INS_VPERMIL2PS = 1045,
    X86_INS_VPERMILPD = 1046,
    X86_INS_VPERMILPS = 1047,
    X86_INS_VPERMPD = 1048,
    X86_INS_VPERMPS = 1049,
    X86_INS_VPERMQ = 1050,
    X86_INS_VPERMT2D = 1051,
    X86_INS_VPERMT2PD = 1052,
    X86_INS_VPERMT2PS = 1053,
    X86_INS_VPERMT2Q = 1054,
    X86_INS_VPEXPANDD = 1055,
    X86_INS_VPEXPANDQ = 1056,
    X86_INS_VPEXTRB = 1057,
    X86_INS_VPEXTRD = 1058,
    X86_INS_VPEXTRQ = 1059,
    X86_INS_VPEXTRW = 1060,
    X86_INS_VPGATHERDD = 1061,
    X86_INS_VPGATHERDQ = 1062,
    X86_INS_VPGATHERQD = 1063,
    X86_INS_VPGATHERQQ = 1064,
    X86_INS_VPHADDBD = 1065,
    X86_INS_VPHADDBQ = 1066,
    X86_INS_VPHADDBW = 1067,
    X86_INS_VPHADDDQ = 1068,
    X86_INS_VPHADDD = 1069,
    X86_INS_VPHADDSW = 1070,
    X86_INS_VPHADDUBD = 1071,
    X86_INS_VPHADDUBQ = 1072,
    X86_INS_VPHADDUBW = 1073,
    X86_INS_VPHADDUDQ = 1074,
    X86_INS_VPHADDUWD = 1075,
    X86_INS_VPHADDUWQ = 1076,
    X86_INS_VPHADDWD = 1077,
    X86_INS_VPHADDWQ = 1078,
    X86_INS_VPHADDW = 1079,
    X86_INS_VPHMINPOSUW = 1080,
    X86_INS_VPHSUBBW = 1081,
    X86_INS_VPHSUBDQ = 1082,
    X86_INS_VPHSUBD = 1083,
    X86_INS_VPHSUBSW = 1084,
    X86_INS_VPHSUBWD = 1085,
    X86_INS_VPHSUBW = 1086,
    X86_INS_VPINSRB = 1087,
    X86_INS_VPINSRD = 1088,
    X86_INS_VPINSRQ = 1089,
    X86_INS_VPINSRW = 1090,
    X86_INS_VPLZCNTD = 1091,
    X86_INS_VPLZCNTQ = 1092,
    X86_INS_VPMACSDD = 1093,
    X86_INS_VPMACSDQH = 1094,
    X86_INS_VPMACSDQL = 1095,
    X86_INS_VPMACSSDD = 1096,
    X86_INS_VPMACSSDQH = 1097,
    X86_INS_VPMACSSDQL = 1098,
    X86_INS_VPMACSSWD = 1099,
    X86_INS_VPMACSSWW = 1100,
    X86_INS_VPMACSWD = 1101,
    X86_INS_VPMACSWW = 1102,
    X86_INS_VPMADCSSWD = 1103,
    X86_INS_VPMADCSWD = 1104,
    X86_INS_VPMADDUBSW = 1105,
    X86_INS_VPMADDWD = 1106,
    X86_INS_VPMASKMOVD = 1107,
    X86_INS_VPMASKMOVQ = 1108,
    X86_INS_VPMAXSB = 1109,
    X86_INS_VPMAXSD = 1110,
    X86_INS_VPMAXSQ = 1111,
    X86_INS_VPMAXSW = 1112,
    X86_INS_VPMAXUB = 1113,
    X86_INS_VPMAXUD = 1114,
    X86_INS_VPMAXUQ = 1115,
    X86_INS_VPMAXUW = 1116,
    X86_INS_VPMINSB = 1117,
    X86_INS_VPMINSD = 1118,
    X86_INS_VPMINSQ = 1119,
    X86_INS_VPMINSW = 1120,
    X86_INS_VPMINUB = 1121,
    X86_INS_VPMINUD = 1122,
    X86_INS_VPMINUQ = 1123,
    X86_INS_VPMINUW = 1124,
    X86_INS_VPMOVDB = 1125,
    X86_INS_VPMOVDW = 1126,
    X86_INS_VPMOVM2B = 1127,
    X86_INS_VPMOVM2D = 1128,
    X86_INS_VPMOVM2Q = 1129,
    X86_INS_VPMOVM2W = 1130,
    X86_INS_VPMOVMSKB = 1131,
    X86_INS_VPMOVQB = 1132,
    X86_INS_VPMOVQD = 1133,
    X86_INS_VPMOVQW = 1134,
    X86_INS_VPMOVSDB = 1135,
    X86_INS_VPMOVSDW = 1136,
    X86_INS_VPMOVSQB = 1137,
    X86_INS_VPMOVSQD = 1138,
    X86_INS_VPMOVSQW = 1139,
    X86_INS_VPMOVSXBD = 1140,
    X86_INS_VPMOVSXBQ = 1141,
    X86_INS_VPMOVSXBW = 1142,
    X86_INS_VPMOVSXDQ = 1143,
    X86_INS_VPMOVSXWD = 1144,
    X86_INS_VPMOVSXWQ = 1145,
    X86_INS_VPMOVUSDB = 1146,
    X86_INS_VPMOVUSDW = 1147,
    X86_INS_VPMOVUSQB = 1148,
    X86_INS_VPMOVUSQD = 1149,
    X86_INS_VPMOVUSQW = 1150,
    X86_INS_VPMOVZXBD = 1151,
    X86_INS_VPMOVZXBQ = 1152,
    X86_INS_VPMOVZXBW = 1153,
    X86_INS_VPMOVZXDQ = 1154,
    X86_INS_VPMOVZXWD = 1155,
    X86_INS_VPMOVZXWQ = 1156,
    X86_INS_VPMULDQ = 1157,
    X86_INS_VPMULHRSW = 1158,
    X86_INS_VPMULHUW = 1159,
    X86_INS_VPMULHW = 1160,
    X86_INS_VPMULLD = 1161,
    X86_INS_VPMULLQ = 1162,
    X86_INS_VPMULLW = 1163,
    X86_INS_VPMULUDQ = 1164,
    X86_INS_VPORD = 1165,
    X86_INS_VPORQ = 1166,
    X86_INS_VPOR = 1167,
    X86_INS_VPPERM = 1168,
    X86_INS_VPROTB = 1169,
    X86_INS_VPROTD = 1170,
    X86_INS_VPROTQ = 1171,
    X86_INS_VPROTW = 1172,
    X86_INS_VPSADBW = 1173,
    X86_INS_VPSCATTERDD = 1174,
    X86_INS_VPSCATTERDQ = 1175,
    X86_INS_VPSCATTERQD = 1176,
    X86_INS_VPSCATTERQQ = 1177,
    X86_INS_VPSHAB = 1178,
    X86_INS_VPSHAD = 1179,
    X86_INS_VPSHAQ = 1180,
    X86_INS_VPSHAW = 1181,
    X86_INS_VPSHLB = 1182,
    X86_INS_VPSHLD = 1183,
    X86_INS_VPSHLQ = 1184,
    X86_INS_VPSHLW = 1185,
    X86_INS_VPSHUFB = 1186,
    X86_INS_VPSHUFD = 1187,
    X86_INS_VPSHUFHW = 1188,
    X86_INS_VPSHUFLW = 1189,
    X86_INS_VPSIGNB = 1190,
    X86_INS_VPSIGND = 1191,
    X86_INS_VPSIGNW = 1192,
    X86_INS_VPSLLDQ = 1193,
    X86_INS_VPSLLD = 1194,
    X86_INS_VPSLLQ = 1195,
    X86_INS_VPSLLVD = 1196,
    X86_INS_VPSLLVQ = 1197,
    X86_INS_VPSLLW = 1198,
    X86_INS_VPSRAD = 1199,
    X86_INS_VPSRAQ = 1200,
    X86_INS_VPSRAVD = 1201,
    X86_INS_VPSRAVQ = 1202,
    X86_INS_VPSRAW = 1203,
    X86_INS_VPSRLDQ = 1204,
    X86_INS_VPSRLD = 1205,
    X86_INS_VPSRLQ = 1206,
    X86_INS_VPSRLVD = 1207,
    X86_INS_VPSRLVQ = 1208,
    X86_INS_VPSRLW = 1209,
    X86_INS_VPSUBB = 1210,
    X86_INS_VPSUBD = 1211,
    X86_INS_VPSUBQ = 1212,
    X86_INS_VPSUBSB = 1213,
    X86_INS_VPSUBSW = 1214,
    X86_INS_VPSUBUSB = 1215,
    X86_INS_VPSUBUSW = 1216,
    X86_INS_VPSUBW = 1217,
    X86_INS_VPTESTMD = 1218,
    X86_INS_VPTESTMQ = 1219,
    X86_INS_VPTESTNMD = 1220,
    X86_INS_VPTESTNMQ = 1221,
    X86_INS_VPTEST = 1222,
    X86_INS_VPUNPCKHBW = 1223,
    X86_INS_VPUNPCKHDQ = 1224,
    X86_INS_VPUNPCKHQDQ = 1225,
    X86_INS_VPUNPCKHWD = 1226,
    X86_INS_VPUNPCKLBW = 1227,
    X86_INS_VPUNPCKLDQ = 1228,
    X86_INS_VPUNPCKLQDQ = 1229,
    X86_INS_VPUNPCKLWD = 1230,
    X86_INS_VPXORD = 1231,
    X86_INS_VPXORQ = 1232,
    X86_INS_VPXOR = 1233,
    X86_INS_VRCP14PD = 1234,
    X86_INS_VRCP14PS = 1235,
    X86_INS_VRCP14SD = 1236,
    X86_INS_VRCP14SS = 1237,
    X86_INS_VRCP28PD = 1238,
    X86_INS_VRCP28PS = 1239,
    X86_INS_VRCP28SD = 1240,
    X86_INS_VRCP28SS = 1241,
    X86_INS_VRCPPS = 1242,
    X86_INS_VRCPSS = 1243,
    X86_INS_VRNDSCALEPD = 1244,
    X86_INS_VRNDSCALEPS = 1245,
    X86_INS_VRNDSCALESD = 1246,
    X86_INS_VRNDSCALESS = 1247,
    X86_INS_VROUNDPD = 1248,
    X86_INS_VROUNDPS = 1249,
    X86_INS_VROUNDSD = 1250,
    X86_INS_VROUNDSS = 1251,
    X86_INS_VRSQRT14PD = 1252,
    X86_INS_VRSQRT14PS = 1253,
    X86_INS_VRSQRT14SD = 1254,
    X86_INS_VRSQRT14SS = 1255,
    X86_INS_VRSQRT28PD = 1256,
    X86_INS_VRSQRT28PS = 1257,
    X86_INS_VRSQRT28SD = 1258,
    X86_INS_VRSQRT28SS = 1259,
    X86_INS_VRSQRTPS = 1260,
    X86_INS_VRSQRTSS = 1261,
    X86_INS_VSCATTERDPD = 1262,
    X86_INS_VSCATTERDPS = 1263,
    X86_INS_VSCATTERPF0DPD = 1264,
    X86_INS_VSCATTERPF0DPS = 1265,
    X86_INS_VSCATTERPF0QPD = 1266,
    X86_INS_VSCATTERPF0QPS = 1267,
    X86_INS_VSCATTERPF1DPD = 1268,
    X86_INS_VSCATTERPF1DPS = 1269,
    X86_INS_VSCATTERPF1QPD = 1270,
    X86_INS_VSCATTERPF1QPS = 1271,
    X86_INS_VSCATTERQPD = 1272,
    X86_INS_VSCATTERQPS = 1273,
    X86_INS_VSHUFPD = 1274,
    X86_INS_VSHUFPS = 1275,
    X86_INS_VSQRTPD = 1276,
    X86_INS_VSQRTPS = 1277,
    X86_INS_VSQRTSD = 1278,
    X86_INS_VSQRTSS = 1279,
    X86_INS_VSTMXCSR = 1280,
    X86_INS_VSUBPD = 1281,
    X86_INS_VSUBPS = 1282,
    X86_INS_VSUBSD = 1283,
    X86_INS_VSUBSS = 1284,
    X86_INS_VTESTPD = 1285,
    X86_INS_VTESTPS = 1286,
    X86_INS_VUNPCKHPD = 1287,
    X86_INS_VUNPCKHPS = 1288,
    X86_INS_VUNPCKLPD = 1289,
    X86_INS_VUNPCKLPS = 1290,
    X86_INS_VZEROALL = 1291,
    X86_INS_VZEROUPPER = 1292,
    X86_INS_WAIT = 1293,
    X86_INS_WBINVD = 1294,
    X86_INS_WRFSBASE = 1295,
    X86_INS_WRGSBASE = 1296,
    X86_INS_WRMSR = 1297,
    X86_INS_XABORT = 1298,
    X86_INS_XACQUIRE = 1299,
    X86_INS_XBEGIN = 1300,
    X86_INS_XCHG = 1301,
    X86_INS_XCRYPTCBC = 1302,
    X86_INS_XCRYPTCFB = 1303,
    X86_INS_XCRYPTCTR = 1304,
    X86_INS_XCRYPTECB = 1305,
    X86_INS_XCRYPTOFB = 1306,
    X86_INS_XEND = 1307,
    X86_INS_XGETBV = 1308,
    X86_INS_XLATB = 1309,
    X86_INS_XRELEASE = 1310,
    X86_INS_XRSTOR = 1311,
    X86_INS_XRSTOR64 = 1312,
    X86_INS_XRSTORS = 1313,
    X86_INS_XRSTORS64 = 1314,
    X86_INS_XSAVE = 1315,
    X86_INS_XSAVE64 = 1316,
    X86_INS_XSAVEC = 1317,
    X86_INS_XSAVEC64 = 1318,
    X86_INS_XSAVEOPT = 1319,
    X86_INS_XSAVEOPT64 = 1320,
    X86_INS_XSAVES = 1321,
    X86_INS_XSAVES64 = 1322,
    X86_INS_XSETBV = 1323,
    X86_INS_XSHA1 = 1324,
    X86_INS_XSHA256 = 1325,
    X86_INS_XSTORE = 1326,
    X86_INS_XTEST = 1327,
    X86_INS_FDISI8087_NOP = 1328,
    X86_INS_FENI8087_NOP = 1329,
    X86_INS_CMPSS = 1330,
    X86_INS_CMPEQSS = 1331,
    X86_INS_CMPLTSS = 1332,
    X86_INS_CMPLESS = 1333,
    X86_INS_CMPUNORDSS = 1334,
    X86_INS_CMPNEQSS = 1335,
    X86_INS_CMPNLTSS = 1336,
    X86_INS_CMPNLESS = 1337,
    X86_INS_CMPORDSS = 1338,
    X86_INS_CMPSD = 1339,
    X86_INS_CMPEQSD = 1340,
    X86_INS_CMPLTSD = 1341,
    X86_INS_CMPLESD = 1342,
    X86_INS_CMPUNORDSD = 1343,
    X86_INS_CMPNEQSD = 1344,
    X86_INS_CMPNLTSD = 1345,
    X86_INS_CMPNLESD = 1346,
    X86_INS_CMPORDSD = 1347,
    X86_INS_CMPPS = 1348,
    X86_INS_CMPEQPS = 1349,
    X86_INS_CMPLTPS = 1350,
    X86_INS_CMPLEPS = 1351,
    X86_INS_CMPUNORDPS = 1352,
    X86_INS_CMPNEQPS = 1353,
    X86_INS_CMPNLTPS = 1354,
    X86_INS_CMPNLEPS = 1355,
    X86_INS_CMPORDPS = 1356,
    X86_INS_CMPPD = 1357,
    X86_INS_CMPEQPD = 1358,
    X86_INS_CMPLTPD = 1359,
    X86_INS_CMPLEPD = 1360,
    X86_INS_CMPUNORDPD = 1361,
    X86_INS_CMPNEQPD = 1362,
    X86_INS_CMPNLTPD = 1363,
    X86_INS_CMPNLEPD = 1364,
    X86_INS_CMPORDPD = 1365,
    X86_INS_VCMPSS = 1366,
    X86_INS_VCMPEQSS = 1367,
    X86_INS_VCMPLTSS = 1368,
    X86_INS_VCMPLESS = 1369,
    X86_INS_VCMPUNORDSS = 1370,
    X86_INS_VCMPNEQSS = 1371,
    X86_INS_VCMPNLTSS = 1372,
    X86_INS_VCMPNLESS = 1373,
    X86_INS_VCMPORDSS = 1374,
    X86_INS_VCMPEQ_UQSS = 1375,
    X86_INS_VCMPNGESS = 1376,
    X86_INS_VCMPNGTSS = 1377,
    X86_INS_VCMPFALSESS = 1378,
    X86_INS_VCMPNEQ_OQSS = 1379,
    X86_INS_VCMPGESS = 1380,
    X86_INS_VCMPGTSS = 1381,
    X86_INS_VCMPTRUESS = 1382,
    X86_INS_VCMPEQ_OSSS = 1383,
    X86_INS_VCMPLT_OQSS = 1384,
    X86_INS_VCMPLE_OQSS = 1385,
    X86_INS_VCMPUNORD_SSS = 1386,
    X86_INS_VCMPNEQ_USSS = 1387,
    X86_INS_VCMPNLT_UQSS = 1388,
    X86_INS_VCMPNLE_UQSS = 1389,
    X86_INS_VCMPORD_SSS = 1390,
    X86_INS_VCMPEQ_USSS = 1391,
    X86_INS_VCMPNGE_UQSS = 1392,
    X86_INS_VCMPNGT_UQSS = 1393,
    X86_INS_VCMPFALSE_OSSS = 1394,
    X86_INS_VCMPNEQ_OSSS = 1395,
    X86_INS_VCMPGE_OQSS = 1396,
    X86_INS_VCMPGT_OQSS = 1397,
    X86_INS_VCMPTRUE_USSS = 1398,
    X86_INS_VCMPSD = 1399,
    X86_INS_VCMPEQSD = 1400,
    X86_INS_VCMPLTSD = 1401,
    X86_INS_VCMPLESD = 1402,
    X86_INS_VCMPUNORDSD = 1403,
    X86_INS_VCMPNEQSD = 1404,
    X86_INS_VCMPNLTSD = 1405,
    X86_INS_VCMPNLESD = 1406,
    X86_INS_VCMPORDSD = 1407,
    X86_INS_VCMPEQ_UQSD = 1408,
    X86_INS_VCMPNGESD = 1409,
    X86_INS_VCMPNGTSD = 1410,
    X86_INS_VCMPFALSESD = 1411,
    X86_INS_VCMPNEQ_OQSD = 1412,
    X86_INS_VCMPGESD = 1413,
    X86_INS_VCMPGTSD = 1414,
    X86_INS_VCMPTRUESD = 1415,
    X86_INS_VCMPEQ_OSSD = 1416,
    X86_INS_VCMPLT_OQSD = 1417,
    X86_INS_VCMPLE_OQSD = 1418,
    X86_INS_VCMPUNORD_SSD = 1419,
    X86_INS_VCMPNEQ_USSD = 1420,
    X86_INS_VCMPNLT_UQSD = 1421,
    X86_INS_VCMPNLE_UQSD = 1422,
    X86_INS_VCMPORD_SSD = 1423,
    X86_INS_VCMPEQ_USSD = 1424,
    X86_INS_VCMPNGE_UQSD = 1425,
    X86_INS_VCMPNGT_UQSD = 1426,
    X86_INS_VCMPFALSE_OSSD = 1427,
    X86_INS_VCMPNEQ_OSSD = 1428,
    X86_INS_VCMPGE_OQSD = 1429,
    X86_INS_VCMPGT_OQSD = 1430,
    X86_INS_VCMPTRUE_USSD = 1431,
    X86_INS_VCMPPS = 1432,
    X86_INS_VCMPEQPS = 1433,
    X86_INS_VCMPLTPS = 1434,
    X86_INS_VCMPLEPS = 1435,
    X86_INS_VCMPUNORDPS = 1436,
    X86_INS_VCMPNEQPS = 1437,
    X86_INS_VCMPNLTPS = 1438,
    X86_INS_VCMPNLEPS = 1439,
    X86_INS_VCMPORDPS = 1440,
    X86_INS_VCMPEQ_UQPS = 1441,
    X86_INS_VCMPNGEPS = 1442,
    X86_INS_VCMPNGTPS = 1443,
    X86_INS_VCMPFALSEPS = 1444,
    X86_INS_VCMPNEQ_OQPS = 1445,
    X86_INS_VCMPGEPS = 1446,
    X86_INS_VCMPGTPS = 1447,
    X86_INS_VCMPTRUEPS = 1448,
    X86_INS_VCMPEQ_OSPS = 1449,
    X86_INS_VCMPLT_OQPS = 1450,
    X86_INS_VCMPLE_OQPS = 1451,
    X86_INS_VCMPUNORD_SPS = 1452,
    X86_INS_VCMPNEQ_USPS = 1453,
    X86_INS_VCMPNLT_UQPS = 1454,
    X86_INS_VCMPNLE_UQPS = 1455,
    X86_INS_VCMPORD_SPS = 1456,
    X86_INS_VCMPEQ_USPS = 1457,
    X86_INS_VCMPNGE_UQPS = 1458,
    X86_INS_VCMPNGT_UQPS = 1459,
    X86_INS_VCMPFALSE_OSPS = 1460,
    X86_INS_VCMPNEQ_OSPS = 1461,
    X86_INS_VCMPGE_OQPS = 1462,
    X86_INS_VCMPGT_OQPS = 1463,
    X86_INS_VCMPTRUE_USPS = 1464,
    X86_INS_VCMPPD = 1465,
    X86_INS_VCMPEQPD = 1466,
    X86_INS_VCMPLTPD = 1467,
    X86_INS_VCMPLEPD = 1468,
    X86_INS_VCMPUNORDPD = 1469,
    X86_INS_VCMPNEQPD = 1470,
    X86_INS_VCMPNLTPD = 1471,
    X86_INS_VCMPNLEPD = 1472,
    X86_INS_VCMPORDPD = 1473,
    X86_INS_VCMPEQ_UQPD = 1474,
    X86_INS_VCMPNGEPD = 1475,
    X86_INS_VCMPNGTPD = 1476,
    X86_INS_VCMPFALSEPD = 1477,
    X86_INS_VCMPNEQ_OQPD = 1478,
    X86_INS_VCMPGEPD = 1479,
    X86_INS_VCMPGTPD = 1480,
    X86_INS_VCMPTRUEPD = 1481,
    X86_INS_VCMPEQ_OSPD = 1482,
    X86_INS_VCMPLT_OQPD = 1483,
    X86_INS_VCMPLE_OQPD = 1484,
    X86_INS_VCMPUNORD_SPD = 1485,
    X86_INS_VCMPNEQ_USPD = 1486,
    X86_INS_VCMPNLT_UQPD = 1487,
    X86_INS_VCMPNLE_UQPD = 1488,
    X86_INS_VCMPORD_SPD = 1489,
    X86_INS_VCMPEQ_USPD = 1490,
    X86_INS_VCMPNGE_UQPD = 1491,
    X86_INS_VCMPNGT_UQPD = 1492,
    X86_INS_VCMPFALSE_OSPD = 1493,
    X86_INS_VCMPNEQ_OSPD = 1494,
    X86_INS_VCMPGE_OQPD = 1495,
    X86_INS_VCMPGT_OQPD = 1496,
    X86_INS_VCMPTRUE_USPD = 1497,
    X86_INS_UD0 = 1498,
    X86_INS_ENDBR32 = 1499,
    X86_INS_ENDBR64 = 1500,
    X86_INS_ENDING = 1501,
}
pub mod x86_insn_group {
    #[doc = " Group of X86 instructions"]
    pub type Type = u32;
    #[doc = "< = CS_GRP_INVALID"]
    pub const X86_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const X86_GRP_JUMP: Type = 1;
    #[doc = "< = CS_GRP_CALL"]
    pub const X86_GRP_CALL: Type = 2;
    #[doc = "< = CS_GRP_RET"]
    pub const X86_GRP_RET: Type = 3;
    #[doc = "< = CS_GRP_INT"]
    pub const X86_GRP_INT: Type = 4;
    #[doc = "< = CS_GRP_IRET"]
    pub const X86_GRP_IRET: Type = 5;
    #[doc = "< = CS_GRP_PRIVILEGE"]
    pub const X86_GRP_PRIVILEGE: Type = 6;
    #[doc = "< = CS_GRP_BRANCH_RELATIVE"]
    pub const X86_GRP_BRANCH_RELATIVE: Type = 7;
    #[doc = "< all virtualization instructions (VT-x + AMD-V)"]
    pub const X86_GRP_VM: Type = 128;
    pub const X86_GRP_3DNOW: Type = 129;
    pub const X86_GRP_AES: Type = 130;
    pub const X86_GRP_ADX: Type = 131;
    pub const X86_GRP_AVX: Type = 132;
    pub const X86_GRP_AVX2: Type = 133;
    pub const X86_GRP_AVX512: Type = 134;
    pub const X86_GRP_BMI: Type = 135;
    pub const X86_GRP_BMI2: Type = 136;
    pub const X86_GRP_CMOV: Type = 137;
    pub const X86_GRP_F16C: Type = 138;
    pub const X86_GRP_FMA: Type = 139;
    pub const X86_GRP_FMA4: Type = 140;
    pub const X86_GRP_FSGSBASE: Type = 141;
    pub const X86_GRP_HLE: Type = 142;
    pub const X86_GRP_MMX: Type = 143;
    pub const X86_GRP_MODE32: Type = 144;
    pub const X86_GRP_MODE64: Type = 145;
    pub const X86_GRP_RTM: Type = 146;
    pub const X86_GRP_SHA: Type = 147;
    pub const X86_GRP_SSE1: Type = 148;
    pub const X86_GRP_SSE2: Type = 149;
    pub const X86_GRP_SSE3: Type = 150;
    pub const X86_GRP_SSE41: Type = 151;
    pub const X86_GRP_SSE42: Type = 152;
    pub const X86_GRP_SSE4A: Type = 153;
    pub const X86_GRP_SSSE3: Type = 154;
    pub const X86_GRP_PCLMUL: Type = 155;
    pub const X86_GRP_XOP: Type = 156;
    pub const X86_GRP_CDI: Type = 157;
    pub const X86_GRP_ERI: Type = 158;
    pub const X86_GRP_TBM: Type = 159;
    pub const X86_GRP_16BITMODE: Type = 160;
    pub const X86_GRP_NOT64BITMODE: Type = 161;
    pub const X86_GRP_SGX: Type = 162;
    pub const X86_GRP_DQI: Type = 163;
    pub const X86_GRP_BWI: Type = 164;
    pub const X86_GRP_PFI: Type = 165;
    pub const X86_GRP_VLX: Type = 166;
    pub const X86_GRP_SMAP: Type = 167;
    pub const X86_GRP_NOVLX: Type = 168;
    pub const X86_GRP_FPU: Type = 169;
    pub const X86_GRP_ENDING: Type = 170;
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum xcore_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    XCORE_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    XCORE_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    XCORE_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    XCORE_OP_MEM = 3,
}
pub mod xcore_reg {
    #[doc = " XCore registers"]
    pub type Type = u32;
    pub const XCORE_REG_INVALID: Type = 0;
    pub const XCORE_REG_CP: Type = 1;
    pub const XCORE_REG_DP: Type = 2;
    pub const XCORE_REG_LR: Type = 3;
    pub const XCORE_REG_SP: Type = 4;
    pub const XCORE_REG_R0: Type = 5;
    pub const XCORE_REG_R1: Type = 6;
    pub const XCORE_REG_R2: Type = 7;
    pub const XCORE_REG_R3: Type = 8;
    pub const XCORE_REG_R4: Type = 9;
    pub const XCORE_REG_R5: Type = 10;
    pub const XCORE_REG_R6: Type = 11;
    pub const XCORE_REG_R7: Type = 12;
    pub const XCORE_REG_R8: Type = 13;
    pub const XCORE_REG_R9: Type = 14;
    pub const XCORE_REG_R10: Type = 15;
    pub const XCORE_REG_R11: Type = 16;
    #[doc = "< pc"]
    pub const XCORE_REG_PC: Type = 17;
    #[doc = "< save pc"]
    pub const XCORE_REG_SCP: Type = 18;
    pub const XCORE_REG_SSR: Type = 19;
    pub const XCORE_REG_ET: Type = 20;
    pub const XCORE_REG_ED: Type = 21;
    pub const XCORE_REG_SED: Type = 22;
    pub const XCORE_REG_KEP: Type = 23;
    pub const XCORE_REG_KSP: Type = 24;
    pub const XCORE_REG_ID: Type = 25;
    pub const XCORE_REG_ENDING: Type = 26;
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with XCORE_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct xcore_op_mem {
    #[doc = "< base register, can be safely interpreted as"]
    #[doc = "< a value of type `xcore_reg`, but it is only"]
    #[doc = "< one byte wide"]
    pub base: u8,
    #[doc = "< index register, same conditions apply here"]
    pub index: u8,
    #[doc = "< displacement/offset value"]
    pub disp: i32,
    #[doc = "< +1: forward, -1: backward"]
    pub direct: libc::c_int,
}
impl Clone for xcore_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_xcore_op {
    #[doc = "< operand type"]
    pub type_: xcore_op_type,
    pub __bindgen_anon_1: cs_xcore_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_xcore_op__bindgen_ty_1 {
    #[doc = "< register value for REG operand"]
    pub reg: xcore_reg::Type,
    #[doc = "< immediate value for IMM operand"]
    pub imm: i32,
    #[doc = "< base/disp value for MEM operand"]
    pub mem: xcore_op_mem,
    _bindgen_union_align: [u32; 3usize],
}
impl Clone for cs_xcore_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_xcore_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_xcore_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_xcore_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_xcore_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_xcore_op {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_xcore {
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_xcore_op; 8usize],
}
impl Clone for cs_xcore {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_xcore {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_xcore {{ op_count: {:?}, operands: {:?} }}",
            self.op_count, self.operands
        )
    }
}
#[repr(u32)]
#[doc = " XCore instruction"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum xcore_insn {
    XCORE_INS_INVALID = 0,
    XCORE_INS_ADD = 1,
    XCORE_INS_ANDNOT = 2,
    XCORE_INS_AND = 3,
    XCORE_INS_ASHR = 4,
    XCORE_INS_BAU = 5,
    XCORE_INS_BITREV = 6,
    XCORE_INS_BLA = 7,
    XCORE_INS_BLAT = 8,
    XCORE_INS_BL = 9,
    XCORE_INS_BF = 10,
    XCORE_INS_BT = 11,
    XCORE_INS_BU = 12,
    XCORE_INS_BRU = 13,
    XCORE_INS_BYTEREV = 14,
    XCORE_INS_CHKCT = 15,
    XCORE_INS_CLRE = 16,
    XCORE_INS_CLRPT = 17,
    XCORE_INS_CLRSR = 18,
    XCORE_INS_CLZ = 19,
    XCORE_INS_CRC8 = 20,
    XCORE_INS_CRC32 = 21,
    XCORE_INS_DCALL = 22,
    XCORE_INS_DENTSP = 23,
    XCORE_INS_DGETREG = 24,
    XCORE_INS_DIVS = 25,
    XCORE_INS_DIVU = 26,
    XCORE_INS_DRESTSP = 27,
    XCORE_INS_DRET = 28,
    XCORE_INS_ECALLF = 29,
    XCORE_INS_ECALLT = 30,
    XCORE_INS_EDU = 31,
    XCORE_INS_EEF = 32,
    XCORE_INS_EET = 33,
    XCORE_INS_EEU = 34,
    XCORE_INS_ENDIN = 35,
    XCORE_INS_ENTSP = 36,
    XCORE_INS_EQ = 37,
    XCORE_INS_EXTDP = 38,
    XCORE_INS_EXTSP = 39,
    XCORE_INS_FREER = 40,
    XCORE_INS_FREET = 41,
    XCORE_INS_GETD = 42,
    XCORE_INS_GET = 43,
    XCORE_INS_GETN = 44,
    XCORE_INS_GETR = 45,
    XCORE_INS_GETSR = 46,
    XCORE_INS_GETST = 47,
    XCORE_INS_GETTS = 48,
    XCORE_INS_INCT = 49,
    XCORE_INS_INIT = 50,
    XCORE_INS_INPW = 51,
    XCORE_INS_INSHR = 52,
    XCORE_INS_INT = 53,
    XCORE_INS_IN = 54,
    XCORE_INS_KCALL = 55,
    XCORE_INS_KENTSP = 56,
    XCORE_INS_KRESTSP = 57,
    XCORE_INS_KRET = 58,
    XCORE_INS_LADD = 59,
    XCORE_INS_LD16S = 60,
    XCORE_INS_LD8U = 61,
    XCORE_INS_LDA16 = 62,
    XCORE_INS_LDAP = 63,
    XCORE_INS_LDAW = 64,
    XCORE_INS_LDC = 65,
    XCORE_INS_LDW = 66,
    XCORE_INS_LDIVU = 67,
    XCORE_INS_LMUL = 68,
    XCORE_INS_LSS = 69,
    XCORE_INS_LSUB = 70,
    XCORE_INS_LSU = 71,
    XCORE_INS_MACCS = 72,
    XCORE_INS_MACCU = 73,
    XCORE_INS_MJOIN = 74,
    XCORE_INS_MKMSK = 75,
    XCORE_INS_MSYNC = 76,
    XCORE_INS_MUL = 77,
    XCORE_INS_NEG = 78,
    XCORE_INS_NOT = 79,
    XCORE_INS_OR = 80,
    XCORE_INS_OUTCT = 81,
    XCORE_INS_OUTPW = 82,
    XCORE_INS_OUTSHR = 83,
    XCORE_INS_OUTT = 84,
    XCORE_INS_OUT = 85,
    XCORE_INS_PEEK = 86,
    XCORE_INS_REMS = 87,
    XCORE_INS_REMU = 88,
    XCORE_INS_RETSP = 89,
    XCORE_INS_SETCLK = 90,
    XCORE_INS_SET = 91,
    XCORE_INS_SETC = 92,
    XCORE_INS_SETD = 93,
    XCORE_INS_SETEV = 94,
    XCORE_INS_SETN = 95,
    XCORE_INS_SETPSC = 96,
    XCORE_INS_SETPT = 97,
    XCORE_INS_SETRDY = 98,
    XCORE_INS_SETSR = 99,
    XCORE_INS_SETTW = 100,
    XCORE_INS_SETV = 101,
    XCORE_INS_SEXT = 102,
    XCORE_INS_SHL = 103,
    XCORE_INS_SHR = 104,
    XCORE_INS_SSYNC = 105,
    XCORE_INS_ST16 = 106,
    XCORE_INS_ST8 = 107,
    XCORE_INS_STW = 108,
    XCORE_INS_SUB = 109,
    XCORE_INS_SYNCR = 110,
    XCORE_INS_TESTCT = 111,
    XCORE_INS_TESTLCL = 112,
    XCORE_INS_TESTWCT = 113,
    XCORE_INS_TSETMR = 114,
    XCORE_INS_START = 115,
    XCORE_INS_WAITEF = 116,
    XCORE_INS_WAITET = 117,
    XCORE_INS_WAITEU = 118,
    XCORE_INS_XOR = 119,
    XCORE_INS_ZEXT = 120,
    XCORE_INS_ENDING = 121,
}
pub mod xcore_insn_group {
    #[doc = " Group of XCore instructions"]
    pub type Type = u32;
    #[doc = "< = CS_GRP_INVALID"]
    pub const XCORE_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const XCORE_GRP_JUMP: Type = 1;
    pub const XCORE_GRP_ENDING: Type = 2;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum tms320c64x_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    TMS320C64X_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    TMS320C64X_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    TMS320C64X_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    TMS320C64X_OP_MEM = 3,
    #[doc = "< Register pair for double word ops"]
    TMS320C64X_OP_REGPAIR = 64,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum tms320c64x_mem_disp {
    TMS320C64X_MEM_DISP_INVALID = 0,
    TMS320C64X_MEM_DISP_CONSTANT = 1,
    TMS320C64X_MEM_DISP_REGISTER = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum tms320c64x_mem_dir {
    TMS320C64X_MEM_DIR_INVALID = 0,
    TMS320C64X_MEM_DIR_FW = 1,
    TMS320C64X_MEM_DIR_BW = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum tms320c64x_mem_mod {
    TMS320C64X_MEM_MOD_INVALID = 0,
    TMS320C64X_MEM_MOD_NO = 1,
    TMS320C64X_MEM_MOD_PRE = 2,
    TMS320C64X_MEM_MOD_POST = 3,
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct tms320c64x_op_mem {
    #[doc = "< base register"]
    pub base: libc::c_uint,
    #[doc = "< displacement/offset value"]
    pub disp: libc::c_uint,
    #[doc = "< unit of base and offset register"]
    pub unit: libc::c_uint,
    #[doc = "< offset scaled"]
    pub scaled: libc::c_uint,
    #[doc = "< displacement type"]
    pub disptype: libc::c_uint,
    #[doc = "< direction"]
    pub direction: libc::c_uint,
    #[doc = "< modification"]
    pub modify: libc::c_uint,
}
impl Clone for tms320c64x_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Copy)]
pub struct cs_tms320c64x_op {
    #[doc = "< operand type"]
    pub type_: tms320c64x_op_type,
    pub __bindgen_anon_1: cs_tms320c64x_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_tms320c64x_op__bindgen_ty_1 {
    #[doc = "< register value for REG operand or first register for REGPAIR operand"]
    pub reg: libc::c_uint,
    #[doc = "< immediate value for IMM operand"]
    pub imm: i32,
    #[doc = "< base/disp value for MEM operand"]
    pub mem: tms320c64x_op_mem,
    _bindgen_union_align: [u32; 7usize],
}
impl Clone for cs_tms320c64x_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_tms320c64x_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_tms320c64x_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_tms320c64x_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_tms320c64x_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_tms320c64x_op {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[repr(C)]
#[derive(Copy)]
pub struct cs_tms320c64x {
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_tms320c64x_op; 8usize],
    pub condition: cs_tms320c64x__bindgen_ty_1,
    pub funit: cs_tms320c64x__bindgen_ty_2,
    pub parallel: libc::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_tms320c64x__bindgen_ty_1 {
    pub reg: libc::c_uint,
    pub zero: libc::c_uint,
}
impl Clone for cs_tms320c64x__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_tms320c64x__bindgen_ty_2 {
    pub unit: libc::c_uint,
    pub side: libc::c_uint,
    pub crosspath: libc::c_uint,
}
impl Clone for cs_tms320c64x__bindgen_ty_2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl Clone for cs_tms320c64x {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_tms320c64x {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! ( f , "cs_tms320c64x {{ op_count: {:?}, operands: {:?}, condition: {:?}, funit: {:?}, parallel: {:?} }}" , self . op_count , self . operands , self . condition , self . funit , self . parallel )
    }
}
pub mod tms320c64x_reg {
    pub type Type = u32;
    pub const TMS320C64X_REG_INVALID: Type = 0;
    pub const TMS320C64X_REG_AMR: Type = 1;
    pub const TMS320C64X_REG_CSR: Type = 2;
    pub const TMS320C64X_REG_DIER: Type = 3;
    pub const TMS320C64X_REG_DNUM: Type = 4;
    pub const TMS320C64X_REG_ECR: Type = 5;
    pub const TMS320C64X_REG_GFPGFR: Type = 6;
    pub const TMS320C64X_REG_GPLYA: Type = 7;
    pub const TMS320C64X_REG_GPLYB: Type = 8;
    pub const TMS320C64X_REG_ICR: Type = 9;
    pub const TMS320C64X_REG_IER: Type = 10;
    pub const TMS320C64X_REG_IERR: Type = 11;
    pub const TMS320C64X_REG_ILC: Type = 12;
    pub const TMS320C64X_REG_IRP: Type = 13;
    pub const TMS320C64X_REG_ISR: Type = 14;
    pub const TMS320C64X_REG_ISTP: Type = 15;
    pub const TMS320C64X_REG_ITSR: Type = 16;
    pub const TMS320C64X_REG_NRP: Type = 17;
    pub const TMS320C64X_REG_NTSR: Type = 18;
    pub const TMS320C64X_REG_REP: Type = 19;
    pub const TMS320C64X_REG_RILC: Type = 20;
    pub const TMS320C64X_REG_SSR: Type = 21;
    pub const TMS320C64X_REG_TSCH: Type = 22;
    pub const TMS320C64X_REG_TSCL: Type = 23;
    pub const TMS320C64X_REG_TSR: Type = 24;
    pub const TMS320C64X_REG_A0: Type = 25;
    pub const TMS320C64X_REG_A1: Type = 26;
    pub const TMS320C64X_REG_A2: Type = 27;
    pub const TMS320C64X_REG_A3: Type = 28;
    pub const TMS320C64X_REG_A4: Type = 29;
    pub const TMS320C64X_REG_A5: Type = 30;
    pub const TMS320C64X_REG_A6: Type = 31;
    pub const TMS320C64X_REG_A7: Type = 32;
    pub const TMS320C64X_REG_A8: Type = 33;
    pub const TMS320C64X_REG_A9: Type = 34;
    pub const TMS320C64X_REG_A10: Type = 35;
    pub const TMS320C64X_REG_A11: Type = 36;
    pub const TMS320C64X_REG_A12: Type = 37;
    pub const TMS320C64X_REG_A13: Type = 38;
    pub const TMS320C64X_REG_A14: Type = 39;
    pub const TMS320C64X_REG_A15: Type = 40;
    pub const TMS320C64X_REG_A16: Type = 41;
    pub const TMS320C64X_REG_A17: Type = 42;
    pub const TMS320C64X_REG_A18: Type = 43;
    pub const TMS320C64X_REG_A19: Type = 44;
    pub const TMS320C64X_REG_A20: Type = 45;
    pub const TMS320C64X_REG_A21: Type = 46;
    pub const TMS320C64X_REG_A22: Type = 47;
    pub const TMS320C64X_REG_A23: Type = 48;
    pub const TMS320C64X_REG_A24: Type = 49;
    pub const TMS320C64X_REG_A25: Type = 50;
    pub const TMS320C64X_REG_A26: Type = 51;
    pub const TMS320C64X_REG_A27: Type = 52;
    pub const TMS320C64X_REG_A28: Type = 53;
    pub const TMS320C64X_REG_A29: Type = 54;
    pub const TMS320C64X_REG_A30: Type = 55;
    pub const TMS320C64X_REG_A31: Type = 56;
    pub const TMS320C64X_REG_B0: Type = 57;
    pub const TMS320C64X_REG_B1: Type = 58;
    pub const TMS320C64X_REG_B2: Type = 59;
    pub const TMS320C64X_REG_B3: Type = 60;
    pub const TMS320C64X_REG_B4: Type = 61;
    pub const TMS320C64X_REG_B5: Type = 62;
    pub const TMS320C64X_REG_B6: Type = 63;
    pub const TMS320C64X_REG_B7: Type = 64;
    pub const TMS320C64X_REG_B8: Type = 65;
    pub const TMS320C64X_REG_B9: Type = 66;
    pub const TMS320C64X_REG_B10: Type = 67;
    pub const TMS320C64X_REG_B11: Type = 68;
    pub const TMS320C64X_REG_B12: Type = 69;
    pub const TMS320C64X_REG_B13: Type = 70;
    pub const TMS320C64X_REG_B14: Type = 71;
    pub const TMS320C64X_REG_B15: Type = 72;
    pub const TMS320C64X_REG_B16: Type = 73;
    pub const TMS320C64X_REG_B17: Type = 74;
    pub const TMS320C64X_REG_B18: Type = 75;
    pub const TMS320C64X_REG_B19: Type = 76;
    pub const TMS320C64X_REG_B20: Type = 77;
    pub const TMS320C64X_REG_B21: Type = 78;
    pub const TMS320C64X_REG_B22: Type = 79;
    pub const TMS320C64X_REG_B23: Type = 80;
    pub const TMS320C64X_REG_B24: Type = 81;
    pub const TMS320C64X_REG_B25: Type = 82;
    pub const TMS320C64X_REG_B26: Type = 83;
    pub const TMS320C64X_REG_B27: Type = 84;
    pub const TMS320C64X_REG_B28: Type = 85;
    pub const TMS320C64X_REG_B29: Type = 86;
    pub const TMS320C64X_REG_B30: Type = 87;
    pub const TMS320C64X_REG_B31: Type = 88;
    pub const TMS320C64X_REG_PCE1: Type = 89;
    pub const TMS320C64X_REG_ENDING: Type = 90;
    pub const TMS320C64X_REG_EFR: Type = 5;
    pub const TMS320C64X_REG_IFR: Type = 14;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum tms320c64x_insn {
    TMS320C64X_INS_INVALID = 0,
    TMS320C64X_INS_ABS = 1,
    TMS320C64X_INS_ABS2 = 2,
    TMS320C64X_INS_ADD = 3,
    TMS320C64X_INS_ADD2 = 4,
    TMS320C64X_INS_ADD4 = 5,
    TMS320C64X_INS_ADDAB = 6,
    TMS320C64X_INS_ADDAD = 7,
    TMS320C64X_INS_ADDAH = 8,
    TMS320C64X_INS_ADDAW = 9,
    TMS320C64X_INS_ADDK = 10,
    TMS320C64X_INS_ADDKPC = 11,
    TMS320C64X_INS_ADDU = 12,
    TMS320C64X_INS_AND = 13,
    TMS320C64X_INS_ANDN = 14,
    TMS320C64X_INS_AVG2 = 15,
    TMS320C64X_INS_AVGU4 = 16,
    TMS320C64X_INS_B = 17,
    TMS320C64X_INS_BDEC = 18,
    TMS320C64X_INS_BITC4 = 19,
    TMS320C64X_INS_BNOP = 20,
    TMS320C64X_INS_BPOS = 21,
    TMS320C64X_INS_CLR = 22,
    TMS320C64X_INS_CMPEQ = 23,
    TMS320C64X_INS_CMPEQ2 = 24,
    TMS320C64X_INS_CMPEQ4 = 25,
    TMS320C64X_INS_CMPGT = 26,
    TMS320C64X_INS_CMPGT2 = 27,
    TMS320C64X_INS_CMPGTU4 = 28,
    TMS320C64X_INS_CMPLT = 29,
    TMS320C64X_INS_CMPLTU = 30,
    TMS320C64X_INS_DEAL = 31,
    TMS320C64X_INS_DOTP2 = 32,
    TMS320C64X_INS_DOTPN2 = 33,
    TMS320C64X_INS_DOTPNRSU2 = 34,
    TMS320C64X_INS_DOTPRSU2 = 35,
    TMS320C64X_INS_DOTPSU4 = 36,
    TMS320C64X_INS_DOTPU4 = 37,
    TMS320C64X_INS_EXT = 38,
    TMS320C64X_INS_EXTU = 39,
    TMS320C64X_INS_GMPGTU = 40,
    TMS320C64X_INS_GMPY4 = 41,
    TMS320C64X_INS_LDB = 42,
    TMS320C64X_INS_LDBU = 43,
    TMS320C64X_INS_LDDW = 44,
    TMS320C64X_INS_LDH = 45,
    TMS320C64X_INS_LDHU = 46,
    TMS320C64X_INS_LDNDW = 47,
    TMS320C64X_INS_LDNW = 48,
    TMS320C64X_INS_LDW = 49,
    TMS320C64X_INS_LMBD = 50,
    TMS320C64X_INS_MAX2 = 51,
    TMS320C64X_INS_MAXU4 = 52,
    TMS320C64X_INS_MIN2 = 53,
    TMS320C64X_INS_MINU4 = 54,
    TMS320C64X_INS_MPY = 55,
    TMS320C64X_INS_MPY2 = 56,
    TMS320C64X_INS_MPYH = 57,
    TMS320C64X_INS_MPYHI = 58,
    TMS320C64X_INS_MPYHIR = 59,
    TMS320C64X_INS_MPYHL = 60,
    TMS320C64X_INS_MPYHLU = 61,
    TMS320C64X_INS_MPYHSLU = 62,
    TMS320C64X_INS_MPYHSU = 63,
    TMS320C64X_INS_MPYHU = 64,
    TMS320C64X_INS_MPYHULS = 65,
    TMS320C64X_INS_MPYHUS = 66,
    TMS320C64X_INS_MPYLH = 67,
    TMS320C64X_INS_MPYLHU = 68,
    TMS320C64X_INS_MPYLI = 69,
    TMS320C64X_INS_MPYLIR = 70,
    TMS320C64X_INS_MPYLSHU = 71,
    TMS320C64X_INS_MPYLUHS = 72,
    TMS320C64X_INS_MPYSU = 73,
    TMS320C64X_INS_MPYSU4 = 74,
    TMS320C64X_INS_MPYU = 75,
    TMS320C64X_INS_MPYU4 = 76,
    TMS320C64X_INS_MPYUS = 77,
    TMS320C64X_INS_MVC = 78,
    TMS320C64X_INS_MVD = 79,
    TMS320C64X_INS_MVK = 80,
    TMS320C64X_INS_MVKL = 81,
    TMS320C64X_INS_MVKLH = 82,
    TMS320C64X_INS_NOP = 83,
    TMS320C64X_INS_NORM = 84,
    TMS320C64X_INS_OR = 85,
    TMS320C64X_INS_PACK2 = 86,
    TMS320C64X_INS_PACKH2 = 87,
    TMS320C64X_INS_PACKH4 = 88,
    TMS320C64X_INS_PACKHL2 = 89,
    TMS320C64X_INS_PACKL4 = 90,
    TMS320C64X_INS_PACKLH2 = 91,
    TMS320C64X_INS_ROTL = 92,
    TMS320C64X_INS_SADD = 93,
    TMS320C64X_INS_SADD2 = 94,
    TMS320C64X_INS_SADDU4 = 95,
    TMS320C64X_INS_SADDUS2 = 96,
    TMS320C64X_INS_SAT = 97,
    TMS320C64X_INS_SET = 98,
    TMS320C64X_INS_SHFL = 99,
    TMS320C64X_INS_SHL = 100,
    TMS320C64X_INS_SHLMB = 101,
    TMS320C64X_INS_SHR = 102,
    TMS320C64X_INS_SHR2 = 103,
    TMS320C64X_INS_SHRMB = 104,
    TMS320C64X_INS_SHRU = 105,
    TMS320C64X_INS_SHRU2 = 106,
    TMS320C64X_INS_SMPY = 107,
    TMS320C64X_INS_SMPY2 = 108,
    TMS320C64X_INS_SMPYH = 109,
    TMS320C64X_INS_SMPYHL = 110,
    TMS320C64X_INS_SMPYLH = 111,
    TMS320C64X_INS_SPACK2 = 112,
    TMS320C64X_INS_SPACKU4 = 113,
    TMS320C64X_INS_SSHL = 114,
    TMS320C64X_INS_SSHVL = 115,
    TMS320C64X_INS_SSHVR = 116,
    TMS320C64X_INS_SSUB = 117,
    TMS320C64X_INS_STB = 118,
    TMS320C64X_INS_STDW = 119,
    TMS320C64X_INS_STH = 120,
    TMS320C64X_INS_STNDW = 121,
    TMS320C64X_INS_STNW = 122,
    TMS320C64X_INS_STW = 123,
    TMS320C64X_INS_SUB = 124,
    TMS320C64X_INS_SUB2 = 125,
    TMS320C64X_INS_SUB4 = 126,
    TMS320C64X_INS_SUBAB = 127,
    TMS320C64X_INS_SUBABS4 = 128,
    TMS320C64X_INS_SUBAH = 129,
    TMS320C64X_INS_SUBAW = 130,
    TMS320C64X_INS_SUBC = 131,
    TMS320C64X_INS_SUBU = 132,
    TMS320C64X_INS_SWAP4 = 133,
    TMS320C64X_INS_UNPKHU4 = 134,
    TMS320C64X_INS_UNPKLU4 = 135,
    TMS320C64X_INS_XOR = 136,
    TMS320C64X_INS_XPND2 = 137,
    TMS320C64X_INS_XPND4 = 138,
    TMS320C64X_INS_IDLE = 139,
    TMS320C64X_INS_MV = 140,
    TMS320C64X_INS_NEG = 141,
    TMS320C64X_INS_NOT = 142,
    TMS320C64X_INS_SWAP2 = 143,
    TMS320C64X_INS_ZERO = 144,
    TMS320C64X_INS_ENDING = 145,
}
pub mod tms320c64x_insn_group {
    pub type Type = u32;
    #[doc = "< = CS_GRP_INVALID"]
    pub const TMS320C64X_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const TMS320C64X_GRP_JUMP: Type = 1;
    pub const TMS320C64X_GRP_FUNIT_D: Type = 128;
    pub const TMS320C64X_GRP_FUNIT_L: Type = 129;
    pub const TMS320C64X_GRP_FUNIT_M: Type = 130;
    pub const TMS320C64X_GRP_FUNIT_S: Type = 131;
    pub const TMS320C64X_GRP_FUNIT_NO: Type = 132;
    pub const TMS320C64X_GRP_ENDING: Type = 133;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum tms320c64x_funit {
    TMS320C64X_FUNIT_INVALID = 0,
    TMS320C64X_FUNIT_D = 1,
    TMS320C64X_FUNIT_L = 2,
    TMS320C64X_FUNIT_M = 3,
    TMS320C64X_FUNIT_S = 4,
    TMS320C64X_FUNIT_NO = 5,
}
pub mod m680x_reg {
    #[doc = " M680X registers and special registers"]
    pub type Type = u32;
    pub const M680X_REG_INVALID: Type = 0;
    #[doc = "< M6800/1/2/3/9, HD6301/9"]
    pub const M680X_REG_A: Type = 1;
    #[doc = "< M6800/1/2/3/9, HD6301/9"]
    pub const M680X_REG_B: Type = 2;
    #[doc = "< HD6309"]
    pub const M680X_REG_E: Type = 3;
    #[doc = "< HD6309"]
    pub const M680X_REG_F: Type = 4;
    #[doc = "< HD6309"]
    pub const M680X_REG_0: Type = 5;
    #[doc = "< M6801/3/9, HD6301/9"]
    pub const M680X_REG_D: Type = 6;
    #[doc = "< HD6309"]
    pub const M680X_REG_W: Type = 7;
    #[doc = "< M6800/1/2/3/9, M6301/9"]
    pub const M680X_REG_CC: Type = 8;
    #[doc = "< M6809/M6309"]
    pub const M680X_REG_DP: Type = 9;
    #[doc = "< M6309"]
    pub const M680X_REG_MD: Type = 10;
    #[doc = "< M6808"]
    pub const M680X_REG_HX: Type = 11;
    #[doc = "< M6808"]
    pub const M680X_REG_H: Type = 12;
    #[doc = "< M6800/1/2/3/9, M6301/9"]
    pub const M680X_REG_X: Type = 13;
    #[doc = "< M6809/M6309"]
    pub const M680X_REG_Y: Type = 14;
    #[doc = "< M6809/M6309"]
    pub const M680X_REG_S: Type = 15;
    #[doc = "< M6809/M6309"]
    pub const M680X_REG_U: Type = 16;
    #[doc = "< M6309"]
    pub const M680X_REG_V: Type = 17;
    #[doc = "< M6309"]
    pub const M680X_REG_Q: Type = 18;
    #[doc = "< M6800/1/2/3/9, M6301/9"]
    pub const M680X_REG_PC: Type = 19;
    #[doc = "< CPU12"]
    pub const M680X_REG_TMP2: Type = 20;
    #[doc = "< CPU12"]
    pub const M680X_REG_TMP3: Type = 21;
    #[doc = "< <-- mark the end of the list of registers"]
    pub const M680X_REG_ENDING: Type = 22;
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum m680x_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    M680X_OP_INVALID = 0,
    #[doc = "< = Register operand."]
    M680X_OP_REGISTER = 1,
    #[doc = "< = Immediate operand."]
    M680X_OP_IMMEDIATE = 2,
    #[doc = "< = Indexed addressing operand."]
    M680X_OP_INDEXED = 3,
    #[doc = "< = Extended addressing operand."]
    M680X_OP_EXTENDED = 4,
    #[doc = "< = Direct addressing operand."]
    M680X_OP_DIRECT = 5,
    #[doc = "< = Relative addressing operand."]
    M680X_OP_RELATIVE = 6,
    #[doc = "< = constant operand (Displayed as number only)."]
    #[doc = "< Used e.g. for a bit index or page number."]
    M680X_OP_CONSTANT = 7,
}
#[doc = " Instruction's operand referring to indexed addressing"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct m680x_op_idx {
    #[doc = "< base register (or M680X_REG_INVALID if"]
    #[doc = "< irrelevant)"]
    pub base_reg: m680x_reg::Type,
    #[doc = "< offset register (or M680X_REG_INVALID if"]
    #[doc = "< irrelevant)"]
    pub offset_reg: m680x_reg::Type,
    #[doc = "< 5-,8- or 16-bit offset. See also offset_bits."]
    pub offset: i16,
    #[doc = "< = offset addr. if base_reg == M680X_REG_PC."]
    #[doc = "< calculated as offset + PC"]
    pub offset_addr: u16,
    #[doc = "< offset width in bits for indexed addressing"]
    pub offset_bits: u8,
    #[doc = "< inc. or dec. value:"]
    #[doc = "<    0: no inc-/decrement"]
    #[doc = "<    1 .. 8: increment by 1 .. 8"]
    #[doc = "<    -1 .. -8: decrement by 1 .. 8"]
    #[doc = "< if flag M680X_IDX_POST_INC_DEC set it is post"]
    #[doc = "< inc-/decrement otherwise pre inc-/decrement"]
    pub inc_dec: i8,
    #[doc = "< 8-bit flags (see above)"]
    pub flags: u8,
}
impl Clone for m680x_op_idx {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction's memory operand referring to relative addressing (Bcc/LBcc)"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct m680x_op_rel {
    #[doc = "< The absolute address."]
    #[doc = "< calculated as PC + offset. PC is the first"]
    #[doc = "< address after the instruction."]
    pub address: u16,
    #[doc = "< the offset/displacement value"]
    pub offset: i16,
}
impl Clone for m680x_op_rel {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction's operand referring to extended addressing"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct m680x_op_ext {
    #[doc = "< The absolute address"]
    pub address: u16,
    #[doc = "< true if extended indirect addressing"]
    pub indirect: bool,
}
impl Clone for m680x_op_ext {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_m680x_op {
    pub type_: m680x_op_type,
    pub __bindgen_anon_1: cs_m680x_op__bindgen_ty_1,
    #[doc = "< size of this operand (in bytes)"]
    pub size: u8,
    #[doc = " How is this operand accessed? (READ, WRITE or READ|WRITE)"]
    #[doc = " This field is combined of cs_ac_type."]
    #[doc = " NOTE: this field is irrelevant if engine is compiled in DIET"]
    pub access: u8,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_m680x_op__bindgen_ty_1 {
    #[doc = "< immediate value for IMM operand"]
    pub imm: i32,
    #[doc = "< register value for REG operand"]
    pub reg: m680x_reg::Type,
    #[doc = "< Indexed addressing operand"]
    pub idx: m680x_op_idx,
    #[doc = "< Relative address. operand (Bcc/LBcc)"]
    pub rel: m680x_op_rel,
    #[doc = "< Extended address"]
    pub ext: m680x_op_ext,
    #[doc = "<</ Direct address (lower 8-bit)"]
    pub direct_addr: u8,
    #[doc = "< constant value (bit index, page nr.)"]
    pub const_val: u8,
    _bindgen_union_align: [u32; 4usize],
}
impl Clone for cs_m680x_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_m680x_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_m680x_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_m680x_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_m680x_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_m680x_op {{ type: {:?}, __bindgen_anon_1: {:?}, size: {:?}, access: {:?} }}",
            self.type_, self.__bindgen_anon_1, self.size, self.access
        )
    }
}
#[repr(u32)]
#[doc = " Group of M680X instructions"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum m680x_group_type {
    M680X_GRP_INVALID = 0,
    #[doc = "< = CS_GRP_JUMP"]
    M680X_GRP_JUMP = 1,
    #[doc = "< = CS_GRP_CALL"]
    M680X_GRP_CALL = 2,
    #[doc = "< = CS_GRP_RET"]
    M680X_GRP_RET = 3,
    #[doc = "< = CS_GRP_INT"]
    M680X_GRP_INT = 4,
    #[doc = "< = CS_GRP_IRET"]
    M680X_GRP_IRET = 5,
    #[doc = "< = CS_GRP_PRIVILEDGE; not used"]
    M680X_GRP_PRIV = 6,
    #[doc = "< = CS_GRP_BRANCH_RELATIVE"]
    M680X_GRP_BRAREL = 7,
    M680X_GRP_ENDING = 8,
}
#[doc = " The M680X instruction and it's operands"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_m680x {
    #[doc = "< See: M680X instruction flags"]
    pub flags: u8,
    #[doc = "< number of operands for the instruction or 0"]
    pub op_count: u8,
    #[doc = "< operands for this insn."]
    pub operands: [cs_m680x_op; 9usize],
}
impl Clone for cs_m680x {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_m680x {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_m680x {{ flags: {:?}, op_count: {:?}, operands: {:?} }}",
            self.flags, self.op_count, self.operands
        )
    }
}
#[repr(u32)]
#[doc = " M680X instruction IDs"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum m680x_insn {
    M680X_INS_INVLD = 0,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_ABA = 1,
    M680X_INS_ABX = 2,
    M680X_INS_ABY = 3,
    M680X_INS_ADC = 4,
    M680X_INS_ADCA = 5,
    M680X_INS_ADCB = 6,
    M680X_INS_ADCD = 7,
    M680X_INS_ADCR = 8,
    M680X_INS_ADD = 9,
    M680X_INS_ADDA = 10,
    M680X_INS_ADDB = 11,
    M680X_INS_ADDD = 12,
    M680X_INS_ADDE = 13,
    M680X_INS_ADDF = 14,
    M680X_INS_ADDR = 15,
    M680X_INS_ADDW = 16,
    M680X_INS_AIM = 17,
    M680X_INS_AIS = 18,
    M680X_INS_AIX = 19,
    M680X_INS_AND = 20,
    M680X_INS_ANDA = 21,
    M680X_INS_ANDB = 22,
    M680X_INS_ANDCC = 23,
    M680X_INS_ANDD = 24,
    M680X_INS_ANDR = 25,
    M680X_INS_ASL = 26,
    M680X_INS_ASLA = 27,
    M680X_INS_ASLB = 28,
    #[doc = "< or LSLD"]
    M680X_INS_ASLD = 29,
    M680X_INS_ASR = 30,
    M680X_INS_ASRA = 31,
    M680X_INS_ASRB = 32,
    M680X_INS_ASRD = 33,
    M680X_INS_ASRX = 34,
    M680X_INS_BAND = 35,
    #[doc = "< or BHS"]
    M680X_INS_BCC = 36,
    M680X_INS_BCLR = 37,
    #[doc = "< or BLO"]
    M680X_INS_BCS = 38,
    M680X_INS_BEOR = 39,
    M680X_INS_BEQ = 40,
    M680X_INS_BGE = 41,
    M680X_INS_BGND = 42,
    M680X_INS_BGT = 43,
    M680X_INS_BHCC = 44,
    M680X_INS_BHCS = 45,
    M680X_INS_BHI = 46,
    M680X_INS_BIAND = 47,
    M680X_INS_BIEOR = 48,
    M680X_INS_BIH = 49,
    M680X_INS_BIL = 50,
    M680X_INS_BIOR = 51,
    M680X_INS_BIT = 52,
    M680X_INS_BITA = 53,
    M680X_INS_BITB = 54,
    M680X_INS_BITD = 55,
    M680X_INS_BITMD = 56,
    M680X_INS_BLE = 57,
    M680X_INS_BLS = 58,
    M680X_INS_BLT = 59,
    M680X_INS_BMC = 60,
    M680X_INS_BMI = 61,
    M680X_INS_BMS = 62,
    M680X_INS_BNE = 63,
    M680X_INS_BOR = 64,
    M680X_INS_BPL = 65,
    M680X_INS_BRCLR = 66,
    M680X_INS_BRSET = 67,
    M680X_INS_BRA = 68,
    M680X_INS_BRN = 69,
    M680X_INS_BSET = 70,
    M680X_INS_BSR = 71,
    M680X_INS_BVC = 72,
    M680X_INS_BVS = 73,
    M680X_INS_CALL = 74,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_CBA = 75,
    M680X_INS_CBEQ = 76,
    M680X_INS_CBEQA = 77,
    M680X_INS_CBEQX = 78,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_CLC = 79,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_CLI = 80,
    M680X_INS_CLR = 81,
    M680X_INS_CLRA = 82,
    M680X_INS_CLRB = 83,
    M680X_INS_CLRD = 84,
    M680X_INS_CLRE = 85,
    M680X_INS_CLRF = 86,
    M680X_INS_CLRH = 87,
    M680X_INS_CLRW = 88,
    M680X_INS_CLRX = 89,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_CLV = 90,
    M680X_INS_CMP = 91,
    M680X_INS_CMPA = 92,
    M680X_INS_CMPB = 93,
    M680X_INS_CMPD = 94,
    M680X_INS_CMPE = 95,
    M680X_INS_CMPF = 96,
    M680X_INS_CMPR = 97,
    M680X_INS_CMPS = 98,
    M680X_INS_CMPU = 99,
    M680X_INS_CMPW = 100,
    M680X_INS_CMPX = 101,
    M680X_INS_CMPY = 102,
    M680X_INS_COM = 103,
    M680X_INS_COMA = 104,
    M680X_INS_COMB = 105,
    M680X_INS_COMD = 106,
    M680X_INS_COME = 107,
    M680X_INS_COMF = 108,
    M680X_INS_COMW = 109,
    M680X_INS_COMX = 110,
    M680X_INS_CPD = 111,
    M680X_INS_CPHX = 112,
    M680X_INS_CPS = 113,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_CPX = 114,
    M680X_INS_CPY = 115,
    M680X_INS_CWAI = 116,
    M680X_INS_DAA = 117,
    M680X_INS_DBEQ = 118,
    M680X_INS_DBNE = 119,
    M680X_INS_DBNZ = 120,
    M680X_INS_DBNZA = 121,
    M680X_INS_DBNZX = 122,
    M680X_INS_DEC = 123,
    M680X_INS_DECA = 124,
    M680X_INS_DECB = 125,
    M680X_INS_DECD = 126,
    M680X_INS_DECE = 127,
    M680X_INS_DECF = 128,
    M680X_INS_DECW = 129,
    M680X_INS_DECX = 130,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_DES = 131,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_DEX = 132,
    M680X_INS_DEY = 133,
    M680X_INS_DIV = 134,
    M680X_INS_DIVD = 135,
    M680X_INS_DIVQ = 136,
    M680X_INS_EDIV = 137,
    M680X_INS_EDIVS = 138,
    M680X_INS_EIM = 139,
    M680X_INS_EMACS = 140,
    M680X_INS_EMAXD = 141,
    M680X_INS_EMAXM = 142,
    M680X_INS_EMIND = 143,
    M680X_INS_EMINM = 144,
    M680X_INS_EMUL = 145,
    M680X_INS_EMULS = 146,
    M680X_INS_EOR = 147,
    M680X_INS_EORA = 148,
    M680X_INS_EORB = 149,
    M680X_INS_EORD = 150,
    M680X_INS_EORR = 151,
    M680X_INS_ETBL = 152,
    M680X_INS_EXG = 153,
    M680X_INS_FDIV = 154,
    M680X_INS_IBEQ = 155,
    M680X_INS_IBNE = 156,
    M680X_INS_IDIV = 157,
    M680X_INS_IDIVS = 158,
    M680X_INS_ILLGL = 159,
    M680X_INS_INC = 160,
    M680X_INS_INCA = 161,
    M680X_INS_INCB = 162,
    M680X_INS_INCD = 163,
    M680X_INS_INCE = 164,
    M680X_INS_INCF = 165,
    M680X_INS_INCW = 166,
    M680X_INS_INCX = 167,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_INS = 168,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_INX = 169,
    M680X_INS_INY = 170,
    M680X_INS_JMP = 171,
    M680X_INS_JSR = 172,
    #[doc = "< or LBHS"]
    M680X_INS_LBCC = 173,
    #[doc = "< or LBLO"]
    M680X_INS_LBCS = 174,
    M680X_INS_LBEQ = 175,
    M680X_INS_LBGE = 176,
    M680X_INS_LBGT = 177,
    M680X_INS_LBHI = 178,
    M680X_INS_LBLE = 179,
    M680X_INS_LBLS = 180,
    M680X_INS_LBLT = 181,
    M680X_INS_LBMI = 182,
    M680X_INS_LBNE = 183,
    M680X_INS_LBPL = 184,
    M680X_INS_LBRA = 185,
    M680X_INS_LBRN = 186,
    M680X_INS_LBSR = 187,
    M680X_INS_LBVC = 188,
    M680X_INS_LBVS = 189,
    M680X_INS_LDA = 190,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_LDAA = 191,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_LDAB = 192,
    M680X_INS_LDB = 193,
    M680X_INS_LDBT = 194,
    M680X_INS_LDD = 195,
    M680X_INS_LDE = 196,
    M680X_INS_LDF = 197,
    M680X_INS_LDHX = 198,
    M680X_INS_LDMD = 199,
    M680X_INS_LDQ = 200,
    M680X_INS_LDS = 201,
    M680X_INS_LDU = 202,
    M680X_INS_LDW = 203,
    M680X_INS_LDX = 204,
    M680X_INS_LDY = 205,
    M680X_INS_LEAS = 206,
    M680X_INS_LEAU = 207,
    M680X_INS_LEAX = 208,
    M680X_INS_LEAY = 209,
    M680X_INS_LSL = 210,
    M680X_INS_LSLA = 211,
    M680X_INS_LSLB = 212,
    M680X_INS_LSLD = 213,
    M680X_INS_LSLX = 214,
    M680X_INS_LSR = 215,
    M680X_INS_LSRA = 216,
    M680X_INS_LSRB = 217,
    #[doc = "< or ASRD"]
    M680X_INS_LSRD = 218,
    M680X_INS_LSRW = 219,
    M680X_INS_LSRX = 220,
    M680X_INS_MAXA = 221,
    M680X_INS_MAXM = 222,
    M680X_INS_MEM = 223,
    M680X_INS_MINA = 224,
    M680X_INS_MINM = 225,
    M680X_INS_MOV = 226,
    M680X_INS_MOVB = 227,
    M680X_INS_MOVW = 228,
    M680X_INS_MUL = 229,
    M680X_INS_MULD = 230,
    M680X_INS_NEG = 231,
    M680X_INS_NEGA = 232,
    M680X_INS_NEGB = 233,
    M680X_INS_NEGD = 234,
    M680X_INS_NEGX = 235,
    M680X_INS_NOP = 236,
    M680X_INS_NSA = 237,
    M680X_INS_OIM = 238,
    M680X_INS_ORA = 239,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_ORAA = 240,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_ORAB = 241,
    M680X_INS_ORB = 242,
    M680X_INS_ORCC = 243,
    M680X_INS_ORD = 244,
    M680X_INS_ORR = 245,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_PSHA = 246,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_PSHB = 247,
    M680X_INS_PSHC = 248,
    M680X_INS_PSHD = 249,
    M680X_INS_PSHH = 250,
    M680X_INS_PSHS = 251,
    M680X_INS_PSHSW = 252,
    M680X_INS_PSHU = 253,
    M680X_INS_PSHUW = 254,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_PSHX = 255,
    M680X_INS_PSHY = 256,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_PULA = 257,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_PULB = 258,
    M680X_INS_PULC = 259,
    M680X_INS_PULD = 260,
    M680X_INS_PULH = 261,
    M680X_INS_PULS = 262,
    M680X_INS_PULSW = 263,
    M680X_INS_PULU = 264,
    M680X_INS_PULUW = 265,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_PULX = 266,
    M680X_INS_PULY = 267,
    M680X_INS_REV = 268,
    M680X_INS_REVW = 269,
    M680X_INS_ROL = 270,
    M680X_INS_ROLA = 271,
    M680X_INS_ROLB = 272,
    M680X_INS_ROLD = 273,
    M680X_INS_ROLW = 274,
    M680X_INS_ROLX = 275,
    M680X_INS_ROR = 276,
    M680X_INS_RORA = 277,
    M680X_INS_RORB = 278,
    M680X_INS_RORD = 279,
    M680X_INS_RORW = 280,
    M680X_INS_RORX = 281,
    M680X_INS_RSP = 282,
    M680X_INS_RTC = 283,
    M680X_INS_RTI = 284,
    M680X_INS_RTS = 285,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_SBA = 286,
    M680X_INS_SBC = 287,
    M680X_INS_SBCA = 288,
    M680X_INS_SBCB = 289,
    M680X_INS_SBCD = 290,
    M680X_INS_SBCR = 291,
    M680X_INS_SEC = 292,
    M680X_INS_SEI = 293,
    M680X_INS_SEV = 294,
    M680X_INS_SEX = 295,
    M680X_INS_SEXW = 296,
    M680X_INS_SLP = 297,
    M680X_INS_STA = 298,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_STAA = 299,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_STAB = 300,
    M680X_INS_STB = 301,
    M680X_INS_STBT = 302,
    M680X_INS_STD = 303,
    M680X_INS_STE = 304,
    M680X_INS_STF = 305,
    M680X_INS_STOP = 306,
    M680X_INS_STHX = 307,
    M680X_INS_STQ = 308,
    M680X_INS_STS = 309,
    M680X_INS_STU = 310,
    M680X_INS_STW = 311,
    M680X_INS_STX = 312,
    M680X_INS_STY = 313,
    M680X_INS_SUB = 314,
    M680X_INS_SUBA = 315,
    M680X_INS_SUBB = 316,
    M680X_INS_SUBD = 317,
    M680X_INS_SUBE = 318,
    M680X_INS_SUBF = 319,
    M680X_INS_SUBR = 320,
    M680X_INS_SUBW = 321,
    M680X_INS_SWI = 322,
    M680X_INS_SWI2 = 323,
    M680X_INS_SWI3 = 324,
    M680X_INS_SYNC = 325,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_TAB = 326,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_TAP = 327,
    M680X_INS_TAX = 328,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_TBA = 329,
    M680X_INS_TBEQ = 330,
    M680X_INS_TBL = 331,
    M680X_INS_TBNE = 332,
    M680X_INS_TEST = 333,
    M680X_INS_TFM = 334,
    M680X_INS_TFR = 335,
    M680X_INS_TIM = 336,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_TPA = 337,
    M680X_INS_TST = 338,
    M680X_INS_TSTA = 339,
    M680X_INS_TSTB = 340,
    M680X_INS_TSTD = 341,
    M680X_INS_TSTE = 342,
    M680X_INS_TSTF = 343,
    M680X_INS_TSTW = 344,
    M680X_INS_TSTX = 345,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_TSX = 346,
    M680X_INS_TSY = 347,
    M680X_INS_TXA = 348,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_TXS = 349,
    M680X_INS_TYS = 350,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_WAI = 351,
    M680X_INS_WAIT = 352,
    M680X_INS_WAV = 353,
    M680X_INS_WAVR = 354,
    #[doc = "< HD6301"]
    M680X_INS_XGDX = 355,
    M680X_INS_XGDY = 356,
    M680X_INS_ENDING = 357,
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_evm {
    #[doc = "< number of items popped from the stack"]
    pub pop: libc::c_uchar,
    #[doc = "< number of items pushed into the stack"]
    pub push: libc::c_uchar,
    #[doc = "< gas fee for the instruction"]
    pub fee: libc::c_uint,
}
impl Clone for cs_evm {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(u32)]
#[doc = " EVM instruction"]
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
pub enum evm_insn {
    EVM_INS_STOP = 0,
    EVM_INS_ADD = 1,
    EVM_INS_MUL = 2,
    EVM_INS_SUB = 3,
    EVM_INS_DIV = 4,
    EVM_INS_SDIV = 5,
    EVM_INS_MOD = 6,
    EVM_INS_SMOD = 7,
    EVM_INS_ADDMOD = 8,
    EVM_INS_MULMOD = 9,
    EVM_INS_EXP = 10,
    EVM_INS_SIGNEXTEND = 11,
    EVM_INS_LT = 16,
    EVM_INS_GT = 17,
    EVM_INS_SLT = 18,
    EVM_INS_SGT = 19,
    EVM_INS_EQ = 20,
    EVM_INS_ISZERO = 21,
    EVM_INS_AND = 22,
    EVM_INS_OR = 23,
    EVM_INS_XOR = 24,
    EVM_INS_NOT = 25,
    EVM_INS_BYTE = 26,
    EVM_INS_SHA3 = 32,
    EVM_INS_ADDRESS = 48,
    EVM_INS_BALANCE = 49,
    EVM_INS_ORIGIN = 50,
    EVM_INS_CALLER = 51,
    EVM_INS_CALLVALUE = 52,
    EVM_INS_CALLDATALOAD = 53,
    EVM_INS_CALLDATASIZE = 54,
    EVM_INS_CALLDATACOPY = 55,
    EVM_INS_CODESIZE = 56,
    EVM_INS_CODECOPY = 57,
    EVM_INS_GASPRICE = 58,
    EVM_INS_EXTCODESIZE = 59,
    EVM_INS_EXTCODECOPY = 60,
    EVM_INS_RETURNDATASIZE = 61,
    EVM_INS_RETURNDATACOPY = 62,
    EVM_INS_BLOCKHASH = 64,
    EVM_INS_COINBASE = 65,
    EVM_INS_TIMESTAMP = 66,
    EVM_INS_NUMBER = 67,
    EVM_INS_DIFFICULTY = 68,
    EVM_INS_GASLIMIT = 69,
    EVM_INS_POP = 80,
    EVM_INS_MLOAD = 81,
    EVM_INS_MSTORE = 82,
    EVM_INS_MSTORE8 = 83,
    EVM_INS_SLOAD = 84,
    EVM_INS_SSTORE = 85,
    EVM_INS_JUMP = 86,
    EVM_INS_JUMPI = 87,
    EVM_INS_PC = 88,
    EVM_INS_MSIZE = 89,
    EVM_INS_GAS = 90,
    EVM_INS_JUMPDEST = 91,
    EVM_INS_PUSH1 = 96,
    EVM_INS_PUSH2 = 97,
    EVM_INS_PUSH3 = 98,
    EVM_INS_PUSH4 = 99,
    EVM_INS_PUSH5 = 100,
    EVM_INS_PUSH6 = 101,
    EVM_INS_PUSH7 = 102,
    EVM_INS_PUSH8 = 103,
    EVM_INS_PUSH9 = 104,
    EVM_INS_PUSH10 = 105,
    EVM_INS_PUSH11 = 106,
    EVM_INS_PUSH12 = 107,
    EVM_INS_PUSH13 = 108,
    EVM_INS_PUSH14 = 109,
    EVM_INS_PUSH15 = 110,
    EVM_INS_PUSH16 = 111,
    EVM_INS_PUSH17 = 112,
    EVM_INS_PUSH18 = 113,
    EVM_INS_PUSH19 = 114,
    EVM_INS_PUSH20 = 115,
    EVM_INS_PUSH21 = 116,
    EVM_INS_PUSH22 = 117,
    EVM_INS_PUSH23 = 118,
    EVM_INS_PUSH24 = 119,
    EVM_INS_PUSH25 = 120,
    EVM_INS_PUSH26 = 121,
    EVM_INS_PUSH27 = 122,
    EVM_INS_PUSH28 = 123,
    EVM_INS_PUSH29 = 124,
    EVM_INS_PUSH30 = 125,
    EVM_INS_PUSH31 = 126,
    EVM_INS_PUSH32 = 127,
    EVM_INS_DUP1 = 128,
    EVM_INS_DUP2 = 129,
    EVM_INS_DUP3 = 130,
    EVM_INS_DUP4 = 131,
    EVM_INS_DUP5 = 132,
    EVM_INS_DUP6 = 133,
    EVM_INS_DUP7 = 134,
    EVM_INS_DUP8 = 135,
    EVM_INS_DUP9 = 136,
    EVM_INS_DUP10 = 137,
    EVM_INS_DUP11 = 138,
    EVM_INS_DUP12 = 139,
    EVM_INS_DUP13 = 140,
    EVM_INS_DUP14 = 141,
    EVM_INS_DUP15 = 142,
    EVM_INS_DUP16 = 143,
    EVM_INS_SWAP1 = 144,
    EVM_INS_SWAP2 = 145,
    EVM_INS_SWAP3 = 146,
    EVM_INS_SWAP4 = 147,
    EVM_INS_SWAP5 = 148,
    EVM_INS_SWAP6 = 149,
    EVM_INS_SWAP7 = 150,
    EVM_INS_SWAP8 = 151,
    EVM_INS_SWAP9 = 152,
    EVM_INS_SWAP10 = 153,
    EVM_INS_SWAP11 = 154,
    EVM_INS_SWAP12 = 155,
    EVM_INS_SWAP13 = 156,
    EVM_INS_SWAP14 = 157,
    EVM_INS_SWAP15 = 158,
    EVM_INS_SWAP16 = 159,
    EVM_INS_LOG0 = 160,
    EVM_INS_LOG1 = 161,
    EVM_INS_LOG2 = 162,
    EVM_INS_LOG3 = 163,
    EVM_INS_LOG4 = 164,
    EVM_INS_CREATE = 240,
    EVM_INS_CALL = 241,
    EVM_INS_CALLCODE = 242,
    EVM_INS_RETURN = 243,
    EVM_INS_DELEGATECALL = 244,
    EVM_INS_CALLBLACKBOX = 245,
    EVM_INS_STATICCALL = 250,
    EVM_INS_REVERT = 253,
    EVM_INS_SUICIDE = 255,
    EVM_INS_INVALID = 512,
    EVM_INS_ENDING = 513,
}
pub mod evm_insn_group {
    #[doc = " Group of EVM instructions"]
    pub type Type = u32;
    #[doc = "< = CS_GRP_INVALID"]
    pub const EVM_GRP_INVALID: Type = 0;
    #[doc = "< all jump instructions"]
    pub const EVM_GRP_JUMP: Type = 1;
    #[doc = "< math instructions"]
    pub const EVM_GRP_MATH: Type = 8;
    #[doc = "< instructions write to stack"]
    pub const EVM_GRP_STACK_WRITE: Type = 9;
    #[doc = "< instructions read from stack"]
    pub const EVM_GRP_STACK_READ: Type = 10;
    #[doc = "< instructions write to memory"]
    pub const EVM_GRP_MEM_WRITE: Type = 11;
    #[doc = "< instructions read from memory"]
    pub const EVM_GRP_MEM_READ: Type = 12;
    #[doc = "< instructions write to storage"]
    pub const EVM_GRP_STORE_WRITE: Type = 13;
    #[doc = "< instructions read from storage"]
    pub const EVM_GRP_STORE_READ: Type = 14;
    #[doc = "< instructions halt execution"]
    pub const EVM_GRP_HALT: Type = 15;
    #[doc = "< <-- mark the end of the list of groups"]
    pub const EVM_GRP_ENDING: Type = 16;
}
#[doc = " NOTE: All information in cs_detail is only available when CS_OPT_DETAIL = CS_OPT_ON"]
#[doc = " Initialized as memset(., 0, offsetof(cs_detail, ARCH)+sizeof(cs_ARCH))"]
#[doc = " by ARCH_getInstruction in arch/ARCH/ARCHDisassembler.c"]
#[doc = " if cs_detail changes, in particular if a field is added after the union,"]
#[doc = " then update arch/ARCH/ARCHDisassembler.c accordingly"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_detail {
    #[doc = "< list of implicit registers read by this insn"]
    pub regs_read: [u16; 12usize],
    #[doc = "< number of implicit registers read by this insn"]
    pub regs_read_count: u8,
    #[doc = "< list of implicit registers modified by this insn"]
    pub regs_write: [u16; 20usize],
    #[doc = "< number of implicit registers modified by this insn"]
    pub regs_write_count: u8,
    #[doc = "< list of group this instruction belong to"]
    pub groups: [u8; 8usize],
    #[doc = "< number of groups this insn belongs to"]
    pub groups_count: u8,
    pub __bindgen_anon_1: cs_detail__bindgen_ty_1,
}
#[doc = " Architecture-specific instruction info"]
#[repr(C)]
#[derive(Copy)]
pub union cs_detail__bindgen_ty_1 {
    #[doc = "< X86 architecture, including 16-bit, 32-bit & 64-bit mode"]
    pub x86: cs_x86,
    #[doc = "< ARM64 architecture (aka AArch64)"]
    pub arm64: cs_arm64,
    #[doc = "< ARM architecture (including Thumb/Thumb2)"]
    pub arm: cs_arm,
    #[doc = "< M68K architecture"]
    pub m68k: cs_m68k,
    #[doc = "< MIPS architecture"]
    pub mips: cs_mips,
    #[doc = "< PowerPC architecture"]
    pub ppc: cs_ppc,
    #[doc = "< Sparc architecture"]
    pub sparc: cs_sparc,
    #[doc = "< SystemZ architecture"]
    pub sysz: cs_sysz,
    #[doc = "< XCore architecture"]
    pub xcore: cs_xcore,
    #[doc = "< TMS320C64x architecture"]
    pub tms320c64x: cs_tms320c64x,
    #[doc = "< M680X architecture"]
    pub m680x: cs_m680x,
    #[doc = "< Ethereum architecture"]
    pub evm: cs_evm,
    _bindgen_union_align: [u64; 221usize],
}
impl Clone for cs_detail__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_detail__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_detail__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_detail {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_detail {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! ( f , "cs_detail {{ regs_read: {:?}, regs_read_count: {:?}, regs_write: {:?}, regs_write_count: {:?}, groups: {:?}, groups_count: {:?}, __bindgen_anon_1: {:?} }}" , self . regs_read , self . regs_read_count , self . regs_write , self . regs_write_count , self . groups , self . groups_count , self . __bindgen_anon_1 )
    }
}
#[doc = " Detail information of disassembled instruction"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_insn {
    #[doc = " Instruction ID (basically a numeric ID for the instruction mnemonic)"]
    #[doc = " Find the instruction id in the '[ARCH]_insn' enum in the header file"]
    #[doc = " of corresponding architecture, such as 'arm_insn' in arm.h for ARM,"]
    #[doc = " 'x86_insn' in x86.h for X86, etc..."]
    #[doc = " This information is available even when CS_OPT_DETAIL = CS_OPT_OFF"]
    #[doc = " NOTE: in Skipdata mode, \"data\" instruction has 0 for this id field."]
    pub id: libc::c_uint,
    #[doc = " Address (EIP) of this instruction"]
    #[doc = " This information is available even when CS_OPT_DETAIL = CS_OPT_OFF"]
    pub address: u64,
    #[doc = " Size of this instruction"]
    #[doc = " This information is available even when CS_OPT_DETAIL = CS_OPT_OFF"]
    pub size: u16,
    #[doc = " Machine bytes of this instruction, with number of bytes indicated by @size above"]
    #[doc = " This information is available even when CS_OPT_DETAIL = CS_OPT_OFF"]
    pub bytes: [u8; 16usize],
    #[doc = " Ascii text of instruction mnemonic"]
    #[doc = " This information is available even when CS_OPT_DETAIL = CS_OPT_OFF"]
    pub mnemonic: [libc::c_char; 32usize],
    #[doc = " Ascii text of instruction operands"]
    #[doc = " This information is available even when CS_OPT_DETAIL = CS_OPT_OFF"]
    pub op_str: [libc::c_char; 160usize],
    #[doc = " Pointer to cs_detail."]
    #[doc = " NOTE: detail pointer is only valid when both requirements below are met:"]
    #[doc = " (1) CS_OP_DETAIL = CS_OPT_ON"]
    #[doc = " (2) Engine is not in Skipdata mode (CS_OP_SKIPDATA option set to CS_OPT_ON)"]
    #[doc = ""]
    #[doc = " NOTE 2: when in Skipdata mode, or when detail mode is OFF, even if this pointer"]
    #[doc = "     is not NULL, its content is still irrelevant."]
    pub detail: *mut cs_detail,
}
impl Clone for cs_insn {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_insn {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! ( f , "cs_insn {{ id: {:?}, address: {:?}, size: {:?}, bytes: {:?}, mnemonic: [...], op_str: [...], detail: {:?} }}" , self . id , self . address , self . size , self . bytes , self . detail )
    }
}
pub mod cs_err {
    #[doc = " All type of errors encountered by Capstone API."]
    #[doc = " These are values returned by cs_errno()"]
    pub type Type = u32;
    #[doc = "< No error: everything was fine"]
    pub const CS_ERR_OK: Type = 0;
    #[doc = "< Out-Of-Memory error: cs_open(), cs_disasm(), cs_disasm_iter()"]
    pub const CS_ERR_MEM: Type = 1;
    #[doc = "< Unsupported architecture: cs_open()"]
    pub const CS_ERR_ARCH: Type = 2;
    #[doc = "< Invalid handle: cs_op_count(), cs_op_index()"]
    pub const CS_ERR_HANDLE: Type = 3;
    #[doc = "< Invalid csh argument: cs_close(), cs_errno(), cs_option()"]
    pub const CS_ERR_CSH: Type = 4;
    #[doc = "< Invalid/unsupported mode: cs_open()"]
    pub const CS_ERR_MODE: Type = 5;
    #[doc = "< Invalid/unsupported option: cs_option()"]
    pub const CS_ERR_OPTION: Type = 6;
    #[doc = "< Information is unavailable because detail option is OFF"]
    pub const CS_ERR_DETAIL: Type = 7;
    #[doc = "< Dynamic memory management uninitialized (see CS_OPT_MEM)"]
    pub const CS_ERR_MEMSETUP: Type = 8;
    #[doc = "< Unsupported version (bindings)"]
    pub const CS_ERR_VERSION: Type = 9;
    #[doc = "< Access irrelevant data in \"diet\" engine"]
    pub const CS_ERR_DIET: Type = 10;
    #[doc = "< Access irrelevant data for \"data\" instruction in SKIPDATA mode"]
    pub const CS_ERR_SKIPDATA: Type = 11;
    #[doc = "< X86 AT&T syntax is unsupported (opt-out at compile time)"]
    pub const CS_ERR_X86_ATT: Type = 12;
    #[doc = "< X86 Intel syntax is unsupported (opt-out at compile time)"]
    pub const CS_ERR_X86_INTEL: Type = 13;
    #[doc = "< X86 Masm syntax is unsupported (opt-out at compile time)"]
    pub const CS_ERR_X86_MASM: Type = 14;
}
extern "C" {
    #[doc = "Return combined API version & major and minor version numbers."]
    #[doc = ""]
    #[doc = "@major: major number of API version"]
    #[doc = "@minor: minor number of API version"]
    #[doc = ""]
    #[doc = "@return hexical number as (major << 8 | minor), which encodes both"]
    #[doc = "major & minor versions."]
    #[doc = "NOTE: This returned value can be compared with version number made"]
    #[doc = "with macro CS_MAKE_VERSION"]
    #[doc = ""]
    #[doc = "For example, second API version would return 1 in @major, and 1 in @minor"]
    #[doc = "The return value would be 0x0101"]
    #[doc = ""]
    #[doc = "NOTE: if you only care about returned value, but not major and minor values,"]
    #[doc = "set both @major & @minor arguments to NULL."]
    pub fn cs_version(major: *mut libc::c_int, minor: *mut libc::c_int) -> libc::c_uint;
}
extern "C" {
    #[doc = "This API can be used to either ask for archs supported by this library,"]
    #[doc = "or check to see if the library was compile with 'diet' option (or called"]
    #[doc = "in 'diet' mode)."]
    #[doc = ""]
    #[doc = "To check if a particular arch is supported by this library, set @query to"]
    #[doc = "arch mode (CS_ARCH_* value)."]
    #[doc = "To verify if this library supports all the archs, use CS_ARCH_ALL."]
    #[doc = ""]
    #[doc = "To check if this library is in 'diet' mode, set @query to CS_SUPPORT_DIET."]
    #[doc = ""]
    #[doc = "@return True if this library supports the given arch, or in 'diet' mode."]
    pub fn cs_support(query: libc::c_int) -> bool;
}
extern "C" {
    #[doc = "Initialize CS handle: this must be done before any usage of CS."]
    #[doc = ""]
    #[doc = "@arch: architecture type (CS_ARCH_*)"]
    #[doc = "@mode: hardware mode. This is combined of CS_MODE_*"]
    #[doc = "@handle: pointer to handle, which will be updated at return time"]
    #[doc = ""]
    #[doc = "@return CS_ERR_OK on success, or other value on failure (refer to cs_err enum"]
    #[doc = "for detailed error)."]
    pub fn cs_open(arch: cs_arch, mode: cs_mode, handle: *mut csh) -> cs_err::Type;
}
extern "C" {
    #[doc = "Close CS handle: MUST do to release the handle when it is not used anymore."]
    #[doc = "NOTE: this must be only called when there is no longer usage of Capstone,"]
    #[doc = "not even access to cs_insn array. The reason is the this API releases some"]
    #[doc = "cached memory, thus access to any Capstone API after cs_close() might crash"]
    #[doc = "your application."]
    #[doc = ""]
    #[doc = "In fact,this API invalidate @handle by ZERO out its value (i.e *handle = 0)."]
    #[doc = ""]
    #[doc = "@handle: pointer to a handle returned by cs_open()"]
    #[doc = ""]
    #[doc = "@return CS_ERR_OK on success, or other value on failure (refer to cs_err enum"]
    #[doc = "for detailed error)."]
    pub fn cs_close(handle: *mut csh) -> cs_err::Type;
}
extern "C" {
    #[doc = "Set option for disassembling engine at runtime"]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@type: type of option to be set"]
    #[doc = "@value: option value corresponding with @type"]
    #[doc = ""]
    #[doc = "@return: CS_ERR_OK on success, or other value on failure."]
    #[doc = "Refer to cs_err enum for detailed error."]
    #[doc = ""]
    #[doc = "NOTE: in the case of CS_OPT_MEM, handle's value can be anything,"]
    #[doc = "so that cs_option(handle, CS_OPT_MEM, value) can (i.e must) be called"]
    #[doc = "even before cs_open()"]
    pub fn cs_option(handle: csh, type_: cs_opt_type, value: usize) -> cs_err::Type;
}
extern "C" {
    #[doc = "Report the last error number when some API function fail."]
    #[doc = "Like glibc's errno, cs_errno might not retain its old value once accessed."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = ""]
    #[doc = "@return: error code of cs_err enum type (CS_ERR_*, see above)"]
    pub fn cs_errno(handle: csh) -> cs_err::Type;
}
extern "C" {
    #[doc = "Return a string describing given error code."]
    #[doc = ""]
    #[doc = "@code: error code (see CS_ERR_* above)"]
    #[doc = ""]
    #[doc = "@return: returns a pointer to a string that describes the error code"]
    #[doc = "passed in the argument @code"]
    pub fn cs_strerror(code: cs_err::Type) -> *const libc::c_char;
}
extern "C" {
    #[doc = "Disassemble binary code, given the code buffer, size, address and number"]
    #[doc = "of instructions to be decoded."]
    #[doc = "This API dynamically allocate memory to contain disassembled instruction."]
    #[doc = "Resulting instructions will be put into @*insn"]
    #[doc = ""]
    #[doc = "NOTE 1: this API will automatically determine memory needed to contain"]
    #[doc = "output disassembled instructions in @insn."]
    #[doc = ""]
    #[doc = "NOTE 2: caller must free the allocated memory itself to avoid memory leaking."]
    #[doc = ""]
    #[doc = "NOTE 3: for system with scarce memory to be dynamically allocated such as"]
    #[doc = "OS kernel or firmware, the API cs_disasm_iter() might be a better choice than"]
    #[doc = "cs_disasm(). The reason is that with cs_disasm(), based on limited available"]
    #[doc = "memory, we have to calculate in advance how many instructions to be disassembled,"]
    #[doc = "which complicates things. This is especially troublesome for the case @count=0,"]
    #[doc = "when cs_disasm() runs uncontrollably (until either end of input buffer, or"]
    #[doc = "when it encounters an invalid instruction)."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@code: buffer containing raw binary code to be disassembled."]
    #[doc = "@code_size: size of the above code buffer."]
    #[doc = "@address: address of the first instruction in given raw code buffer."]
    #[doc = "@insn: array of instructions filled in by this API."]
    #[doc = "NOTE: @insn will be allocated by this function, and should be freed"]
    #[doc = "with cs_free() API."]
    #[doc = "@count: number of instructions to be disassembled, or 0 to get all of them"]
    #[doc = ""]
    #[doc = "@return: the number of successfully disassembled instructions,"]
    #[doc = "or 0 if this function failed to disassemble the given code"]
    #[doc = ""]
    #[doc = "On failure, call cs_errno() for error code."]
    pub fn cs_disasm(
        handle: csh,
        code: *const u8,
        code_size: usize,
        address: u64,
        count: usize,
        insn: *mut *mut cs_insn,
    ) -> usize;
}
extern "C" {
    #[doc = "Deprecated function - to be retired in the next version!"]
    #[doc = "Use cs_disasm() instead of cs_disasm_ex()"]
    pub fn cs_disasm_ex(
        handle: csh,
        code: *const u8,
        code_size: usize,
        address: u64,
        count: usize,
        insn: *mut *mut cs_insn,
    ) -> usize;
}
extern "C" {
    #[doc = "Free memory allocated by cs_malloc() or cs_disasm() (argument @insn)"]
    #[doc = ""]
    #[doc = "@insn: pointer returned by @insn argument in cs_disasm() or cs_malloc()"]
    #[doc = "@count: number of cs_insn structures returned by cs_disasm(), or 1"]
    #[doc = "to free memory allocated by cs_malloc()."]
    pub fn cs_free(insn: *mut cs_insn, count: usize);
}
extern "C" {
    #[doc = "Allocate memory for 1 instruction to be used by cs_disasm_iter()."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = ""]
    #[doc = "NOTE: when no longer in use, you can reclaim the memory allocated for"]
    #[doc = "this instruction with cs_free(insn, 1)"]
    pub fn cs_malloc(handle: csh) -> *mut cs_insn;
}
extern "C" {
    #[doc = "Fast API to disassemble binary code, given the code buffer, size, address"]
    #[doc = "and number of instructions to be decoded."]
    #[doc = "This API puts the resulting instruction into a given cache in @insn."]
    #[doc = "See tests/test_iter.c for sample code demonstrating this API."]
    #[doc = ""]
    #[doc = "NOTE 1: this API will update @code, @size & @address to point to the next"]
    #[doc = "instruction in the input buffer. Therefore, it is convenient to use"]
    #[doc = "cs_disasm_iter() inside a loop to quickly iterate all the instructions."]
    #[doc = "While decoding one instruction at a time can also be achieved with"]
    #[doc = "cs_disasm(count=1), some benchmarks shown that cs_disasm_iter() can be 30%"]
    #[doc = "faster on random input."]
    #[doc = ""]
    #[doc = "NOTE 2: the cache in @insn can be created with cs_malloc() API."]
    #[doc = ""]
    #[doc = "NOTE 3: for system with scarce memory to be dynamically allocated such as"]
    #[doc = "OS kernel or firmware, this API is recommended over cs_disasm(), which"]
    #[doc = "allocates memory based on the number of instructions to be disassembled."]
    #[doc = "The reason is that with cs_disasm(), based on limited available memory,"]
    #[doc = "we have to calculate in advance how many instructions to be disassembled,"]
    #[doc = "which complicates things. This is especially troublesome for the case"]
    #[doc = "@count=0, when cs_disasm() runs uncontrollably (until either end of input"]
    #[doc = "buffer, or when it encounters an invalid instruction)."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@code: buffer containing raw binary code to be disassembled"]
    #[doc = "@size: size of above code"]
    #[doc = "@address: address of the first insn in given raw code buffer"]
    #[doc = "@insn: pointer to instruction to be filled in by this API."]
    #[doc = ""]
    #[doc = "@return: true if this API successfully decode 1 instruction,"]
    #[doc = "or false otherwise."]
    #[doc = ""]
    #[doc = "On failure, call cs_errno() for error code."]
    pub fn cs_disasm_iter(
        handle: csh,
        code: *mut *const u8,
        size: *mut usize,
        address: *mut u64,
        insn: *mut cs_insn,
    ) -> bool;
}
extern "C" {
    #[doc = "Return friendly name of register in a string."]
    #[doc = "Find the instruction id from header file of corresponding architecture (arm.h for ARM,"]
    #[doc = "x86.h for X86, ...)"]
    #[doc = ""]
    #[doc = "WARN: when in 'diet' mode, this API is irrelevant because engine does not"]
    #[doc = "store register name."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@reg_id: register id"]
    #[doc = ""]
    #[doc = "@return: string name of the register, or NULL if @reg_id is invalid."]
    pub fn cs_reg_name(handle: csh, reg_id: libc::c_uint) -> *const libc::c_char;
}
extern "C" {
    #[doc = "Return friendly name of an instruction in a string."]
    #[doc = "Find the instruction id from header file of corresponding architecture (arm.h for ARM, x86.h for X86, ...)"]
    #[doc = ""]
    #[doc = "WARN: when in 'diet' mode, this API is irrelevant because the engine does not"]
    #[doc = "store instruction name."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@insn_id: instruction id"]
    #[doc = ""]
    #[doc = "@return: string name of the instruction, or NULL if @insn_id is invalid."]
    pub fn cs_insn_name(handle: csh, insn_id: libc::c_uint) -> *const libc::c_char;
}
extern "C" {
    #[doc = "Return friendly name of a group id (that an instruction can belong to)"]
    #[doc = "Find the group id from header file of corresponding architecture (arm.h for ARM, x86.h for X86, ...)"]
    #[doc = ""]
    #[doc = "WARN: when in 'diet' mode, this API is irrelevant because the engine does not"]
    #[doc = "store group name."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@group_id: group id"]
    #[doc = ""]
    #[doc = "@return: string name of the group, or NULL if @group_id is invalid."]
    pub fn cs_group_name(handle: csh, group_id: libc::c_uint) -> *const libc::c_char;
}
extern "C" {
    #[doc = "Check if a disassembled instruction belong to a particular group."]
    #[doc = "Find the group id from header file of corresponding architecture (arm.h for ARM, x86.h for X86, ...)"]
    #[doc = "Internally, this simply verifies if @group_id matches any member of insn->groups array."]
    #[doc = ""]
    #[doc = "NOTE: this API is only valid when detail option is ON (which is OFF by default)."]
    #[doc = ""]
    #[doc = "WARN: when in 'diet' mode, this API is irrelevant because the engine does not"]
    #[doc = "update @groups array."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@insn: disassembled instruction structure received from cs_disasm() or cs_disasm_iter()"]
    #[doc = "@group_id: group that you want to check if this instruction belong to."]
    #[doc = ""]
    #[doc = "@return: true if this instruction indeed belongs to the given group, or false otherwise."]
    pub fn cs_insn_group(handle: csh, insn: *const cs_insn, group_id: libc::c_uint) -> bool;
}
extern "C" {
    #[doc = "Check if a disassembled instruction IMPLICITLY used a particular register."]
    #[doc = "Find the register id from header file of corresponding architecture (arm.h for ARM, x86.h for X86, ...)"]
    #[doc = "Internally, this simply verifies if @reg_id matches any member of insn->regs_read array."]
    #[doc = ""]
    #[doc = "NOTE: this API is only valid when detail option is ON (which is OFF by default)"]
    #[doc = ""]
    #[doc = "WARN: when in 'diet' mode, this API is irrelevant because the engine does not"]
    #[doc = "update @regs_read array."]
    #[doc = ""]
    #[doc = "@insn: disassembled instruction structure received from cs_disasm() or cs_disasm_iter()"]
    #[doc = "@reg_id: register that you want to check if this instruction used it."]
    #[doc = ""]
    #[doc = "@return: true if this instruction indeed implicitly used the given register, or false otherwise."]
    pub fn cs_reg_read(handle: csh, insn: *const cs_insn, reg_id: libc::c_uint) -> bool;
}
extern "C" {
    #[doc = "Check if a disassembled instruction IMPLICITLY modified a particular register."]
    #[doc = "Find the register id from header file of corresponding architecture (arm.h for ARM, x86.h for X86, ...)"]
    #[doc = "Internally, this simply verifies if @reg_id matches any member of insn->regs_write array."]
    #[doc = ""]
    #[doc = "NOTE: this API is only valid when detail option is ON (which is OFF by default)"]
    #[doc = ""]
    #[doc = "WARN: when in 'diet' mode, this API is irrelevant because the engine does not"]
    #[doc = "update @regs_write array."]
    #[doc = ""]
    #[doc = "@insn: disassembled instruction structure received from cs_disasm() or cs_disasm_iter()"]
    #[doc = "@reg_id: register that you want to check if this instruction modified it."]
    #[doc = ""]
    #[doc = "@return: true if this instruction indeed implicitly modified the given register, or false otherwise."]
    pub fn cs_reg_write(handle: csh, insn: *const cs_insn, reg_id: libc::c_uint) -> bool;
}
extern "C" {
    #[doc = "Count the number of operands of a given type."]
    #[doc = "Find the operand type in header file of corresponding architecture (arm.h for ARM, x86.h for X86, ...)"]
    #[doc = ""]
    #[doc = "NOTE: this API is only valid when detail option is ON (which is OFF by default)"]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@insn: disassembled instruction structure received from cs_disasm() or cs_disasm_iter()"]
    #[doc = "@op_type: Operand type to be found."]
    #[doc = ""]
    #[doc = "@return: number of operands of given type @op_type in instruction @insn,"]
    #[doc = "or -1 on failure."]
    pub fn cs_op_count(handle: csh, insn: *const cs_insn, op_type: libc::c_uint) -> libc::c_int;
}
extern "C" {
    #[doc = "Retrieve the position of operand of given type in <arch>.operands[] array."]
    #[doc = "Later, the operand can be accessed using the returned position."]
    #[doc = "Find the operand type in header file of corresponding architecture (arm.h for ARM, x86.h for X86, ...)"]
    #[doc = ""]
    #[doc = "NOTE: this API is only valid when detail option is ON (which is OFF by default)"]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@insn: disassembled instruction structure received from cs_disasm() or cs_disasm_iter()"]
    #[doc = "@op_type: Operand type to be found."]
    #[doc = "@position: position of the operand to be found. This must be in the range"]
    #[doc = "[1, cs_op_count(handle, insn, op_type)]"]
    #[doc = ""]
    #[doc = "@return: index of operand of given type @op_type in <arch>.operands[] array"]
    #[doc = "in instruction @insn, or -1 on failure."]
    pub fn cs_op_index(
        handle: csh,
        insn: *const cs_insn,
        op_type: libc::c_uint,
        position: libc::c_uint,
    ) -> libc::c_int;
}
#[doc = " Type of array to keep the list of registers"]
pub type cs_regs = [u16; 64usize];
extern "C" {
    #[doc = "Retrieve all the registers accessed by an instruction, either explicitly or"]
    #[doc = "implicitly."]
    #[doc = ""]
    #[doc = "WARN: when in 'diet' mode, this API is irrelevant because engine does not"]
    #[doc = "store registers."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@insn: disassembled instruction structure returned from cs_disasm() or cs_disasm_iter()"]
    #[doc = "@regs_read: on return, this array contains all registers read by instruction."]
    #[doc = "@regs_read_count: number of registers kept inside @regs_read array."]
    #[doc = "@regs_write: on return, this array contains all registers written by instruction."]
    #[doc = "@regs_write_count: number of registers kept inside @regs_write array."]
    #[doc = ""]
    #[doc = "@return CS_ERR_OK on success, or other value on failure (refer to cs_err enum"]
    #[doc = "for detailed error)."]
    pub fn cs_regs_access(
        handle: csh,
        insn: *const cs_insn,
        regs_read: *mut u16,
        regs_read_count: *mut u8,
        regs_write: *mut u16,
        regs_write_count: *mut u8,
    ) -> cs_err::Type;
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy)]
pub struct __va_list_tag {
    pub gp_offset: libc::c_uint,
    pub fp_offset: libc::c_uint,
    pub overflow_arg_area: *mut libc::c_void,
    pub reg_save_area: *mut libc::c_void,
}
impl Clone for __va_list_tag {
    fn clone(&self) -> Self {
        *self
    }
}
