# gtk 

[Project site](http://gtk-rs.org/)

__Rust__ bindings and wrappers for __GTK 3__, part of [gtk3-rs](https://github.com/gtk-rs/gtk3-rs).

## Minimum supported Rust version

Currently, the minimum supported Rust version is `1.51.0`.

## Building

__gtk__ expects __GTK__, __GLib__ and __Cairo__ development files to be installed on your system.
See the [GTK installation page](https://www.gtk.org/docs/installations/).

## Using

We recommend using [crates from crates.io](https://crates.io/keywords/gtk-rs),
as [demonstrated here](http://gtk-rs.org/#using).

If you want to track the bleeding edge, use the git dependency instead:

```toml
[dependencies]
gtk = { git = "https://github.com/gtk-rs/gtk3-rs.git" }
```

Avoid mixing versioned and git crates like this:

```toml
# This will not compile
[dependencies]
gtk = "0.13"
gtk = { git = "https://github.com/gtk-rs/gtk3-rs.git" }
```

## Documentation

 * [Rust API - Stable](https://gtk-rs.org/gtk3-rs/stable/latest/docs/gtk/)
 * [Rust API - Development](https://gtk-rs.org/gtk3-rs/git/docs/gtk)
 * [C API](https://developer.gnome.org/gtk/stable/)
 * [GTK Installation instructions](https://www.gtk.org/docs/installations/)

Generate the docs:

```shell
> cargo doc --features dox
```

(if the installed GTK+ version is lower than 3.16, adjust the feature name accordingly).

## Contribute

Contributor you're welcome!

See the general [bindings documentation](https://gtk-rs.org/gtk-rs-core/stable/latest/docs/glib/).

Most of the bindings ([`src/auto`](src/auto)) are generated by [gir](https://github.com/gtk-rs/gir) using [this configuration file](Gir.toml). After editing `Gir.toml` the sources can be regenerated with

```shell
> make gir
```

When opening a PR please put the changes to the `src/auto` directory in a separate commit.

You may also wish to run `cargo clippy -- -D warnings` and check that you're clean because
otherwise you may be surprised when CI fails.

## See Also

 * [atk](https://crates.io/crates/atk)
 * [cairo](https://crates.io/crates/cairo-rs)
 * [gdk](https://crates.io/crates/gdk)
 * [gdk-pixbuf](https://crates.io/crates/gdk-pixbuf)
 * [gio](https://crates.io/crates/gio)
 * [glib](https://crates.io/crates/glib)
 * [pango](https://crates.io/crates/pango)

## License

__gtk__ is available under the MIT License, please refer to it.
