// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, CacheType, SessionFeature};
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "SoupCache")]
    pub struct Cache(Object<ffi::SoupCache, ffi::SoupCacheClass>) @implements SessionFeature;

    match fn {
        type_ => || ffi::soup_cache_get_type(),
    }
}

impl Cache {
    pub const NONE: Option<&'static Cache> = None;

    #[doc(alias = "soup_cache_new")]
    pub fn new(cache_dir: Option<&str>, cache_type: CacheType) -> Cache {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_cache_new(
                cache_dir.to_glib_none().0,
                cache_type.into_glib(),
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Cache`] objects.
    ///
    /// This method returns an instance of [`CacheBuilder`](crate::builders::CacheBuilder) which can be used to create [`Cache`] objects.
    pub fn builder() -> CacheBuilder {
        CacheBuilder::new()
    }
}

impl Default for Cache {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Cache`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct CacheBuilder {
    builder: glib::object::ObjectBuilder<'static, Cache>,
}

impl CacheBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn cache_dir(self, cache_dir: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("cache-dir", cache_dir.into()),
        }
    }

    pub fn cache_type(self, cache_type: CacheType) -> Self {
        Self {
            builder: self.builder.property("cache-type", cache_type),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Cache`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Cache {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Cache>> Sealed for T {}
}

pub trait CacheExt: IsA<Cache> + sealed::Sealed + 'static {
    #[doc(alias = "soup_cache_clear")]
    fn clear(&self) {
        unsafe {
            ffi::soup_cache_clear(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "soup_cache_dump")]
    fn dump(&self) {
        unsafe {
            ffi::soup_cache_dump(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "soup_cache_flush")]
    fn flush(&self) {
        unsafe {
            ffi::soup_cache_flush(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "soup_cache_get_max_size")]
    #[doc(alias = "get_max_size")]
    fn max_size(&self) -> u32 {
        unsafe { ffi::soup_cache_get_max_size(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "soup_cache_load")]
    fn load(&self) {
        unsafe {
            ffi::soup_cache_load(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "soup_cache_set_max_size")]
    fn set_max_size(&self, max_size: u32) {
        unsafe {
            ffi::soup_cache_set_max_size(self.as_ref().to_glib_none().0, max_size);
        }
    }

    #[doc(alias = "cache-dir")]
    fn cache_dir(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "cache-dir")
    }

    #[doc(alias = "cache-type")]
    fn cache_type(&self) -> CacheType {
        ObjectExt::property(self.as_ref(), "cache-type")
    }
}

impl<O: IsA<Cache>> CacheExt for O {}
