This error occurs when the compiler is unable to unambiguously infer the
return type of a function or method which is generic on return type, such
as the `collect` method for `Iterator`s.

For example:

```compile_fail,E0284
fn foo() -> Result<bool, ()> {
    let results = [Ok(true), Ok(false), Err(())].iter().cloned();
    let v: Vec<bool> = results.collect()?;
    // Do things with v...
    Ok(true)
}
```

Here we have an iterator `results` over `Result<bool, ()>`.
Hence, `results.collect()` can return any type implementing
`FromIterator<Result<bool, ()>>`. On the other hand, the
`?` operator can accept any type implementing `Try`.

The author of this code probably wants `collect()` to return a
`Result<Vec<bool>, ()>`, but the compiler can't be sure
that there isn't another type `T` implementing both `Try` and
`FromIterator<Result<bool, ()>>` in scope such that
`T::Ok == Vec<bool>`. Hence, this code is ambiguous and an error
is returned.

To resolve this error, use a concrete type for the intermediate expression:

```
fn foo() -> Result<bool, ()> {
    let results = [Ok(true), Ok(false), Err(())].iter().cloned();
    let v = {
        let temp: Result<Vec<bool>, ()> = results.collect();
        temp?
    };
    // Do things with v...
    Ok(true)
}
```

Note that the type of `v` can now be inferred from the type of `temp`.
