A type that is not a trait was used in a trait position, such as a bound
or `impl`.

Erroneous code example:

```compile_fail,E0404
struct Foo;
struct Bar;

impl Foo for Bar {} // error: `Foo` is not a trait
```

Another erroneous code example:

```compile_fail,E0404
struct Foo;

fn bar<T: Foo>(t: T) {} // error: `Foo` is not a trait
```

Please verify that the trait's name was not misspelled or that the right
identifier was used. Example:

```
trait Foo {
    // some functions
}
struct Bar;

impl Foo for Bar { // ok!
    // functions implementation
}
```

or:

```
trait Foo {
    // some functions
}

fn bar<T: Foo>(t: T) {} // ok!
```
