//===- llvm/unittest/Bitcode/BitReaderTestCode.h - Bitcode for tests ------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_UNITTESTS_BITCODE_BITREADERTESTCODE_H
#define LLVM_UNITTESTS_BITCODE_BITREADERTESTCODE_H

// define void @func() {
//   unreachable
// }
// declare i32 @func_header()
// declare i8* @ret_ptr()
// declare i8* @ret_and_arg_ptr(i32 addrspace(8)*)
// declare i8 addrspace(1)* @double_ptr(i32* addrspace(2)*, i32***)
const unsigned char AccessFunctionTypeInfoBc[] = {
    0x42, 0x43, 0xc0, 0xde, 0x35, 0x14, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x62, 0x0c, 0x30, 0x24, 0x4d, 0x59, 0xbe, 0x66, 0xad, 0xfb, 0xb4, 0x4f,
    0x1b, 0xc8, 0x24, 0x44, 0x01, 0x32, 0x05, 0x00, 0x21, 0x0c, 0x00, 0x00,
    0x3f, 0x01, 0x00, 0x00, 0x0b, 0x02, 0x21, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x16, 0x00, 0x00, 0x00, 0x07, 0x81, 0x23, 0x91, 0x41, 0xc8, 0x04, 0x49,
    0x06, 0x10, 0x32, 0x39, 0x92, 0x01, 0x84, 0x0c, 0x25, 0x05, 0x08, 0x19,
    0x1e, 0x04, 0x8b, 0x62, 0x80, 0x14, 0x45, 0x02, 0x42, 0x92, 0x0b, 0x42,
    0xa4, 0x10, 0x32, 0x14, 0x38, 0x08, 0x18, 0x4b, 0x0a, 0x32, 0x52, 0x88,
    0x48, 0x70, 0xc4, 0x21, 0x23, 0x44, 0x12, 0x87, 0x8c, 0x10, 0x41, 0x92,
    0x02, 0x64, 0xc8, 0x08, 0xb1, 0x14, 0x20, 0x43, 0x46, 0x88, 0x20, 0xc9,
    0x01, 0x32, 0x52, 0x84, 0x18, 0x2a, 0x28, 0x2a, 0x90, 0x31, 0x7c, 0xb0,
    0x5c, 0x91, 0x20, 0xc5, 0xc8, 0x00, 0x00, 0x00, 0x89, 0x20, 0x00, 0x00,
    0x14, 0x00, 0x00, 0x00, 0x32, 0x22, 0x48, 0x09, 0x20, 0x62, 0x46, 0x00,
    0x21, 0x2b, 0x24, 0x98, 0x14, 0x21, 0x25, 0x24, 0x98, 0x14, 0x19, 0x27,
    0x0c, 0x85, 0xa4, 0x90, 0x60, 0x52, 0x64, 0x5c, 0x20, 0x24, 0x65, 0x82,
    0xa0, 0x1a, 0x01, 0x30, 0x01, 0xa0, 0x30, 0x47, 0x00, 0x06, 0x26, 0x18,
    0x44, 0xe6, 0x08, 0x10, 0x32, 0x26, 0x38, 0x84, 0x06, 0x11, 0x06, 0xc4,
    0x08, 0x47, 0xd1, 0x1a, 0x44, 0x30, 0x02, 0x1a, 0x83, 0x08, 0x8e, 0x40,
    0x8e, 0xa0, 0x19, 0xda, 0x8b, 0x24, 0x07, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x1a, 0x21, 0x4c, 0x0e, 0x0f, 0xde, 0x9c, 0x4e, 0x4e, 0xbb, 0x7d, 0x43,
    0x2a, 0x80, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x08, 0x60, 0x48, 0x45, 0x2c, 0x04, 0x10, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0c, 0xa9,
    0x9e, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x80, 0x21, 0x95, 0xf5, 0x2c, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x30, 0xa4, 0x2a,
    0x03, 0x45, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x00, 0x89, 0x0d, 0x02, 0x45, 0x87, 0x02, 0x00, 0x00,
    0x62, 0x31, 0x00, 0x00, 0xb9, 0x00, 0x00, 0x00, 0x33, 0x08, 0x80, 0x1c,
    0xc4, 0xe1, 0x1c, 0x66, 0x14, 0x01, 0x3d, 0x88, 0x43, 0x38, 0x84, 0xc3,
    0x8c, 0x42, 0x80, 0x07, 0x79, 0x78, 0x07, 0x73, 0x98, 0x71, 0x0c, 0xe6,
    0x00, 0x0f, 0xed, 0x10, 0x0e, 0xf4, 0x80, 0x0e, 0x33, 0x0c, 0x42, 0x1e,
    0xc2, 0xc1, 0x1d, 0xce, 0xa1, 0x1c, 0x66, 0x30, 0x05, 0x3d, 0x88, 0x43,
    0x38, 0x84, 0x83, 0x1b, 0xcc, 0x03, 0x3d, 0xc8, 0x43, 0x3d, 0x8c, 0x03,
    0x3d, 0xcc, 0x78, 0x8c, 0x74, 0x70, 0x07, 0x7b, 0x08, 0x07, 0x79, 0x48,
    0x87, 0x70, 0x70, 0x07, 0x7a, 0x70, 0x03, 0x76, 0x78, 0x87, 0x70, 0x20,
    0x87, 0x19, 0xcc, 0x11, 0x0e, 0xec, 0x90, 0x0e, 0xe1, 0x30, 0x0f, 0x6e,
    0x30, 0x0f, 0xe3, 0xf0, 0x0e, 0xf0, 0x50, 0x0e, 0x33, 0x10, 0xc4, 0x1d,
    0xde, 0x21, 0x1c, 0xd8, 0x21, 0x1d, 0xc2, 0x61, 0x1e, 0x66, 0x30, 0x89,
    0x3b, 0xbc, 0x83, 0x3b, 0xd0, 0x43, 0x39, 0xb4, 0x03, 0x3c, 0xbc, 0x83,
    0x3c, 0x84, 0x03, 0x3b, 0xcc, 0xf0, 0x14, 0x76, 0x60, 0x07, 0x7b, 0x68,
    0x07, 0x37, 0x68, 0x87, 0x72, 0x68, 0x07, 0x37, 0x80, 0x87, 0x70, 0x90,
    0x87, 0x70, 0x60, 0x07, 0x76, 0x28, 0x07, 0x76, 0xf8, 0x05, 0x76, 0x78,
    0x87, 0x77, 0x80, 0x87, 0x5f, 0x08, 0x87, 0x71, 0x18, 0x87, 0x72, 0x98,
    0x87, 0x79, 0x98, 0x81, 0x2c, 0xee, 0xf0, 0x0e, 0xee, 0xe0, 0x0e, 0xf5,
    0xc0, 0x0e, 0xec, 0x30, 0x03, 0x62, 0xc8, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c,
    0xcc, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xdc, 0x61, 0x1c, 0xca, 0x21, 0x1c,
    0xc4, 0x81, 0x1d, 0xca, 0x61, 0x06, 0xd6, 0x90, 0x43, 0x39, 0xc8, 0x43,
    0x39, 0x98, 0x43, 0x39, 0xc8, 0x43, 0x39, 0xb8, 0xc3, 0x38, 0x94, 0x43,
    0x38, 0x88, 0x03, 0x3b, 0x94, 0xc3, 0x2f, 0xbc, 0x83, 0x3c, 0xfc, 0x82,
    0x3b, 0xd4, 0x03, 0x3b, 0xb0, 0xc3, 0x0c, 0xc7, 0x69, 0x87, 0x70, 0x58,
    0x87, 0x72, 0x70, 0x83, 0x74, 0x68, 0x07, 0x78, 0x60, 0x87, 0x74, 0x18,
    0x87, 0x74, 0xa0, 0x87, 0x19, 0xce, 0x53, 0x0f, 0xee, 0x00, 0x0f, 0xf2,
    0x50, 0x0e, 0xe4, 0x90, 0x0e, 0xe3, 0x40, 0x0f, 0xe1, 0x20, 0x0e, 0xec,
    0x50, 0x0e, 0x33, 0x20, 0x28, 0x1d, 0xdc, 0xc1, 0x1e, 0xc2, 0x41, 0x1e,
    0xd2, 0x21, 0x1c, 0xdc, 0x81, 0x1e, 0xdc, 0xe0, 0x1c, 0xe4, 0xe1, 0x1d,
    0xea, 0x01, 0x1e, 0x66, 0x18, 0x51, 0x38, 0xb0, 0x43, 0x3a, 0x9c, 0x83,
    0x3b, 0xcc, 0x50, 0x24, 0x76, 0x60, 0x07, 0x7b, 0x68, 0x07, 0x37, 0x60,
    0x87, 0x77, 0x78, 0x07, 0x78, 0x98, 0x51, 0x4c, 0xf4, 0x90, 0x0f, 0xf0,
    0x50, 0x0e, 0x33, 0x1e, 0x6a, 0x1e, 0xca, 0x61, 0x1c, 0xe8, 0x21, 0x1d,
    0xde, 0xc1, 0x1d, 0x7e, 0x01, 0x1e, 0xe4, 0xa1, 0x1c, 0xcc, 0x21, 0x1d,
    0xf0, 0x61, 0x06, 0x54, 0x85, 0x83, 0x38, 0xcc, 0xc3, 0x3b, 0xb0, 0x43,
    0x3d, 0xd0, 0x43, 0x39, 0xfc, 0xc2, 0x3c, 0xe4, 0x43, 0x3b, 0x88, 0xc3,
    0x3b, 0xb0, 0xc3, 0x8c, 0xc5, 0x0a, 0x87, 0x79, 0x98, 0x87, 0x77, 0x18,
    0x87, 0x74, 0x08, 0x07, 0x7a, 0x28, 0x07, 0x72, 0x98, 0x81, 0x5c, 0xe3,
    0x10, 0x0e, 0xec, 0xc0, 0x0e, 0xe5, 0x50, 0x0e, 0xf3, 0x30, 0x23, 0xc1,
    0xd2, 0x41, 0x1e, 0xe4, 0xe1, 0x17, 0xd8, 0xe1, 0x1d, 0xde, 0x01, 0x1e,
    0x66, 0x48, 0x19, 0x3b, 0xb0, 0x83, 0x3d, 0xb4, 0x83, 0x1b, 0x84, 0xc3,
    0x38, 0x8c, 0x43, 0x39, 0xcc, 0xc3, 0x3c, 0xb8, 0xc1, 0x39, 0xc8, 0xc3,
    0x3b, 0xd4, 0x03, 0x3c, 0xcc, 0x48, 0xb4, 0x71, 0x08, 0x07, 0x76, 0x60,
    0x07, 0x71, 0x08, 0x87, 0x71, 0x58, 0x87, 0x19, 0xdb, 0xc6, 0x0e, 0xec,
    0x60, 0x0f, 0xed, 0xe0, 0x06, 0xf0, 0x20, 0x0f, 0xe5, 0x30, 0x0f, 0xe5,
    0x20, 0x0f, 0xf6, 0x50, 0x0e, 0x6e, 0x10, 0x0e, 0xe3, 0x30, 0x0e, 0xe5,
    0x30, 0x0f, 0xf3, 0xe0, 0x06, 0xe9, 0xe0, 0x0e, 0xe4, 0x50, 0x0e, 0xf8,
    0x30, 0x23, 0xe2, 0xec, 0x61, 0x1c, 0xc2, 0x81, 0x1d, 0xd8, 0xe1, 0x17,
    0xec, 0x21, 0x1d, 0xe6, 0x21, 0x1d, 0xc4, 0x21, 0x1d, 0xd8, 0x21, 0x1d,
    0xe8, 0x21, 0x1f, 0x66, 0x20, 0x9d, 0x3b, 0xbc, 0x43, 0x3d, 0xb8, 0x03,
    0x39, 0x94, 0x83, 0x39, 0xcc, 0x58, 0xbc, 0x70, 0x70, 0x07, 0x77, 0x78,
    0x07, 0x7a, 0x08, 0x07, 0x7a, 0x48, 0x87, 0x77, 0x70, 0x87, 0x19, 0xcb,
    0xe7, 0x0e, 0xef, 0x30, 0x0f, 0xe1, 0xe0, 0x0e, 0xe9, 0x40, 0x0f, 0xe9,
    0xa0, 0x0f, 0xe5, 0x30, 0xc3, 0x01, 0x03, 0x73, 0xa8, 0x07, 0x77, 0x18,
    0x87, 0x5f, 0x98, 0x87, 0x70, 0x70, 0x87, 0x74, 0xa0, 0x87, 0x74, 0xd0,
    0x87, 0x72, 0x98, 0x81, 0x84, 0x41, 0x39, 0xe0, 0xc3, 0x38, 0xb0, 0x43,
    0x3d, 0x90, 0x43, 0x39, 0xcc, 0x40, 0xc4, 0xa0, 0x1d, 0xca, 0xa1, 0x1d,
    0xe0, 0x41, 0x1e, 0xde, 0xc1, 0x1c, 0x66, 0x24, 0x63, 0x30, 0x0e, 0xe1,
    0xc0, 0x0e, 0xec, 0x30, 0x0f, 0xe9, 0x40, 0x0f, 0xe5, 0x30, 0x43, 0x21,
    0x83, 0x75, 0x18, 0x07, 0x73, 0x48, 0x87, 0x5f, 0xa0, 0x87, 0x7c, 0x80,
    0x87, 0x72, 0x98, 0xb1, 0x94, 0x01, 0x3c, 0x8c, 0xc3, 0x3c, 0x94, 0xc3,
    0x38, 0xd0, 0x43, 0x3a, 0xbc, 0x83, 0x3b, 0xcc, 0xc3, 0x8c, 0xc5, 0x0c,
    0x48, 0x21, 0x15, 0x42, 0x61, 0x1e, 0xe6, 0x21, 0x1d, 0xce, 0xc1, 0x1d,
    0x52, 0x81, 0x14, 0x00, 0xa9, 0x18, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00,
    0x0b, 0x0a, 0x72, 0x28, 0x87, 0x77, 0x80, 0x07, 0x7a, 0x58, 0x70, 0x98,
    0x43, 0x3d, 0xb8, 0xc3, 0x38, 0xb0, 0x43, 0x39, 0xd0, 0xc3, 0x82, 0xe6,
    0x1c, 0xc6, 0xa1, 0x0d, 0xe8, 0x41, 0x1e, 0xc2, 0xc1, 0x1d, 0xe6, 0x21,
    0x1d, 0xe8, 0x21, 0x1d, 0xde, 0xc1, 0x1d, 0x16, 0x34, 0xe3, 0x60, 0x0e,
    0xe7, 0x50, 0x0f, 0xe1, 0x20, 0x0f, 0xe4, 0x40, 0x0f, 0xe1, 0x20, 0x0f,
    0xe7, 0x50, 0x0e, 0xf4, 0xb0, 0x80, 0x81, 0x07, 0x79, 0x28, 0x87, 0x70,
    0x60, 0x07, 0x76, 0x78, 0x87, 0x71, 0x08, 0x07, 0x7a, 0x28, 0x07, 0x72,
    0x58, 0x70, 0x9c, 0xc3, 0x38, 0xb4, 0x01, 0x3b, 0xa4, 0x83, 0x3d, 0x94,
    0xc3, 0x02, 0x6b, 0x1c, 0xd8, 0x21, 0x1c, 0xdc, 0xe1, 0x1c, 0xdc, 0x20,
    0x1c, 0xe4, 0x61, 0x1c, 0xdc, 0x20, 0x1c, 0xe8, 0x81, 0x1e, 0xc2, 0x61,
    0x1c, 0xd0, 0xa1, 0x1c, 0xc8, 0x61, 0x1c, 0xc2, 0x81, 0x1d, 0xd8, 0x61,
    0xc1, 0x01, 0x0f, 0xf4, 0x20, 0x0f, 0xe1, 0x50, 0x0f, 0xf4, 0x80, 0x0e,
    0x0b, 0x88, 0x75, 0x18, 0x07, 0x73, 0x48, 0x07, 0x00, 0x00, 0x00, 0x00,
    0xd1, 0x10, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x07, 0xcc, 0x3c, 0xa4,
    0x83, 0x3b, 0x9c, 0x03, 0x3b, 0x94, 0x03, 0x3d, 0xa0, 0x83, 0x3c, 0x94,
    0x43, 0x38, 0x90, 0xc3, 0x01, 0x00, 0x00, 0x00, 0x61, 0x20, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0x13, 0x04, 0x01, 0x03, 0x71, 0x20, 0x00, 0x00,
    0x03, 0x00, 0x00, 0x00, 0x32, 0x0e, 0x10, 0x22, 0x84, 0x00, 0xc0, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5d, 0x0c, 0x00, 0x00,
    0x1d, 0x00, 0x00, 0x00, 0x12, 0x03, 0x94, 0xe8, 0x00, 0x00, 0x00, 0x00,
    0x66, 0x75, 0x6e, 0x63, 0x66, 0x75, 0x6e, 0x63, 0x5f, 0x68, 0x65, 0x61,
    0x64, 0x65, 0x72, 0x72, 0x65, 0x74, 0x5f, 0x70, 0x74, 0x72, 0x72, 0x65,
    0x74, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x61, 0x72, 0x67, 0x5f, 0x70, 0x74,
    0x72, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x74, 0x72, 0x31,
    0x36, 0x2e, 0x30, 0x2e, 0x30, 0x67, 0x69, 0x74, 0x20, 0x61, 0x63, 0x37,
    0x38, 0x39, 0x33, 0x66, 0x64, 0x39, 0x63, 0x39, 0x36, 0x35, 0x63, 0x35,
    0x30, 0x36, 0x34, 0x38, 0x63, 0x36, 0x33, 0x63, 0x30, 0x37, 0x35, 0x34,
    0x35, 0x36, 0x31, 0x35, 0x32, 0x65, 0x64, 0x35, 0x31, 0x38, 0x36, 0x39,
    0x30, 0x3c, 0x73, 0x74, 0x64, 0x69, 0x6e, 0x3e, 0x00, 0x00, 0x00, 0x00};

// %dx.types.f32 = type { float }
// declare void @main()
// !md = !{!0}
// !md2 = !{!1}
// !0 = !{i32 2, %dx.types.f32 addrspace(1)* undef, void ()* @main, void()
// addrspace(3)* null}
// !1 = !{i8*(i32* addrspace(2)*) addrspace(4)* undef, i32*** undef}
const unsigned char AccessMetadataTypeInfoBc[] = {
    0x42, 0x43, 0xc0, 0xde, 0x35, 0x14, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x62, 0x0c, 0x30, 0x24, 0x4d, 0x59, 0xbe, 0x66, 0xad, 0xfb, 0xb4, 0x4f,
    0x1b, 0xc8, 0x24, 0x44, 0x01, 0x32, 0x05, 0x00, 0x21, 0x0c, 0x00, 0x00,
    0x49, 0x01, 0x00, 0x00, 0x0b, 0x02, 0x21, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x16, 0x00, 0x00, 0x00, 0x07, 0x81, 0x23, 0x91, 0x41, 0xc8, 0x04, 0x49,
    0x06, 0x10, 0x32, 0x39, 0x92, 0x01, 0x84, 0x0c, 0x25, 0x05, 0x08, 0x19,
    0x1e, 0x04, 0x8b, 0x62, 0x80, 0x14, 0x45, 0x02, 0x42, 0x92, 0x0b, 0x42,
    0xa4, 0x10, 0x32, 0x14, 0x38, 0x08, 0x18, 0x4b, 0x0a, 0x32, 0x52, 0x88,
    0x48, 0x70, 0xc4, 0x21, 0x23, 0x44, 0x12, 0x87, 0x8c, 0x10, 0x41, 0x92,
    0x02, 0x64, 0xc8, 0x08, 0xb1, 0x14, 0x20, 0x43, 0x46, 0x88, 0x20, 0xc9,
    0x01, 0x32, 0x52, 0x84, 0x18, 0x2a, 0x28, 0x2a, 0x90, 0x31, 0x7c, 0xb0,
    0x5c, 0x91, 0x20, 0xc5, 0xc8, 0x00, 0x00, 0x00, 0x89, 0x20, 0x00, 0x00,
    0x15, 0x00, 0x00, 0x00, 0x32, 0x22, 0x48, 0x09, 0x20, 0x62, 0x46, 0x00,
    0x21, 0x2b, 0x24, 0x98, 0x14, 0x21, 0x25, 0x24, 0x98, 0x14, 0x19, 0x27,
    0x0c, 0x85, 0xa4, 0x90, 0x60, 0x52, 0x64, 0x5c, 0x20, 0x24, 0x65, 0x82,
    0x20, 0x1a, 0x01, 0x30, 0x01, 0xa0, 0x30, 0x10, 0x30, 0x47, 0x00, 0x06,
    0x33, 0x00, 0xc8, 0x0c, 0x97, 0x3f, 0x61, 0x0f, 0x21, 0xf9, 0xc5, 0x6d,
    0xa7, 0xa0, 0x0c, 0x22, 0x18, 0xc1, 0x20, 0x42, 0x30, 0xcc, 0x11, 0x20,
    0x94, 0x88, 0x0c, 0x22, 0x2c, 0x82, 0x11, 0x14, 0x1b, 0x44, 0x68, 0x08,
    0x5a, 0xf4, 0x00, 0x00, 0x1a, 0x21, 0x4c, 0x0e, 0x0f, 0xde, 0x9c, 0x4e,
    0x4e, 0xbb, 0x7d, 0x43, 0x2a, 0x80, 0x08, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x40, 0x62, 0x83, 0x40,
    0x51, 0xa7, 0x00, 0x00, 0x80, 0x2c, 0x10, 0x00, 0x08, 0x00, 0x00, 0x00,
    0x32, 0x1e, 0x98, 0x0c, 0x19, 0x11, 0x4c, 0x90, 0x8c, 0x09, 0x26, 0x47,
    0xc6, 0x04, 0x43, 0x22, 0x45, 0x40, 0x67, 0x06, 0x80, 0xd0, 0x08, 0x00,
    0xb9, 0x19, 0x00, 0x82, 0x33, 0x00, 0x00, 0x00, 0xb1, 0x18, 0x00, 0x00,
    0xb9, 0x00, 0x00, 0x00, 0x33, 0x08, 0x80, 0x1c, 0xc4, 0xe1, 0x1c, 0x66,
    0x14, 0x01, 0x3d, 0x88, 0x43, 0x38, 0x84, 0xc3, 0x8c, 0x42, 0x80, 0x07,
    0x79, 0x78, 0x07, 0x73, 0x98, 0x71, 0x0c, 0xe6, 0x00, 0x0f, 0xed, 0x10,
    0x0e, 0xf4, 0x80, 0x0e, 0x33, 0x0c, 0x42, 0x1e, 0xc2, 0xc1, 0x1d, 0xce,
    0xa1, 0x1c, 0x66, 0x30, 0x05, 0x3d, 0x88, 0x43, 0x38, 0x84, 0x83, 0x1b,
    0xcc, 0x03, 0x3d, 0xc8, 0x43, 0x3d, 0x8c, 0x03, 0x3d, 0xcc, 0x78, 0x8c,
    0x74, 0x70, 0x07, 0x7b, 0x08, 0x07, 0x79, 0x48, 0x87, 0x70, 0x70, 0x07,
    0x7a, 0x70, 0x03, 0x76, 0x78, 0x87, 0x70, 0x20, 0x87, 0x19, 0xcc, 0x11,
    0x0e, 0xec, 0x90, 0x0e, 0xe1, 0x30, 0x0f, 0x6e, 0x30, 0x0f, 0xe3, 0xf0,
    0x0e, 0xf0, 0x50, 0x0e, 0x33, 0x10, 0xc4, 0x1d, 0xde, 0x21, 0x1c, 0xd8,
    0x21, 0x1d, 0xc2, 0x61, 0x1e, 0x66, 0x30, 0x89, 0x3b, 0xbc, 0x83, 0x3b,
    0xd0, 0x43, 0x39, 0xb4, 0x03, 0x3c, 0xbc, 0x83, 0x3c, 0x84, 0x03, 0x3b,
    0xcc, 0xf0, 0x14, 0x76, 0x60, 0x07, 0x7b, 0x68, 0x07, 0x37, 0x68, 0x87,
    0x72, 0x68, 0x07, 0x37, 0x80, 0x87, 0x70, 0x90, 0x87, 0x70, 0x60, 0x07,
    0x76, 0x28, 0x07, 0x76, 0xf8, 0x05, 0x76, 0x78, 0x87, 0x77, 0x80, 0x87,
    0x5f, 0x08, 0x87, 0x71, 0x18, 0x87, 0x72, 0x98, 0x87, 0x79, 0x98, 0x81,
    0x2c, 0xee, 0xf0, 0x0e, 0xee, 0xe0, 0x0e, 0xf5, 0xc0, 0x0e, 0xec, 0x30,
    0x03, 0x62, 0xc8, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xcc, 0xa1, 0x1c, 0xe4,
    0xa1, 0x1c, 0xdc, 0x61, 0x1c, 0xca, 0x21, 0x1c, 0xc4, 0x81, 0x1d, 0xca,
    0x61, 0x06, 0xd6, 0x90, 0x43, 0x39, 0xc8, 0x43, 0x39, 0x98, 0x43, 0x39,
    0xc8, 0x43, 0x39, 0xb8, 0xc3, 0x38, 0x94, 0x43, 0x38, 0x88, 0x03, 0x3b,
    0x94, 0xc3, 0x2f, 0xbc, 0x83, 0x3c, 0xfc, 0x82, 0x3b, 0xd4, 0x03, 0x3b,
    0xb0, 0xc3, 0x0c, 0xc7, 0x69, 0x87, 0x70, 0x58, 0x87, 0x72, 0x70, 0x83,
    0x74, 0x68, 0x07, 0x78, 0x60, 0x87, 0x74, 0x18, 0x87, 0x74, 0xa0, 0x87,
    0x19, 0xce, 0x53, 0x0f, 0xee, 0x00, 0x0f, 0xf2, 0x50, 0x0e, 0xe4, 0x90,
    0x0e, 0xe3, 0x40, 0x0f, 0xe1, 0x20, 0x0e, 0xec, 0x50, 0x0e, 0x33, 0x20,
    0x28, 0x1d, 0xdc, 0xc1, 0x1e, 0xc2, 0x41, 0x1e, 0xd2, 0x21, 0x1c, 0xdc,
    0x81, 0x1e, 0xdc, 0xe0, 0x1c, 0xe4, 0xe1, 0x1d, 0xea, 0x01, 0x1e, 0x66,
    0x18, 0x51, 0x38, 0xb0, 0x43, 0x3a, 0x9c, 0x83, 0x3b, 0xcc, 0x50, 0x24,
    0x76, 0x60, 0x07, 0x7b, 0x68, 0x07, 0x37, 0x60, 0x87, 0x77, 0x78, 0x07,
    0x78, 0x98, 0x51, 0x4c, 0xf4, 0x90, 0x0f, 0xf0, 0x50, 0x0e, 0x33, 0x1e,
    0x6a, 0x1e, 0xca, 0x61, 0x1c, 0xe8, 0x21, 0x1d, 0xde, 0xc1, 0x1d, 0x7e,
    0x01, 0x1e, 0xe4, 0xa1, 0x1c, 0xcc, 0x21, 0x1d, 0xf0, 0x61, 0x06, 0x54,
    0x85, 0x83, 0x38, 0xcc, 0xc3, 0x3b, 0xb0, 0x43, 0x3d, 0xd0, 0x43, 0x39,
    0xfc, 0xc2, 0x3c, 0xe4, 0x43, 0x3b, 0x88, 0xc3, 0x3b, 0xb0, 0xc3, 0x8c,
    0xc5, 0x0a, 0x87, 0x79, 0x98, 0x87, 0x77, 0x18, 0x87, 0x74, 0x08, 0x07,
    0x7a, 0x28, 0x07, 0x72, 0x98, 0x81, 0x5c, 0xe3, 0x10, 0x0e, 0xec, 0xc0,
    0x0e, 0xe5, 0x50, 0x0e, 0xf3, 0x30, 0x23, 0xc1, 0xd2, 0x41, 0x1e, 0xe4,
    0xe1, 0x17, 0xd8, 0xe1, 0x1d, 0xde, 0x01, 0x1e, 0x66, 0x48, 0x19, 0x3b,
    0xb0, 0x83, 0x3d, 0xb4, 0x83, 0x1b, 0x84, 0xc3, 0x38, 0x8c, 0x43, 0x39,
    0xcc, 0xc3, 0x3c, 0xb8, 0xc1, 0x39, 0xc8, 0xc3, 0x3b, 0xd4, 0x03, 0x3c,
    0xcc, 0x48, 0xb4, 0x71, 0x08, 0x07, 0x76, 0x60, 0x07, 0x71, 0x08, 0x87,
    0x71, 0x58, 0x87, 0x19, 0xdb, 0xc6, 0x0e, 0xec, 0x60, 0x0f, 0xed, 0xe0,
    0x06, 0xf0, 0x20, 0x0f, 0xe5, 0x30, 0x0f, 0xe5, 0x20, 0x0f, 0xf6, 0x50,
    0x0e, 0x6e, 0x10, 0x0e, 0xe3, 0x30, 0x0e, 0xe5, 0x30, 0x0f, 0xf3, 0xe0,
    0x06, 0xe9, 0xe0, 0x0e, 0xe4, 0x50, 0x0e, 0xf8, 0x30, 0x23, 0xe2, 0xec,
    0x61, 0x1c, 0xc2, 0x81, 0x1d, 0xd8, 0xe1, 0x17, 0xec, 0x21, 0x1d, 0xe6,
    0x21, 0x1d, 0xc4, 0x21, 0x1d, 0xd8, 0x21, 0x1d, 0xe8, 0x21, 0x1f, 0x66,
    0x20, 0x9d, 0x3b, 0xbc, 0x43, 0x3d, 0xb8, 0x03, 0x39, 0x94, 0x83, 0x39,
    0xcc, 0x58, 0xbc, 0x70, 0x70, 0x07, 0x77, 0x78, 0x07, 0x7a, 0x08, 0x07,
    0x7a, 0x48, 0x87, 0x77, 0x70, 0x87, 0x19, 0xcb, 0xe7, 0x0e, 0xef, 0x30,
    0x0f, 0xe1, 0xe0, 0x0e, 0xe9, 0x40, 0x0f, 0xe9, 0xa0, 0x0f, 0xe5, 0x30,
    0xc3, 0x01, 0x03, 0x73, 0xa8, 0x07, 0x77, 0x18, 0x87, 0x5f, 0x98, 0x87,
    0x70, 0x70, 0x87, 0x74, 0xa0, 0x87, 0x74, 0xd0, 0x87, 0x72, 0x98, 0x81,
    0x84, 0x41, 0x39, 0xe0, 0xc3, 0x38, 0xb0, 0x43, 0x3d, 0x90, 0x43, 0x39,
    0xcc, 0x40, 0xc4, 0xa0, 0x1d, 0xca, 0xa1, 0x1d, 0xe0, 0x41, 0x1e, 0xde,
    0xc1, 0x1c, 0x66, 0x24, 0x63, 0x30, 0x0e, 0xe1, 0xc0, 0x0e, 0xec, 0x30,
    0x0f, 0xe9, 0x40, 0x0f, 0xe5, 0x30, 0x43, 0x21, 0x83, 0x75, 0x18, 0x07,
    0x73, 0x48, 0x87, 0x5f, 0xa0, 0x87, 0x7c, 0x80, 0x87, 0x72, 0x98, 0xb1,
    0x94, 0x01, 0x3c, 0x8c, 0xc3, 0x3c, 0x94, 0xc3, 0x38, 0xd0, 0x43, 0x3a,
    0xbc, 0x83, 0x3b, 0xcc, 0xc3, 0x8c, 0xc5, 0x0c, 0x48, 0x21, 0x15, 0x42,
    0x61, 0x1e, 0xe6, 0x21, 0x1d, 0xce, 0xc1, 0x1d, 0x52, 0x81, 0x14, 0x00,
    0x79, 0x20, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x72, 0x1e, 0x48, 0x20,
    0x43, 0x88, 0x0c, 0x19, 0x09, 0x72, 0x32, 0x48, 0x20, 0x23, 0x81, 0x8c,
    0x91, 0x91, 0xd1, 0x44, 0xa0, 0x10, 0x28, 0x64, 0x3c, 0x31, 0x32, 0x23,
    0x08, 0x44, 0x30, 0x82, 0x70, 0x08, 0x23, 0x08, 0x02, 0x30, 0x82, 0x80,
    0x0c, 0x23, 0x08, 0x0e, 0x31, 0x82, 0x00, 0x15, 0x33, 0x10, 0x81, 0x30,
    0x10, 0x33, 0x08, 0x85, 0x21, 0x23, 0x81, 0x09, 0x42, 0xa1, 0x8d, 0x6c,
    0x94, 0xc0, 0xc0, 0xa1, 0x8d, 0x4c, 0x66, 0x94, 0xe0, 0x00, 0x00, 0x00,
    0xa9, 0x18, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x0b, 0x0a, 0x72, 0x28,
    0x87, 0x77, 0x80, 0x07, 0x7a, 0x58, 0x70, 0x98, 0x43, 0x3d, 0xb8, 0xc3,
    0x38, 0xb0, 0x43, 0x39, 0xd0, 0xc3, 0x82, 0xe6, 0x1c, 0xc6, 0xa1, 0x0d,
    0xe8, 0x41, 0x1e, 0xc2, 0xc1, 0x1d, 0xe6, 0x21, 0x1d, 0xe8, 0x21, 0x1d,
    0xde, 0xc1, 0x1d, 0x16, 0x34, 0xe3, 0x60, 0x0e, 0xe7, 0x50, 0x0f, 0xe1,
    0x20, 0x0f, 0xe4, 0x40, 0x0f, 0xe1, 0x20, 0x0f, 0xe7, 0x50, 0x0e, 0xf4,
    0xb0, 0x80, 0x81, 0x07, 0x79, 0x28, 0x87, 0x70, 0x60, 0x07, 0x76, 0x78,
    0x87, 0x71, 0x08, 0x07, 0x7a, 0x28, 0x07, 0x72, 0x58, 0x70, 0x9c, 0xc3,
    0x38, 0xb4, 0x01, 0x3b, 0xa4, 0x83, 0x3d, 0x94, 0xc3, 0x02, 0x6b, 0x1c,
    0xd8, 0x21, 0x1c, 0xdc, 0xe1, 0x1c, 0xdc, 0x20, 0x1c, 0xe4, 0x61, 0x1c,
    0xdc, 0x20, 0x1c, 0xe8, 0x81, 0x1e, 0xc2, 0x61, 0x1c, 0xd0, 0xa1, 0x1c,
    0xc8, 0x61, 0x1c, 0xc2, 0x81, 0x1d, 0xd8, 0x61, 0xc1, 0x01, 0x0f, 0xf4,
    0x20, 0x0f, 0xe1, 0x50, 0x0f, 0xf4, 0x80, 0x0e, 0x0b, 0x88, 0x75, 0x18,
    0x07, 0x73, 0x48, 0x07, 0x00, 0x00, 0x00, 0x00, 0xd1, 0x10, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x07, 0xcc, 0x3c, 0xa4, 0x83, 0x3b, 0x9c, 0x03,
    0x3b, 0x94, 0x03, 0x3d, 0xa0, 0x83, 0x3c, 0x94, 0x43, 0x38, 0x90, 0xc3,
    0x01, 0x00, 0x00, 0x00, 0x71, 0x20, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x32, 0x0e, 0x10, 0x22, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x5d, 0x0c, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x12, 0x03, 0x94, 0x7d,
    0x00, 0x00, 0x00, 0x00, 0x6d, 0x61, 0x69, 0x6e, 0x31, 0x36, 0x2e, 0x30,
    0x2e, 0x30, 0x67, 0x69, 0x74, 0x20, 0x61, 0x63, 0x37, 0x38, 0x39, 0x33,
    0x66, 0x64, 0x39, 0x63, 0x39, 0x36, 0x35, 0x63, 0x35, 0x30, 0x36, 0x34,
    0x38, 0x63, 0x36, 0x33, 0x63, 0x30, 0x37, 0x35, 0x34, 0x35, 0x36, 0x31,
    0x35, 0x32, 0x65, 0x64, 0x35, 0x31, 0x38, 0x36, 0x39, 0x30, 0x3c, 0x73,
    0x74, 0x64, 0x69, 0x6e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#endif
