/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file Exceptions.hxx
    \author Romain BONDUE
    \date 05/07/2005
    \warning This file should only be included from Exceptions.h */
#include <typeinfo>



inline nsErrors::CException::CException (const std::string& Msg, int Code)
                                                                        throw()
    : m_Msg (Msg), m_Code (Code) {}


inline nsErrors::CException::~CException () throw() {}


inline const std::string& nsErrors::CException::GetMsg () const throw()
{
    return m_Msg;

} // GetMsg()


inline const char* nsErrors::CException::what () const throw()
{
    return m_Msg.c_str();

} // what()


inline int nsErrors::CException::GetCode () const throw() {return m_Code;}


inline nsErrors::CSystemExc::CSystemExc (const std::string& Msg, int Code)
                                                                        throw()
    : CException (Msg, Code) {}


template<class CExcType>
inline const char* nsErrors::CRTExc<CExcType>::what () const throw()
{
    return typeid (CExcType).name();

} // what()
