/* rygel-basic-management.c generated by valac 0.36.6, the Vala compiler
 * generated from rygel-basic-management.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Christophe Guiraud,
 *         Jussi Kukkonen
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_BASIC_MANAGEMENT (rygel_basic_management_get_type ())
#define RYGEL_BASIC_MANAGEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement))
#define RYGEL_BASIC_MANAGEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagementClass))
#define RYGEL_IS_BASIC_MANAGEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT))
#define RYGEL_IS_BASIC_MANAGEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT))
#define RYGEL_BASIC_MANAGEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagementClass))

typedef struct _RygelBasicManagement RygelBasicManagement;
typedef struct _RygelBasicManagementClass RygelBasicManagementClass;
typedef struct _RygelBasicManagementPrivate RygelBasicManagementPrivate;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST (rygel_basic_management_test_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest))
#define RYGEL_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))

typedef struct _RygelBasicManagementTest RygelBasicManagementTest;
typedef struct _RygelBasicManagementTestClass RygelBasicManagementTestClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelBasicManagementTestPrivate RygelBasicManagementTestPrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_INIT_STATE (rygel_basic_management_test_init_state_get_type ())
typedef struct _Block1Data Block1Data;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_EXECUTION_STATE (rygel_basic_management_test_execution_state_get_type ())

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING (rygel_basic_management_test_ping_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_PING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing))
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_PING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_PING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING))
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingClass))

typedef struct _RygelBasicManagementTestPing RygelBasicManagementTestPing;
typedef struct _RygelBasicManagementTestPingClass RygelBasicManagementTestPingClass;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP (rygel_basic_management_test_ns_lookup_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup))
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_NS_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_NS_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP))
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupClass))

typedef struct _RygelBasicManagementTestNSLookup RygelBasicManagementTestNSLookup;
typedef struct _RygelBasicManagementTestNSLookupClass RygelBasicManagementTestNSLookupClass;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE (rygel_basic_management_test_traceroute_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute))
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTracerouteClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_TRACEROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_TRACEROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE))
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTracerouteClass))

typedef struct _RygelBasicManagementTestTraceroute RygelBasicManagementTestTraceroute;
typedef struct _RygelBasicManagementTestTracerouteClass RygelBasicManagementTestTracerouteClass;

struct _RygelBasicManagement {
	GUPnPService parent_instance;
	RygelBasicManagementPrivate * priv;
	gchar* device_status;
};

struct _RygelBasicManagementClass {
	GUPnPServiceClass parent_class;
};

struct _RygelBasicManagementPrivate {
	guint _max_history_size;
	GeeHashMap* tests_map;
	GeeHashMap* test_ids_by_type;
	guint current_id;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER
} RygelBasicManagementTestInitState;

struct _RygelBasicManagementTest {
	GObject parent_instance;
	RygelBasicManagementTestPrivate * priv;
	GCancellable* _cancellable;
	RygelBasicManagementTestInitState init_state;
	gchar* id;
	guint iterations;
	GSpawnFlags flags;
	gchar** command;
	gint command_length1;
	gint _command_size_;
};

struct _RygelBasicManagementTestClass {
	GObjectClass parent_class;
	void (*init_iteration) (RygelBasicManagementTest* self);
	void (*handle_output) (RygelBasicManagementTest* self, const gchar* line);
	void (*handle_error) (RygelBasicManagementTest* self, const gchar* line);
	gboolean (*finish_iteration) (RygelBasicManagementTest* self);
	void (*run) (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelBasicManagementTest* self, GAsyncResult* _res_);
	const gchar* (*get_method_type) (RygelBasicManagementTest* self);
	const gchar* (*get_results_type) (RygelBasicManagementTest* self);
};

struct _Block1Data {
	int _ref_count_;
	RygelBasicManagement* self;
	RygelBasicManagementTest* bm_test;
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_REQUESTED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_CANCELED
} RygelBasicManagementTestExecutionState;


static gpointer rygel_basic_management_parent_class = NULL;

GType rygel_basic_management_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_get_type (void) G_GNUC_CONST;
#define RYGEL_BASIC_MANAGEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagementPrivate))
enum  {
	RYGEL_BASIC_MANAGEMENT_DUMMY_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE_PROPERTY
};
#define RYGEL_BASIC_MANAGEMENT_UPNP_ID "urn:upnp-org:serviceId:BasicManagement"
#define RYGEL_BASIC_MANAGEMENT_UPNP_TYPE "urn:schemas-upnp-org:service:BasicManagement:2"
#define RYGEL_BASIC_MANAGEMENT_DESCRIPTION_PATH "xml/BasicManagement2.xml"
static void rygel_basic_management_real_constructed (GObject* base);
static void rygel_basic_management_query_device_status_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val);
static void _rygel_basic_management_query_device_status_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_basic_management_query_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val);
static void _rygel_basic_management_query_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_basic_management_query_active_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val);
static void _rygel_basic_management_query_active_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_basic_management_get_device_status_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_get_device_status_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_ping_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_ping_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_ping_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_ping_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_nslookup_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_nslookup_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_nslookup_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_nslookup_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_traceroute_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_traceroute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_traceroute_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_traceroute_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_get_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_get_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_get_active_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_get_active_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_get_test_info_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_get_test_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_cancel_test_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_cancel_test_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static gchar* rygel_basic_management_create_test_ids_list (RygelBasicManagement* self, gboolean active_only);
gboolean rygel_basic_management_test_is_active (RygelBasicManagementTest* self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_init_state_get_type (void) G_GNUC_CONST;
static gchar* rygel_basic_management_add_test (RygelBasicManagement* self, RygelBasicManagementTest* test);
const gchar* rygel_basic_management_test_get_method_type (RygelBasicManagementTest* self);
guint rygel_basic_management_get_max_history_size (RygelBasicManagement* self);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_basic_management_add_test_and_return_action (RygelBasicManagement* self, RygelBasicManagementTest* bm_test, GUPnPServiceAction* action);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void rygel_basic_management_test_run (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_basic_management_test_run_finish (RygelBasicManagementTest* self, GAsyncResult* _res_);
static void __lambda5_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean rygel_basic_management_ensure_test_exists (RygelBasicManagement* self, GUPnPServiceAction* action, RygelBasicManagementTest* * bm_test);
const gchar* rygel_basic_management_test_get_results_type (RygelBasicManagementTest* self);
GType rygel_basic_management_test_execution_state_get_type (void) G_GNUC_CONST;
RygelBasicManagementTestExecutionState rygel_basic_management_test_get_execution_state (RygelBasicManagementTest* self);
gchar* rygel_basic_management_test_execution_state_to_string (RygelBasicManagementTestExecutionState self);
GType rygel_basic_management_test_ping_get_type (void) G_GNUC_CONST;
RygelBasicManagementTestPing* rygel_basic_management_test_ping_new (const gchar* host, guint repeat_count, guint32 interval_time_out, guint data_block_size, guint dscp);
RygelBasicManagementTestPing* rygel_basic_management_test_ping_construct (GType object_type, const gchar* host, guint repeat_count, guint32 interval_time_out, guint data_block_size, guint dscp);
void rygel_basic_management_test_ping_get_results (RygelBasicManagementTestPing* self, gchar* * status, gchar* * additional_info, guint* success_count, guint* failure_count, guint32* avg_response_time, guint32* min_response_time, guint32* max_response_time);
GType rygel_basic_management_test_ns_lookup_get_type (void) G_GNUC_CONST;
RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_new (const gchar* host_name, const gchar* name_server, guint repetitions, guint32 interval_time_out);
RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_construct (GType object_type, const gchar* host_name, const gchar* name_server, guint repetitions, guint32 interval_time_out);
void rygel_basic_management_test_ns_lookup_get_results (RygelBasicManagementTestNSLookup* self, gchar* * status, gchar* * additional_info, guint* success_count, gchar* * result_string);
GType rygel_basic_management_test_traceroute_get_type (void) G_GNUC_CONST;
RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_new (const gchar* host, guint32 wait_time_out, guint data_block_size, guint max_hop_count, guint dscp);
RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_construct (GType object_type, const gchar* host, guint32 wait_time_out, guint data_block_size, guint max_hop_count, guint dscp);
void rygel_basic_management_test_traceroute_get_results (RygelBasicManagementTestTraceroute* self, gchar* * status, gchar* * additional_info, guint32* response_time, gchar* * hop_ips);
RygelBasicManagement* rygel_basic_management_new (void);
RygelBasicManagement* rygel_basic_management_construct (GType object_type);
void rygel_basic_management_set_max_history_size (RygelBasicManagement* self, guint value);
static void rygel_basic_management_finalize (GObject * obj);
static void _vala_rygel_basic_management_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_basic_management_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _rygel_basic_management_query_device_status_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_basic_management_query_device_status_cb ((RygelBasicManagement*) self, _sender, variable, value);
}


static void _rygel_basic_management_query_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_basic_management_query_test_ids_cb ((RygelBasicManagement*) self, _sender, variable, value);
}


static void _rygel_basic_management_query_active_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_basic_management_query_active_test_ids_cb ((RygelBasicManagement*) self, _sender, variable, value);
}


static void _rygel_basic_management_get_device_status_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_get_device_status_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_ping_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_ping_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_ping_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_ping_result_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_nslookup_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_nslookup_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_nslookup_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_nslookup_result_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_traceroute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_traceroute_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_traceroute_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_traceroute_result_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_get_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_get_test_ids_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_get_active_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_get_active_test_ids_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_get_test_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_get_test_info_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_cancel_test_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_cancel_test_cb ((RygelBasicManagement*) self, _sender, action);
}


static void rygel_basic_management_real_constructed (GObject* base) {
	RygelBasicManagement * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GTimeVal now = {0};
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self = (RygelBasicManagement*) base;
	G_OBJECT_CLASS (rygel_basic_management_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->tests_map);
	self->priv->tests_map = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LINKED_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->test_ids_by_type);
	self->priv->test_ids_by_type = _tmp1_;
	g_get_current_time (&now);
	now.tv_usec = (glong) 0;
	_tmp2_ = g_time_val_to_iso8601 (&now);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("OK,", _tmp3_, NULL);
	_g_free0 (self->device_status);
	self->device_status = _tmp4_;
	_g_free0 (_tmp3_);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::DeviceStatus", (GCallback) _rygel_basic_management_query_device_status_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::TestIDs", (GCallback) _rygel_basic_management_query_test_ids_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::ActiveTestIDs", (GCallback) _rygel_basic_management_query_active_test_ids_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetDeviceStatus", (GCallback) _rygel_basic_management_get_device_status_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Ping", (GCallback) _rygel_basic_management_ping_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetPingResult", (GCallback) _rygel_basic_management_ping_result_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::NSLookup", (GCallback) _rygel_basic_management_nslookup_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetNSLookupResult", (GCallback) _rygel_basic_management_nslookup_result_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Traceroute", (GCallback) _rygel_basic_management_traceroute_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTracerouteResult", (GCallback) _rygel_basic_management_traceroute_result_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTestIDs", (GCallback) _rygel_basic_management_get_test_ids_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetActiveTestIDs", (GCallback) _rygel_basic_management_get_active_test_ids_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTestInfo", (GCallback) _rygel_basic_management_get_test_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::CancelTest", (GCallback) _rygel_basic_management_cancel_test_cb_gupnp_service_action_invoked, self, 0);
}


static gchar* rygel_basic_management_create_test_ids_list (RygelBasicManagement* self, gboolean active_only) {
	gchar* result = NULL;
	gchar* test_ids_list = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	test_ids_list = _tmp0_;
	{
		GeeIterator* _test_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->priv->tests_map;
		_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_test_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_;
			RygelBasicManagementTest* test = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_;
			const gchar* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			const gchar* _tmp20_;
			RygelBasicManagementTest* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp7_ = _test_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _test_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			test = (RygelBasicManagementTest*) _tmp10_;
			_tmp12_ = active_only;
			if (_tmp12_) {
				RygelBasicManagementTest* _tmp13_;
				gboolean _tmp14_;
				_tmp13_ = test;
				_tmp14_ = rygel_basic_management_test_is_active (_tmp13_);
				_tmp11_ = !_tmp14_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				_g_object_unref0 (test);
				continue;
			}
			_tmp15_ = test_ids_list;
			_tmp16_ = strlen (_tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ > 0) {
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp18_ = test_ids_list;
				_tmp19_ = g_strconcat (_tmp18_, ",", NULL);
				_g_free0 (test_ids_list);
				test_ids_list = _tmp19_;
			}
			_tmp20_ = test_ids_list;
			_tmp21_ = test;
			_tmp22_ = _tmp21_->id;
			_tmp23_ = g_strconcat (_tmp20_, _tmp22_, NULL);
			_g_free0 (test_ids_list);
			test_ids_list = _tmp23_;
			_g_object_unref0 (test);
		}
		_g_object_unref0 (_test_it);
	}
	result = test_ids_list;
	return result;
}


static gchar* rygel_basic_management_add_test (RygelBasicManagement* self, RygelBasicManagementTest* test) {
	gchar* result = NULL;
	guint _tmp0_;
	RygelBasicManagementTest* _tmp1_;
	guint _tmp2_;
	gchar* _tmp3_;
	GeeHashMap* _tmp4_;
	RygelBasicManagementTest* _tmp5_;
	const gchar* _tmp6_;
	RygelBasicManagementTest* _tmp7_;
	GeeLinkedList* type_test_ids = NULL;
	GeeHashMap* _tmp8_;
	RygelBasicManagementTest* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gpointer _tmp12_;
	GeeLinkedList* _tmp13_;
	GeeLinkedList* _tmp20_;
	RygelBasicManagementTest* _tmp21_;
	const gchar* _tmp22_;
	GeeLinkedList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	guint _tmp26_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	RygelBasicManagementTest* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (test != NULL, NULL);
	_tmp0_ = self->priv->current_id;
	self->priv->current_id = _tmp0_ + 1;
	_tmp1_ = test;
	_tmp2_ = self->priv->current_id;
	_tmp3_ = g_strdup_printf ("%u", _tmp2_);
	_g_free0 (_tmp1_->id);
	_tmp1_->id = _tmp3_;
	_tmp4_ = self->priv->tests_map;
	_tmp5_ = test;
	_tmp6_ = _tmp5_->id;
	_tmp7_ = test;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, _tmp6_, _tmp7_);
	_tmp8_ = self->priv->test_ids_by_type;
	_tmp9_ = test;
	_tmp10_ = rygel_basic_management_test_get_method_type (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, _tmp11_);
	_g_object_unref0 (type_test_ids);
	type_test_ids = (GeeLinkedList*) _tmp12_;
	_tmp13_ = type_test_ids;
	if (_tmp13_ == NULL) {
		GeeLinkedList* _tmp14_;
		GeeHashMap* _tmp15_;
		RygelBasicManagementTest* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		GeeLinkedList* _tmp19_;
		_tmp14_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (type_test_ids);
		type_test_ids = _tmp14_;
		_tmp15_ = self->priv->test_ids_by_type;
		_tmp16_ = test;
		_tmp17_ = rygel_basic_management_test_get_method_type (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = type_test_ids;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp18_, _tmp19_);
	}
	_tmp20_ = type_test_ids;
	_tmp21_ = test;
	_tmp22_ = _tmp21_->id;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp22_);
	_tmp23_ = type_test_ids;
	_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = self->priv->_max_history_size;
	if (((guint) _tmp25_) > _tmp26_) {
		gchar* old_id = NULL;
		GeeLinkedList* _tmp27_;
		gpointer _tmp28_;
		GeeHashMap* _tmp29_;
		const gchar* _tmp30_;
		gpointer _tmp31_;
		RygelBasicManagementTest* _tmp32_;
		GCancellable* _tmp33_;
		GCancellable* _tmp34_;
		GeeHashMap* _tmp35_;
		const gchar* _tmp36_;
		_tmp27_ = type_test_ids;
		_tmp28_ = gee_deque_poll_head ((GeeDeque*) _tmp27_);
		old_id = (gchar*) _tmp28_;
		_tmp29_ = self->priv->tests_map;
		_tmp30_ = old_id;
		_tmp31_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp29_, _tmp30_);
		_tmp32_ = (RygelBasicManagementTest*) _tmp31_;
		_tmp33_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp32_);
		_tmp34_ = _tmp33_;
		g_cancellable_cancel (_tmp34_);
		_g_object_unref0 (_tmp32_);
		_tmp35_ = self->priv->tests_map;
		_tmp36_ = old_id;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp35_, _tmp36_, NULL);
		_g_free0 (old_id);
	}
	_tmp37_ = rygel_basic_management_create_test_ids_list (self, FALSE);
	_tmp38_ = _tmp37_;
	gupnp_service_notify ((GUPnPService*) self, "TestIDs", G_TYPE_STRING, _tmp38_, NULL);
	_g_free0 (_tmp38_);
	_tmp39_ = rygel_basic_management_create_test_ids_list (self, TRUE);
	_tmp40_ = _tmp39_;
	gupnp_service_notify ((GUPnPService*) self, "ActiveTestIDs", G_TYPE_STRING, _tmp40_, NULL);
	_g_free0 (_tmp40_);
	_tmp41_ = test;
	_tmp42_ = _tmp41_->id;
	_tmp43_ = g_strdup (_tmp42_);
	result = _tmp43_;
	_g_object_unref0 (type_test_ids);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelBasicManagement* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->bm_test);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda5_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	RygelBasicManagement* self;
	RygelBasicManagementTest* _tmp0_;
	GAsyncResult* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = _data1_->bm_test;
	_tmp1_ = res;
	rygel_basic_management_test_run_finish (_tmp0_, _tmp1_);
	_tmp2_ = rygel_basic_management_create_test_ids_list (self, TRUE);
	_tmp3_ = _tmp2_;
	gupnp_service_notify ((GUPnPService*) self, "ActiveTestIDs", G_TYPE_STRING, _tmp3_, NULL);
	_g_free0 (_tmp3_);
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda5_ (self, source_object, res);
	block1_data_unref (self);
}


static void rygel_basic_management_add_test_and_return_action (RygelBasicManagement* self, RygelBasicManagementTest* bm_test, GUPnPServiceAction* action) {
	Block1Data* _data1_;
	RygelBasicManagementTest* _tmp0_;
	RygelBasicManagementTest* _tmp1_;
	gchar* id = NULL;
	RygelBasicManagementTest* _tmp2_;
	gchar* _tmp3_;
	RygelBasicManagementTest* _tmp4_;
	GUPnPServiceAction* _tmp5_;
	GUPnPServiceAction* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm_test != NULL);
	g_return_if_fail (action != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = bm_test;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data1_->bm_test);
	_data1_->bm_test = _tmp1_;
	_tmp2_ = _data1_->bm_test;
	_tmp3_ = rygel_basic_management_add_test (self, _tmp2_);
	id = _tmp3_;
	_tmp4_ = _data1_->bm_test;
	rygel_basic_management_test_run (_tmp4_, ___lambda5__gasync_ready_callback, block1_data_ref (_data1_));
	_tmp5_ = action;
	gupnp_service_action_set (_tmp5_, "TestID", G_TYPE_STRING, id, NULL);
	_tmp6_ = action;
	gupnp_service_action_return (_tmp6_);
	_g_free0 (id);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static gboolean rygel_basic_management_ensure_test_exists (RygelBasicManagement* self, GUPnPServiceAction* action, RygelBasicManagementTest* * bm_test) {
	RygelBasicManagementTest* _vala_bm_test = NULL;
	gboolean result = FALSE;
	gchar* test_id = NULL;
	GUPnPServiceAction* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_;
	gchar* action_name = NULL;
	GUPnPServiceAction* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	RygelBasicManagementTest* _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (action != NULL, FALSE);
	_tmp0_ = action;
	gupnp_service_action_get (_tmp0_, "TestID", G_TYPE_STRING, &test_id, NULL);
	_tmp1_ = self->priv->tests_map;
	_tmp2_ = test_id;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
	_g_object_unref0 (_vala_bm_test);
	_vala_bm_test = (RygelBasicManagementTest*) _tmp3_;
	_tmp4_ = action;
	_tmp5_ = gupnp_service_action_get_name (_tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	action_name = _tmp6_;
	_tmp7_ = _vala_bm_test;
	if (_tmp7_ == NULL) {
		GUPnPServiceAction* _tmp8_;
		_tmp8_ = action;
		gupnp_service_action_return_error (_tmp8_, (guint) 706, _ ("No Such Test"));
		result = FALSE;
		_g_free0 (action_name);
		_g_free0 (test_id);
		if (bm_test) {
			*bm_test = _vala_bm_test;
		} else {
			_g_object_unref0 (_vala_bm_test);
		}
		return result;
	} else {
		gboolean _tmp9_ = FALSE;
		RygelBasicManagementTest* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp10_ = _vala_bm_test;
		_tmp11_ = rygel_basic_management_test_get_results_type (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = action_name;
		if (g_strcmp0 (_tmp12_, _tmp13_) != 0) {
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			const gchar* _tmp16_;
			_tmp16_ = action_name;
			if (g_strcmp0 (_tmp16_, "GetPingResult") == 0) {
				_tmp15_ = TRUE;
			} else {
				const gchar* _tmp17_;
				_tmp17_ = action_name;
				_tmp15_ = g_strcmp0 (_tmp17_, "GetNSLookupResult") == 0;
			}
			if (_tmp15_) {
				_tmp14_ = TRUE;
			} else {
				const gchar* _tmp18_;
				_tmp18_ = action_name;
				_tmp14_ = g_strcmp0 (_tmp18_, "GetTracerouteResult") == 0;
			}
			_tmp9_ = _tmp14_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GUPnPServiceAction* _tmp19_;
			_tmp19_ = action;
			gupnp_service_action_return_error (_tmp19_, (guint) 707, _ ("Wrong Test Type"));
			result = FALSE;
			_g_free0 (action_name);
			_g_free0 (test_id);
			if (bm_test) {
				*bm_test = _vala_bm_test;
			} else {
				_g_object_unref0 (_vala_bm_test);
			}
			return result;
		} else {
			gboolean _tmp20_ = FALSE;
			RygelBasicManagementTest* _tmp21_;
			RygelBasicManagementTestExecutionState _tmp22_;
			RygelBasicManagementTestExecutionState _tmp23_;
			_tmp21_ = _vala_bm_test;
			_tmp22_ = rygel_basic_management_test_get_execution_state (_tmp21_);
			_tmp23_ = _tmp22_;
			if (_tmp23_ != RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED) {
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				const gchar* _tmp26_;
				_tmp26_ = action_name;
				if (g_strcmp0 (_tmp26_, "GetPingResult") == 0) {
					_tmp25_ = TRUE;
				} else {
					const gchar* _tmp27_;
					_tmp27_ = action_name;
					_tmp25_ = g_strcmp0 (_tmp27_, "GetNSLookupResult") == 0;
				}
				if (_tmp25_) {
					_tmp24_ = TRUE;
				} else {
					const gchar* _tmp28_;
					_tmp28_ = action_name;
					_tmp24_ = g_strcmp0 (_tmp28_, "GetTracerouteResult") == 0;
				}
				_tmp20_ = _tmp24_;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				GUPnPServiceAction* _tmp29_;
				RygelBasicManagementTest* _tmp30_;
				RygelBasicManagementTestExecutionState _tmp31_;
				RygelBasicManagementTestExecutionState _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				_tmp29_ = action;
				_tmp30_ = _vala_bm_test;
				_tmp31_ = rygel_basic_management_test_get_execution_state (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = rygel_basic_management_test_execution_state_to_string (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = g_strdup_printf (_ ("Invalid Test State “%s”"), _tmp34_);
				_tmp36_ = _tmp35_;
				gupnp_service_action_return_error (_tmp29_, (guint) 708, _tmp36_);
				_g_free0 (_tmp36_);
				_g_free0 (_tmp34_);
				result = FALSE;
				_g_free0 (action_name);
				_g_free0 (test_id);
				if (bm_test) {
					*bm_test = _vala_bm_test;
				} else {
					_g_object_unref0 (_vala_bm_test);
				}
				return result;
			} else {
				gboolean _tmp37_ = FALSE;
				const gchar* _tmp38_;
				_tmp38_ = action_name;
				if (g_strcmp0 (_tmp38_, "CancelTest") == 0) {
					RygelBasicManagementTest* _tmp39_;
					gboolean _tmp40_;
					_tmp39_ = _vala_bm_test;
					_tmp40_ = rygel_basic_management_test_is_active (_tmp39_);
					_tmp37_ = !_tmp40_;
				} else {
					_tmp37_ = FALSE;
				}
				if (_tmp37_) {
					GUPnPServiceAction* _tmp41_;
					RygelBasicManagementTest* _tmp42_;
					RygelBasicManagementTestExecutionState _tmp43_;
					RygelBasicManagementTestExecutionState _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					_tmp41_ = action;
					_tmp42_ = _vala_bm_test;
					_tmp43_ = rygel_basic_management_test_get_execution_state (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = rygel_basic_management_test_execution_state_to_string (_tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = g_strdup_printf (_ ("State “%s” Precludes Cancel"), _tmp46_);
					_tmp48_ = _tmp47_;
					gupnp_service_action_return_error (_tmp41_, (guint) 709, _tmp48_);
					_g_free0 (_tmp48_);
					_g_free0 (_tmp46_);
					result = FALSE;
					_g_free0 (action_name);
					_g_free0 (test_id);
					if (bm_test) {
						*bm_test = _vala_bm_test;
					} else {
						_g_object_unref0 (_vala_bm_test);
					}
					return result;
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (action_name);
	_g_free0 (test_id);
	if (bm_test) {
		*bm_test = _vala_bm_test;
	} else {
		_g_object_unref0 (_vala_bm_test);
	}
	return result;
}


static void rygel_basic_management_query_device_status_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (var != NULL);
	g_return_if_fail (val != NULL);
	g_value_init (val, G_TYPE_STRING);
	_tmp0_ = self->device_status;
	g_value_set_string (val, _tmp0_);
}


static void rygel_basic_management_query_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (var != NULL);
	g_return_if_fail (val != NULL);
	g_value_init (val, G_TYPE_STRING);
	_tmp0_ = rygel_basic_management_create_test_ids_list (self, FALSE);
	_tmp1_ = _tmp0_;
	g_value_set_string (val, _tmp1_);
	_g_free0 (_tmp1_);
}


static void rygel_basic_management_query_active_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (var != NULL);
	g_return_if_fail (val != NULL);
	g_value_init (val, G_TYPE_STRING);
	_tmp0_ = rygel_basic_management_create_test_ids_list (self, TRUE);
	_tmp1_ = _tmp0_;
	g_value_set_string (val, _tmp1_);
	_g_free0 (_tmp1_);
}


static void rygel_basic_management_get_device_status_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_;
	GUPnPServiceAction* _tmp3_;
	const gchar* _tmp4_;
	GUPnPServiceAction* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 0)) {
		GUPnPServiceAction* _tmp2_;
		_tmp2_ = action;
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp3_ = action;
	_tmp4_ = self->device_status;
	gupnp_service_action_set (_tmp3_, "DeviceStatus", G_TYPE_STRING, _tmp4_, NULL);
	_tmp5_ = action;
	gupnp_service_action_return (_tmp5_);
}


static void rygel_basic_management_ping_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_;
	gchar* host = NULL;
	guint repeat_count = 0U;
	guint data_block_size = 0U;
	guint dscp = 0U;
	guint32 interval_time_out = 0U;
	GUPnPServiceAction* _tmp3_;
	const gchar* _tmp4_;
	RygelBasicManagementTestPing* ping = NULL;
	const gchar* _tmp6_;
	guint _tmp7_;
	guint32 _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	RygelBasicManagementTestPing* _tmp11_;
	RygelBasicManagementTestPing* _tmp12_;
	GUPnPServiceAction* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 5)) {
		GUPnPServiceAction* _tmp2_;
		_tmp2_ = action;
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp3_ = action;
	gupnp_service_action_get (_tmp3_, "Host", G_TYPE_STRING, &host, "NumberOfRepetitions", G_TYPE_UINT, &repeat_count, "Timeout", G_TYPE_UINT, &interval_time_out, "DataBlockSize", G_TYPE_UINT, &data_block_size, "DSCP", G_TYPE_UINT, &dscp, NULL);
	_tmp4_ = host;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		GUPnPServiceAction* _tmp5_;
		g_warning ("rygel-basic-management.vala:255: %s", _ ("Cannot run “Ping” action: Host is empty"));
		_tmp5_ = action;
		gupnp_service_action_return_error (_tmp5_, (guint) 402, _ ("Invalid argument"));
		_g_free0 (host);
		return;
	}
	_tmp6_ = host;
	_tmp7_ = repeat_count;
	_tmp8_ = interval_time_out;
	_tmp9_ = data_block_size;
	_tmp10_ = dscp;
	_tmp11_ = rygel_basic_management_test_ping_new (_tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp10_);
	ping = _tmp11_;
	_tmp12_ = ping;
	_tmp13_ = action;
	rygel_basic_management_add_test_and_return_action (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST) ? ((RygelBasicManagementTest*) _tmp12_) : NULL, _tmp13_);
	_g_object_unref0 (ping);
	_g_free0 (host);
}


static void rygel_basic_management_ping_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_;
	RygelBasicManagementTest* bm_test = NULL;
	GUPnPServiceAction* _tmp3_;
	RygelBasicManagementTest* _tmp4_ = NULL;
	gboolean _tmp5_;
	gchar* status = NULL;
	gchar* additional_info = NULL;
	guint success_count = 0U;
	guint failure_count = 0U;
	guint32 avg_response_time = 0U;
	guint32 min_response_time = 0U;
	guint32 max_response_time = 0U;
	RygelBasicManagementTest* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	guint32 _tmp11_ = 0U;
	guint32 _tmp12_ = 0U;
	guint32 _tmp13_ = 0U;
	GUPnPServiceAction* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	guint _tmp17_;
	guint _tmp18_;
	guint32 _tmp19_;
	guint32 _tmp20_;
	guint32 _tmp21_;
	GUPnPServiceAction* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 1)) {
		GUPnPServiceAction* _tmp2_;
		_tmp2_ = action;
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp3_ = action;
	_tmp5_ = rygel_basic_management_ensure_test_exists (self, _tmp3_, &_tmp4_);
	_g_object_unref0 (bm_test);
	bm_test = _tmp4_;
	if (!_tmp5_) {
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp6_ = bm_test;
	rygel_basic_management_test_ping_get_results (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING) ? ((RygelBasicManagementTestPing*) _tmp6_) : NULL, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_);
	_g_free0 (status);
	status = _tmp7_;
	_g_free0 (additional_info);
	additional_info = _tmp8_;
	success_count = _tmp9_;
	failure_count = _tmp10_;
	avg_response_time = _tmp11_;
	min_response_time = _tmp12_;
	max_response_time = _tmp13_;
	_tmp14_ = action;
	_tmp15_ = status;
	_tmp16_ = additional_info;
	_tmp17_ = success_count;
	_tmp18_ = failure_count;
	_tmp19_ = avg_response_time;
	_tmp20_ = min_response_time;
	_tmp21_ = max_response_time;
	gupnp_service_action_set (_tmp14_, "Status", G_TYPE_STRING, _tmp15_, "AdditionalInfo", G_TYPE_STRING, _tmp16_, "SuccessCount", G_TYPE_UINT, _tmp17_, "FailureCount", G_TYPE_UINT, _tmp18_, "AverageResponseTime", G_TYPE_UINT, _tmp19_, "MinimumResponseTime", G_TYPE_UINT, _tmp20_, "MaximumResponseTime", G_TYPE_UINT, _tmp21_, NULL);
	_tmp22_ = action;
	gupnp_service_action_return (_tmp22_);
	_g_free0 (additional_info);
	_g_free0 (status);
	_g_object_unref0 (bm_test);
}


static void rygel_basic_management_nslookup_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_;
	gchar* hostname = NULL;
	gchar* dns_server = NULL;
	guint repeat_count = 0U;
	guint32 interval_time_out = 0U;
	GUPnPServiceAction* _tmp3_;
	const gchar* _tmp4_;
	RygelBasicManagementTestNSLookup* nslookup = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	guint _tmp8_;
	guint32 _tmp9_;
	RygelBasicManagementTestNSLookup* _tmp10_;
	RygelBasicManagementTestNSLookup* _tmp11_;
	GUPnPServiceAction* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 4)) {
		GUPnPServiceAction* _tmp2_;
		_tmp2_ = action;
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp3_ = action;
	gupnp_service_action_get (_tmp3_, "HostName", G_TYPE_STRING, &hostname, "DNSServer", G_TYPE_STRING, &dns_server, "NumberOfRepetitions", G_TYPE_UINT, &repeat_count, "Timeout", G_TYPE_UINT, &interval_time_out, NULL);
	_tmp4_ = hostname;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		GUPnPServiceAction* _tmp5_;
		g_warning ("rygel-basic-management.vala:348: %s", _ ("Cannot run “NSLookup” action: HostName is empty"));
		_tmp5_ = action;
		gupnp_service_action_return_error (_tmp5_, (guint) 402, _ ("Invalid argument"));
		_g_free0 (dns_server);
		_g_free0 (hostname);
		return;
	}
	_tmp6_ = hostname;
	_tmp7_ = dns_server;
	_tmp8_ = repeat_count;
	_tmp9_ = interval_time_out;
	_tmp10_ = rygel_basic_management_test_ns_lookup_new (_tmp6_, _tmp7_, _tmp8_, _tmp9_);
	nslookup = _tmp10_;
	_tmp11_ = nslookup;
	_tmp12_ = action;
	rygel_basic_management_add_test_and_return_action (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST) ? ((RygelBasicManagementTest*) _tmp11_) : NULL, _tmp12_);
	_g_object_unref0 (nslookup);
	_g_free0 (dns_server);
	_g_free0 (hostname);
}


static void rygel_basic_management_nslookup_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_;
	RygelBasicManagementTest* bm_test = NULL;
	GUPnPServiceAction* _tmp3_;
	RygelBasicManagementTest* _tmp4_ = NULL;
	gboolean _tmp5_;
	gchar* status = NULL;
	gchar* additional_info = NULL;
	gchar* _result_ = NULL;
	guint success_count = 0U;
	RygelBasicManagementTest* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	gchar* _tmp10_ = NULL;
	GUPnPServiceAction* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	guint _tmp14_;
	const gchar* _tmp15_;
	GUPnPServiceAction* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 1)) {
		GUPnPServiceAction* _tmp2_;
		_tmp2_ = action;
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp3_ = action;
	_tmp5_ = rygel_basic_management_ensure_test_exists (self, _tmp3_, &_tmp4_);
	_g_object_unref0 (bm_test);
	bm_test = _tmp4_;
	if (!_tmp5_) {
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp6_ = bm_test;
	rygel_basic_management_test_ns_lookup_get_results (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP) ? ((RygelBasicManagementTestNSLookup*) _tmp6_) : NULL, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
	_g_free0 (status);
	status = _tmp7_;
	_g_free0 (additional_info);
	additional_info = _tmp8_;
	success_count = _tmp9_;
	_g_free0 (_result_);
	_result_ = _tmp10_;
	_tmp11_ = action;
	_tmp12_ = status;
	_tmp13_ = additional_info;
	_tmp14_ = success_count;
	_tmp15_ = _result_;
	gupnp_service_action_set (_tmp11_, "Status", G_TYPE_STRING, _tmp12_, "AdditionalInfo", G_TYPE_STRING, _tmp13_, "SuccessCount", G_TYPE_UINT, _tmp14_, "Result", G_TYPE_STRING, _tmp15_, NULL);
	_tmp16_ = action;
	gupnp_service_action_return (_tmp16_);
	_g_free0 (_result_);
	_g_free0 (additional_info);
	_g_free0 (status);
	_g_object_unref0 (bm_test);
}


static void rygel_basic_management_traceroute_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_;
	gchar* host = NULL;
	guint32 wait_time_out = 0U;
	guint data_block_size = 0U;
	guint max_hop_count = 0U;
	guint dscp = 0U;
	GUPnPServiceAction* _tmp3_;
	const gchar* _tmp4_;
	RygelBasicManagementTestTraceroute* traceroute = NULL;
	const gchar* _tmp6_;
	guint32 _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	RygelBasicManagementTestTraceroute* _tmp11_;
	RygelBasicManagementTestTraceroute* _tmp12_;
	GUPnPServiceAction* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 5)) {
		GUPnPServiceAction* _tmp2_;
		_tmp2_ = action;
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp3_ = action;
	gupnp_service_action_get (_tmp3_, "Host", G_TYPE_STRING, &host, "Timeout", G_TYPE_UINT, &wait_time_out, "DataBlockSize", G_TYPE_UINT, &data_block_size, "MaxHopCount", G_TYPE_UINT, &max_hop_count, "DSCP", G_TYPE_UINT, &dscp, NULL);
	_tmp4_ = host;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		GUPnPServiceAction* _tmp5_;
		g_warning ("rygel-basic-management.vala:430: %s", _ ("Cannot run “Traceroute” action: Host is empty"));
		_tmp5_ = action;
		gupnp_service_action_return_error (_tmp5_, (guint) 402, _ ("Invalid argument"));
		_g_free0 (host);
		return;
	}
	_tmp6_ = host;
	_tmp7_ = wait_time_out;
	_tmp8_ = data_block_size;
	_tmp9_ = max_hop_count;
	_tmp10_ = dscp;
	_tmp11_ = rygel_basic_management_test_traceroute_new (_tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp10_);
	traceroute = _tmp11_;
	_tmp12_ = traceroute;
	_tmp13_ = action;
	rygel_basic_management_add_test_and_return_action (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST) ? ((RygelBasicManagementTest*) _tmp12_) : NULL, _tmp13_);
	_g_object_unref0 (traceroute);
	_g_free0 (host);
}


static void rygel_basic_management_traceroute_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_;
	RygelBasicManagementTest* bm_test = NULL;
	GUPnPServiceAction* _tmp3_;
	RygelBasicManagementTest* _tmp4_ = NULL;
	gboolean _tmp5_;
	gchar* status = NULL;
	gchar* additional_info = NULL;
	gchar* hop_hosts = NULL;
	guint32 response_time = 0U;
	RygelBasicManagementTest* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	guint32 _tmp9_ = 0U;
	gchar* _tmp10_ = NULL;
	GUPnPServiceAction* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	guint32 _tmp14_;
	const gchar* _tmp15_;
	GUPnPServiceAction* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 1)) {
		GUPnPServiceAction* _tmp2_;
		_tmp2_ = action;
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp3_ = action;
	_tmp5_ = rygel_basic_management_ensure_test_exists (self, _tmp3_, &_tmp4_);
	_g_object_unref0 (bm_test);
	bm_test = _tmp4_;
	if (!_tmp5_) {
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp6_ = bm_test;
	rygel_basic_management_test_traceroute_get_results (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE) ? ((RygelBasicManagementTestTraceroute*) _tmp6_) : NULL, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
	_g_free0 (status);
	status = _tmp7_;
	_g_free0 (additional_info);
	additional_info = _tmp8_;
	response_time = _tmp9_;
	_g_free0 (hop_hosts);
	hop_hosts = _tmp10_;
	_tmp11_ = action;
	_tmp12_ = status;
	_tmp13_ = additional_info;
	_tmp14_ = response_time;
	_tmp15_ = hop_hosts;
	gupnp_service_action_set (_tmp11_, "Status", G_TYPE_STRING, _tmp12_, "AdditionalInfo", G_TYPE_STRING, _tmp13_, "ResponseTime", G_TYPE_UINT, _tmp14_, "HopHosts", G_TYPE_STRING, _tmp15_, NULL);
	_tmp16_ = action;
	gupnp_service_action_return (_tmp16_);
	_g_free0 (hop_hosts);
	_g_free0 (additional_info);
	_g_free0 (status);
	_g_object_unref0 (bm_test);
}


static void rygel_basic_management_get_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_;
	GUPnPServiceAction* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GUPnPServiceAction* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 0)) {
		GUPnPServiceAction* _tmp2_;
		_tmp2_ = action;
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp3_ = action;
	_tmp4_ = rygel_basic_management_create_test_ids_list (self, FALSE);
	_tmp5_ = _tmp4_;
	gupnp_service_action_set (_tmp3_, "TestIDs", G_TYPE_STRING, _tmp5_, NULL);
	_g_free0 (_tmp5_);
	_tmp6_ = action;
	gupnp_service_action_return (_tmp6_);
}


static void rygel_basic_management_get_active_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_;
	GUPnPServiceAction* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GUPnPServiceAction* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 0)) {
		GUPnPServiceAction* _tmp2_;
		_tmp2_ = action;
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp3_ = action;
	_tmp4_ = rygel_basic_management_create_test_ids_list (self, TRUE);
	_tmp5_ = _tmp4_;
	gupnp_service_action_set (_tmp3_, "TestIDs", G_TYPE_STRING, _tmp5_, NULL);
	_g_free0 (_tmp5_);
	_tmp6_ = action;
	gupnp_service_action_return (_tmp6_);
}


static void rygel_basic_management_get_test_info_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_;
	RygelBasicManagementTest* bm_test = NULL;
	GUPnPServiceAction* _tmp3_;
	RygelBasicManagementTest* _tmp4_ = NULL;
	gboolean _tmp5_;
	GUPnPServiceAction* _tmp6_;
	RygelBasicManagementTest* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	RygelBasicManagementTest* _tmp10_;
	RygelBasicManagementTestExecutionState _tmp11_;
	RygelBasicManagementTestExecutionState _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GUPnPServiceAction* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 1)) {
		GUPnPServiceAction* _tmp2_;
		_tmp2_ = action;
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp3_ = action;
	_tmp5_ = rygel_basic_management_ensure_test_exists (self, _tmp3_, &_tmp4_);
	_g_object_unref0 (bm_test);
	bm_test = _tmp4_;
	if (!_tmp5_) {
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp6_ = action;
	_tmp7_ = bm_test;
	_tmp8_ = rygel_basic_management_test_get_method_type (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = bm_test;
	_tmp11_ = rygel_basic_management_test_get_execution_state (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = rygel_basic_management_test_execution_state_to_string (_tmp12_);
	_tmp14_ = _tmp13_;
	gupnp_service_action_set (_tmp6_, "Type", G_TYPE_STRING, _tmp9_, "State", G_TYPE_STRING, _tmp14_, NULL);
	_g_free0 (_tmp14_);
	_tmp15_ = action;
	gupnp_service_action_return (_tmp15_);
	_g_object_unref0 (bm_test);
}


static void rygel_basic_management_cancel_test_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_;
	RygelBasicManagementTest* bm_test = NULL;
	GUPnPServiceAction* _tmp3_;
	RygelBasicManagementTest* _tmp4_ = NULL;
	gboolean _tmp5_;
	RygelBasicManagementTest* _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
	GUPnPServiceAction* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 1)) {
		GUPnPServiceAction* _tmp2_;
		_tmp2_ = action;
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp3_ = action;
	_tmp5_ = rygel_basic_management_ensure_test_exists (self, _tmp3_, &_tmp4_);
	_g_object_unref0 (bm_test);
	bm_test = _tmp4_;
	if (!_tmp5_) {
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp6_ = bm_test;
	_tmp7_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_cancellable_cancel (_tmp8_);
	_tmp9_ = action;
	gupnp_service_action_return (_tmp9_);
	_g_object_unref0 (bm_test);
}


RygelBasicManagement* rygel_basic_management_construct (GType object_type) {
	RygelBasicManagement * self = NULL;
	self = (RygelBasicManagement*) g_object_new (object_type, NULL);
	return self;
}


RygelBasicManagement* rygel_basic_management_new (void) {
	return rygel_basic_management_construct (RYGEL_TYPE_BASIC_MANAGEMENT);
}


guint rygel_basic_management_get_max_history_size (RygelBasicManagement* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_max_history_size;
	result = _tmp0_;
	return result;
}


void rygel_basic_management_set_max_history_size (RygelBasicManagement* self, guint value) {
	g_return_if_fail (self != NULL);
	if (rygel_basic_management_get_max_history_size (self) != value) {
		guint _tmp0_;
		_tmp0_ = value;
		self->priv->_max_history_size = _tmp0_;
		g_object_notify ((GObject *) self, "max-history-size");
	}
}


static void rygel_basic_management_class_init (RygelBasicManagementClass * klass) {
	rygel_basic_management_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelBasicManagementPrivate));
	((GObjectClass *) klass)->constructed = (void (*) (GObject *)) rygel_basic_management_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_basic_management_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_basic_management_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_basic_management_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE_PROPERTY, g_param_spec_uint ("max-history-size", "max-history-size", "max-history-size", 0, G_MAXUINT, (guint) 10, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_basic_management_instance_init (RygelBasicManagement * self) {
	self->priv = RYGEL_BASIC_MANAGEMENT_GET_PRIVATE (self);
	self->priv->_max_history_size = (guint) 10;
}


static void rygel_basic_management_finalize (GObject * obj) {
	RygelBasicManagement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement);
	_g_object_unref0 (self->priv->tests_map);
	_g_object_unref0 (self->priv->test_ids_by_type);
	_g_free0 (self->device_status);
	G_OBJECT_CLASS (rygel_basic_management_parent_class)->finalize (obj);
}


/**
 * Basic implementation of UPnP BasicManagement service version 2.
 */
GType rygel_basic_management_get_type (void) {
	static volatile gsize rygel_basic_management_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBasicManagementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_basic_management_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBasicManagement), 0, (GInstanceInitFunc) rygel_basic_management_instance_init, NULL };
		GType rygel_basic_management_type_id;
		rygel_basic_management_type_id = g_type_register_static (gupnp_service_get_type (), "RygelBasicManagement", &g_define_type_info, 0);
		g_once_init_leave (&rygel_basic_management_type_id__volatile, rygel_basic_management_type_id);
	}
	return rygel_basic_management_type_id__volatile;
}


static void _vala_rygel_basic_management_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelBasicManagement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE_PROPERTY:
		g_value_set_uint (value, rygel_basic_management_get_max_history_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_basic_management_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelBasicManagement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE_PROPERTY:
		rygel_basic_management_set_max_history_size (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



